/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.nimble.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a streaming image resource.
 * </p>
 * <p>
 * Streaming images are used by studio users to select which operating system and software they want to use in a Nimble
 * Studio streaming session.
 * </p>
 * <p>
 * Amazon provides a number of streaming images that include popular 3rd-party software.
 * </p>
 * <p>
 * You can create your own streaming images using an Amazon Elastic Compute Cloud (Amazon EC2) machine image that you
 * create for this purpose. You can also include software that your users require.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StreamingImage implements SdkPojo, Serializable, ToCopyableBuilder<StreamingImage.Builder, StreamingImage> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(StreamingImage::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(StreamingImage::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> EC2_IMAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ec2ImageId").getter(getter(StreamingImage::ec2ImageId)).setter(setter(Builder::ec2ImageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2ImageId").build()).build();

    private static final SdkField<StreamingImageEncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField
            .<StreamingImageEncryptionConfiguration> builder(MarshallingType.SDK_POJO).memberName("encryptionConfiguration")
            .getter(getter(StreamingImage::encryptionConfiguration)).setter(setter(Builder::encryptionConfiguration))
            .constructor(StreamingImageEncryptionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionConfiguration").build())
            .build();

    private static final SdkField<List<String>> EULA_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("eulaIds")
            .getter(getter(StreamingImage::eulaIds))
            .setter(setter(Builder::eulaIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eulaIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(StreamingImage::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("owner")
            .getter(getter(StreamingImage::owner)).setter(setter(Builder::owner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owner").build()).build();

    private static final SdkField<String> PLATFORM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("platform").getter(getter(StreamingImage::platform)).setter(setter(Builder::platform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("state")
            .getter(getter(StreamingImage::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusCode").getter(getter(StreamingImage::statusCodeAsString)).setter(setter(Builder::statusCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusCode").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusMessage").getter(getter(StreamingImage::statusMessage)).setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()).build();

    private static final SdkField<String> STREAMING_IMAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("streamingImageId").getter(getter(StreamingImage::streamingImageId))
            .setter(setter(Builder::streamingImageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamingImageId").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(StreamingImage::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, DESCRIPTION_FIELD,
            EC2_IMAGE_ID_FIELD, ENCRYPTION_CONFIGURATION_FIELD, EULA_IDS_FIELD, NAME_FIELD, OWNER_FIELD, PLATFORM_FIELD,
            STATE_FIELD, STATUS_CODE_FIELD, STATUS_MESSAGE_FIELD, STREAMING_IMAGE_ID_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String description;

    private final String ec2ImageId;

    private final StreamingImageEncryptionConfiguration encryptionConfiguration;

    private final List<String> eulaIds;

    private final String name;

    private final String owner;

    private final String platform;

    private final String state;

    private final String statusCodeValue;

    private final String statusMessage;

    private final String streamingImageId;

    private final Map<String, String> tags;

    private StreamingImage(BuilderImpl builder) {
        this.arn = builder.arn;
        this.description = builder.description;
        this.ec2ImageId = builder.ec2ImageId;
        this.encryptionConfiguration = builder.encryptionConfiguration;
        this.eulaIds = builder.eulaIds;
        this.name = builder.name;
        this.owner = builder.owner;
        this.platform = builder.platform;
        this.state = builder.state;
        this.statusCodeValue = builder.statusCodeValue;
        this.statusMessage = builder.statusMessage;
        this.streamingImageId = builder.streamingImageId;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ARN of the resource.
     * </p>
     * 
     * @return The ARN of the resource.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * A human-readable description of the streaming image.
     * </p>
     * 
     * @return A human-readable description of the streaming image.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ID of an EC2 machine image with which to create the streaming image.
     * </p>
     * 
     * @return The ID of an EC2 machine image with which to create the streaming image.
     */
    public final String ec2ImageId() {
        return ec2ImageId;
    }

    /**
     * <p>
     * The encryption configuration.
     * </p>
     * 
     * @return The encryption configuration.
     */
    public final StreamingImageEncryptionConfiguration encryptionConfiguration() {
        return encryptionConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the EulaIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEulaIds() {
        return eulaIds != null && !(eulaIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of EULAs that must be accepted before a Streaming Session can be started using this streaming image.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEulaIds} method.
     * </p>
     * 
     * @return The list of EULAs that must be accepted before a Streaming Session can be started using this streaming
     *         image.
     */
    public final List<String> eulaIds() {
        return eulaIds;
    }

    /**
     * <p>
     * A friendly name for a streaming image resource.
     * </p>
     * 
     * @return A friendly name for a streaming image resource.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The owner of the streaming image, either the studioId that contains the streaming image, or 'amazon' for images
     * that are provided by Amazon Nimble Studio.
     * </p>
     * 
     * @return The owner of the streaming image, either the studioId that contains the streaming image, or 'amazon' for
     *         images that are provided by Amazon Nimble Studio.
     */
    public final String owner() {
        return owner;
    }

    /**
     * <p>
     * The platform of the streaming image, either WINDOWS or LINUX.
     * </p>
     * 
     * @return The platform of the streaming image, either WINDOWS or LINUX.
     */
    public final String platform() {
        return platform;
    }

    /**
     * <p>
     * The current state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link StreamingImageState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state.
     * @see StreamingImageState
     */
    public final StreamingImageState state() {
        return StreamingImageState.fromValue(state);
    }

    /**
     * <p>
     * The current state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link StreamingImageState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state.
     * @see StreamingImageState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The status code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusCode} will
     * return {@link StreamingImageStatusCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusCodeAsString}.
     * </p>
     * 
     * @return The status code.
     * @see StreamingImageStatusCode
     */
    public final StreamingImageStatusCode statusCode() {
        return StreamingImageStatusCode.fromValue(statusCodeValue);
    }

    /**
     * <p>
     * The status code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusCode} will
     * return {@link StreamingImageStatusCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusCodeAsString}.
     * </p>
     * 
     * @return The status code.
     * @see StreamingImageStatusCode
     */
    public final String statusCodeAsString() {
        return statusCodeValue;
    }

    /**
     * <p>
     * The status message for the streaming image.
     * </p>
     * 
     * @return The status message for the streaming image.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The ID of the streaming image.
     * </p>
     * 
     * @return The ID of the streaming image.
     */
    public final String streamingImageId() {
        return streamingImageId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A collection of labels, in the form of key:value pairs, that apply to this resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A collection of labels, in the form of key:value pairs, that apply to this resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(ec2ImageId());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasEulaIds() ? eulaIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        hashCode = 31 * hashCode + Objects.hashCode(platform());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(streamingImageId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamingImage)) {
            return false;
        }
        StreamingImage other = (StreamingImage) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(description(), other.description())
                && Objects.equals(ec2ImageId(), other.ec2ImageId())
                && Objects.equals(encryptionConfiguration(), other.encryptionConfiguration())
                && hasEulaIds() == other.hasEulaIds() && Objects.equals(eulaIds(), other.eulaIds())
                && Objects.equals(name(), other.name()) && Objects.equals(owner(), other.owner())
                && Objects.equals(platform(), other.platform()) && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(statusCodeAsString(), other.statusCodeAsString())
                && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(streamingImageId(), other.streamingImageId()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StreamingImage").add("Arn", arn())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Ec2ImageId", ec2ImageId()).add("EncryptionConfiguration", encryptionConfiguration())
                .add("EulaIds", hasEulaIds() ? eulaIds() : null)
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***").add("Owner", owner())
                .add("Platform", platform()).add("State", stateAsString()).add("StatusCode", statusCodeAsString())
                .add("StatusMessage", statusMessage()).add("StreamingImageId", streamingImageId())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ec2ImageId":
            return Optional.ofNullable(clazz.cast(ec2ImageId()));
        case "encryptionConfiguration":
            return Optional.ofNullable(clazz.cast(encryptionConfiguration()));
        case "eulaIds":
            return Optional.ofNullable(clazz.cast(eulaIds()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "owner":
            return Optional.ofNullable(clazz.cast(owner()));
        case "platform":
            return Optional.ofNullable(clazz.cast(platform()));
        case "state":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "statusCode":
            return Optional.ofNullable(clazz.cast(statusCodeAsString()));
        case "statusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "streamingImageId":
            return Optional.ofNullable(clazz.cast(streamingImageId()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StreamingImage, T> g) {
        return obj -> g.apply((StreamingImage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StreamingImage> {
        /**
         * <p>
         * The ARN of the resource.
         * </p>
         * 
         * @param arn
         *        The ARN of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * A human-readable description of the streaming image.
         * </p>
         * 
         * @param description
         *        A human-readable description of the streaming image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of an EC2 machine image with which to create the streaming image.
         * </p>
         * 
         * @param ec2ImageId
         *        The ID of an EC2 machine image with which to create the streaming image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2ImageId(String ec2ImageId);

        /**
         * <p>
         * The encryption configuration.
         * </p>
         * 
         * @param encryptionConfiguration
         *        The encryption configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionConfiguration(StreamingImageEncryptionConfiguration encryptionConfiguration);

        /**
         * <p>
         * The encryption configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link StreamingImageEncryptionConfiguration.Builder}
         * avoiding the need to create one manually via {@link StreamingImageEncryptionConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link StreamingImageEncryptionConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #encryptionConfiguration(StreamingImageEncryptionConfiguration)}.
         * 
         * @param encryptionConfiguration
         *        a consumer that will call methods on {@link StreamingImageEncryptionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionConfiguration(StreamingImageEncryptionConfiguration)
         */
        default Builder encryptionConfiguration(Consumer<StreamingImageEncryptionConfiguration.Builder> encryptionConfiguration) {
            return encryptionConfiguration(StreamingImageEncryptionConfiguration.builder().applyMutation(encryptionConfiguration)
                    .build());
        }

        /**
         * <p>
         * The list of EULAs that must be accepted before a Streaming Session can be started using this streaming image.
         * </p>
         * 
         * @param eulaIds
         *        The list of EULAs that must be accepted before a Streaming Session can be started using this streaming
         *        image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eulaIds(Collection<String> eulaIds);

        /**
         * <p>
         * The list of EULAs that must be accepted before a Streaming Session can be started using this streaming image.
         * </p>
         * 
         * @param eulaIds
         *        The list of EULAs that must be accepted before a Streaming Session can be started using this streaming
         *        image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eulaIds(String... eulaIds);

        /**
         * <p>
         * A friendly name for a streaming image resource.
         * </p>
         * 
         * @param name
         *        A friendly name for a streaming image resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The owner of the streaming image, either the studioId that contains the streaming image, or 'amazon' for
         * images that are provided by Amazon Nimble Studio.
         * </p>
         * 
         * @param owner
         *        The owner of the streaming image, either the studioId that contains the streaming image, or 'amazon'
         *        for images that are provided by Amazon Nimble Studio.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(String owner);

        /**
         * <p>
         * The platform of the streaming image, either WINDOWS or LINUX.
         * </p>
         * 
         * @param platform
         *        The platform of the streaming image, either WINDOWS or LINUX.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platform(String platform);

        /**
         * <p>
         * The current state.
         * </p>
         * 
         * @param state
         *        The current state.
         * @see StreamingImageState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamingImageState
         */
        Builder state(String state);

        /**
         * <p>
         * The current state.
         * </p>
         * 
         * @param state
         *        The current state.
         * @see StreamingImageState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamingImageState
         */
        Builder state(StreamingImageState state);

        /**
         * <p>
         * The status code.
         * </p>
         * 
         * @param statusCodeValue
         *        The status code.
         * @see StreamingImageStatusCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamingImageStatusCode
         */
        Builder statusCode(String statusCodeValue);

        /**
         * <p>
         * The status code.
         * </p>
         * 
         * @param statusCodeValue
         *        The status code.
         * @see StreamingImageStatusCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamingImageStatusCode
         */
        Builder statusCode(StreamingImageStatusCode statusCodeValue);

        /**
         * <p>
         * The status message for the streaming image.
         * </p>
         * 
         * @param statusMessage
         *        The status message for the streaming image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The ID of the streaming image.
         * </p>
         * 
         * @param streamingImageId
         *        The ID of the streaming image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamingImageId(String streamingImageId);

        /**
         * <p>
         * A collection of labels, in the form of key:value pairs, that apply to this resource.
         * </p>
         * 
         * @param tags
         *        A collection of labels, in the form of key:value pairs, that apply to this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String description;

        private String ec2ImageId;

        private StreamingImageEncryptionConfiguration encryptionConfiguration;

        private List<String> eulaIds = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private String owner;

        private String platform;

        private String state;

        private String statusCodeValue;

        private String statusMessage;

        private String streamingImageId;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StreamingImage model) {
            arn(model.arn);
            description(model.description);
            ec2ImageId(model.ec2ImageId);
            encryptionConfiguration(model.encryptionConfiguration);
            eulaIds(model.eulaIds);
            name(model.name);
            owner(model.owner);
            platform(model.platform);
            state(model.state);
            statusCode(model.statusCodeValue);
            statusMessage(model.statusMessage);
            streamingImageId(model.streamingImageId);
            tags(model.tags);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEc2ImageId() {
            return ec2ImageId;
        }

        public final void setEc2ImageId(String ec2ImageId) {
            this.ec2ImageId = ec2ImageId;
        }

        @Override
        @Transient
        public final Builder ec2ImageId(String ec2ImageId) {
            this.ec2ImageId = ec2ImageId;
            return this;
        }

        public final StreamingImageEncryptionConfiguration.Builder getEncryptionConfiguration() {
            return encryptionConfiguration != null ? encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(StreamingImageEncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder encryptionConfiguration(StreamingImageEncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public final Collection<String> getEulaIds() {
            if (eulaIds instanceof SdkAutoConstructList) {
                return null;
            }
            return eulaIds;
        }

        public final void setEulaIds(Collection<String> eulaIds) {
            this.eulaIds = EulaIdListCopier.copy(eulaIds);
        }

        @Override
        @Transient
        public final Builder eulaIds(Collection<String> eulaIds) {
            this.eulaIds = EulaIdListCopier.copy(eulaIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder eulaIds(String... eulaIds) {
            eulaIds(Arrays.asList(eulaIds));
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOwner() {
            return owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        @Transient
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final String getPlatform() {
            return platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        @Transient
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        @Transient
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        @Transient
        public final Builder state(StreamingImageState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStatusCode() {
            return statusCodeValue;
        }

        public final void setStatusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
        }

        @Override
        @Transient
        public final Builder statusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
            return this;
        }

        @Override
        @Transient
        public final Builder statusCode(StreamingImageStatusCode statusCodeValue) {
            this.statusCode(statusCodeValue == null ? null : statusCodeValue.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        @Transient
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getStreamingImageId() {
            return streamingImageId;
        }

        public final void setStreamingImageId(String streamingImageId) {
            this.streamingImageId = streamingImageId;
        }

        @Override
        @Transient
        public final Builder streamingImageId(String streamingImageId) {
            this.streamingImageId = streamingImageId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public StreamingImage build() {
            return new StreamingImage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
