/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.nimble.model.EulaIdListCopier;
import software.amazon.awssdk.services.nimble.model.StreamingImageEncryptionConfiguration;
import software.amazon.awssdk.services.nimble.model.StreamingImageState;
import software.amazon.awssdk.services.nimble.model.StreamingImageStatusCode;
import software.amazon.awssdk.services.nimble.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StreamingImage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StreamingImage> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(StreamingImage.getter(StreamingImage::arn)).setter(StreamingImage.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(StreamingImage.getter(StreamingImage::description)).setter(StreamingImage.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> EC2_IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ec2ImageId").getter(StreamingImage.getter(StreamingImage::ec2ImageId)).setter(StreamingImage.setter(Builder::ec2ImageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2ImageId").build()}).build();
    private static final SdkField<StreamingImageEncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("encryptionConfiguration").getter(StreamingImage.getter(StreamingImage::encryptionConfiguration)).setter(StreamingImage.setter(Builder::encryptionConfiguration)).constructor(StreamingImageEncryptionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionConfiguration").build()}).build();
    private static final SdkField<List<String>> EULA_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("eulaIds").getter(StreamingImage.getter(StreamingImage::eulaIds)).setter(StreamingImage.setter(Builder::eulaIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eulaIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(StreamingImage.getter(StreamingImage::name)).setter(StreamingImage.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("owner").getter(StreamingImage.getter(StreamingImage::owner)).setter(StreamingImage.setter(Builder::owner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owner").build()}).build();
    private static final SdkField<String> PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("platform").getter(StreamingImage.getter(StreamingImage::platform)).setter(StreamingImage.setter(Builder::platform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(StreamingImage.getter(StreamingImage::stateAsString)).setter(StreamingImage.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusCode").getter(StreamingImage.getter(StreamingImage::statusCodeAsString)).setter(StreamingImage.setter(Builder::statusCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusCode").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusMessage").getter(StreamingImage.getter(StreamingImage::statusMessage)).setter(StreamingImage.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()}).build();
    private static final SdkField<String> STREAMING_IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("streamingImageId").getter(StreamingImage.getter(StreamingImage::streamingImageId)).setter(StreamingImage.setter(Builder::streamingImageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamingImageId").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(StreamingImage.getter(StreamingImage::tags)).setter(StreamingImage.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, DESCRIPTION_FIELD, EC2_IMAGE_ID_FIELD, ENCRYPTION_CONFIGURATION_FIELD, EULA_IDS_FIELD, NAME_FIELD, OWNER_FIELD, PLATFORM_FIELD, STATE_FIELD, STATUS_CODE_FIELD, STATUS_MESSAGE_FIELD, STREAMING_IMAGE_ID_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String description;
    private final String ec2ImageId;
    private final StreamingImageEncryptionConfiguration encryptionConfiguration;
    private final List<String> eulaIds;
    private final String name;
    private final String owner;
    private final String platform;
    private final String state;
    private final String statusCodeValue;
    private final String statusMessage;
    private final String streamingImageId;
    private final Map<String, String> tags;

    private StreamingImage(BuilderImpl builder) {
        this.arn = builder.arn;
        this.description = builder.description;
        this.ec2ImageId = builder.ec2ImageId;
        this.encryptionConfiguration = builder.encryptionConfiguration;
        this.eulaIds = builder.eulaIds;
        this.name = builder.name;
        this.owner = builder.owner;
        this.platform = builder.platform;
        this.state = builder.state;
        this.statusCodeValue = builder.statusCodeValue;
        this.statusMessage = builder.statusMessage;
        this.streamingImageId = builder.streamingImageId;
        this.tags = builder.tags;
    }

    public final String arn() {
        return this.arn;
    }

    public final String description() {
        return this.description;
    }

    public final String ec2ImageId() {
        return this.ec2ImageId;
    }

    public final StreamingImageEncryptionConfiguration encryptionConfiguration() {
        return this.encryptionConfiguration;
    }

    public final boolean hasEulaIds() {
        return this.eulaIds != null && !(this.eulaIds instanceof SdkAutoConstructList);
    }

    public final List<String> eulaIds() {
        return this.eulaIds;
    }

    public final String name() {
        return this.name;
    }

    public final String owner() {
        return this.owner;
    }

    public final String platform() {
        return this.platform;
    }

    public final StreamingImageState state() {
        return StreamingImageState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final StreamingImageStatusCode statusCode() {
        return StreamingImageStatusCode.fromValue(this.statusCodeValue);
    }

    public final String statusCodeAsString() {
        return this.statusCodeValue;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final String streamingImageId() {
        return this.streamingImageId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2ImageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEulaIds() ? this.eulaIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        hashCode = 31 * hashCode + Objects.hashCode(this.platform());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamingImageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamingImage)) {
            return false;
        }
        StreamingImage other = (StreamingImage)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.ec2ImageId(), other.ec2ImageId()) && Objects.equals(this.encryptionConfiguration(), other.encryptionConfiguration()) && this.hasEulaIds() == other.hasEulaIds() && Objects.equals(this.eulaIds(), other.eulaIds()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.owner(), other.owner()) && Objects.equals(this.platform(), other.platform()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.statusCodeAsString(), other.statusCodeAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.streamingImageId(), other.streamingImageId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"StreamingImage").add("Arn", (Object)this.arn()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("Ec2ImageId", (Object)this.ec2ImageId()).add("EncryptionConfiguration", (Object)this.encryptionConfiguration()).add("EulaIds", this.hasEulaIds() ? this.eulaIds() : null).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("Owner", (Object)this.owner()).add("Platform", (Object)this.platform()).add("State", (Object)this.stateAsString()).add("StatusCode", (Object)this.statusCodeAsString()).add("StatusMessage", (Object)this.statusMessage()).add("StreamingImageId", (Object)this.streamingImageId()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ec2ImageId": {
                return Optional.ofNullable(clazz.cast(this.ec2ImageId()));
            }
            case "encryptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.encryptionConfiguration()));
            }
            case "eulaIds": {
                return Optional.ofNullable(clazz.cast(this.eulaIds()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "owner": {
                return Optional.ofNullable(clazz.cast(this.owner()));
            }
            case "platform": {
                return Optional.ofNullable(clazz.cast(this.platform()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "statusCode": {
                return Optional.ofNullable(clazz.cast(this.statusCodeAsString()));
            }
            case "statusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "streamingImageId": {
                return Optional.ofNullable(clazz.cast(this.streamingImageId()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StreamingImage, T> g) {
        return obj -> g.apply((StreamingImage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String description;
        private String ec2ImageId;
        private StreamingImageEncryptionConfiguration encryptionConfiguration;
        private List<String> eulaIds = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private String owner;
        private String platform;
        private String state;
        private String statusCodeValue;
        private String statusMessage;
        private String streamingImageId;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StreamingImage model) {
            this.arn(model.arn);
            this.description(model.description);
            this.ec2ImageId(model.ec2ImageId);
            this.encryptionConfiguration(model.encryptionConfiguration);
            this.eulaIds(model.eulaIds);
            this.name(model.name);
            this.owner(model.owner);
            this.platform(model.platform);
            this.state(model.state);
            this.statusCode(model.statusCodeValue);
            this.statusMessage(model.statusMessage);
            this.streamingImageId(model.streamingImageId);
            this.tags(model.tags);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEc2ImageId() {
            return this.ec2ImageId;
        }

        public final void setEc2ImageId(String ec2ImageId) {
            this.ec2ImageId = ec2ImageId;
        }

        @Override
        @Transient
        public final Builder ec2ImageId(String ec2ImageId) {
            this.ec2ImageId = ec2ImageId;
            return this;
        }

        public final StreamingImageEncryptionConfiguration.Builder getEncryptionConfiguration() {
            return this.encryptionConfiguration != null ? this.encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(StreamingImageEncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder encryptionConfiguration(StreamingImageEncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public final Collection<String> getEulaIds() {
            if (this.eulaIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.eulaIds;
        }

        public final void setEulaIds(Collection<String> eulaIds) {
            this.eulaIds = EulaIdListCopier.copy(eulaIds);
        }

        @Override
        @Transient
        public final Builder eulaIds(Collection<String> eulaIds) {
            this.eulaIds = EulaIdListCopier.copy(eulaIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder eulaIds(String ... eulaIds) {
            this.eulaIds(Arrays.asList(eulaIds));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOwner() {
            return this.owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        @Transient
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final String getPlatform() {
            return this.platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        @Transient
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        @Transient
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        @Transient
        public final Builder state(StreamingImageState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStatusCode() {
            return this.statusCodeValue;
        }

        public final void setStatusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
        }

        @Override
        @Transient
        public final Builder statusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
            return this;
        }

        @Override
        @Transient
        public final Builder statusCode(StreamingImageStatusCode statusCodeValue) {
            this.statusCode(statusCodeValue == null ? null : statusCodeValue.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        @Transient
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getStreamingImageId() {
            return this.streamingImageId;
        }

        public final void setStreamingImageId(String streamingImageId) {
            this.streamingImageId = streamingImageId;
        }

        @Override
        @Transient
        public final Builder streamingImageId(String streamingImageId) {
            this.streamingImageId = streamingImageId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public StreamingImage build() {
            return new StreamingImage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StreamingImage> {
        public Builder arn(String var1);

        public Builder description(String var1);

        public Builder ec2ImageId(String var1);

        public Builder encryptionConfiguration(StreamingImageEncryptionConfiguration var1);

        default public Builder encryptionConfiguration(Consumer<StreamingImageEncryptionConfiguration.Builder> encryptionConfiguration) {
            return this.encryptionConfiguration((StreamingImageEncryptionConfiguration)((StreamingImageEncryptionConfiguration.Builder)StreamingImageEncryptionConfiguration.builder().applyMutation(encryptionConfiguration)).build());
        }

        public Builder eulaIds(Collection<String> var1);

        public Builder eulaIds(String ... var1);

        public Builder name(String var1);

        public Builder owner(String var1);

        public Builder platform(String var1);

        public Builder state(String var1);

        public Builder state(StreamingImageState var1);

        public Builder statusCode(String var1);

        public Builder statusCode(StreamingImageStatusCode var1);

        public Builder statusMessage(String var1);

        public Builder streamingImageId(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

