/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.nimble.model.StudioEncryptionConfiguration;
import software.amazon.awssdk.services.nimble.model.StudioState;
import software.amazon.awssdk.services.nimble.model.StudioStatusCode;
import software.amazon.awssdk.services.nimble.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Studio
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Studio> {
    private static final SdkField<String> ADMIN_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("adminRoleArn").getter(Studio.getter(Studio::adminRoleArn)).setter(Studio.setter(Builder::adminRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adminRoleArn").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(Studio.getter(Studio::arn)).setter(Studio.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(Studio.getter(Studio::createdAt)).setter(Studio.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(Studio.getter(Studio::displayName)).setter(Studio.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<String> HOME_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("homeRegion").getter(Studio.getter(Studio::homeRegion)).setter(Studio.setter(Builder::homeRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("homeRegion").build()}).build();
    private static final SdkField<String> SSO_CLIENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ssoClientId").getter(Studio.getter(Studio::ssoClientId)).setter(Studio.setter(Builder::ssoClientId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ssoClientId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(Studio.getter(Studio::stateAsString)).setter(Studio.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusCode").getter(Studio.getter(Studio::statusCodeAsString)).setter(Studio.setter(Builder::statusCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusCode").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusMessage").getter(Studio.getter(Studio::statusMessage)).setter(Studio.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()}).build();
    private static final SdkField<StudioEncryptionConfiguration> STUDIO_ENCRYPTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("studioEncryptionConfiguration").getter(Studio.getter(Studio::studioEncryptionConfiguration)).setter(Studio.setter(Builder::studioEncryptionConfiguration)).constructor(StudioEncryptionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("studioEncryptionConfiguration").build()}).build();
    private static final SdkField<String> STUDIO_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("studioId").getter(Studio.getter(Studio::studioId)).setter(Studio.setter(Builder::studioId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("studioId").build()}).build();
    private static final SdkField<String> STUDIO_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("studioName").getter(Studio.getter(Studio::studioName)).setter(Studio.setter(Builder::studioName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("studioName").build()}).build();
    private static final SdkField<String> STUDIO_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("studioUrl").getter(Studio.getter(Studio::studioUrl)).setter(Studio.setter(Builder::studioUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("studioUrl").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(Studio.getter(Studio::tags)).setter(Studio.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(Studio.getter(Studio::updatedAt)).setter(Studio.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> USER_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userRoleArn").getter(Studio.getter(Studio::userRoleArn)).setter(Studio.setter(Builder::userRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userRoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADMIN_ROLE_ARN_FIELD, ARN_FIELD, CREATED_AT_FIELD, DISPLAY_NAME_FIELD, HOME_REGION_FIELD, SSO_CLIENT_ID_FIELD, STATE_FIELD, STATUS_CODE_FIELD, STATUS_MESSAGE_FIELD, STUDIO_ENCRYPTION_CONFIGURATION_FIELD, STUDIO_ID_FIELD, STUDIO_NAME_FIELD, STUDIO_URL_FIELD, TAGS_FIELD, UPDATED_AT_FIELD, USER_ROLE_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String adminRoleArn;
    private final String arn;
    private final Instant createdAt;
    private final String displayName;
    private final String homeRegion;
    private final String ssoClientId;
    private final String state;
    private final String statusCodeValue;
    private final String statusMessage;
    private final StudioEncryptionConfiguration studioEncryptionConfiguration;
    private final String studioId;
    private final String studioName;
    private final String studioUrl;
    private final Map<String, String> tags;
    private final Instant updatedAt;
    private final String userRoleArn;

    private Studio(BuilderImpl builder) {
        this.adminRoleArn = builder.adminRoleArn;
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.displayName = builder.displayName;
        this.homeRegion = builder.homeRegion;
        this.ssoClientId = builder.ssoClientId;
        this.state = builder.state;
        this.statusCodeValue = builder.statusCodeValue;
        this.statusMessage = builder.statusMessage;
        this.studioEncryptionConfiguration = builder.studioEncryptionConfiguration;
        this.studioId = builder.studioId;
        this.studioName = builder.studioName;
        this.studioUrl = builder.studioUrl;
        this.tags = builder.tags;
        this.updatedAt = builder.updatedAt;
        this.userRoleArn = builder.userRoleArn;
    }

    public final String adminRoleArn() {
        return this.adminRoleArn;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String homeRegion() {
        return this.homeRegion;
    }

    public final String ssoClientId() {
        return this.ssoClientId;
    }

    public final StudioState state() {
        return StudioState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final StudioStatusCode statusCode() {
        return StudioStatusCode.fromValue(this.statusCodeValue);
    }

    public final String statusCodeAsString() {
        return this.statusCodeValue;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final StudioEncryptionConfiguration studioEncryptionConfiguration() {
        return this.studioEncryptionConfiguration;
    }

    public final String studioId() {
        return this.studioId;
    }

    public final String studioName() {
        return this.studioName;
    }

    public final String studioUrl() {
        return this.studioUrl;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final String userRoleArn() {
        return this.userRoleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.adminRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.homeRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.ssoClientId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.studioEncryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.studioId());
        hashCode = 31 * hashCode + Objects.hashCode(this.studioName());
        hashCode = 31 * hashCode + Objects.hashCode(this.studioUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.userRoleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Studio)) {
            return false;
        }
        Studio other = (Studio)obj;
        return Objects.equals(this.adminRoleArn(), other.adminRoleArn()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.homeRegion(), other.homeRegion()) && Objects.equals(this.ssoClientId(), other.ssoClientId()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.statusCodeAsString(), other.statusCodeAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.studioEncryptionConfiguration(), other.studioEncryptionConfiguration()) && Objects.equals(this.studioId(), other.studioId()) && Objects.equals(this.studioName(), other.studioName()) && Objects.equals(this.studioUrl(), other.studioUrl()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.userRoleArn(), other.userRoleArn());
    }

    public final String toString() {
        return ToString.builder((String)"Studio").add("AdminRoleArn", (Object)this.adminRoleArn()).add("Arn", (Object)this.arn()).add("CreatedAt", (Object)this.createdAt()).add("DisplayName", (Object)(this.displayName() == null ? null : "*** Sensitive Data Redacted ***")).add("HomeRegion", (Object)this.homeRegion()).add("SsoClientId", (Object)this.ssoClientId()).add("State", (Object)this.stateAsString()).add("StatusCode", (Object)this.statusCodeAsString()).add("StatusMessage", (Object)this.statusMessage()).add("StudioEncryptionConfiguration", (Object)this.studioEncryptionConfiguration()).add("StudioId", (Object)this.studioId()).add("StudioName", (Object)this.studioName()).add("StudioUrl", (Object)this.studioUrl()).add("Tags", this.hasTags() ? this.tags() : null).add("UpdatedAt", (Object)this.updatedAt()).add("UserRoleArn", (Object)this.userRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "adminRoleArn": {
                return Optional.ofNullable(clazz.cast(this.adminRoleArn()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "homeRegion": {
                return Optional.ofNullable(clazz.cast(this.homeRegion()));
            }
            case "ssoClientId": {
                return Optional.ofNullable(clazz.cast(this.ssoClientId()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "statusCode": {
                return Optional.ofNullable(clazz.cast(this.statusCodeAsString()));
            }
            case "statusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "studioEncryptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.studioEncryptionConfiguration()));
            }
            case "studioId": {
                return Optional.ofNullable(clazz.cast(this.studioId()));
            }
            case "studioName": {
                return Optional.ofNullable(clazz.cast(this.studioName()));
            }
            case "studioUrl": {
                return Optional.ofNullable(clazz.cast(this.studioUrl()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "userRoleArn": {
                return Optional.ofNullable(clazz.cast(this.userRoleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Studio, T> g) {
        return obj -> g.apply((Studio)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String adminRoleArn;
        private String arn;
        private Instant createdAt;
        private String displayName;
        private String homeRegion;
        private String ssoClientId;
        private String state;
        private String statusCodeValue;
        private String statusMessage;
        private StudioEncryptionConfiguration studioEncryptionConfiguration;
        private String studioId;
        private String studioName;
        private String studioUrl;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Instant updatedAt;
        private String userRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(Studio model) {
            this.adminRoleArn(model.adminRoleArn);
            this.arn(model.arn);
            this.createdAt(model.createdAt);
            this.displayName(model.displayName);
            this.homeRegion(model.homeRegion);
            this.ssoClientId(model.ssoClientId);
            this.state(model.state);
            this.statusCode(model.statusCodeValue);
            this.statusMessage(model.statusMessage);
            this.studioEncryptionConfiguration(model.studioEncryptionConfiguration);
            this.studioId(model.studioId);
            this.studioName(model.studioName);
            this.studioUrl(model.studioUrl);
            this.tags(model.tags);
            this.updatedAt(model.updatedAt);
            this.userRoleArn(model.userRoleArn);
        }

        public final String getAdminRoleArn() {
            return this.adminRoleArn;
        }

        public final void setAdminRoleArn(String adminRoleArn) {
            this.adminRoleArn = adminRoleArn;
        }

        @Override
        @Transient
        public final Builder adminRoleArn(String adminRoleArn) {
            this.adminRoleArn = adminRoleArn;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        @Transient
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        @Transient
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getHomeRegion() {
            return this.homeRegion;
        }

        public final void setHomeRegion(String homeRegion) {
            this.homeRegion = homeRegion;
        }

        @Override
        @Transient
        public final Builder homeRegion(String homeRegion) {
            this.homeRegion = homeRegion;
            return this;
        }

        public final String getSsoClientId() {
            return this.ssoClientId;
        }

        public final void setSsoClientId(String ssoClientId) {
            this.ssoClientId = ssoClientId;
        }

        @Override
        @Transient
        public final Builder ssoClientId(String ssoClientId) {
            this.ssoClientId = ssoClientId;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        @Transient
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        @Transient
        public final Builder state(StudioState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStatusCode() {
            return this.statusCodeValue;
        }

        public final void setStatusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
        }

        @Override
        @Transient
        public final Builder statusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
            return this;
        }

        @Override
        @Transient
        public final Builder statusCode(StudioStatusCode statusCodeValue) {
            this.statusCode(statusCodeValue == null ? null : statusCodeValue.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        @Transient
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final StudioEncryptionConfiguration.Builder getStudioEncryptionConfiguration() {
            return this.studioEncryptionConfiguration != null ? this.studioEncryptionConfiguration.toBuilder() : null;
        }

        public final void setStudioEncryptionConfiguration(StudioEncryptionConfiguration.BuilderImpl studioEncryptionConfiguration) {
            this.studioEncryptionConfiguration = studioEncryptionConfiguration != null ? studioEncryptionConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder studioEncryptionConfiguration(StudioEncryptionConfiguration studioEncryptionConfiguration) {
            this.studioEncryptionConfiguration = studioEncryptionConfiguration;
            return this;
        }

        public final String getStudioId() {
            return this.studioId;
        }

        public final void setStudioId(String studioId) {
            this.studioId = studioId;
        }

        @Override
        @Transient
        public final Builder studioId(String studioId) {
            this.studioId = studioId;
            return this;
        }

        public final String getStudioName() {
            return this.studioName;
        }

        public final void setStudioName(String studioName) {
            this.studioName = studioName;
        }

        @Override
        @Transient
        public final Builder studioName(String studioName) {
            this.studioName = studioName;
            return this;
        }

        public final String getStudioUrl() {
            return this.studioUrl;
        }

        public final void setStudioUrl(String studioUrl) {
            this.studioUrl = studioUrl;
        }

        @Override
        @Transient
        public final Builder studioUrl(String studioUrl) {
            this.studioUrl = studioUrl;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        @Transient
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getUserRoleArn() {
            return this.userRoleArn;
        }

        public final void setUserRoleArn(String userRoleArn) {
            this.userRoleArn = userRoleArn;
        }

        @Override
        @Transient
        public final Builder userRoleArn(String userRoleArn) {
            this.userRoleArn = userRoleArn;
            return this;
        }

        public Studio build() {
            return new Studio(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Studio> {
        public Builder adminRoleArn(String var1);

        public Builder arn(String var1);

        public Builder createdAt(Instant var1);

        public Builder displayName(String var1);

        public Builder homeRegion(String var1);

        public Builder ssoClientId(String var1);

        public Builder state(String var1);

        public Builder state(StudioState var1);

        public Builder statusCode(String var1);

        public Builder statusCode(StudioStatusCode var1);

        public Builder statusMessage(String var1);

        public Builder studioEncryptionConfiguration(StudioEncryptionConfiguration var1);

        default public Builder studioEncryptionConfiguration(Consumer<StudioEncryptionConfiguration.Builder> studioEncryptionConfiguration) {
            return this.studioEncryptionConfiguration((StudioEncryptionConfiguration)((StudioEncryptionConfiguration.Builder)StudioEncryptionConfiguration.builder().applyMutation(studioEncryptionConfiguration)).build());
        }

        public Builder studioId(String var1);

        public Builder studioName(String var1);

        public Builder studioUrl(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder updatedAt(Instant var1);

        public Builder userRoleArn(String var1);
    }
}

