/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.nimble.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for a streaming session’s upload storage.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StreamConfigurationSessionStorage implements SdkPojo, Serializable,
        ToCopyableBuilder<StreamConfigurationSessionStorage.Builder, StreamConfigurationSessionStorage> {
    private static final SdkField<List<String>> MODE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("mode")
            .getter(getter(StreamConfigurationSessionStorage::modeAsStrings))
            .setter(setter(Builder::modeWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mode").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<StreamingSessionStorageRoot> ROOT_FIELD = SdkField
            .<StreamingSessionStorageRoot> builder(MarshallingType.SDK_POJO).memberName("root")
            .getter(getter(StreamConfigurationSessionStorage::root)).setter(setter(Builder::root))
            .constructor(StreamingSessionStorageRoot::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("root").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODE_FIELD, ROOT_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> mode;

    private final StreamingSessionStorageRoot root;

    private StreamConfigurationSessionStorage(BuilderImpl builder) {
        this.mode = builder.mode;
        this.root = builder.root;
    }

    /**
     * <p>
     * Allows artists to upload files to their workstations. The only valid option is <code>UPLOAD</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMode} method.
     * </p>
     * 
     * @return Allows artists to upload files to their workstations. The only valid option is <code>UPLOAD</code>.
     */
    public final List<StreamingSessionStorageMode> mode() {
        return StreamingSessionStorageModeListCopier.copyStringToEnum(mode);
    }

    /**
     * For responses, this returns true if the service returned a value for the Mode property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasMode() {
        return mode != null && !(mode instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Allows artists to upload files to their workstations. The only valid option is <code>UPLOAD</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMode} method.
     * </p>
     * 
     * @return Allows artists to upload files to their workstations. The only valid option is <code>UPLOAD</code>.
     */
    public final List<String> modeAsStrings() {
        return mode;
    }

    /**
     * <p>
     * The configuration for the upload storage root of the streaming session.
     * </p>
     * 
     * @return The configuration for the upload storage root of the streaming session.
     */
    public final StreamingSessionStorageRoot root() {
        return root;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasMode() ? modeAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(root());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamConfigurationSessionStorage)) {
            return false;
        }
        StreamConfigurationSessionStorage other = (StreamConfigurationSessionStorage) obj;
        return hasMode() == other.hasMode() && Objects.equals(modeAsStrings(), other.modeAsStrings())
                && Objects.equals(root(), other.root());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StreamConfigurationSessionStorage").add("Mode", hasMode() ? modeAsStrings() : null)
                .add("Root", root()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "mode":
            return Optional.ofNullable(clazz.cast(modeAsStrings()));
        case "root":
            return Optional.ofNullable(clazz.cast(root()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StreamConfigurationSessionStorage, T> g) {
        return obj -> g.apply((StreamConfigurationSessionStorage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StreamConfigurationSessionStorage> {
        /**
         * <p>
         * Allows artists to upload files to their workstations. The only valid option is <code>UPLOAD</code>.
         * </p>
         * 
         * @param mode
         *        Allows artists to upload files to their workstations. The only valid option is <code>UPLOAD</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modeWithStrings(Collection<String> mode);

        /**
         * <p>
         * Allows artists to upload files to their workstations. The only valid option is <code>UPLOAD</code>.
         * </p>
         * 
         * @param mode
         *        Allows artists to upload files to their workstations. The only valid option is <code>UPLOAD</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modeWithStrings(String... mode);

        /**
         * <p>
         * Allows artists to upload files to their workstations. The only valid option is <code>UPLOAD</code>.
         * </p>
         * 
         * @param mode
         *        Allows artists to upload files to their workstations. The only valid option is <code>UPLOAD</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mode(Collection<StreamingSessionStorageMode> mode);

        /**
         * <p>
         * Allows artists to upload files to their workstations. The only valid option is <code>UPLOAD</code>.
         * </p>
         * 
         * @param mode
         *        Allows artists to upload files to their workstations. The only valid option is <code>UPLOAD</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mode(StreamingSessionStorageMode... mode);

        /**
         * <p>
         * The configuration for the upload storage root of the streaming session.
         * </p>
         * 
         * @param root
         *        The configuration for the upload storage root of the streaming session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder root(StreamingSessionStorageRoot root);

        /**
         * <p>
         * The configuration for the upload storage root of the streaming session.
         * </p>
         * This is a convenience method that creates an instance of the {@link StreamingSessionStorageRoot.Builder}
         * avoiding the need to create one manually via {@link StreamingSessionStorageRoot#builder()}.
         *
         * When the {@link Consumer} completes, {@link StreamingSessionStorageRoot.Builder#build()} is called
         * immediately and its result is passed to {@link #root(StreamingSessionStorageRoot)}.
         * 
         * @param root
         *        a consumer that will call methods on {@link StreamingSessionStorageRoot.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #root(StreamingSessionStorageRoot)
         */
        default Builder root(Consumer<StreamingSessionStorageRoot.Builder> root) {
            return root(StreamingSessionStorageRoot.builder().applyMutation(root).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<String> mode = DefaultSdkAutoConstructList.getInstance();

        private StreamingSessionStorageRoot root;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamConfigurationSessionStorage model) {
            modeWithStrings(model.mode);
            root(model.root);
        }

        public final Collection<String> getMode() {
            if (mode instanceof SdkAutoConstructList) {
                return null;
            }
            return mode;
        }

        public final void setMode(Collection<String> mode) {
            this.mode = StreamingSessionStorageModeListCopier.copy(mode);
        }

        @Override
        public final Builder modeWithStrings(Collection<String> mode) {
            this.mode = StreamingSessionStorageModeListCopier.copy(mode);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modeWithStrings(String... mode) {
            modeWithStrings(Arrays.asList(mode));
            return this;
        }

        @Override
        public final Builder mode(Collection<StreamingSessionStorageMode> mode) {
            this.mode = StreamingSessionStorageModeListCopier.copyEnumToString(mode);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mode(StreamingSessionStorageMode... mode) {
            mode(Arrays.asList(mode));
            return this;
        }

        public final StreamingSessionStorageRoot.Builder getRoot() {
            return root != null ? root.toBuilder() : null;
        }

        public final void setRoot(StreamingSessionStorageRoot.BuilderImpl root) {
            this.root = root != null ? root.build() : null;
        }

        @Override
        public final Builder root(StreamingSessionStorageRoot root) {
            this.root = root;
            return this;
        }

        @Override
        public StreamConfigurationSessionStorage build() {
            return new StreamConfigurationSessionStorage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
