/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.nimble.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetEulaResponse extends NimbleResponse implements ToCopyableBuilder<GetEulaResponse.Builder, GetEulaResponse> {
    private static final SdkField<Eula> EULA_FIELD = SdkField.<Eula> builder(MarshallingType.SDK_POJO).memberName("eula")
            .getter(getter(GetEulaResponse::eula)).setter(setter(Builder::eula)).constructor(Eula::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eula").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EULA_FIELD));

    private final Eula eula;

    private GetEulaResponse(BuilderImpl builder) {
        super(builder);
        this.eula = builder.eula;
    }

    /**
     * <p>
     * The EULA.
     * </p>
     * 
     * @return The EULA.
     */
    public final Eula eula() {
        return eula;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(eula());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEulaResponse)) {
            return false;
        }
        GetEulaResponse other = (GetEulaResponse) obj;
        return Objects.equals(eula(), other.eula());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetEulaResponse").add("Eula", eula()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eula":
            return Optional.ofNullable(clazz.cast(eula()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetEulaResponse, T> g) {
        return obj -> g.apply((GetEulaResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NimbleResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetEulaResponse> {
        /**
         * <p>
         * The EULA.
         * </p>
         * 
         * @param eula
         *        The EULA.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eula(Eula eula);

        /**
         * <p>
         * The EULA.
         * </p>
         * This is a convenience method that creates an instance of the {@link Eula.Builder} avoiding the need to create
         * one manually via {@link Eula#builder()}.
         *
         * When the {@link Consumer} completes, {@link Eula.Builder#build()} is called immediately and its result is
         * passed to {@link #eula(Eula)}.
         * 
         * @param eula
         *        a consumer that will call methods on {@link Eula.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eula(Eula)
         */
        default Builder eula(Consumer<Eula.Builder> eula) {
            return eula(Eula.builder().applyMutation(eula).build());
        }
    }

    static final class BuilderImpl extends NimbleResponse.BuilderImpl implements Builder {
        private Eula eula;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEulaResponse model) {
            super(model);
            eula(model.eula);
        }

        public final Eula.Builder getEula() {
            return eula != null ? eula.toBuilder() : null;
        }

        public final void setEula(Eula.BuilderImpl eula) {
            this.eula = eula != null ? eula.build() : null;
        }

        @Override
        public final Builder eula(Eula eula) {
            this.eula = eula;
            return this;
        }

        @Override
        public GetEulaResponse build() {
            return new GetEulaResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
