/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.nimble.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of the studio component, based on component type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StudioComponentConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<StudioComponentConfiguration.Builder, StudioComponentConfiguration> {
    private static final SdkField<ActiveDirectoryConfiguration> ACTIVE_DIRECTORY_CONFIGURATION_FIELD = SdkField
            .<ActiveDirectoryConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("activeDirectoryConfiguration")
            .getter(getter(StudioComponentConfiguration::activeDirectoryConfiguration))
            .setter(setter(Builder::activeDirectoryConfiguration))
            .constructor(ActiveDirectoryConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeDirectoryConfiguration")
                    .build()).build();

    private static final SdkField<ComputeFarmConfiguration> COMPUTE_FARM_CONFIGURATION_FIELD = SdkField
            .<ComputeFarmConfiguration> builder(MarshallingType.SDK_POJO).memberName("computeFarmConfiguration")
            .getter(getter(StudioComponentConfiguration::computeFarmConfiguration))
            .setter(setter(Builder::computeFarmConfiguration)).constructor(ComputeFarmConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeFarmConfiguration").build())
            .build();

    private static final SdkField<LicenseServiceConfiguration> LICENSE_SERVICE_CONFIGURATION_FIELD = SdkField
            .<LicenseServiceConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("licenseServiceConfiguration")
            .getter(getter(StudioComponentConfiguration::licenseServiceConfiguration))
            .setter(setter(Builder::licenseServiceConfiguration))
            .constructor(LicenseServiceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenseServiceConfiguration")
                    .build()).build();

    private static final SdkField<SharedFileSystemConfiguration> SHARED_FILE_SYSTEM_CONFIGURATION_FIELD = SdkField
            .<SharedFileSystemConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("sharedFileSystemConfiguration")
            .getter(getter(StudioComponentConfiguration::sharedFileSystemConfiguration))
            .setter(setter(Builder::sharedFileSystemConfiguration))
            .constructor(SharedFileSystemConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sharedFileSystemConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ACTIVE_DIRECTORY_CONFIGURATION_FIELD, COMPUTE_FARM_CONFIGURATION_FIELD, LICENSE_SERVICE_CONFIGURATION_FIELD,
            SHARED_FILE_SYSTEM_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final ActiveDirectoryConfiguration activeDirectoryConfiguration;

    private final ComputeFarmConfiguration computeFarmConfiguration;

    private final LicenseServiceConfiguration licenseServiceConfiguration;

    private final SharedFileSystemConfiguration sharedFileSystemConfiguration;

    private final Type type;

    private StudioComponentConfiguration(BuilderImpl builder) {
        this.activeDirectoryConfiguration = builder.activeDirectoryConfiguration;
        this.computeFarmConfiguration = builder.computeFarmConfiguration;
        this.licenseServiceConfiguration = builder.licenseServiceConfiguration;
        this.sharedFileSystemConfiguration = builder.sharedFileSystemConfiguration;
        this.type = builder.type;
    }

    /**
     * <p>
     * The configuration for a Microsoft Active Directory (Microsoft AD) studio resource.
     * </p>
     * 
     * @return The configuration for a Microsoft Active Directory (Microsoft AD) studio resource.
     */
    public final ActiveDirectoryConfiguration activeDirectoryConfiguration() {
        return activeDirectoryConfiguration;
    }

    /**
     * <p>
     * The configuration for a render farm that is associated with a studio resource.
     * </p>
     * 
     * @return The configuration for a render farm that is associated with a studio resource.
     */
    public final ComputeFarmConfiguration computeFarmConfiguration() {
        return computeFarmConfiguration;
    }

    /**
     * <p>
     * The configuration for a license service that is associated with a studio resource.
     * </p>
     * 
     * @return The configuration for a license service that is associated with a studio resource.
     */
    public final LicenseServiceConfiguration licenseServiceConfiguration() {
        return licenseServiceConfiguration;
    }

    /**
     * <p>
     * The configuration for a shared file storage system that is associated with a studio resource.
     * </p>
     * 
     * @return The configuration for a shared file storage system that is associated with a studio resource.
     */
    public final SharedFileSystemConfiguration sharedFileSystemConfiguration() {
        return sharedFileSystemConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(activeDirectoryConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(computeFarmConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(licenseServiceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(sharedFileSystemConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StudioComponentConfiguration)) {
            return false;
        }
        StudioComponentConfiguration other = (StudioComponentConfiguration) obj;
        return Objects.equals(activeDirectoryConfiguration(), other.activeDirectoryConfiguration())
                && Objects.equals(computeFarmConfiguration(), other.computeFarmConfiguration())
                && Objects.equals(licenseServiceConfiguration(), other.licenseServiceConfiguration())
                && Objects.equals(sharedFileSystemConfiguration(), other.sharedFileSystemConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StudioComponentConfiguration")
                .add("ActiveDirectoryConfiguration", activeDirectoryConfiguration())
                .add("ComputeFarmConfiguration", computeFarmConfiguration())
                .add("LicenseServiceConfiguration", licenseServiceConfiguration())
                .add("SharedFileSystemConfiguration", sharedFileSystemConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "activeDirectoryConfiguration":
            return Optional.ofNullable(clazz.cast(activeDirectoryConfiguration()));
        case "computeFarmConfiguration":
            return Optional.ofNullable(clazz.cast(computeFarmConfiguration()));
        case "licenseServiceConfiguration":
            return Optional.ofNullable(clazz.cast(licenseServiceConfiguration()));
        case "sharedFileSystemConfiguration":
            return Optional.ofNullable(clazz.cast(sharedFileSystemConfiguration()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #activeDirectoryConfiguration()} initialized to the given value.
     *
     * <p>
     * The configuration for a Microsoft Active Directory (Microsoft AD) studio resource.
     * </p>
     * 
     * @param activeDirectoryConfiguration
     *        The configuration for a Microsoft Active Directory (Microsoft AD) studio resource.
     */
    public static StudioComponentConfiguration fromActiveDirectoryConfiguration(
            ActiveDirectoryConfiguration activeDirectoryConfiguration) {
        return builder().activeDirectoryConfiguration(activeDirectoryConfiguration).build();
    }

    /**
     * Create an instance of this class with {@link #activeDirectoryConfiguration()} initialized to the given value.
     *
     * <p>
     * The configuration for a Microsoft Active Directory (Microsoft AD) studio resource.
     * </p>
     * 
     * @param activeDirectoryConfiguration
     *        The configuration for a Microsoft Active Directory (Microsoft AD) studio resource.
     */
    public static StudioComponentConfiguration fromActiveDirectoryConfiguration(
            Consumer<ActiveDirectoryConfiguration.Builder> activeDirectoryConfiguration) {
        ActiveDirectoryConfiguration.Builder builder = ActiveDirectoryConfiguration.builder();
        activeDirectoryConfiguration.accept(builder);
        return fromActiveDirectoryConfiguration(builder.build());
    }

    /**
     * Create an instance of this class with {@link #computeFarmConfiguration()} initialized to the given value.
     *
     * <p>
     * The configuration for a render farm that is associated with a studio resource.
     * </p>
     * 
     * @param computeFarmConfiguration
     *        The configuration for a render farm that is associated with a studio resource.
     */
    public static StudioComponentConfiguration fromComputeFarmConfiguration(ComputeFarmConfiguration computeFarmConfiguration) {
        return builder().computeFarmConfiguration(computeFarmConfiguration).build();
    }

    /**
     * Create an instance of this class with {@link #computeFarmConfiguration()} initialized to the given value.
     *
     * <p>
     * The configuration for a render farm that is associated with a studio resource.
     * </p>
     * 
     * @param computeFarmConfiguration
     *        The configuration for a render farm that is associated with a studio resource.
     */
    public static StudioComponentConfiguration fromComputeFarmConfiguration(
            Consumer<ComputeFarmConfiguration.Builder> computeFarmConfiguration) {
        ComputeFarmConfiguration.Builder builder = ComputeFarmConfiguration.builder();
        computeFarmConfiguration.accept(builder);
        return fromComputeFarmConfiguration(builder.build());
    }

    /**
     * Create an instance of this class with {@link #licenseServiceConfiguration()} initialized to the given value.
     *
     * <p>
     * The configuration for a license service that is associated with a studio resource.
     * </p>
     * 
     * @param licenseServiceConfiguration
     *        The configuration for a license service that is associated with a studio resource.
     */
    public static StudioComponentConfiguration fromLicenseServiceConfiguration(
            LicenseServiceConfiguration licenseServiceConfiguration) {
        return builder().licenseServiceConfiguration(licenseServiceConfiguration).build();
    }

    /**
     * Create an instance of this class with {@link #licenseServiceConfiguration()} initialized to the given value.
     *
     * <p>
     * The configuration for a license service that is associated with a studio resource.
     * </p>
     * 
     * @param licenseServiceConfiguration
     *        The configuration for a license service that is associated with a studio resource.
     */
    public static StudioComponentConfiguration fromLicenseServiceConfiguration(
            Consumer<LicenseServiceConfiguration.Builder> licenseServiceConfiguration) {
        LicenseServiceConfiguration.Builder builder = LicenseServiceConfiguration.builder();
        licenseServiceConfiguration.accept(builder);
        return fromLicenseServiceConfiguration(builder.build());
    }

    /**
     * Create an instance of this class with {@link #sharedFileSystemConfiguration()} initialized to the given value.
     *
     * <p>
     * The configuration for a shared file storage system that is associated with a studio resource.
     * </p>
     * 
     * @param sharedFileSystemConfiguration
     *        The configuration for a shared file storage system that is associated with a studio resource.
     */
    public static StudioComponentConfiguration fromSharedFileSystemConfiguration(
            SharedFileSystemConfiguration sharedFileSystemConfiguration) {
        return builder().sharedFileSystemConfiguration(sharedFileSystemConfiguration).build();
    }

    /**
     * Create an instance of this class with {@link #sharedFileSystemConfiguration()} initialized to the given value.
     *
     * <p>
     * The configuration for a shared file storage system that is associated with a studio resource.
     * </p>
     * 
     * @param sharedFileSystemConfiguration
     *        The configuration for a shared file storage system that is associated with a studio resource.
     */
    public static StudioComponentConfiguration fromSharedFileSystemConfiguration(
            Consumer<SharedFileSystemConfiguration.Builder> sharedFileSystemConfiguration) {
        SharedFileSystemConfiguration.Builder builder = SharedFileSystemConfiguration.builder();
        sharedFileSystemConfiguration.accept(builder);
        return fromSharedFileSystemConfiguration(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StudioComponentConfiguration, T> g) {
        return obj -> g.apply((StudioComponentConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StudioComponentConfiguration> {
        /**
         * <p>
         * The configuration for a Microsoft Active Directory (Microsoft AD) studio resource.
         * </p>
         * 
         * @param activeDirectoryConfiguration
         *        The configuration for a Microsoft Active Directory (Microsoft AD) studio resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeDirectoryConfiguration(ActiveDirectoryConfiguration activeDirectoryConfiguration);

        /**
         * <p>
         * The configuration for a Microsoft Active Directory (Microsoft AD) studio resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActiveDirectoryConfiguration.Builder}
         * avoiding the need to create one manually via {@link ActiveDirectoryConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ActiveDirectoryConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #activeDirectoryConfiguration(ActiveDirectoryConfiguration)}.
         * 
         * @param activeDirectoryConfiguration
         *        a consumer that will call methods on {@link ActiveDirectoryConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #activeDirectoryConfiguration(ActiveDirectoryConfiguration)
         */
        default Builder activeDirectoryConfiguration(Consumer<ActiveDirectoryConfiguration.Builder> activeDirectoryConfiguration) {
            return activeDirectoryConfiguration(ActiveDirectoryConfiguration.builder()
                    .applyMutation(activeDirectoryConfiguration).build());
        }

        /**
         * <p>
         * The configuration for a render farm that is associated with a studio resource.
         * </p>
         * 
         * @param computeFarmConfiguration
         *        The configuration for a render farm that is associated with a studio resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeFarmConfiguration(ComputeFarmConfiguration computeFarmConfiguration);

        /**
         * <p>
         * The configuration for a render farm that is associated with a studio resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link ComputeFarmConfiguration.Builder}
         * avoiding the need to create one manually via {@link ComputeFarmConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ComputeFarmConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #computeFarmConfiguration(ComputeFarmConfiguration)}.
         * 
         * @param computeFarmConfiguration
         *        a consumer that will call methods on {@link ComputeFarmConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #computeFarmConfiguration(ComputeFarmConfiguration)
         */
        default Builder computeFarmConfiguration(Consumer<ComputeFarmConfiguration.Builder> computeFarmConfiguration) {
            return computeFarmConfiguration(ComputeFarmConfiguration.builder().applyMutation(computeFarmConfiguration).build());
        }

        /**
         * <p>
         * The configuration for a license service that is associated with a studio resource.
         * </p>
         * 
         * @param licenseServiceConfiguration
         *        The configuration for a license service that is associated with a studio resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseServiceConfiguration(LicenseServiceConfiguration licenseServiceConfiguration);

        /**
         * <p>
         * The configuration for a license service that is associated with a studio resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link LicenseServiceConfiguration.Builder}
         * avoiding the need to create one manually via {@link LicenseServiceConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link LicenseServiceConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #licenseServiceConfiguration(LicenseServiceConfiguration)}.
         * 
         * @param licenseServiceConfiguration
         *        a consumer that will call methods on {@link LicenseServiceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #licenseServiceConfiguration(LicenseServiceConfiguration)
         */
        default Builder licenseServiceConfiguration(Consumer<LicenseServiceConfiguration.Builder> licenseServiceConfiguration) {
            return licenseServiceConfiguration(LicenseServiceConfiguration.builder().applyMutation(licenseServiceConfiguration)
                    .build());
        }

        /**
         * <p>
         * The configuration for a shared file storage system that is associated with a studio resource.
         * </p>
         * 
         * @param sharedFileSystemConfiguration
         *        The configuration for a shared file storage system that is associated with a studio resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharedFileSystemConfiguration(SharedFileSystemConfiguration sharedFileSystemConfiguration);

        /**
         * <p>
         * The configuration for a shared file storage system that is associated with a studio resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link SharedFileSystemConfiguration.Builder}
         * avoiding the need to create one manually via {@link SharedFileSystemConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link SharedFileSystemConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #sharedFileSystemConfiguration(SharedFileSystemConfiguration)}
         * .
         * 
         * @param sharedFileSystemConfiguration
         *        a consumer that will call methods on {@link SharedFileSystemConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sharedFileSystemConfiguration(SharedFileSystemConfiguration)
         */
        default Builder sharedFileSystemConfiguration(
                Consumer<SharedFileSystemConfiguration.Builder> sharedFileSystemConfiguration) {
            return sharedFileSystemConfiguration(SharedFileSystemConfiguration.builder()
                    .applyMutation(sharedFileSystemConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ActiveDirectoryConfiguration activeDirectoryConfiguration;

        private ComputeFarmConfiguration computeFarmConfiguration;

        private LicenseServiceConfiguration licenseServiceConfiguration;

        private SharedFileSystemConfiguration sharedFileSystemConfiguration;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(StudioComponentConfiguration model) {
            activeDirectoryConfiguration(model.activeDirectoryConfiguration);
            computeFarmConfiguration(model.computeFarmConfiguration);
            licenseServiceConfiguration(model.licenseServiceConfiguration);
            sharedFileSystemConfiguration(model.sharedFileSystemConfiguration);
        }

        public final ActiveDirectoryConfiguration.Builder getActiveDirectoryConfiguration() {
            return activeDirectoryConfiguration != null ? activeDirectoryConfiguration.toBuilder() : null;
        }

        public final void setActiveDirectoryConfiguration(ActiveDirectoryConfiguration.BuilderImpl activeDirectoryConfiguration) {
            Object oldValue = this.activeDirectoryConfiguration;
            this.activeDirectoryConfiguration = activeDirectoryConfiguration != null ? activeDirectoryConfiguration.build()
                    : null;
            handleUnionValueChange(Type.ACTIVE_DIRECTORY_CONFIGURATION, oldValue, this.activeDirectoryConfiguration);
        }

        @Override
        public final Builder activeDirectoryConfiguration(ActiveDirectoryConfiguration activeDirectoryConfiguration) {
            Object oldValue = this.activeDirectoryConfiguration;
            this.activeDirectoryConfiguration = activeDirectoryConfiguration;
            handleUnionValueChange(Type.ACTIVE_DIRECTORY_CONFIGURATION, oldValue, this.activeDirectoryConfiguration);
            return this;
        }

        public final ComputeFarmConfiguration.Builder getComputeFarmConfiguration() {
            return computeFarmConfiguration != null ? computeFarmConfiguration.toBuilder() : null;
        }

        public final void setComputeFarmConfiguration(ComputeFarmConfiguration.BuilderImpl computeFarmConfiguration) {
            Object oldValue = this.computeFarmConfiguration;
            this.computeFarmConfiguration = computeFarmConfiguration != null ? computeFarmConfiguration.build() : null;
            handleUnionValueChange(Type.COMPUTE_FARM_CONFIGURATION, oldValue, this.computeFarmConfiguration);
        }

        @Override
        public final Builder computeFarmConfiguration(ComputeFarmConfiguration computeFarmConfiguration) {
            Object oldValue = this.computeFarmConfiguration;
            this.computeFarmConfiguration = computeFarmConfiguration;
            handleUnionValueChange(Type.COMPUTE_FARM_CONFIGURATION, oldValue, this.computeFarmConfiguration);
            return this;
        }

        public final LicenseServiceConfiguration.Builder getLicenseServiceConfiguration() {
            return licenseServiceConfiguration != null ? licenseServiceConfiguration.toBuilder() : null;
        }

        public final void setLicenseServiceConfiguration(LicenseServiceConfiguration.BuilderImpl licenseServiceConfiguration) {
            Object oldValue = this.licenseServiceConfiguration;
            this.licenseServiceConfiguration = licenseServiceConfiguration != null ? licenseServiceConfiguration.build() : null;
            handleUnionValueChange(Type.LICENSE_SERVICE_CONFIGURATION, oldValue, this.licenseServiceConfiguration);
        }

        @Override
        public final Builder licenseServiceConfiguration(LicenseServiceConfiguration licenseServiceConfiguration) {
            Object oldValue = this.licenseServiceConfiguration;
            this.licenseServiceConfiguration = licenseServiceConfiguration;
            handleUnionValueChange(Type.LICENSE_SERVICE_CONFIGURATION, oldValue, this.licenseServiceConfiguration);
            return this;
        }

        public final SharedFileSystemConfiguration.Builder getSharedFileSystemConfiguration() {
            return sharedFileSystemConfiguration != null ? sharedFileSystemConfiguration.toBuilder() : null;
        }

        public final void setSharedFileSystemConfiguration(SharedFileSystemConfiguration.BuilderImpl sharedFileSystemConfiguration) {
            Object oldValue = this.sharedFileSystemConfiguration;
            this.sharedFileSystemConfiguration = sharedFileSystemConfiguration != null ? sharedFileSystemConfiguration.build()
                    : null;
            handleUnionValueChange(Type.SHARED_FILE_SYSTEM_CONFIGURATION, oldValue, this.sharedFileSystemConfiguration);
        }

        @Override
        public final Builder sharedFileSystemConfiguration(SharedFileSystemConfiguration sharedFileSystemConfiguration) {
            Object oldValue = this.sharedFileSystemConfiguration;
            this.sharedFileSystemConfiguration = sharedFileSystemConfiguration;
            handleUnionValueChange(Type.SHARED_FILE_SYSTEM_CONFIGURATION, oldValue, this.sharedFileSystemConfiguration);
            return this;
        }

        @Override
        public StudioComponentConfiguration build() {
            return new StudioComponentConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see StudioComponentConfiguration#type()
     */
    public enum Type {
        ACTIVE_DIRECTORY_CONFIGURATION,

        COMPUTE_FARM_CONFIGURATION,

        LICENSE_SERVICE_CONFIGURATION,

        SHARED_FILE_SYSTEM_CONFIGURATION,

        UNKNOWN_TO_SDK_VERSION
    }
}
