/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.nimble.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Launch Profile Initialization Active Directory contains information required for the launch profile to connect to
 * the Active Directory.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LaunchProfileInitializationActiveDirectory implements SdkPojo, Serializable,
        ToCopyableBuilder<LaunchProfileInitializationActiveDirectory.Builder, LaunchProfileInitializationActiveDirectory> {
    private static final SdkField<List<ActiveDirectoryComputerAttribute>> COMPUTER_ATTRIBUTES_FIELD = SdkField
            .<List<ActiveDirectoryComputerAttribute>> builder(MarshallingType.LIST)
            .memberName("computerAttributes")
            .getter(getter(LaunchProfileInitializationActiveDirectory::computerAttributes))
            .setter(setter(Builder::computerAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computerAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ActiveDirectoryComputerAttribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(ActiveDirectoryComputerAttribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("directoryId").getter(getter(LaunchProfileInitializationActiveDirectory::directoryId))
            .setter(setter(Builder::directoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("directoryId").build()).build();

    private static final SdkField<String> DIRECTORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("directoryName").getter(getter(LaunchProfileInitializationActiveDirectory::directoryName))
            .setter(setter(Builder::directoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("directoryName").build()).build();

    private static final SdkField<List<String>> DNS_IP_ADDRESSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("dnsIpAddresses")
            .getter(getter(LaunchProfileInitializationActiveDirectory::dnsIpAddresses))
            .setter(setter(Builder::dnsIpAddresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dnsIpAddresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ORGANIZATIONAL_UNIT_DISTINGUISHED_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("organizationalUnitDistinguishedName")
            .getter(getter(LaunchProfileInitializationActiveDirectory::organizationalUnitDistinguishedName))
            .setter(setter(Builder::organizationalUnitDistinguishedName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("organizationalUnitDistinguishedName").build()).build();

    private static final SdkField<String> STUDIO_COMPONENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("studioComponentId").getter(getter(LaunchProfileInitializationActiveDirectory::studioComponentId))
            .setter(setter(Builder::studioComponentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("studioComponentId").build()).build();

    private static final SdkField<String> STUDIO_COMPONENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("studioComponentName").getter(getter(LaunchProfileInitializationActiveDirectory::studioComponentName))
            .setter(setter(Builder::studioComponentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("studioComponentName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTER_ATTRIBUTES_FIELD,
            DIRECTORY_ID_FIELD, DIRECTORY_NAME_FIELD, DNS_IP_ADDRESSES_FIELD, ORGANIZATIONAL_UNIT_DISTINGUISHED_NAME_FIELD,
            STUDIO_COMPONENT_ID_FIELD, STUDIO_COMPONENT_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<ActiveDirectoryComputerAttribute> computerAttributes;

    private final String directoryId;

    private final String directoryName;

    private final List<String> dnsIpAddresses;

    private final String organizationalUnitDistinguishedName;

    private final String studioComponentId;

    private final String studioComponentName;

    private LaunchProfileInitializationActiveDirectory(BuilderImpl builder) {
        this.computerAttributes = builder.computerAttributes;
        this.directoryId = builder.directoryId;
        this.directoryName = builder.directoryName;
        this.dnsIpAddresses = builder.dnsIpAddresses;
        this.organizationalUnitDistinguishedName = builder.organizationalUnitDistinguishedName;
        this.studioComponentId = builder.studioComponentId;
        this.studioComponentName = builder.studioComponentName;
    }

    /**
     * For responses, this returns true if the service returned a value for the ComputerAttributes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasComputerAttributes() {
        return computerAttributes != null && !(computerAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A collection of custom attributes for an Active Directory computer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasComputerAttributes} method.
     * </p>
     * 
     * @return A collection of custom attributes for an Active Directory computer.
     */
    public final List<ActiveDirectoryComputerAttribute> computerAttributes() {
        return computerAttributes;
    }

    /**
     * <p>
     * The directory ID of the Directory Service for Microsoft Active Directory to access using this launch profile.
     * </p>
     * 
     * @return The directory ID of the Directory Service for Microsoft Active Directory to access using this launch
     *         profile.
     */
    public final String directoryId() {
        return directoryId;
    }

    /**
     * <p>
     * The directory name.
     * </p>
     * 
     * @return The directory name.
     */
    public final String directoryName() {
        return directoryName;
    }

    /**
     * For responses, this returns true if the service returned a value for the DnsIpAddresses property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDnsIpAddresses() {
        return dnsIpAddresses != null && !(dnsIpAddresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The DNS IP address.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDnsIpAddresses} method.
     * </p>
     * 
     * @return The DNS IP address.
     */
    public final List<String> dnsIpAddresses() {
        return dnsIpAddresses;
    }

    /**
     * <p>
     * The name for the organizational unit distinguished name.
     * </p>
     * 
     * @return The name for the organizational unit distinguished name.
     */
    public final String organizationalUnitDistinguishedName() {
        return organizationalUnitDistinguishedName;
    }

    /**
     * <p>
     * The unique identifier for a studio component resource.
     * </p>
     * 
     * @return The unique identifier for a studio component resource.
     */
    public final String studioComponentId() {
        return studioComponentId;
    }

    /**
     * <p>
     * The name for the studio component.
     * </p>
     * 
     * @return The name for the studio component.
     */
    public final String studioComponentName() {
        return studioComponentName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasComputerAttributes() ? computerAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(directoryName());
        hashCode = 31 * hashCode + Objects.hashCode(hasDnsIpAddresses() ? dnsIpAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(organizationalUnitDistinguishedName());
        hashCode = 31 * hashCode + Objects.hashCode(studioComponentId());
        hashCode = 31 * hashCode + Objects.hashCode(studioComponentName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchProfileInitializationActiveDirectory)) {
            return false;
        }
        LaunchProfileInitializationActiveDirectory other = (LaunchProfileInitializationActiveDirectory) obj;
        return hasComputerAttributes() == other.hasComputerAttributes()
                && Objects.equals(computerAttributes(), other.computerAttributes())
                && Objects.equals(directoryId(), other.directoryId()) && Objects.equals(directoryName(), other.directoryName())
                && hasDnsIpAddresses() == other.hasDnsIpAddresses() && Objects.equals(dnsIpAddresses(), other.dnsIpAddresses())
                && Objects.equals(organizationalUnitDistinguishedName(), other.organizationalUnitDistinguishedName())
                && Objects.equals(studioComponentId(), other.studioComponentId())
                && Objects.equals(studioComponentName(), other.studioComponentName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LaunchProfileInitializationActiveDirectory")
                .add("ComputerAttributes", computerAttributes() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DirectoryId", directoryId()).add("DirectoryName", directoryName())
                .add("DnsIpAddresses", hasDnsIpAddresses() ? dnsIpAddresses() : null)
                .add("OrganizationalUnitDistinguishedName", organizationalUnitDistinguishedName())
                .add("StudioComponentId", studioComponentId())
                .add("StudioComponentName", studioComponentName() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "computerAttributes":
            return Optional.ofNullable(clazz.cast(computerAttributes()));
        case "directoryId":
            return Optional.ofNullable(clazz.cast(directoryId()));
        case "directoryName":
            return Optional.ofNullable(clazz.cast(directoryName()));
        case "dnsIpAddresses":
            return Optional.ofNullable(clazz.cast(dnsIpAddresses()));
        case "organizationalUnitDistinguishedName":
            return Optional.ofNullable(clazz.cast(organizationalUnitDistinguishedName()));
        case "studioComponentId":
            return Optional.ofNullable(clazz.cast(studioComponentId()));
        case "studioComponentName":
            return Optional.ofNullable(clazz.cast(studioComponentName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LaunchProfileInitializationActiveDirectory, T> g) {
        return obj -> g.apply((LaunchProfileInitializationActiveDirectory) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LaunchProfileInitializationActiveDirectory> {
        /**
         * <p>
         * A collection of custom attributes for an Active Directory computer.
         * </p>
         * 
         * @param computerAttributes
         *        A collection of custom attributes for an Active Directory computer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computerAttributes(Collection<ActiveDirectoryComputerAttribute> computerAttributes);

        /**
         * <p>
         * A collection of custom attributes for an Active Directory computer.
         * </p>
         * 
         * @param computerAttributes
         *        A collection of custom attributes for an Active Directory computer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computerAttributes(ActiveDirectoryComputerAttribute... computerAttributes);

        /**
         * <p>
         * A collection of custom attributes for an Active Directory computer.
         * </p>
         * This is a convenience method that creates an instance of the {@link List
         * <ActiveDirectoryComputerAttribute>.Builder} avoiding the need to create one manually via {@link List
         * <ActiveDirectoryComputerAttribute>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ActiveDirectoryComputerAttribute>.Builder#build()} is called
         * immediately and its result is passed to {@link #computerAttributes(List<ActiveDirectoryComputerAttribute>)}.
         * 
         * @param computerAttributes
         *        a consumer that will call methods on {@link List<ActiveDirectoryComputerAttribute>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #computerAttributes(List<ActiveDirectoryComputerAttribute>)
         */
        Builder computerAttributes(Consumer<ActiveDirectoryComputerAttribute.Builder>... computerAttributes);

        /**
         * <p>
         * The directory ID of the Directory Service for Microsoft Active Directory to access using this launch profile.
         * </p>
         * 
         * @param directoryId
         *        The directory ID of the Directory Service for Microsoft Active Directory to access using this launch
         *        profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryId(String directoryId);

        /**
         * <p>
         * The directory name.
         * </p>
         * 
         * @param directoryName
         *        The directory name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryName(String directoryName);

        /**
         * <p>
         * The DNS IP address.
         * </p>
         * 
         * @param dnsIpAddresses
         *        The DNS IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsIpAddresses(Collection<String> dnsIpAddresses);

        /**
         * <p>
         * The DNS IP address.
         * </p>
         * 
         * @param dnsIpAddresses
         *        The DNS IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsIpAddresses(String... dnsIpAddresses);

        /**
         * <p>
         * The name for the organizational unit distinguished name.
         * </p>
         * 
         * @param organizationalUnitDistinguishedName
         *        The name for the organizational unit distinguished name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationalUnitDistinguishedName(String organizationalUnitDistinguishedName);

        /**
         * <p>
         * The unique identifier for a studio component resource.
         * </p>
         * 
         * @param studioComponentId
         *        The unique identifier for a studio component resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder studioComponentId(String studioComponentId);

        /**
         * <p>
         * The name for the studio component.
         * </p>
         * 
         * @param studioComponentName
         *        The name for the studio component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder studioComponentName(String studioComponentName);
    }

    static final class BuilderImpl implements Builder {
        private List<ActiveDirectoryComputerAttribute> computerAttributes = DefaultSdkAutoConstructList.getInstance();

        private String directoryId;

        private String directoryName;

        private List<String> dnsIpAddresses = DefaultSdkAutoConstructList.getInstance();

        private String organizationalUnitDistinguishedName;

        private String studioComponentId;

        private String studioComponentName;

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchProfileInitializationActiveDirectory model) {
            computerAttributes(model.computerAttributes);
            directoryId(model.directoryId);
            directoryName(model.directoryName);
            dnsIpAddresses(model.dnsIpAddresses);
            organizationalUnitDistinguishedName(model.organizationalUnitDistinguishedName);
            studioComponentId(model.studioComponentId);
            studioComponentName(model.studioComponentName);
        }

        public final List<ActiveDirectoryComputerAttribute.Builder> getComputerAttributes() {
            List<ActiveDirectoryComputerAttribute.Builder> result = ActiveDirectoryComputerAttributeListCopier
                    .copyToBuilder(this.computerAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setComputerAttributes(Collection<ActiveDirectoryComputerAttribute.BuilderImpl> computerAttributes) {
            this.computerAttributes = ActiveDirectoryComputerAttributeListCopier.copyFromBuilder(computerAttributes);
        }

        @Override
        public final Builder computerAttributes(Collection<ActiveDirectoryComputerAttribute> computerAttributes) {
            this.computerAttributes = ActiveDirectoryComputerAttributeListCopier.copy(computerAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computerAttributes(ActiveDirectoryComputerAttribute... computerAttributes) {
            computerAttributes(Arrays.asList(computerAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computerAttributes(Consumer<ActiveDirectoryComputerAttribute.Builder>... computerAttributes) {
            computerAttributes(Stream.of(computerAttributes)
                    .map(c -> ActiveDirectoryComputerAttribute.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDirectoryId() {
            return directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final String getDirectoryName() {
            return directoryName;
        }

        public final void setDirectoryName(String directoryName) {
            this.directoryName = directoryName;
        }

        @Override
        public final Builder directoryName(String directoryName) {
            this.directoryName = directoryName;
            return this;
        }

        public final Collection<String> getDnsIpAddresses() {
            if (dnsIpAddresses instanceof SdkAutoConstructList) {
                return null;
            }
            return dnsIpAddresses;
        }

        public final void setDnsIpAddresses(Collection<String> dnsIpAddresses) {
            this.dnsIpAddresses = ActiveDirectoryDnsIpAddressListCopier.copy(dnsIpAddresses);
        }

        @Override
        public final Builder dnsIpAddresses(Collection<String> dnsIpAddresses) {
            this.dnsIpAddresses = ActiveDirectoryDnsIpAddressListCopier.copy(dnsIpAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dnsIpAddresses(String... dnsIpAddresses) {
            dnsIpAddresses(Arrays.asList(dnsIpAddresses));
            return this;
        }

        public final String getOrganizationalUnitDistinguishedName() {
            return organizationalUnitDistinguishedName;
        }

        public final void setOrganizationalUnitDistinguishedName(String organizationalUnitDistinguishedName) {
            this.organizationalUnitDistinguishedName = organizationalUnitDistinguishedName;
        }

        @Override
        public final Builder organizationalUnitDistinguishedName(String organizationalUnitDistinguishedName) {
            this.organizationalUnitDistinguishedName = organizationalUnitDistinguishedName;
            return this;
        }

        public final String getStudioComponentId() {
            return studioComponentId;
        }

        public final void setStudioComponentId(String studioComponentId) {
            this.studioComponentId = studioComponentId;
        }

        @Override
        public final Builder studioComponentId(String studioComponentId) {
            this.studioComponentId = studioComponentId;
            return this;
        }

        public final String getStudioComponentName() {
            return studioComponentName;
        }

        public final void setStudioComponentName(String studioComponentName) {
            this.studioComponentName = studioComponentName;
        }

        @Override
        public final Builder studioComponentName(String studioComponentName) {
            this.studioComponentName = studioComponentName;
            return this;
        }

        @Override
        public LaunchProfileInitializationActiveDirectory build() {
            return new LaunchProfileInitializationActiveDirectory(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
