/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.nimble.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListStreamingSessionsRequest extends NimbleRequest implements
        ToCopyableBuilder<ListStreamingSessionsRequest.Builder, ListStreamingSessionsRequest> {
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(ListStreamingSessionsRequest::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("createdBy").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListStreamingSessionsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> OWNED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ownedBy").getter(getter(ListStreamingSessionsRequest::ownedBy)).setter(setter(Builder::ownedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ownedBy").build()).build();

    private static final SdkField<String> SESSION_IDS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionIds").getter(getter(ListStreamingSessionsRequest::sessionIds))
            .setter(setter(Builder::sessionIds))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("sessionIds").build()).build();

    private static final SdkField<String> STUDIO_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("studioId").getter(getter(ListStreamingSessionsRequest::studioId)).setter(setter(Builder::studioId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("studioId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_BY_FIELD,
            NEXT_TOKEN_FIELD, OWNED_BY_FIELD, SESSION_IDS_FIELD, STUDIO_ID_FIELD));

    private final String createdBy;

    private final String nextToken;

    private final String ownedBy;

    private final String sessionIds;

    private final String studioId;

    private ListStreamingSessionsRequest(BuilderImpl builder) {
        super(builder);
        this.createdBy = builder.createdBy;
        this.nextToken = builder.nextToken;
        this.ownedBy = builder.ownedBy;
        this.sessionIds = builder.sessionIds;
        this.studioId = builder.studioId;
    }

    /**
     * <p>
     * Filters the request to streaming sessions created by the given user.
     * </p>
     * 
     * @return Filters the request to streaming sessions created by the given user.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The token to request the next page of results.
     * </p>
     * 
     * @return The token to request the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Filters the request to streaming session owned by the given user
     * </p>
     * 
     * @return Filters the request to streaming session owned by the given user
     */
    public final String ownedBy() {
        return ownedBy;
    }

    /**
     * <p>
     * Filters the request to only the provided session IDs.
     * </p>
     * 
     * @return Filters the request to only the provided session IDs.
     */
    public final String sessionIds() {
        return sessionIds;
    }

    /**
     * <p>
     * The studio ID.
     * </p>
     * 
     * @return The studio ID.
     */
    public final String studioId() {
        return studioId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(ownedBy());
        hashCode = 31 * hashCode + Objects.hashCode(sessionIds());
        hashCode = 31 * hashCode + Objects.hashCode(studioId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStreamingSessionsRequest)) {
            return false;
        }
        ListStreamingSessionsRequest other = (ListStreamingSessionsRequest) obj;
        return Objects.equals(createdBy(), other.createdBy()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(ownedBy(), other.ownedBy()) && Objects.equals(sessionIds(), other.sessionIds())
                && Objects.equals(studioId(), other.studioId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListStreamingSessionsRequest").add("CreatedBy", createdBy()).add("NextToken", nextToken())
                .add("OwnedBy", ownedBy()).add("SessionIds", sessionIds()).add("StudioId", studioId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "ownedBy":
            return Optional.ofNullable(clazz.cast(ownedBy()));
        case "sessionIds":
            return Optional.ofNullable(clazz.cast(sessionIds()));
        case "studioId":
            return Optional.ofNullable(clazz.cast(studioId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListStreamingSessionsRequest, T> g) {
        return obj -> g.apply((ListStreamingSessionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NimbleRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListStreamingSessionsRequest> {
        /**
         * <p>
         * Filters the request to streaming sessions created by the given user.
         * </p>
         * 
         * @param createdBy
         *        Filters the request to streaming sessions created by the given user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The token to request the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token to request the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Filters the request to streaming session owned by the given user
         * </p>
         * 
         * @param ownedBy
         *        Filters the request to streaming session owned by the given user
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownedBy(String ownedBy);

        /**
         * <p>
         * Filters the request to only the provided session IDs.
         * </p>
         * 
         * @param sessionIds
         *        Filters the request to only the provided session IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionIds(String sessionIds);

        /**
         * <p>
         * The studio ID.
         * </p>
         * 
         * @param studioId
         *        The studio ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder studioId(String studioId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NimbleRequest.BuilderImpl implements Builder {
        private String createdBy;

        private String nextToken;

        private String ownedBy;

        private String sessionIds;

        private String studioId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStreamingSessionsRequest model) {
            super(model);
            createdBy(model.createdBy);
            nextToken(model.nextToken);
            ownedBy(model.ownedBy);
            sessionIds(model.sessionIds);
            studioId(model.studioId);
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getOwnedBy() {
            return ownedBy;
        }

        public final void setOwnedBy(String ownedBy) {
            this.ownedBy = ownedBy;
        }

        @Override
        public final Builder ownedBy(String ownedBy) {
            this.ownedBy = ownedBy;
            return this;
        }

        public final String getSessionIds() {
            return sessionIds;
        }

        public final void setSessionIds(String sessionIds) {
            this.sessionIds = sessionIds;
        }

        @Override
        public final Builder sessionIds(String sessionIds) {
            this.sessionIds = sessionIds;
            return this;
        }

        public final String getStudioId() {
            return studioId;
        }

        public final void setStudioId(String studioId) {
            this.studioId = studioId;
        }

        @Override
        public final Builder studioId(String studioId) {
            this.studioId = studioId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListStreamingSessionsRequest build() {
            return new ListStreamingSessionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
