/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.nimble;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.util.VersionInfo;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.nimble.model.AcceptEulasRequest;
import software.amazon.awssdk.services.nimble.model.AcceptEulasResponse;
import software.amazon.awssdk.services.nimble.model.AccessDeniedException;
import software.amazon.awssdk.services.nimble.model.ConflictException;
import software.amazon.awssdk.services.nimble.model.CreateLaunchProfileRequest;
import software.amazon.awssdk.services.nimble.model.CreateLaunchProfileResponse;
import software.amazon.awssdk.services.nimble.model.CreateStreamingImageRequest;
import software.amazon.awssdk.services.nimble.model.CreateStreamingImageResponse;
import software.amazon.awssdk.services.nimble.model.CreateStreamingSessionRequest;
import software.amazon.awssdk.services.nimble.model.CreateStreamingSessionResponse;
import software.amazon.awssdk.services.nimble.model.CreateStreamingSessionStreamRequest;
import software.amazon.awssdk.services.nimble.model.CreateStreamingSessionStreamResponse;
import software.amazon.awssdk.services.nimble.model.CreateStudioComponentRequest;
import software.amazon.awssdk.services.nimble.model.CreateStudioComponentResponse;
import software.amazon.awssdk.services.nimble.model.CreateStudioRequest;
import software.amazon.awssdk.services.nimble.model.CreateStudioResponse;
import software.amazon.awssdk.services.nimble.model.DeleteLaunchProfileMemberRequest;
import software.amazon.awssdk.services.nimble.model.DeleteLaunchProfileMemberResponse;
import software.amazon.awssdk.services.nimble.model.DeleteLaunchProfileRequest;
import software.amazon.awssdk.services.nimble.model.DeleteLaunchProfileResponse;
import software.amazon.awssdk.services.nimble.model.DeleteStreamingImageRequest;
import software.amazon.awssdk.services.nimble.model.DeleteStreamingImageResponse;
import software.amazon.awssdk.services.nimble.model.DeleteStreamingSessionRequest;
import software.amazon.awssdk.services.nimble.model.DeleteStreamingSessionResponse;
import software.amazon.awssdk.services.nimble.model.DeleteStudioComponentRequest;
import software.amazon.awssdk.services.nimble.model.DeleteStudioComponentResponse;
import software.amazon.awssdk.services.nimble.model.DeleteStudioMemberRequest;
import software.amazon.awssdk.services.nimble.model.DeleteStudioMemberResponse;
import software.amazon.awssdk.services.nimble.model.DeleteStudioRequest;
import software.amazon.awssdk.services.nimble.model.DeleteStudioResponse;
import software.amazon.awssdk.services.nimble.model.GetEulaRequest;
import software.amazon.awssdk.services.nimble.model.GetEulaResponse;
import software.amazon.awssdk.services.nimble.model.GetLaunchProfileDetailsRequest;
import software.amazon.awssdk.services.nimble.model.GetLaunchProfileDetailsResponse;
import software.amazon.awssdk.services.nimble.model.GetLaunchProfileInitializationRequest;
import software.amazon.awssdk.services.nimble.model.GetLaunchProfileInitializationResponse;
import software.amazon.awssdk.services.nimble.model.GetLaunchProfileMemberRequest;
import software.amazon.awssdk.services.nimble.model.GetLaunchProfileMemberResponse;
import software.amazon.awssdk.services.nimble.model.GetLaunchProfileRequest;
import software.amazon.awssdk.services.nimble.model.GetLaunchProfileResponse;
import software.amazon.awssdk.services.nimble.model.GetStreamingImageRequest;
import software.amazon.awssdk.services.nimble.model.GetStreamingImageResponse;
import software.amazon.awssdk.services.nimble.model.GetStreamingSessionRequest;
import software.amazon.awssdk.services.nimble.model.GetStreamingSessionResponse;
import software.amazon.awssdk.services.nimble.model.GetStreamingSessionStreamRequest;
import software.amazon.awssdk.services.nimble.model.GetStreamingSessionStreamResponse;
import software.amazon.awssdk.services.nimble.model.GetStudioComponentRequest;
import software.amazon.awssdk.services.nimble.model.GetStudioComponentResponse;
import software.amazon.awssdk.services.nimble.model.GetStudioMemberRequest;
import software.amazon.awssdk.services.nimble.model.GetStudioMemberResponse;
import software.amazon.awssdk.services.nimble.model.GetStudioRequest;
import software.amazon.awssdk.services.nimble.model.GetStudioResponse;
import software.amazon.awssdk.services.nimble.model.InternalServerErrorException;
import software.amazon.awssdk.services.nimble.model.ListEulaAcceptancesRequest;
import software.amazon.awssdk.services.nimble.model.ListEulaAcceptancesResponse;
import software.amazon.awssdk.services.nimble.model.ListEulasRequest;
import software.amazon.awssdk.services.nimble.model.ListEulasResponse;
import software.amazon.awssdk.services.nimble.model.ListLaunchProfileMembersRequest;
import software.amazon.awssdk.services.nimble.model.ListLaunchProfileMembersResponse;
import software.amazon.awssdk.services.nimble.model.ListLaunchProfilesRequest;
import software.amazon.awssdk.services.nimble.model.ListLaunchProfilesResponse;
import software.amazon.awssdk.services.nimble.model.ListStreamingImagesRequest;
import software.amazon.awssdk.services.nimble.model.ListStreamingImagesResponse;
import software.amazon.awssdk.services.nimble.model.ListStreamingSessionsRequest;
import software.amazon.awssdk.services.nimble.model.ListStreamingSessionsResponse;
import software.amazon.awssdk.services.nimble.model.ListStudioComponentsRequest;
import software.amazon.awssdk.services.nimble.model.ListStudioComponentsResponse;
import software.amazon.awssdk.services.nimble.model.ListStudioMembersRequest;
import software.amazon.awssdk.services.nimble.model.ListStudioMembersResponse;
import software.amazon.awssdk.services.nimble.model.ListStudiosRequest;
import software.amazon.awssdk.services.nimble.model.ListStudiosResponse;
import software.amazon.awssdk.services.nimble.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.nimble.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.nimble.model.NimbleException;
import software.amazon.awssdk.services.nimble.model.NimbleRequest;
import software.amazon.awssdk.services.nimble.model.PutLaunchProfileMembersRequest;
import software.amazon.awssdk.services.nimble.model.PutLaunchProfileMembersResponse;
import software.amazon.awssdk.services.nimble.model.PutStudioMembersRequest;
import software.amazon.awssdk.services.nimble.model.PutStudioMembersResponse;
import software.amazon.awssdk.services.nimble.model.ResourceNotFoundException;
import software.amazon.awssdk.services.nimble.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.nimble.model.StartStreamingSessionRequest;
import software.amazon.awssdk.services.nimble.model.StartStreamingSessionResponse;
import software.amazon.awssdk.services.nimble.model.StartStudioSsoConfigurationRepairRequest;
import software.amazon.awssdk.services.nimble.model.StartStudioSsoConfigurationRepairResponse;
import software.amazon.awssdk.services.nimble.model.StopStreamingSessionRequest;
import software.amazon.awssdk.services.nimble.model.StopStreamingSessionResponse;
import software.amazon.awssdk.services.nimble.model.TagResourceRequest;
import software.amazon.awssdk.services.nimble.model.TagResourceResponse;
import software.amazon.awssdk.services.nimble.model.ThrottlingException;
import software.amazon.awssdk.services.nimble.model.UntagResourceRequest;
import software.amazon.awssdk.services.nimble.model.UntagResourceResponse;
import software.amazon.awssdk.services.nimble.model.UpdateLaunchProfileMemberRequest;
import software.amazon.awssdk.services.nimble.model.UpdateLaunchProfileMemberResponse;
import software.amazon.awssdk.services.nimble.model.UpdateLaunchProfileRequest;
import software.amazon.awssdk.services.nimble.model.UpdateLaunchProfileResponse;
import software.amazon.awssdk.services.nimble.model.UpdateStreamingImageRequest;
import software.amazon.awssdk.services.nimble.model.UpdateStreamingImageResponse;
import software.amazon.awssdk.services.nimble.model.UpdateStudioComponentRequest;
import software.amazon.awssdk.services.nimble.model.UpdateStudioComponentResponse;
import software.amazon.awssdk.services.nimble.model.UpdateStudioRequest;
import software.amazon.awssdk.services.nimble.model.UpdateStudioResponse;
import software.amazon.awssdk.services.nimble.model.ValidationException;
import software.amazon.awssdk.services.nimble.paginators.ListEulaAcceptancesPublisher;
import software.amazon.awssdk.services.nimble.paginators.ListEulasPublisher;
import software.amazon.awssdk.services.nimble.paginators.ListLaunchProfileMembersPublisher;
import software.amazon.awssdk.services.nimble.paginators.ListLaunchProfilesPublisher;
import software.amazon.awssdk.services.nimble.paginators.ListStreamingImagesPublisher;
import software.amazon.awssdk.services.nimble.paginators.ListStreamingSessionsPublisher;
import software.amazon.awssdk.services.nimble.paginators.ListStudioComponentsPublisher;
import software.amazon.awssdk.services.nimble.paginators.ListStudioMembersPublisher;
import software.amazon.awssdk.services.nimble.paginators.ListStudiosPublisher;
import software.amazon.awssdk.services.nimble.transform.AcceptEulasRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.CreateLaunchProfileRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.CreateStreamingImageRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.CreateStreamingSessionRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.CreateStreamingSessionStreamRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.CreateStudioComponentRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.CreateStudioRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.DeleteLaunchProfileMemberRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.DeleteLaunchProfileRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.DeleteStreamingImageRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.DeleteStreamingSessionRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.DeleteStudioComponentRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.DeleteStudioMemberRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.DeleteStudioRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.GetEulaRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.GetLaunchProfileDetailsRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.GetLaunchProfileInitializationRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.GetLaunchProfileMemberRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.GetLaunchProfileRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.GetStreamingImageRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.GetStreamingSessionRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.GetStreamingSessionStreamRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.GetStudioComponentRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.GetStudioMemberRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.GetStudioRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.ListEulaAcceptancesRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.ListEulasRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.ListLaunchProfileMembersRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.ListLaunchProfilesRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.ListStreamingImagesRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.ListStreamingSessionsRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.ListStudioComponentsRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.ListStudioMembersRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.ListStudiosRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.PutLaunchProfileMembersRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.PutStudioMembersRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.StartStreamingSessionRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.StartStudioSsoConfigurationRepairRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.StopStreamingSessionRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.UpdateLaunchProfileMemberRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.UpdateLaunchProfileRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.UpdateStreamingImageRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.UpdateStudioComponentRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.UpdateStudioRequestMarshaller;
import software.amazon.awssdk.services.nimble.waiters.NimbleAsyncWaiter;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link NimbleAsyncClient}.
 *
 * @see NimbleAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultNimbleAsyncClient implements NimbleAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultNimbleAsyncClient.class);

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    private final ScheduledExecutorService executorService;

    protected DefaultNimbleAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
        this.executorService = clientConfiguration.option(SdkClientOption.SCHEDULED_EXECUTOR_SERVICE);
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Accept EULAs.
     * </p>
     *
     * @param acceptEulasRequest
     * @return A Java Future containing the result of the AcceptEulas operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.AcceptEulas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/AcceptEulas" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AcceptEulasResponse> acceptEulas(AcceptEulasRequest acceptEulasRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, acceptEulasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AcceptEulas");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AcceptEulasResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    AcceptEulasResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AcceptEulasResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AcceptEulasRequest, AcceptEulasResponse>()
                            .withOperationName("AcceptEulas").withMarshaller(new AcceptEulasRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(acceptEulasRequest));
            CompletableFuture<AcceptEulasResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Create a launch profile.
     * </p>
     *
     * @param createLaunchProfileRequest
     * @return A Java Future containing the result of the CreateLaunchProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.CreateLaunchProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/CreateLaunchProfile" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateLaunchProfileResponse> createLaunchProfile(
            CreateLaunchProfileRequest createLaunchProfileRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createLaunchProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateLaunchProfile");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateLaunchProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateLaunchProfileResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateLaunchProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateLaunchProfileRequest, CreateLaunchProfileResponse>()
                            .withOperationName("CreateLaunchProfile")
                            .withMarshaller(new CreateLaunchProfileRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createLaunchProfileRequest));
            CompletableFuture<CreateLaunchProfileResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a streaming image resource in a studio.
     * </p>
     *
     * @param createStreamingImageRequest
     * @return A Java Future containing the result of the CreateStreamingImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.CreateStreamingImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/CreateStreamingImage" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateStreamingImageResponse> createStreamingImage(
            CreateStreamingImageRequest createStreamingImageRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createStreamingImageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateStreamingImage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateStreamingImageResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateStreamingImageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateStreamingImageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateStreamingImageRequest, CreateStreamingImageResponse>()
                            .withOperationName("CreateStreamingImage")
                            .withMarshaller(new CreateStreamingImageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createStreamingImageRequest));
            CompletableFuture<CreateStreamingImageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a streaming session in a studio.
     * </p>
     * <p>
     * After invoking this operation, you must poll GetStreamingSession until the streaming session is in state READY.
     * </p>
     *
     * @param createStreamingSessionRequest
     * @return A Java Future containing the result of the CreateStreamingSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.CreateStreamingSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/CreateStreamingSession" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateStreamingSessionResponse> createStreamingSession(
            CreateStreamingSessionRequest createStreamingSessionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createStreamingSessionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateStreamingSession");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateStreamingSessionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateStreamingSessionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateStreamingSessionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateStreamingSessionRequest, CreateStreamingSessionResponse>()
                            .withOperationName("CreateStreamingSession")
                            .withMarshaller(new CreateStreamingSessionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createStreamingSessionRequest));
            CompletableFuture<CreateStreamingSessionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a streaming session stream for a streaming session.
     * </p>
     * <p>
     * After invoking this API, invoke GetStreamingSessionStream with the returned streamId to poll the resource until
     * it is in state READY.
     * </p>
     *
     * @param createStreamingSessionStreamRequest
     * @return A Java Future containing the result of the CreateStreamingSessionStream operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.CreateStreamingSessionStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/CreateStreamingSessionStream"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateStreamingSessionStreamResponse> createStreamingSessionStream(
            CreateStreamingSessionStreamRequest createStreamingSessionStreamRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createStreamingSessionStreamRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateStreamingSessionStream");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateStreamingSessionStreamResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateStreamingSessionStreamResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateStreamingSessionStreamResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateStreamingSessionStreamRequest, CreateStreamingSessionStreamResponse>()
                            .withOperationName("CreateStreamingSessionStream")
                            .withMarshaller(new CreateStreamingSessionStreamRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createStreamingSessionStreamRequest));
            CompletableFuture<CreateStreamingSessionStreamResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Create a new Studio.
     * </p>
     * <p>
     * When creating a Studio, two IAM roles must be provided: the admin role and the user Role. These roles are assumed
     * by your users when they log in to the Nimble Studio portal.
     * </p>
     * <p>
     * The user role must have the AmazonNimbleStudio-StudioUser managed policy attached for the portal to function
     * properly.
     * </p>
     * <p>
     * The Admin Role must have the AmazonNimbleStudio-StudioAdmin managed policy attached for the portal to function
     * properly.
     * </p>
     * <p>
     * You may optionally specify a KMS key in the StudioEncryptionConfiguration.
     * </p>
     * <p>
     * In Nimble Studio, resource names, descriptions, initialization scripts, and other data you provide are always
     * encrypted at rest using an KMS key. By default, this key is owned by Amazon Web Services and managed on your
     * behalf. You may provide your own KMS key when calling CreateStudio to encrypt this data using a key you own and
     * manage.
     * </p>
     * <p>
     * When providing an KMS key during studio creation, Nimble Studio creates KMS grants in your account to provide
     * your studio user and admin roles access to these KMS keys.
     * </p>
     * <p>
     * If you delete this grant, the studio will no longer be accessible to your portal users.
     * </p>
     * <p>
     * If you delete the studio KMS key, your studio will no longer be accessible.
     * </p>
     *
     * @param createStudioRequest
     * @return A Java Future containing the result of the CreateStudio operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.CreateStudio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/CreateStudio" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateStudioResponse> createStudio(CreateStudioRequest createStudioRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createStudioRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateStudio");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateStudioResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateStudioResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateStudioResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateStudioRequest, CreateStudioResponse>()
                            .withOperationName("CreateStudio").withMarshaller(new CreateStudioRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createStudioRequest));
            CompletableFuture<CreateStudioResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a studio component resource.
     * </p>
     *
     * @param createStudioComponentRequest
     * @return A Java Future containing the result of the CreateStudioComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.CreateStudioComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/CreateStudioComponent" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateStudioComponentResponse> createStudioComponent(
            CreateStudioComponentRequest createStudioComponentRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createStudioComponentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateStudioComponent");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateStudioComponentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateStudioComponentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateStudioComponentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateStudioComponentRequest, CreateStudioComponentResponse>()
                            .withOperationName("CreateStudioComponent")
                            .withMarshaller(new CreateStudioComponentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createStudioComponentRequest));
            CompletableFuture<CreateStudioComponentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Permanently delete a launch profile.
     * </p>
     *
     * @param deleteLaunchProfileRequest
     * @return A Java Future containing the result of the DeleteLaunchProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.DeleteLaunchProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/DeleteLaunchProfile" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteLaunchProfileResponse> deleteLaunchProfile(
            DeleteLaunchProfileRequest deleteLaunchProfileRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteLaunchProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteLaunchProfile");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteLaunchProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteLaunchProfileResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteLaunchProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteLaunchProfileRequest, DeleteLaunchProfileResponse>()
                            .withOperationName("DeleteLaunchProfile")
                            .withMarshaller(new DeleteLaunchProfileRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteLaunchProfileRequest));
            CompletableFuture<DeleteLaunchProfileResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Delete a user from launch profile membership.
     * </p>
     *
     * @param deleteLaunchProfileMemberRequest
     * @return A Java Future containing the result of the DeleteLaunchProfileMember operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.DeleteLaunchProfileMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/DeleteLaunchProfileMember"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteLaunchProfileMemberResponse> deleteLaunchProfileMember(
            DeleteLaunchProfileMemberRequest deleteLaunchProfileMemberRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteLaunchProfileMemberRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteLaunchProfileMember");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteLaunchProfileMemberResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteLaunchProfileMemberResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteLaunchProfileMemberResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteLaunchProfileMemberRequest, DeleteLaunchProfileMemberResponse>()
                            .withOperationName("DeleteLaunchProfileMember")
                            .withMarshaller(new DeleteLaunchProfileMemberRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteLaunchProfileMemberRequest));
            CompletableFuture<DeleteLaunchProfileMemberResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Delete streaming image.
     * </p>
     *
     * @param deleteStreamingImageRequest
     * @return A Java Future containing the result of the DeleteStreamingImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.DeleteStreamingImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/DeleteStreamingImage" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteStreamingImageResponse> deleteStreamingImage(
            DeleteStreamingImageRequest deleteStreamingImageRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteStreamingImageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteStreamingImage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteStreamingImageResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteStreamingImageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteStreamingImageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteStreamingImageRequest, DeleteStreamingImageResponse>()
                            .withOperationName("DeleteStreamingImage")
                            .withMarshaller(new DeleteStreamingImageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteStreamingImageRequest));
            CompletableFuture<DeleteStreamingImageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes streaming session resource.
     * </p>
     * <p>
     * After invoking this operation, use GetStreamingSession to poll the resource until it transitions to a DELETED
     * state.
     * </p>
     * <p>
     * A streaming session will count against your streaming session quota until it is marked DELETED.
     * </p>
     *
     * @param deleteStreamingSessionRequest
     * @return A Java Future containing the result of the DeleteStreamingSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.DeleteStreamingSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/DeleteStreamingSession" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteStreamingSessionResponse> deleteStreamingSession(
            DeleteStreamingSessionRequest deleteStreamingSessionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteStreamingSessionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteStreamingSession");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteStreamingSessionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteStreamingSessionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteStreamingSessionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteStreamingSessionRequest, DeleteStreamingSessionResponse>()
                            .withOperationName("DeleteStreamingSession")
                            .withMarshaller(new DeleteStreamingSessionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteStreamingSessionRequest));
            CompletableFuture<DeleteStreamingSessionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Delete a studio resource.
     * </p>
     *
     * @param deleteStudioRequest
     * @return A Java Future containing the result of the DeleteStudio operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.DeleteStudio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/DeleteStudio" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteStudioResponse> deleteStudio(DeleteStudioRequest deleteStudioRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteStudioRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteStudio");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteStudioResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteStudioResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteStudioResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteStudioRequest, DeleteStudioResponse>()
                            .withOperationName("DeleteStudio").withMarshaller(new DeleteStudioRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteStudioRequest));
            CompletableFuture<DeleteStudioResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a studio component resource.
     * </p>
     *
     * @param deleteStudioComponentRequest
     * @return A Java Future containing the result of the DeleteStudioComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.DeleteStudioComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/DeleteStudioComponent" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteStudioComponentResponse> deleteStudioComponent(
            DeleteStudioComponentRequest deleteStudioComponentRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteStudioComponentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteStudioComponent");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteStudioComponentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteStudioComponentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteStudioComponentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteStudioComponentRequest, DeleteStudioComponentResponse>()
                            .withOperationName("DeleteStudioComponent")
                            .withMarshaller(new DeleteStudioComponentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteStudioComponentRequest));
            CompletableFuture<DeleteStudioComponentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Delete a user from studio membership.
     * </p>
     *
     * @param deleteStudioMemberRequest
     * @return A Java Future containing the result of the DeleteStudioMember operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.DeleteStudioMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/DeleteStudioMember" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteStudioMemberResponse> deleteStudioMember(DeleteStudioMemberRequest deleteStudioMemberRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteStudioMemberRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteStudioMember");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteStudioMemberResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteStudioMemberResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteStudioMemberResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteStudioMemberRequest, DeleteStudioMemberResponse>()
                            .withOperationName("DeleteStudioMember")
                            .withMarshaller(new DeleteStudioMemberRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteStudioMemberRequest));
            CompletableFuture<DeleteStudioMemberResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Get Eula.
     * </p>
     *
     * @param getEulaRequest
     * @return A Java Future containing the result of the GetEula operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.GetEula
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/GetEula" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetEulaResponse> getEula(GetEulaRequest getEulaRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getEulaRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEula");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetEulaResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetEulaResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetEulaResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetEulaRequest, GetEulaResponse>().withOperationName("GetEula")
                            .withMarshaller(new GetEulaRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getEulaRequest));
            CompletableFuture<GetEulaResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Get a launch profile.
     * </p>
     *
     * @param getLaunchProfileRequest
     * @return A Java Future containing the result of the GetLaunchProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.GetLaunchProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/GetLaunchProfile" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetLaunchProfileResponse> getLaunchProfile(GetLaunchProfileRequest getLaunchProfileRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getLaunchProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetLaunchProfile");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetLaunchProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetLaunchProfileResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetLaunchProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetLaunchProfileRequest, GetLaunchProfileResponse>()
                            .withOperationName("GetLaunchProfile")
                            .withMarshaller(new GetLaunchProfileRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getLaunchProfileRequest));
            CompletableFuture<GetLaunchProfileResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Launch profile details include the launch profile resource and summary information of resources that are used by,
     * or available to, the launch profile. This includes the name and description of all studio components used by the
     * launch profiles, and the name and description of streaming images that can be used with this launch profile.
     * </p>
     *
     * @param getLaunchProfileDetailsRequest
     * @return A Java Future containing the result of the GetLaunchProfileDetails operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.GetLaunchProfileDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/GetLaunchProfileDetails"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetLaunchProfileDetailsResponse> getLaunchProfileDetails(
            GetLaunchProfileDetailsRequest getLaunchProfileDetailsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getLaunchProfileDetailsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetLaunchProfileDetails");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetLaunchProfileDetailsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetLaunchProfileDetailsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetLaunchProfileDetailsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetLaunchProfileDetailsRequest, GetLaunchProfileDetailsResponse>()
                            .withOperationName("GetLaunchProfileDetails")
                            .withMarshaller(new GetLaunchProfileDetailsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getLaunchProfileDetailsRequest));
            CompletableFuture<GetLaunchProfileDetailsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Get a launch profile initialization.
     * </p>
     *
     * @param getLaunchProfileInitializationRequest
     * @return A Java Future containing the result of the GetLaunchProfileInitialization operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.GetLaunchProfileInitialization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/GetLaunchProfileInitialization"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetLaunchProfileInitializationResponse> getLaunchProfileInitialization(
            GetLaunchProfileInitializationRequest getLaunchProfileInitializationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getLaunchProfileInitializationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetLaunchProfileInitialization");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetLaunchProfileInitializationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetLaunchProfileInitializationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetLaunchProfileInitializationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetLaunchProfileInitializationRequest, GetLaunchProfileInitializationResponse>()
                            .withOperationName("GetLaunchProfileInitialization")
                            .withMarshaller(new GetLaunchProfileInitializationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getLaunchProfileInitializationRequest));
            CompletableFuture<GetLaunchProfileInitializationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Get a user persona in launch profile membership.
     * </p>
     *
     * @param getLaunchProfileMemberRequest
     * @return A Java Future containing the result of the GetLaunchProfileMember operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.GetLaunchProfileMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/GetLaunchProfileMember" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetLaunchProfileMemberResponse> getLaunchProfileMember(
            GetLaunchProfileMemberRequest getLaunchProfileMemberRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getLaunchProfileMemberRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetLaunchProfileMember");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetLaunchProfileMemberResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetLaunchProfileMemberResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetLaunchProfileMemberResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetLaunchProfileMemberRequest, GetLaunchProfileMemberResponse>()
                            .withOperationName("GetLaunchProfileMember")
                            .withMarshaller(new GetLaunchProfileMemberRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getLaunchProfileMemberRequest));
            CompletableFuture<GetLaunchProfileMemberResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Get streaming image.
     * </p>
     *
     * @param getStreamingImageRequest
     * @return A Java Future containing the result of the GetStreamingImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.GetStreamingImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/GetStreamingImage" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetStreamingImageResponse> getStreamingImage(GetStreamingImageRequest getStreamingImageRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getStreamingImageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetStreamingImage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetStreamingImageResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetStreamingImageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetStreamingImageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetStreamingImageRequest, GetStreamingImageResponse>()
                            .withOperationName("GetStreamingImage")
                            .withMarshaller(new GetStreamingImageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getStreamingImageRequest));
            CompletableFuture<GetStreamingImageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets StreamingSession resource.
     * </p>
     * <p>
     * Invoke this operation to poll for a streaming session state while creating or deleting a session.
     * </p>
     *
     * @param getStreamingSessionRequest
     * @return A Java Future containing the result of the GetStreamingSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.GetStreamingSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/GetStreamingSession" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetStreamingSessionResponse> getStreamingSession(
            GetStreamingSessionRequest getStreamingSessionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getStreamingSessionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetStreamingSession");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetStreamingSessionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetStreamingSessionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetStreamingSessionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetStreamingSessionRequest, GetStreamingSessionResponse>()
                            .withOperationName("GetStreamingSession")
                            .withMarshaller(new GetStreamingSessionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getStreamingSessionRequest));
            CompletableFuture<GetStreamingSessionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a StreamingSessionStream for a streaming session.
     * </p>
     * <p>
     * Invoke this operation to poll the resource after invoking CreateStreamingSessionStream.
     * </p>
     * <p>
     * After the StreamingSessionStream changes to the state READY, the url property will contain a stream to be used
     * with the DCV streaming client.
     * </p>
     *
     * @param getStreamingSessionStreamRequest
     * @return A Java Future containing the result of the GetStreamingSessionStream operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.GetStreamingSessionStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/GetStreamingSessionStream"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetStreamingSessionStreamResponse> getStreamingSessionStream(
            GetStreamingSessionStreamRequest getStreamingSessionStreamRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getStreamingSessionStreamRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetStreamingSessionStream");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetStreamingSessionStreamResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetStreamingSessionStreamResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetStreamingSessionStreamResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetStreamingSessionStreamRequest, GetStreamingSessionStreamResponse>()
                            .withOperationName("GetStreamingSessionStream")
                            .withMarshaller(new GetStreamingSessionStreamRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getStreamingSessionStreamRequest));
            CompletableFuture<GetStreamingSessionStreamResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Get a Studio resource.
     * </p>
     *
     * @param getStudioRequest
     * @return A Java Future containing the result of the GetStudio operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.GetStudio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/GetStudio" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetStudioResponse> getStudio(GetStudioRequest getStudioRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getStudioRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetStudio");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetStudioResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetStudioResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetStudioResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetStudioRequest, GetStudioResponse>().withOperationName("GetStudio")
                            .withMarshaller(new GetStudioRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getStudioRequest));
            CompletableFuture<GetStudioResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a studio component resource.
     * </p>
     *
     * @param getStudioComponentRequest
     * @return A Java Future containing the result of the GetStudioComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.GetStudioComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/GetStudioComponent" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetStudioComponentResponse> getStudioComponent(GetStudioComponentRequest getStudioComponentRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getStudioComponentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetStudioComponent");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetStudioComponentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetStudioComponentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetStudioComponentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetStudioComponentRequest, GetStudioComponentResponse>()
                            .withOperationName("GetStudioComponent")
                            .withMarshaller(new GetStudioComponentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getStudioComponentRequest));
            CompletableFuture<GetStudioComponentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Get a user's membership in a studio.
     * </p>
     *
     * @param getStudioMemberRequest
     * @return A Java Future containing the result of the GetStudioMember operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.GetStudioMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/GetStudioMember" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetStudioMemberResponse> getStudioMember(GetStudioMemberRequest getStudioMemberRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getStudioMemberRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetStudioMember");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetStudioMemberResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetStudioMemberResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetStudioMemberResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetStudioMemberRequest, GetStudioMemberResponse>()
                            .withOperationName("GetStudioMember")
                            .withMarshaller(new GetStudioMemberRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getStudioMemberRequest));
            CompletableFuture<GetStudioMemberResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * List Eula Acceptances.
     * </p>
     *
     * @param listEulaAcceptancesRequest
     * @return A Java Future containing the result of the ListEulaAcceptances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.ListEulaAcceptances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListEulaAcceptances" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListEulaAcceptancesResponse> listEulaAcceptances(
            ListEulaAcceptancesRequest listEulaAcceptancesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listEulaAcceptancesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListEulaAcceptances");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListEulaAcceptancesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListEulaAcceptancesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListEulaAcceptancesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListEulaAcceptancesRequest, ListEulaAcceptancesResponse>()
                            .withOperationName("ListEulaAcceptances")
                            .withMarshaller(new ListEulaAcceptancesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listEulaAcceptancesRequest));
            CompletableFuture<ListEulaAcceptancesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * List Eula Acceptances.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEulaAcceptances(software.amazon.awssdk.services.nimble.model.ListEulaAcceptancesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.nimble.paginators.ListEulaAcceptancesPublisher publisher = client.listEulaAcceptancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.nimble.paginators.ListEulaAcceptancesPublisher publisher = client.listEulaAcceptancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.nimble.model.ListEulaAcceptancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.nimble.model.ListEulaAcceptancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEulaAcceptances(software.amazon.awssdk.services.nimble.model.ListEulaAcceptancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEulaAcceptancesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.ListEulaAcceptances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListEulaAcceptances" target="_top">AWS
     *      API Documentation</a>
     */
    public ListEulaAcceptancesPublisher listEulaAcceptancesPaginator(ListEulaAcceptancesRequest listEulaAcceptancesRequest) {
        return new ListEulaAcceptancesPublisher(this, applyPaginatorUserAgent(listEulaAcceptancesRequest));
    }

    /**
     * <p>
     * List Eulas.
     * </p>
     *
     * @param listEulasRequest
     * @return A Java Future containing the result of the ListEulas operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.ListEulas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListEulas" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListEulasResponse> listEulas(ListEulasRequest listEulasRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listEulasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListEulas");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListEulasResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListEulasResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListEulasResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListEulasRequest, ListEulasResponse>().withOperationName("ListEulas")
                            .withMarshaller(new ListEulasRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(listEulasRequest));
            CompletableFuture<ListEulasResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * List Eulas.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listEulas(software.amazon.awssdk.services.nimble.model.ListEulasRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.nimble.paginators.ListEulasPublisher publisher = client.listEulasPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.nimble.paginators.ListEulasPublisher publisher = client.listEulasPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.nimble.model.ListEulasResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.nimble.model.ListEulasResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEulas(software.amazon.awssdk.services.nimble.model.ListEulasRequest)} operation.</b>
     * </p>
     *
     * @param listEulasRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.ListEulas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListEulas" target="_top">AWS API
     *      Documentation</a>
     */
    public ListEulasPublisher listEulasPaginator(ListEulasRequest listEulasRequest) {
        return new ListEulasPublisher(this, applyPaginatorUserAgent(listEulasRequest));
    }

    /**
     * <p>
     * Get all users in a given launch profile membership.
     * </p>
     *
     * @param listLaunchProfileMembersRequest
     * @return A Java Future containing the result of the ListLaunchProfileMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.ListLaunchProfileMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListLaunchProfileMembers"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListLaunchProfileMembersResponse> listLaunchProfileMembers(
            ListLaunchProfileMembersRequest listLaunchProfileMembersRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listLaunchProfileMembersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListLaunchProfileMembers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListLaunchProfileMembersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListLaunchProfileMembersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListLaunchProfileMembersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListLaunchProfileMembersRequest, ListLaunchProfileMembersResponse>()
                            .withOperationName("ListLaunchProfileMembers")
                            .withMarshaller(new ListLaunchProfileMembersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listLaunchProfileMembersRequest));
            CompletableFuture<ListLaunchProfileMembersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Get all users in a given launch profile membership.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listLaunchProfileMembers(software.amazon.awssdk.services.nimble.model.ListLaunchProfileMembersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.nimble.paginators.ListLaunchProfileMembersPublisher publisher = client.listLaunchProfileMembersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.nimble.paginators.ListLaunchProfileMembersPublisher publisher = client.listLaunchProfileMembersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.nimble.model.ListLaunchProfileMembersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.nimble.model.ListLaunchProfileMembersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLaunchProfileMembers(software.amazon.awssdk.services.nimble.model.ListLaunchProfileMembersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listLaunchProfileMembersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.ListLaunchProfileMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListLaunchProfileMembers"
     *      target="_top">AWS API Documentation</a>
     */
    public ListLaunchProfileMembersPublisher listLaunchProfileMembersPaginator(
            ListLaunchProfileMembersRequest listLaunchProfileMembersRequest) {
        return new ListLaunchProfileMembersPublisher(this, applyPaginatorUserAgent(listLaunchProfileMembersRequest));
    }

    /**
     * <p>
     * List all the launch profiles a studio.
     * </p>
     *
     * @param listLaunchProfilesRequest
     * @return A Java Future containing the result of the ListLaunchProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.ListLaunchProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListLaunchProfiles" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListLaunchProfilesResponse> listLaunchProfiles(ListLaunchProfilesRequest listLaunchProfilesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listLaunchProfilesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListLaunchProfiles");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListLaunchProfilesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListLaunchProfilesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListLaunchProfilesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListLaunchProfilesRequest, ListLaunchProfilesResponse>()
                            .withOperationName("ListLaunchProfiles")
                            .withMarshaller(new ListLaunchProfilesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listLaunchProfilesRequest));
            CompletableFuture<ListLaunchProfilesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * List all the launch profiles a studio.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listLaunchProfiles(software.amazon.awssdk.services.nimble.model.ListLaunchProfilesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.nimble.paginators.ListLaunchProfilesPublisher publisher = client.listLaunchProfilesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.nimble.paginators.ListLaunchProfilesPublisher publisher = client.listLaunchProfilesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.nimble.model.ListLaunchProfilesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.nimble.model.ListLaunchProfilesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLaunchProfiles(software.amazon.awssdk.services.nimble.model.ListLaunchProfilesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listLaunchProfilesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.ListLaunchProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListLaunchProfiles" target="_top">AWS API
     *      Documentation</a>
     */
    public ListLaunchProfilesPublisher listLaunchProfilesPaginator(ListLaunchProfilesRequest listLaunchProfilesRequest) {
        return new ListLaunchProfilesPublisher(this, applyPaginatorUserAgent(listLaunchProfilesRequest));
    }

    /**
     * <p>
     * List the streaming image resources available to this studio.
     * </p>
     * <p>
     * This list will contain both images provided by Amazon Web Services, as well as streaming images that you have
     * created in your studio.
     * </p>
     *
     * @param listStreamingImagesRequest
     * @return A Java Future containing the result of the ListStreamingImages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.ListStreamingImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListStreamingImages" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListStreamingImagesResponse> listStreamingImages(
            ListStreamingImagesRequest listStreamingImagesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listStreamingImagesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListStreamingImages");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListStreamingImagesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListStreamingImagesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListStreamingImagesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListStreamingImagesRequest, ListStreamingImagesResponse>()
                            .withOperationName("ListStreamingImages")
                            .withMarshaller(new ListStreamingImagesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listStreamingImagesRequest));
            CompletableFuture<ListStreamingImagesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * List the streaming image resources available to this studio.
     * </p>
     * <p>
     * This list will contain both images provided by Amazon Web Services, as well as streaming images that you have
     * created in your studio.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listStreamingImages(software.amazon.awssdk.services.nimble.model.ListStreamingImagesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.nimble.paginators.ListStreamingImagesPublisher publisher = client.listStreamingImagesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.nimble.paginators.ListStreamingImagesPublisher publisher = client.listStreamingImagesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.nimble.model.ListStreamingImagesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.nimble.model.ListStreamingImagesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStreamingImages(software.amazon.awssdk.services.nimble.model.ListStreamingImagesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listStreamingImagesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.ListStreamingImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListStreamingImages" target="_top">AWS
     *      API Documentation</a>
     */
    public ListStreamingImagesPublisher listStreamingImagesPaginator(ListStreamingImagesRequest listStreamingImagesRequest) {
        return new ListStreamingImagesPublisher(this, applyPaginatorUserAgent(listStreamingImagesRequest));
    }

    /**
     * <p>
     * Lists the streaming sessions in a studio.
     * </p>
     *
     * @param listStreamingSessionsRequest
     * @return A Java Future containing the result of the ListStreamingSessions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.ListStreamingSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListStreamingSessions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListStreamingSessionsResponse> listStreamingSessions(
            ListStreamingSessionsRequest listStreamingSessionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listStreamingSessionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListStreamingSessions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListStreamingSessionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListStreamingSessionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListStreamingSessionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListStreamingSessionsRequest, ListStreamingSessionsResponse>()
                            .withOperationName("ListStreamingSessions")
                            .withMarshaller(new ListStreamingSessionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listStreamingSessionsRequest));
            CompletableFuture<ListStreamingSessionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the streaming sessions in a studio.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listStreamingSessions(software.amazon.awssdk.services.nimble.model.ListStreamingSessionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.nimble.paginators.ListStreamingSessionsPublisher publisher = client.listStreamingSessionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.nimble.paginators.ListStreamingSessionsPublisher publisher = client.listStreamingSessionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.nimble.model.ListStreamingSessionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.nimble.model.ListStreamingSessionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStreamingSessions(software.amazon.awssdk.services.nimble.model.ListStreamingSessionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listStreamingSessionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.ListStreamingSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListStreamingSessions" target="_top">AWS
     *      API Documentation</a>
     */
    public ListStreamingSessionsPublisher listStreamingSessionsPaginator(ListStreamingSessionsRequest listStreamingSessionsRequest) {
        return new ListStreamingSessionsPublisher(this, applyPaginatorUserAgent(listStreamingSessionsRequest));
    }

    /**
     * <p>
     * Lists the StudioComponents in a studio.
     * </p>
     *
     * @param listStudioComponentsRequest
     * @return A Java Future containing the result of the ListStudioComponents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.ListStudioComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListStudioComponents" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListStudioComponentsResponse> listStudioComponents(
            ListStudioComponentsRequest listStudioComponentsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listStudioComponentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListStudioComponents");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListStudioComponentsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListStudioComponentsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListStudioComponentsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListStudioComponentsRequest, ListStudioComponentsResponse>()
                            .withOperationName("ListStudioComponents")
                            .withMarshaller(new ListStudioComponentsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listStudioComponentsRequest));
            CompletableFuture<ListStudioComponentsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the StudioComponents in a studio.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listStudioComponents(software.amazon.awssdk.services.nimble.model.ListStudioComponentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.nimble.paginators.ListStudioComponentsPublisher publisher = client.listStudioComponentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.nimble.paginators.ListStudioComponentsPublisher publisher = client.listStudioComponentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.nimble.model.ListStudioComponentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.nimble.model.ListStudioComponentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStudioComponents(software.amazon.awssdk.services.nimble.model.ListStudioComponentsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listStudioComponentsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.ListStudioComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListStudioComponents" target="_top">AWS
     *      API Documentation</a>
     */
    public ListStudioComponentsPublisher listStudioComponentsPaginator(ListStudioComponentsRequest listStudioComponentsRequest) {
        return new ListStudioComponentsPublisher(this, applyPaginatorUserAgent(listStudioComponentsRequest));
    }

    /**
     * <p>
     * Get all users in a given studio membership.
     * </p>
     * <note>
     * <p>
     * <code>ListStudioMembers</code> only returns admin members.
     * </p>
     * </note>
     *
     * @param listStudioMembersRequest
     * @return A Java Future containing the result of the ListStudioMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.ListStudioMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListStudioMembers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListStudioMembersResponse> listStudioMembers(ListStudioMembersRequest listStudioMembersRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listStudioMembersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListStudioMembers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListStudioMembersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListStudioMembersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListStudioMembersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListStudioMembersRequest, ListStudioMembersResponse>()
                            .withOperationName("ListStudioMembers")
                            .withMarshaller(new ListStudioMembersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listStudioMembersRequest));
            CompletableFuture<ListStudioMembersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Get all users in a given studio membership.
     * </p>
     * <note>
     * <p>
     * <code>ListStudioMembers</code> only returns admin members.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listStudioMembers(software.amazon.awssdk.services.nimble.model.ListStudioMembersRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.nimble.paginators.ListStudioMembersPublisher publisher = client.listStudioMembersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.nimble.paginators.ListStudioMembersPublisher publisher = client.listStudioMembersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.nimble.model.ListStudioMembersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.nimble.model.ListStudioMembersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStudioMembers(software.amazon.awssdk.services.nimble.model.ListStudioMembersRequest)} operation.</b>
     * </p>
     *
     * @param listStudioMembersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.ListStudioMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListStudioMembers" target="_top">AWS API
     *      Documentation</a>
     */
    public ListStudioMembersPublisher listStudioMembersPaginator(ListStudioMembersRequest listStudioMembersRequest) {
        return new ListStudioMembersPublisher(this, applyPaginatorUserAgent(listStudioMembersRequest));
    }

    /**
     * <p>
     * List studios in your Amazon Web Services account in the requested Amazon Web Services Region.
     * </p>
     *
     * @param listStudiosRequest
     * @return A Java Future containing the result of the ListStudios operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.ListStudios
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListStudios" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListStudiosResponse> listStudios(ListStudiosRequest listStudiosRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listStudiosRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListStudios");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListStudiosResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListStudiosResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListStudiosResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListStudiosRequest, ListStudiosResponse>()
                            .withOperationName("ListStudios").withMarshaller(new ListStudiosRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listStudiosRequest));
            CompletableFuture<ListStudiosResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * List studios in your Amazon Web Services account in the requested Amazon Web Services Region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listStudios(software.amazon.awssdk.services.nimble.model.ListStudiosRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.nimble.paginators.ListStudiosPublisher publisher = client.listStudiosPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.nimble.paginators.ListStudiosPublisher publisher = client.listStudiosPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.nimble.model.ListStudiosResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.nimble.model.ListStudiosResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStudios(software.amazon.awssdk.services.nimble.model.ListStudiosRequest)} operation.</b>
     * </p>
     *
     * @param listStudiosRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.ListStudios
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListStudios" target="_top">AWS API
     *      Documentation</a>
     */
    public ListStudiosPublisher listStudiosPaginator(ListStudiosRequest listStudiosRequest) {
        return new ListStudiosPublisher(this, applyPaginatorUserAgent(listStudiosRequest));
    }

    /**
     * <p>
     * Gets the tags for a resource, given its Amazon Resource Names (ARN).
     * </p>
     * <p>
     * This operation supports ARNs for all resource types in Nimble Studio that support tags, including studio, studio
     * component, launch profile, streaming image, and streaming session. All resources that can be tagged will contain
     * an ARN property, so you do not have to create this ARN yourself.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource")
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listTagsForResourceRequest));
            CompletableFuture<ListTagsForResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Add/update users with given persona to launch profile membership.
     * </p>
     *
     * @param putLaunchProfileMembersRequest
     * @return A Java Future containing the result of the PutLaunchProfileMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.PutLaunchProfileMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/PutLaunchProfileMembers"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutLaunchProfileMembersResponse> putLaunchProfileMembers(
            PutLaunchProfileMembersRequest putLaunchProfileMembersRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putLaunchProfileMembersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutLaunchProfileMembers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutLaunchProfileMembersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutLaunchProfileMembersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutLaunchProfileMembersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutLaunchProfileMembersRequest, PutLaunchProfileMembersResponse>()
                            .withOperationName("PutLaunchProfileMembers")
                            .withMarshaller(new PutLaunchProfileMembersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(putLaunchProfileMembersRequest));
            CompletableFuture<PutLaunchProfileMembersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Add/update users with given persona to studio membership.
     * </p>
     *
     * @param putStudioMembersRequest
     * @return A Java Future containing the result of the PutStudioMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.PutStudioMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/PutStudioMembers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<PutStudioMembersResponse> putStudioMembers(PutStudioMembersRequest putStudioMembersRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putStudioMembersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutStudioMembers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutStudioMembersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutStudioMembersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutStudioMembersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutStudioMembersRequest, PutStudioMembersResponse>()
                            .withOperationName("PutStudioMembers")
                            .withMarshaller(new PutStudioMembersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(putStudioMembersRequest));
            CompletableFuture<PutStudioMembersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Transitions sessions from the STOPPED state into the READY state. The START_IN_PROGRESS state is the intermediate
     * state between the STOPPED and READY states.
     * </p>
     *
     * @param startStreamingSessionRequest
     * @return A Java Future containing the result of the StartStreamingSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.StartStreamingSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/StartStreamingSession" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<StartStreamingSessionResponse> startStreamingSession(
            StartStreamingSessionRequest startStreamingSessionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startStreamingSessionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartStreamingSession");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartStreamingSessionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartStreamingSessionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartStreamingSessionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartStreamingSessionRequest, StartStreamingSessionResponse>()
                            .withOperationName("StartStreamingSession")
                            .withMarshaller(new StartStreamingSessionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(startStreamingSessionRequest));
            CompletableFuture<StartStreamingSessionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Repairs the Amazon Web Services SSO configuration for a given studio.
     * </p>
     * <p>
     * If the studio has a valid Amazon Web Services SSO configuration currently associated with it, this operation will
     * fail with a validation error.
     * </p>
     * <p>
     * If the studio does not have a valid Amazon Web Services SSO configuration currently associated with it, then a
     * new Amazon Web Services SSO application is created for the studio and the studio is changed to the READY state.
     * </p>
     * <p>
     * After the Amazon Web Services SSO application is repaired, you must use the Amazon Nimble Studio console to add
     * administrators and users to your studio.
     * </p>
     *
     * @param startStudioSsoConfigurationRepairRequest
     * @return A Java Future containing the result of the StartStudioSSOConfigurationRepair operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.StartStudioSSOConfigurationRepair
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/StartStudioSSOConfigurationRepair"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartStudioSsoConfigurationRepairResponse> startStudioSSOConfigurationRepair(
            StartStudioSsoConfigurationRepairRequest startStudioSsoConfigurationRepairRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                startStudioSsoConfigurationRepairRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartStudioSSOConfigurationRepair");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartStudioSsoConfigurationRepairResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, StartStudioSsoConfigurationRepairResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartStudioSsoConfigurationRepairResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartStudioSsoConfigurationRepairRequest, StartStudioSsoConfigurationRepairResponse>()
                            .withOperationName("StartStudioSSOConfigurationRepair")
                            .withMarshaller(new StartStudioSsoConfigurationRepairRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(startStudioSsoConfigurationRepairRequest));
            CompletableFuture<StartStudioSsoConfigurationRepairResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Transitions sessions from the READY state into the STOPPED state. The STOP_IN_PROGRESS state is the intermediate
     * state between the READY and STOPPED states.
     * </p>
     *
     * @param stopStreamingSessionRequest
     * @return A Java Future containing the result of the StopStreamingSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.StopStreamingSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/StopStreamingSession" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<StopStreamingSessionResponse> stopStreamingSession(
            StopStreamingSessionRequest stopStreamingSessionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopStreamingSessionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopStreamingSession");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StopStreamingSessionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StopStreamingSessionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StopStreamingSessionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopStreamingSessionRequest, StopStreamingSessionResponse>()
                            .withOperationName("StopStreamingSession")
                            .withMarshaller(new StopStreamingSessionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(stopStreamingSessionRequest));
            CompletableFuture<StopStreamingSessionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates tags for a resource, given its ARN.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(tagResourceRequest));
            CompletableFuture<TagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the tags for a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource")
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(untagResourceRequest));
            CompletableFuture<UntagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Update a launch profile.
     * </p>
     *
     * @param updateLaunchProfileRequest
     * @return A Java Future containing the result of the UpdateLaunchProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.UpdateLaunchProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/UpdateLaunchProfile" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateLaunchProfileResponse> updateLaunchProfile(
            UpdateLaunchProfileRequest updateLaunchProfileRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateLaunchProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateLaunchProfile");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateLaunchProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateLaunchProfileResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateLaunchProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateLaunchProfileRequest, UpdateLaunchProfileResponse>()
                            .withOperationName("UpdateLaunchProfile")
                            .withMarshaller(new UpdateLaunchProfileRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateLaunchProfileRequest));
            CompletableFuture<UpdateLaunchProfileResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Update a user persona in launch profile membership.
     * </p>
     *
     * @param updateLaunchProfileMemberRequest
     * @return A Java Future containing the result of the UpdateLaunchProfileMember operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.UpdateLaunchProfileMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/UpdateLaunchProfileMember"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateLaunchProfileMemberResponse> updateLaunchProfileMember(
            UpdateLaunchProfileMemberRequest updateLaunchProfileMemberRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateLaunchProfileMemberRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateLaunchProfileMember");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateLaunchProfileMemberResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateLaunchProfileMemberResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateLaunchProfileMemberResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateLaunchProfileMemberRequest, UpdateLaunchProfileMemberResponse>()
                            .withOperationName("UpdateLaunchProfileMember")
                            .withMarshaller(new UpdateLaunchProfileMemberRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateLaunchProfileMemberRequest));
            CompletableFuture<UpdateLaunchProfileMemberResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Update streaming image.
     * </p>
     *
     * @param updateStreamingImageRequest
     * @return A Java Future containing the result of the UpdateStreamingImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.UpdateStreamingImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/UpdateStreamingImage" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateStreamingImageResponse> updateStreamingImage(
            UpdateStreamingImageRequest updateStreamingImageRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateStreamingImageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateStreamingImage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateStreamingImageResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateStreamingImageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateStreamingImageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateStreamingImageRequest, UpdateStreamingImageResponse>()
                            .withOperationName("UpdateStreamingImage")
                            .withMarshaller(new UpdateStreamingImageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateStreamingImageRequest));
            CompletableFuture<UpdateStreamingImageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Update a Studio resource.
     * </p>
     * <p>
     * Currently, this operation only supports updating the displayName of your studio.
     * </p>
     *
     * @param updateStudioRequest
     * @return A Java Future containing the result of the UpdateStudio operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.UpdateStudio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/UpdateStudio" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateStudioResponse> updateStudio(UpdateStudioRequest updateStudioRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateStudioRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateStudio");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateStudioResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateStudioResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateStudioResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateStudioRequest, UpdateStudioResponse>()
                            .withOperationName("UpdateStudio").withMarshaller(new UpdateStudioRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateStudioRequest));
            CompletableFuture<UpdateStudioResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a studio component resource.
     * </p>
     *
     * @param updateStudioComponentRequest
     * @return A Java Future containing the result of the UpdateStudioComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource could not be found.</li>
     *         <li>ConflictException Another operation is in progress.</li>
     *         <li>ThrottlingException The request throughput limit was exceeded.</li>
     *         <li>ValidationException One of the parameters in the request is invalid.</li>
     *         <li>AccessDeniedException You are not authorized to perform this operation. Check your IAM policies, and
     *         ensure that you are using the correct access keys.</li>
     *         <li>InternalServerErrorException An internal error has occurred. Please retry your request.</li>
     *         <li>ServiceQuotaExceededException Your current quota does not allow you to perform the request action.
     *         You can request increases for some quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use AWS Service Quotas to request an increase.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NimbleException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NimbleAsyncClient.UpdateStudioComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/UpdateStudioComponent" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateStudioComponentResponse> updateStudioComponent(
            UpdateStudioComponentRequest updateStudioComponentRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateStudioComponentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateStudioComponent");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateStudioComponentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateStudioComponentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateStudioComponentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateStudioComponentRequest, UpdateStudioComponentResponse>()
                            .withOperationName("UpdateStudioComponent")
                            .withMarshaller(new UpdateStudioComponentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateStudioComponentRequest));
            CompletableFuture<UpdateStudioComponentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(NimbleException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottlingException")
                                .exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException")
                                .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(402).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ValidationException")
                                .exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerErrorException")
                                .exceptionBuilderSupplier(InternalServerErrorException::builder).httpStatusCode(500).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private <T extends NimbleRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder()
                .version(VersionInfo.SDK_VERSION).name("PAGINATED").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration()
                .map(c -> c.toBuilder().applyMutation(userAgentApplier).build())
                .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()));
        return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    @Override
    public NimbleAsyncWaiter waiter() {
        return NimbleAsyncWaiter.builder().client(this).scheduledExecutorService(executorService).build();
    }
}
