/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.nimble.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateStudioResponse extends NimbleResponse implements
        ToCopyableBuilder<CreateStudioResponse.Builder, CreateStudioResponse> {
    private static final SdkField<Studio> STUDIO_FIELD = SdkField.<Studio> builder(MarshallingType.SDK_POJO).memberName("studio")
            .getter(getter(CreateStudioResponse::studio)).setter(setter(Builder::studio)).constructor(Studio::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("studio").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STUDIO_FIELD));

    private final Studio studio;

    private CreateStudioResponse(BuilderImpl builder) {
        super(builder);
        this.studio = builder.studio;
    }

    /**
     * <p>
     * Information about a studio.
     * </p>
     * 
     * @return Information about a studio.
     */
    public final Studio studio() {
        return studio;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(studio());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStudioResponse)) {
            return false;
        }
        CreateStudioResponse other = (CreateStudioResponse) obj;
        return Objects.equals(studio(), other.studio());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateStudioResponse").add("Studio", studio()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "studio":
            return Optional.ofNullable(clazz.cast(studio()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateStudioResponse, T> g) {
        return obj -> g.apply((CreateStudioResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NimbleResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateStudioResponse> {
        /**
         * <p>
         * Information about a studio.
         * </p>
         * 
         * @param studio
         *        Information about a studio.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder studio(Studio studio);

        /**
         * <p>
         * Information about a studio.
         * </p>
         * This is a convenience method that creates an instance of the {@link Studio.Builder} avoiding the need to
         * create one manually via {@link Studio#builder()}.
         *
         * When the {@link Consumer} completes, {@link Studio.Builder#build()} is called immediately and its result is
         * passed to {@link #studio(Studio)}.
         * 
         * @param studio
         *        a consumer that will call methods on {@link Studio.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #studio(Studio)
         */
        default Builder studio(Consumer<Studio.Builder> studio) {
            return studio(Studio.builder().applyMutation(studio).build());
        }
    }

    static final class BuilderImpl extends NimbleResponse.BuilderImpl implements Builder {
        private Studio studio;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStudioResponse model) {
            super(model);
            studio(model.studio);
        }

        public final Studio.Builder getStudio() {
            return studio != null ? studio.toBuilder() : null;
        }

        public final void setStudio(Studio.BuilderImpl studio) {
            this.studio = studio != null ? studio.build() : null;
        }

        @Override
        public final Builder studio(Studio studio) {
            this.studio = studio;
            return this;
        }

        @Override
        public CreateStudioResponse build() {
            return new CreateStudioResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
