/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.nimble.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateStudioComponentRequest extends NimbleRequest implements
        ToCopyableBuilder<UpdateStudioComponentRequest.Builder, UpdateStudioComponentRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateStudioComponentRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Client-Token").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<StudioComponentConfiguration> CONFIGURATION_FIELD = SdkField
            .<StudioComponentConfiguration> builder(MarshallingType.SDK_POJO).memberName("configuration")
            .getter(getter(UpdateStudioComponentRequest::configuration)).setter(setter(Builder::configuration))
            .constructor(StudioComponentConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateStudioComponentRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<String>> EC2_SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ec2SecurityGroupIds")
            .getter(getter(UpdateStudioComponentRequest::ec2SecurityGroupIds))
            .setter(setter(Builder::ec2SecurityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2SecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StudioComponentInitializationScript>> INITIALIZATION_SCRIPTS_FIELD = SdkField
            .<List<StudioComponentInitializationScript>> builder(MarshallingType.LIST)
            .memberName("initializationScripts")
            .getter(getter(UpdateStudioComponentRequest::initializationScripts))
            .setter(setter(Builder::initializationScripts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initializationScripts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StudioComponentInitializationScript> builder(MarshallingType.SDK_POJO)
                                            .constructor(StudioComponentInitializationScript::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateStudioComponentRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> RUNTIME_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("runtimeRoleArn").getter(getter(UpdateStudioComponentRequest::runtimeRoleArn))
            .setter(setter(Builder::runtimeRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runtimeRoleArn").build()).build();

    private static final SdkField<List<ScriptParameterKeyValue>> SCRIPT_PARAMETERS_FIELD = SdkField
            .<List<ScriptParameterKeyValue>> builder(MarshallingType.LIST)
            .memberName("scriptParameters")
            .getter(getter(UpdateStudioComponentRequest::scriptParameters))
            .setter(setter(Builder::scriptParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scriptParameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ScriptParameterKeyValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(ScriptParameterKeyValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SECURE_INITIALIZATION_ROLE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("secureInitializationRoleArn")
            .getter(getter(UpdateStudioComponentRequest::secureInitializationRoleArn))
            .setter(setter(Builder::secureInitializationRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secureInitializationRoleArn")
                    .build()).build();

    private static final SdkField<String> STUDIO_COMPONENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("studioComponentId").getter(getter(UpdateStudioComponentRequest::studioComponentId))
            .setter(setter(Builder::studioComponentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("studioComponentId").build()).build();

    private static final SdkField<String> STUDIO_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("studioId").getter(getter(UpdateStudioComponentRequest::studioId)).setter(setter(Builder::studioId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("studioId").build()).build();

    private static final SdkField<String> SUBTYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("subtype")
            .getter(getter(UpdateStudioComponentRequest::subtypeAsString)).setter(setter(Builder::subtype))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subtype").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(UpdateStudioComponentRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            CONFIGURATION_FIELD, DESCRIPTION_FIELD, EC2_SECURITY_GROUP_IDS_FIELD, INITIALIZATION_SCRIPTS_FIELD, NAME_FIELD,
            RUNTIME_ROLE_ARN_FIELD, SCRIPT_PARAMETERS_FIELD, SECURE_INITIALIZATION_ROLE_ARN_FIELD, STUDIO_COMPONENT_ID_FIELD,
            STUDIO_ID_FIELD, SUBTYPE_FIELD, TYPE_FIELD));

    private final String clientToken;

    private final StudioComponentConfiguration configuration;

    private final String description;

    private final List<String> ec2SecurityGroupIds;

    private final List<StudioComponentInitializationScript> initializationScripts;

    private final String name;

    private final String runtimeRoleArn;

    private final List<ScriptParameterKeyValue> scriptParameters;

    private final String secureInitializationRoleArn;

    private final String studioComponentId;

    private final String studioId;

    private final String subtype;

    private final String type;

    private UpdateStudioComponentRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.configuration = builder.configuration;
        this.description = builder.description;
        this.ec2SecurityGroupIds = builder.ec2SecurityGroupIds;
        this.initializationScripts = builder.initializationScripts;
        this.name = builder.name;
        this.runtimeRoleArn = builder.runtimeRoleArn;
        this.scriptParameters = builder.scriptParameters;
        this.secureInitializationRoleArn = builder.secureInitializationRoleArn;
        this.studioComponentId = builder.studioComponentId;
        this.studioId = builder.studioId;
        this.subtype = builder.subtype;
        this.type = builder.type;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify
     * a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure
     * idempotency.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t
     *         specify a client token, the AWS SDK automatically generates a client token and uses it for the request to
     *         ensure idempotency.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The configuration of the studio component, based on component type.
     * </p>
     * 
     * @return The configuration of the studio component, based on component type.
     */
    public final StudioComponentConfiguration configuration() {
        return configuration;
    }

    /**
     * <p>
     * The description.
     * </p>
     * 
     * @return The description.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Ec2SecurityGroupIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEc2SecurityGroupIds() {
        return ec2SecurityGroupIds != null && !(ec2SecurityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The EC2 security groups that control access to the studio component.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEc2SecurityGroupIds} method.
     * </p>
     * 
     * @return The EC2 security groups that control access to the studio component.
     */
    public final List<String> ec2SecurityGroupIds() {
        return ec2SecurityGroupIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the InitializationScripts property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasInitializationScripts() {
        return initializationScripts != null && !(initializationScripts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Initialization scripts for studio components.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInitializationScripts} method.
     * </p>
     * 
     * @return Initialization scripts for studio components.
     */
    public final List<StudioComponentInitializationScript> initializationScripts() {
        return initializationScripts;
    }

    /**
     * <p>
     * The name for the studio component.
     * </p>
     * 
     * @return The name for the studio component.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * An IAM role attached to a Studio Component that gives the studio component access to AWS resources at anytime
     * while the instance is running.
     * </p>
     * 
     * @return An IAM role attached to a Studio Component that gives the studio component access to AWS resources at
     *         anytime while the instance is running.
     */
    public final String runtimeRoleArn() {
        return runtimeRoleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the ScriptParameters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasScriptParameters() {
        return scriptParameters != null && !(scriptParameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Parameters for the studio component scripts.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScriptParameters} method.
     * </p>
     * 
     * @return Parameters for the studio component scripts.
     */
    public final List<ScriptParameterKeyValue> scriptParameters() {
        return scriptParameters;
    }

    /**
     * <p>
     * An IAM role attached to Studio Component when the system initialization script runs which give the studio
     * component access to AWS resources when the system initialization script runs.
     * </p>
     * 
     * @return An IAM role attached to Studio Component when the system initialization script runs which give the studio
     *         component access to AWS resources when the system initialization script runs.
     */
    public final String secureInitializationRoleArn() {
        return secureInitializationRoleArn;
    }

    /**
     * <p>
     * The studio component ID.
     * </p>
     * 
     * @return The studio component ID.
     */
    public final String studioComponentId() {
        return studioComponentId;
    }

    /**
     * <p>
     * The studio ID.
     * </p>
     * 
     * @return The studio ID.
     */
    public final String studioId() {
        return studioId;
    }

    /**
     * <p>
     * The specific subtype of a studio component.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #subtype} will
     * return {@link StudioComponentSubtype#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #subtypeAsString}.
     * </p>
     * 
     * @return The specific subtype of a studio component.
     * @see StudioComponentSubtype
     */
    public final StudioComponentSubtype subtype() {
        return StudioComponentSubtype.fromValue(subtype);
    }

    /**
     * <p>
     * The specific subtype of a studio component.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #subtype} will
     * return {@link StudioComponentSubtype#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #subtypeAsString}.
     * </p>
     * 
     * @return The specific subtype of a studio component.
     * @see StudioComponentSubtype
     */
    public final String subtypeAsString() {
        return subtype;
    }

    /**
     * <p>
     * The type of the studio component.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link StudioComponentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the studio component.
     * @see StudioComponentType
     */
    public final StudioComponentType type() {
        return StudioComponentType.fromValue(type);
    }

    /**
     * <p>
     * The type of the studio component.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link StudioComponentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the studio component.
     * @see StudioComponentType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasEc2SecurityGroupIds() ? ec2SecurityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasInitializationScripts() ? initializationScripts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(runtimeRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasScriptParameters() ? scriptParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(secureInitializationRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(studioComponentId());
        hashCode = 31 * hashCode + Objects.hashCode(studioId());
        hashCode = 31 * hashCode + Objects.hashCode(subtypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStudioComponentRequest)) {
            return false;
        }
        UpdateStudioComponentRequest other = (UpdateStudioComponentRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(configuration(), other.configuration())
                && Objects.equals(description(), other.description())
                && hasEc2SecurityGroupIds() == other.hasEc2SecurityGroupIds()
                && Objects.equals(ec2SecurityGroupIds(), other.ec2SecurityGroupIds())
                && hasInitializationScripts() == other.hasInitializationScripts()
                && Objects.equals(initializationScripts(), other.initializationScripts()) && Objects.equals(name(), other.name())
                && Objects.equals(runtimeRoleArn(), other.runtimeRoleArn())
                && hasScriptParameters() == other.hasScriptParameters()
                && Objects.equals(scriptParameters(), other.scriptParameters())
                && Objects.equals(secureInitializationRoleArn(), other.secureInitializationRoleArn())
                && Objects.equals(studioComponentId(), other.studioComponentId()) && Objects.equals(studioId(), other.studioId())
                && Objects.equals(subtypeAsString(), other.subtypeAsString())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateStudioComponentRequest").add("ClientToken", clientToken())
                .add("Configuration", configuration())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Ec2SecurityGroupIds", hasEc2SecurityGroupIds() ? ec2SecurityGroupIds() : null)
                .add("InitializationScripts", hasInitializationScripts() ? initializationScripts() : null)
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***").add("RuntimeRoleArn", runtimeRoleArn())
                .add("ScriptParameters", scriptParameters() == null ? null : "*** Sensitive Data Redacted ***")
                .add("SecureInitializationRoleArn", secureInitializationRoleArn()).add("StudioComponentId", studioComponentId())
                .add("StudioId", studioId()).add("Subtype", subtypeAsString()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ec2SecurityGroupIds":
            return Optional.ofNullable(clazz.cast(ec2SecurityGroupIds()));
        case "initializationScripts":
            return Optional.ofNullable(clazz.cast(initializationScripts()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "runtimeRoleArn":
            return Optional.ofNullable(clazz.cast(runtimeRoleArn()));
        case "scriptParameters":
            return Optional.ofNullable(clazz.cast(scriptParameters()));
        case "secureInitializationRoleArn":
            return Optional.ofNullable(clazz.cast(secureInitializationRoleArn()));
        case "studioComponentId":
            return Optional.ofNullable(clazz.cast(studioComponentId()));
        case "studioId":
            return Optional.ofNullable(clazz.cast(studioId()));
        case "subtype":
            return Optional.ofNullable(clazz.cast(subtypeAsString()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateStudioComponentRequest, T> g) {
        return obj -> g.apply((UpdateStudioComponentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NimbleRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateStudioComponentRequest> {
        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t
         * specify a client token, the AWS SDK automatically generates a client token and uses it for the request to
         * ensure idempotency.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you
         *        don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the
         *        request to ensure idempotency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The configuration of the studio component, based on component type.
         * </p>
         * 
         * @param configuration
         *        The configuration of the studio component, based on component type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(StudioComponentConfiguration configuration);

        /**
         * <p>
         * The configuration of the studio component, based on component type.
         * </p>
         * This is a convenience method that creates an instance of the {@link StudioComponentConfiguration.Builder}
         * avoiding the need to create one manually via {@link StudioComponentConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link StudioComponentConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #configuration(StudioComponentConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link StudioComponentConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(StudioComponentConfiguration)
         */
        default Builder configuration(Consumer<StudioComponentConfiguration.Builder> configuration) {
            return configuration(StudioComponentConfiguration.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * The description.
         * </p>
         * 
         * @param description
         *        The description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The EC2 security groups that control access to the studio component.
         * </p>
         * 
         * @param ec2SecurityGroupIds
         *        The EC2 security groups that control access to the studio component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2SecurityGroupIds(Collection<String> ec2SecurityGroupIds);

        /**
         * <p>
         * The EC2 security groups that control access to the studio component.
         * </p>
         * 
         * @param ec2SecurityGroupIds
         *        The EC2 security groups that control access to the studio component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2SecurityGroupIds(String... ec2SecurityGroupIds);

        /**
         * <p>
         * Initialization scripts for studio components.
         * </p>
         * 
         * @param initializationScripts
         *        Initialization scripts for studio components.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initializationScripts(Collection<StudioComponentInitializationScript> initializationScripts);

        /**
         * <p>
         * Initialization scripts for studio components.
         * </p>
         * 
         * @param initializationScripts
         *        Initialization scripts for studio components.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initializationScripts(StudioComponentInitializationScript... initializationScripts);

        /**
         * <p>
         * Initialization scripts for studio components.
         * </p>
         * This is a convenience method that creates an instance of the {@link List
         * <StudioComponentInitializationScript>.Builder} avoiding the need to create one manually via {@link List
         * <StudioComponentInitializationScript>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StudioComponentInitializationScript>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #initializationScripts(List<StudioComponentInitializationScript>)}.
         * 
         * @param initializationScripts
         *        a consumer that will call methods on {@link List<StudioComponentInitializationScript>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #initializationScripts(List<StudioComponentInitializationScript>)
         */
        Builder initializationScripts(Consumer<StudioComponentInitializationScript.Builder>... initializationScripts);

        /**
         * <p>
         * The name for the studio component.
         * </p>
         * 
         * @param name
         *        The name for the studio component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * An IAM role attached to a Studio Component that gives the studio component access to AWS resources at anytime
         * while the instance is running.
         * </p>
         * 
         * @param runtimeRoleArn
         *        An IAM role attached to a Studio Component that gives the studio component access to AWS resources at
         *        anytime while the instance is running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runtimeRoleArn(String runtimeRoleArn);

        /**
         * <p>
         * Parameters for the studio component scripts.
         * </p>
         * 
         * @param scriptParameters
         *        Parameters for the studio component scripts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scriptParameters(Collection<ScriptParameterKeyValue> scriptParameters);

        /**
         * <p>
         * Parameters for the studio component scripts.
         * </p>
         * 
         * @param scriptParameters
         *        Parameters for the studio component scripts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scriptParameters(ScriptParameterKeyValue... scriptParameters);

        /**
         * <p>
         * Parameters for the studio component scripts.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ScriptParameterKeyValue>.Builder}
         * avoiding the need to create one manually via {@link List<ScriptParameterKeyValue>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ScriptParameterKeyValue>.Builder#build()} is called
         * immediately and its result is passed to {@link #scriptParameters(List<ScriptParameterKeyValue>)}.
         * 
         * @param scriptParameters
         *        a consumer that will call methods on {@link List<ScriptParameterKeyValue>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scriptParameters(List<ScriptParameterKeyValue>)
         */
        Builder scriptParameters(Consumer<ScriptParameterKeyValue.Builder>... scriptParameters);

        /**
         * <p>
         * An IAM role attached to Studio Component when the system initialization script runs which give the studio
         * component access to AWS resources when the system initialization script runs.
         * </p>
         * 
         * @param secureInitializationRoleArn
         *        An IAM role attached to Studio Component when the system initialization script runs which give the
         *        studio component access to AWS resources when the system initialization script runs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secureInitializationRoleArn(String secureInitializationRoleArn);

        /**
         * <p>
         * The studio component ID.
         * </p>
         * 
         * @param studioComponentId
         *        The studio component ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder studioComponentId(String studioComponentId);

        /**
         * <p>
         * The studio ID.
         * </p>
         * 
         * @param studioId
         *        The studio ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder studioId(String studioId);

        /**
         * <p>
         * The specific subtype of a studio component.
         * </p>
         * 
         * @param subtype
         *        The specific subtype of a studio component.
         * @see StudioComponentSubtype
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StudioComponentSubtype
         */
        Builder subtype(String subtype);

        /**
         * <p>
         * The specific subtype of a studio component.
         * </p>
         * 
         * @param subtype
         *        The specific subtype of a studio component.
         * @see StudioComponentSubtype
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StudioComponentSubtype
         */
        Builder subtype(StudioComponentSubtype subtype);

        /**
         * <p>
         * The type of the studio component.
         * </p>
         * 
         * @param type
         *        The type of the studio component.
         * @see StudioComponentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StudioComponentType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the studio component.
         * </p>
         * 
         * @param type
         *        The type of the studio component.
         * @see StudioComponentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StudioComponentType
         */
        Builder type(StudioComponentType type);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NimbleRequest.BuilderImpl implements Builder {
        private String clientToken;

        private StudioComponentConfiguration configuration;

        private String description;

        private List<String> ec2SecurityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private List<StudioComponentInitializationScript> initializationScripts = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private String runtimeRoleArn;

        private List<ScriptParameterKeyValue> scriptParameters = DefaultSdkAutoConstructList.getInstance();

        private String secureInitializationRoleArn;

        private String studioComponentId;

        private String studioId;

        private String subtype;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStudioComponentRequest model) {
            super(model);
            clientToken(model.clientToken);
            configuration(model.configuration);
            description(model.description);
            ec2SecurityGroupIds(model.ec2SecurityGroupIds);
            initializationScripts(model.initializationScripts);
            name(model.name);
            runtimeRoleArn(model.runtimeRoleArn);
            scriptParameters(model.scriptParameters);
            secureInitializationRoleArn(model.secureInitializationRoleArn);
            studioComponentId(model.studioComponentId);
            studioId(model.studioId);
            subtype(model.subtype);
            type(model.type);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final StudioComponentConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(StudioComponentConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(StudioComponentConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getEc2SecurityGroupIds() {
            if (ec2SecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return ec2SecurityGroupIds;
        }

        public final void setEc2SecurityGroupIds(Collection<String> ec2SecurityGroupIds) {
            this.ec2SecurityGroupIds = StudioComponentSecurityGroupIdListCopier.copy(ec2SecurityGroupIds);
        }

        @Override
        public final Builder ec2SecurityGroupIds(Collection<String> ec2SecurityGroupIds) {
            this.ec2SecurityGroupIds = StudioComponentSecurityGroupIdListCopier.copy(ec2SecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2SecurityGroupIds(String... ec2SecurityGroupIds) {
            ec2SecurityGroupIds(Arrays.asList(ec2SecurityGroupIds));
            return this;
        }

        public final List<StudioComponentInitializationScript.Builder> getInitializationScripts() {
            List<StudioComponentInitializationScript.Builder> result = StudioComponentInitializationScriptListCopier
                    .copyToBuilder(this.initializationScripts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInitializationScripts(
                Collection<StudioComponentInitializationScript.BuilderImpl> initializationScripts) {
            this.initializationScripts = StudioComponentInitializationScriptListCopier.copyFromBuilder(initializationScripts);
        }

        @Override
        public final Builder initializationScripts(Collection<StudioComponentInitializationScript> initializationScripts) {
            this.initializationScripts = StudioComponentInitializationScriptListCopier.copy(initializationScripts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder initializationScripts(StudioComponentInitializationScript... initializationScripts) {
            initializationScripts(Arrays.asList(initializationScripts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder initializationScripts(Consumer<StudioComponentInitializationScript.Builder>... initializationScripts) {
            initializationScripts(Stream.of(initializationScripts)
                    .map(c -> StudioComponentInitializationScript.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRuntimeRoleArn() {
            return runtimeRoleArn;
        }

        public final void setRuntimeRoleArn(String runtimeRoleArn) {
            this.runtimeRoleArn = runtimeRoleArn;
        }

        @Override
        public final Builder runtimeRoleArn(String runtimeRoleArn) {
            this.runtimeRoleArn = runtimeRoleArn;
            return this;
        }

        public final List<ScriptParameterKeyValue.Builder> getScriptParameters() {
            List<ScriptParameterKeyValue.Builder> result = StudioComponentScriptParameterKeyValueListCopier
                    .copyToBuilder(this.scriptParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScriptParameters(Collection<ScriptParameterKeyValue.BuilderImpl> scriptParameters) {
            this.scriptParameters = StudioComponentScriptParameterKeyValueListCopier.copyFromBuilder(scriptParameters);
        }

        @Override
        public final Builder scriptParameters(Collection<ScriptParameterKeyValue> scriptParameters) {
            this.scriptParameters = StudioComponentScriptParameterKeyValueListCopier.copy(scriptParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scriptParameters(ScriptParameterKeyValue... scriptParameters) {
            scriptParameters(Arrays.asList(scriptParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scriptParameters(Consumer<ScriptParameterKeyValue.Builder>... scriptParameters) {
            scriptParameters(Stream.of(scriptParameters).map(c -> ScriptParameterKeyValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getSecureInitializationRoleArn() {
            return secureInitializationRoleArn;
        }

        public final void setSecureInitializationRoleArn(String secureInitializationRoleArn) {
            this.secureInitializationRoleArn = secureInitializationRoleArn;
        }

        @Override
        public final Builder secureInitializationRoleArn(String secureInitializationRoleArn) {
            this.secureInitializationRoleArn = secureInitializationRoleArn;
            return this;
        }

        public final String getStudioComponentId() {
            return studioComponentId;
        }

        public final void setStudioComponentId(String studioComponentId) {
            this.studioComponentId = studioComponentId;
        }

        @Override
        public final Builder studioComponentId(String studioComponentId) {
            this.studioComponentId = studioComponentId;
            return this;
        }

        public final String getStudioId() {
            return studioId;
        }

        public final void setStudioId(String studioId) {
            this.studioId = studioId;
        }

        @Override
        public final Builder studioId(String studioId) {
            this.studioId = studioId;
            return this;
        }

        public final String getSubtype() {
            return subtype;
        }

        public final void setSubtype(String subtype) {
            this.subtype = subtype;
        }

        @Override
        public final Builder subtype(String subtype) {
            this.subtype = subtype;
            return this;
        }

        @Override
        public final Builder subtype(StudioComponentSubtype subtype) {
            this.subtype(subtype == null ? null : subtype.toString());
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(StudioComponentType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateStudioComponentRequest build() {
            return new UpdateStudioComponentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
