/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.nimble.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for a render farm that is associated with a studio resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComputeFarmConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ComputeFarmConfiguration.Builder, ComputeFarmConfiguration> {
    private static final SdkField<String> ACTIVE_DIRECTORY_USER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("activeDirectoryUser").getter(getter(ComputeFarmConfiguration::activeDirectoryUser))
            .setter(setter(Builder::activeDirectoryUser))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeDirectoryUser").build())
            .build();

    private static final SdkField<String> ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("endpoint").getter(getter(ComputeFarmConfiguration::endpoint)).setter(setter(Builder::endpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoint").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVE_DIRECTORY_USER_FIELD,
            ENDPOINT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String activeDirectoryUser;

    private final String endpoint;

    private ComputeFarmConfiguration(BuilderImpl builder) {
        this.activeDirectoryUser = builder.activeDirectoryUser;
        this.endpoint = builder.endpoint;
    }

    /**
     * <p>
     * The name of an Active Directory user that is used on ComputeFarm worker instances.
     * </p>
     * 
     * @return The name of an Active Directory user that is used on ComputeFarm worker instances.
     */
    public final String activeDirectoryUser() {
        return activeDirectoryUser;
    }

    /**
     * <p>
     * The endpoint of the ComputeFarm that is accessed by the studio component resource.
     * </p>
     * 
     * @return The endpoint of the ComputeFarm that is accessed by the studio component resource.
     */
    public final String endpoint() {
        return endpoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(activeDirectoryUser());
        hashCode = 31 * hashCode + Objects.hashCode(endpoint());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComputeFarmConfiguration)) {
            return false;
        }
        ComputeFarmConfiguration other = (ComputeFarmConfiguration) obj;
        return Objects.equals(activeDirectoryUser(), other.activeDirectoryUser()) && Objects.equals(endpoint(), other.endpoint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ComputeFarmConfiguration").add("ActiveDirectoryUser", activeDirectoryUser())
                .add("Endpoint", endpoint() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "activeDirectoryUser":
            return Optional.ofNullable(clazz.cast(activeDirectoryUser()));
        case "endpoint":
            return Optional.ofNullable(clazz.cast(endpoint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ComputeFarmConfiguration, T> g) {
        return obj -> g.apply((ComputeFarmConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComputeFarmConfiguration> {
        /**
         * <p>
         * The name of an Active Directory user that is used on ComputeFarm worker instances.
         * </p>
         * 
         * @param activeDirectoryUser
         *        The name of an Active Directory user that is used on ComputeFarm worker instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeDirectoryUser(String activeDirectoryUser);

        /**
         * <p>
         * The endpoint of the ComputeFarm that is accessed by the studio component resource.
         * </p>
         * 
         * @param endpoint
         *        The endpoint of the ComputeFarm that is accessed by the studio component resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoint(String endpoint);
    }

    static final class BuilderImpl implements Builder {
        private String activeDirectoryUser;

        private String endpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(ComputeFarmConfiguration model) {
            activeDirectoryUser(model.activeDirectoryUser);
            endpoint(model.endpoint);
        }

        public final String getActiveDirectoryUser() {
            return activeDirectoryUser;
        }

        public final void setActiveDirectoryUser(String activeDirectoryUser) {
            this.activeDirectoryUser = activeDirectoryUser;
        }

        @Override
        public final Builder activeDirectoryUser(String activeDirectoryUser) {
            this.activeDirectoryUser = activeDirectoryUser;
            return this;
        }

        public final String getEndpoint() {
            return endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        @Override
        public ComputeFarmConfiguration build() {
            return new ComputeFarmConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
