/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.nimble.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * <p>
 * The status code.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public enum StudioStatusCode {
    STUDIO_CREATED("STUDIO_CREATED"),

    STUDIO_DELETED("STUDIO_DELETED"),

    STUDIO_UPDATED("STUDIO_UPDATED"),

    STUDIO_CREATE_IN_PROGRESS("STUDIO_CREATE_IN_PROGRESS"),

    STUDIO_UPDATE_IN_PROGRESS("STUDIO_UPDATE_IN_PROGRESS"),

    STUDIO_DELETE_IN_PROGRESS("STUDIO_DELETE_IN_PROGRESS"),

    STUDIO_WITH_LAUNCH_PROFILES_NOT_DELETED("STUDIO_WITH_LAUNCH_PROFILES_NOT_DELETED"),

    STUDIO_WITH_STUDIO_COMPONENTS_NOT_DELETED("STUDIO_WITH_STUDIO_COMPONENTS_NOT_DELETED"),

    STUDIO_WITH_STREAMING_IMAGES_NOT_DELETED("STUDIO_WITH_STREAMING_IMAGES_NOT_DELETED"),

    AWS_SSO_NOT_ENABLED("AWS_SSO_NOT_ENABLED"),

    AWS_SSO_ACCESS_DENIED("AWS_SSO_ACCESS_DENIED"),

    ROLE_NOT_OWNED_BY_STUDIO_OWNER("ROLE_NOT_OWNED_BY_STUDIO_OWNER"),

    ROLE_COULD_NOT_BE_ASSUMED("ROLE_COULD_NOT_BE_ASSUMED"),

    INTERNAL_ERROR("INTERNAL_ERROR"),

    ENCRYPTION_KEY_NOT_FOUND("ENCRYPTION_KEY_NOT_FOUND"),

    ENCRYPTION_KEY_ACCESS_DENIED("ENCRYPTION_KEY_ACCESS_DENIED"),

    AWS_SSO_CONFIGURATION_REPAIRED("AWS_SSO_CONFIGURATION_REPAIRED"),

    AWS_SSO_CONFIGURATION_REPAIR_IN_PROGRESS("AWS_SSO_CONFIGURATION_REPAIR_IN_PROGRESS"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StudioStatusCode> VALUE_MAP = EnumUtils.uniqueIndex(StudioStatusCode.class,
            StudioStatusCode::toString);

    private final String value;

    private StudioStatusCode(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return StudioStatusCode corresponding to the value
     */
    public static StudioStatusCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link StudioStatusCode}s
     */
    public static Set<StudioStatusCode> knownValues() {
        Set<StudioStatusCode> knownValues = EnumSet.allOf(StudioStatusCode.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
