/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.nimble.model.NimbleRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateStreamingImageRequest
extends NimbleRequest
implements ToCopyableBuilder<Builder, UpdateStreamingImageRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateStreamingImageRequest.getter(UpdateStreamingImageRequest::clientToken)).setter(UpdateStreamingImageRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Client-Token").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateStreamingImageRequest.getter(UpdateStreamingImageRequest::description)).setter(UpdateStreamingImageRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateStreamingImageRequest.getter(UpdateStreamingImageRequest::name)).setter(UpdateStreamingImageRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> STREAMING_IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("streamingImageId").getter(UpdateStreamingImageRequest.getter(UpdateStreamingImageRequest::streamingImageId)).setter(UpdateStreamingImageRequest.setter(Builder::streamingImageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("streamingImageId").build()}).build();
    private static final SdkField<String> STUDIO_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("studioId").getter(UpdateStreamingImageRequest.getter(UpdateStreamingImageRequest::studioId)).setter(UpdateStreamingImageRequest.setter(Builder::studioId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("studioId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, DESCRIPTION_FIELD, NAME_FIELD, STREAMING_IMAGE_ID_FIELD, STUDIO_ID_FIELD));
    private final String clientToken;
    private final String description;
    private final String name;
    private final String streamingImageId;
    private final String studioId;

    private UpdateStreamingImageRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.name = builder.name;
        this.streamingImageId = builder.streamingImageId;
        this.studioId = builder.studioId;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String description() {
        return this.description;
    }

    public final String name() {
        return this.name;
    }

    public final String streamingImageId() {
        return this.streamingImageId;
    }

    public final String studioId() {
        return this.studioId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamingImageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.studioId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStreamingImageRequest)) {
            return false;
        }
        UpdateStreamingImageRequest other = (UpdateStreamingImageRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.streamingImageId(), other.streamingImageId()) && Objects.equals(this.studioId(), other.studioId());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateStreamingImageRequest").add("ClientToken", (Object)this.clientToken()).add("Description", (Object)this.description()).add("Name", (Object)this.name()).add("StreamingImageId", (Object)this.streamingImageId()).add("StudioId", (Object)this.studioId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "streamingImageId": {
                return Optional.ofNullable(clazz.cast(this.streamingImageId()));
            }
            case "studioId": {
                return Optional.ofNullable(clazz.cast(this.studioId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateStreamingImageRequest, T> g) {
        return obj -> g.apply((UpdateStreamingImageRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NimbleRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String description;
        private String name;
        private String streamingImageId;
        private String studioId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStreamingImageRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.description(model.description);
            this.name(model.name);
            this.streamingImageId(model.streamingImageId);
            this.studioId(model.studioId);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStreamingImageId() {
            return this.streamingImageId;
        }

        public final void setStreamingImageId(String streamingImageId) {
            this.streamingImageId = streamingImageId;
        }

        @Override
        @Transient
        public final Builder streamingImageId(String streamingImageId) {
            this.streamingImageId = streamingImageId;
            return this;
        }

        public final String getStudioId() {
            return this.studioId;
        }

        public final void setStudioId(String studioId) {
            this.studioId = studioId;
        }

        @Override
        @Transient
        public final Builder studioId(String studioId) {
            this.studioId = studioId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateStreamingImageRequest build() {
            return new UpdateStreamingImageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NimbleRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateStreamingImageRequest> {
        public Builder clientToken(String var1);

        public Builder description(String var1);

        public Builder name(String var1);

        public Builder streamingImageId(String var1);

        public Builder studioId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

