/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.nimble.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class EulaAcceptance implements SdkPojo, Serializable, ToCopyableBuilder<EulaAcceptance.Builder, EulaAcceptance> {
    private static final SdkField<Instant> ACCEPTED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("acceptedAt")
            .getter(getter(EulaAcceptance::acceptedAt))
            .setter(setter(Builder::acceptedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acceptedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> ACCEPTED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("acceptedBy").getter(getter(EulaAcceptance::acceptedBy)).setter(setter(Builder::acceptedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acceptedBy").build()).build();

    private static final SdkField<String> ACCEPTEE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accepteeId").getter(getter(EulaAcceptance::accepteeId)).setter(setter(Builder::accepteeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accepteeId").build()).build();

    private static final SdkField<String> EULA_ACCEPTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eulaAcceptanceId").getter(getter(EulaAcceptance::eulaAcceptanceId))
            .setter(setter(Builder::eulaAcceptanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eulaAcceptanceId").build()).build();

    private static final SdkField<String> EULA_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("eulaId")
            .getter(getter(EulaAcceptance::eulaId)).setter(setter(Builder::eulaId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eulaId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPTED_AT_FIELD,
            ACCEPTED_BY_FIELD, ACCEPTEE_ID_FIELD, EULA_ACCEPTANCE_ID_FIELD, EULA_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant acceptedAt;

    private final String acceptedBy;

    private final String accepteeId;

    private final String eulaAcceptanceId;

    private final String eulaId;

    private EulaAcceptance(BuilderImpl builder) {
        this.acceptedAt = builder.acceptedAt;
        this.acceptedBy = builder.acceptedBy;
        this.accepteeId = builder.accepteeId;
        this.eulaAcceptanceId = builder.eulaAcceptanceId;
        this.eulaId = builder.eulaId;
    }

    /**
     * <p>
     * The Unix epoch timestamp in seconds for when the EULA was accepted.
     * </p>
     * 
     * @return The Unix epoch timestamp in seconds for when the EULA was accepted.
     */
    public final Instant acceptedAt() {
        return acceptedAt;
    }

    /**
     * <p>
     * The ID of the person who accepted the EULA.
     * </p>
     * 
     * @return The ID of the person who accepted the EULA.
     */
    public final String acceptedBy() {
        return acceptedBy;
    }

    /**
     * <p>
     * The ID of the acceptee.
     * </p>
     * 
     * @return The ID of the acceptee.
     */
    public final String accepteeId() {
        return accepteeId;
    }

    /**
     * <p>
     * The EULA acceptance ID.
     * </p>
     * 
     * @return The EULA acceptance ID.
     */
    public final String eulaAcceptanceId() {
        return eulaAcceptanceId;
    }

    /**
     * <p>
     * The EULA ID.
     * </p>
     * 
     * @return The EULA ID.
     */
    public final String eulaId() {
        return eulaId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(acceptedAt());
        hashCode = 31 * hashCode + Objects.hashCode(acceptedBy());
        hashCode = 31 * hashCode + Objects.hashCode(accepteeId());
        hashCode = 31 * hashCode + Objects.hashCode(eulaAcceptanceId());
        hashCode = 31 * hashCode + Objects.hashCode(eulaId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EulaAcceptance)) {
            return false;
        }
        EulaAcceptance other = (EulaAcceptance) obj;
        return Objects.equals(acceptedAt(), other.acceptedAt()) && Objects.equals(acceptedBy(), other.acceptedBy())
                && Objects.equals(accepteeId(), other.accepteeId())
                && Objects.equals(eulaAcceptanceId(), other.eulaAcceptanceId()) && Objects.equals(eulaId(), other.eulaId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EulaAcceptance").add("AcceptedAt", acceptedAt()).add("AcceptedBy", acceptedBy())
                .add("AccepteeId", accepteeId()).add("EulaAcceptanceId", eulaAcceptanceId()).add("EulaId", eulaId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "acceptedAt":
            return Optional.ofNullable(clazz.cast(acceptedAt()));
        case "acceptedBy":
            return Optional.ofNullable(clazz.cast(acceptedBy()));
        case "accepteeId":
            return Optional.ofNullable(clazz.cast(accepteeId()));
        case "eulaAcceptanceId":
            return Optional.ofNullable(clazz.cast(eulaAcceptanceId()));
        case "eulaId":
            return Optional.ofNullable(clazz.cast(eulaId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EulaAcceptance, T> g) {
        return obj -> g.apply((EulaAcceptance) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EulaAcceptance> {
        /**
         * <p>
         * The Unix epoch timestamp in seconds for when the EULA was accepted.
         * </p>
         * 
         * @param acceptedAt
         *        The Unix epoch timestamp in seconds for when the EULA was accepted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceptedAt(Instant acceptedAt);

        /**
         * <p>
         * The ID of the person who accepted the EULA.
         * </p>
         * 
         * @param acceptedBy
         *        The ID of the person who accepted the EULA.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceptedBy(String acceptedBy);

        /**
         * <p>
         * The ID of the acceptee.
         * </p>
         * 
         * @param accepteeId
         *        The ID of the acceptee.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accepteeId(String accepteeId);

        /**
         * <p>
         * The EULA acceptance ID.
         * </p>
         * 
         * @param eulaAcceptanceId
         *        The EULA acceptance ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eulaAcceptanceId(String eulaAcceptanceId);

        /**
         * <p>
         * The EULA ID.
         * </p>
         * 
         * @param eulaId
         *        The EULA ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eulaId(String eulaId);
    }

    static final class BuilderImpl implements Builder {
        private Instant acceptedAt;

        private String acceptedBy;

        private String accepteeId;

        private String eulaAcceptanceId;

        private String eulaId;

        private BuilderImpl() {
        }

        private BuilderImpl(EulaAcceptance model) {
            acceptedAt(model.acceptedAt);
            acceptedBy(model.acceptedBy);
            accepteeId(model.accepteeId);
            eulaAcceptanceId(model.eulaAcceptanceId);
            eulaId(model.eulaId);
        }

        public final Instant getAcceptedAt() {
            return acceptedAt;
        }

        public final void setAcceptedAt(Instant acceptedAt) {
            this.acceptedAt = acceptedAt;
        }

        @Override
        @Transient
        public final Builder acceptedAt(Instant acceptedAt) {
            this.acceptedAt = acceptedAt;
            return this;
        }

        public final String getAcceptedBy() {
            return acceptedBy;
        }

        public final void setAcceptedBy(String acceptedBy) {
            this.acceptedBy = acceptedBy;
        }

        @Override
        @Transient
        public final Builder acceptedBy(String acceptedBy) {
            this.acceptedBy = acceptedBy;
            return this;
        }

        public final String getAccepteeId() {
            return accepteeId;
        }

        public final void setAccepteeId(String accepteeId) {
            this.accepteeId = accepteeId;
        }

        @Override
        @Transient
        public final Builder accepteeId(String accepteeId) {
            this.accepteeId = accepteeId;
            return this;
        }

        public final String getEulaAcceptanceId() {
            return eulaAcceptanceId;
        }

        public final void setEulaAcceptanceId(String eulaAcceptanceId) {
            this.eulaAcceptanceId = eulaAcceptanceId;
        }

        @Override
        @Transient
        public final Builder eulaAcceptanceId(String eulaAcceptanceId) {
            this.eulaAcceptanceId = eulaAcceptanceId;
            return this;
        }

        public final String getEulaId() {
            return eulaId;
        }

        public final void setEulaId(String eulaId) {
            this.eulaId = eulaId;
        }

        @Override
        @Transient
        public final Builder eulaId(String eulaId) {
            this.eulaId = eulaId;
            return this;
        }

        @Override
        public EulaAcceptance build() {
            return new EulaAcceptance(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
