/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.nimble.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetStreamingImageRequest extends NimbleRequest implements
        ToCopyableBuilder<GetStreamingImageRequest.Builder, GetStreamingImageRequest> {
    private static final SdkField<String> STREAMING_IMAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("streamingImageId").getter(getter(GetStreamingImageRequest::streamingImageId))
            .setter(setter(Builder::streamingImageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("streamingImageId").build()).build();

    private static final SdkField<String> STUDIO_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("studioId").getter(getter(GetStreamingImageRequest::studioId)).setter(setter(Builder::studioId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("studioId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAMING_IMAGE_ID_FIELD,
            STUDIO_ID_FIELD));

    private final String streamingImageId;

    private final String studioId;

    private GetStreamingImageRequest(BuilderImpl builder) {
        super(builder);
        this.streamingImageId = builder.streamingImageId;
        this.studioId = builder.studioId;
    }

    /**
     * <p>
     * The streaming image ID.
     * </p>
     * 
     * @return The streaming image ID.
     */
    public final String streamingImageId() {
        return streamingImageId;
    }

    /**
     * <p>
     * The studio ID.
     * </p>
     * 
     * @return The studio ID.
     */
    public final String studioId() {
        return studioId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(streamingImageId());
        hashCode = 31 * hashCode + Objects.hashCode(studioId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetStreamingImageRequest)) {
            return false;
        }
        GetStreamingImageRequest other = (GetStreamingImageRequest) obj;
        return Objects.equals(streamingImageId(), other.streamingImageId()) && Objects.equals(studioId(), other.studioId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetStreamingImageRequest").add("StreamingImageId", streamingImageId())
                .add("StudioId", studioId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "streamingImageId":
            return Optional.ofNullable(clazz.cast(streamingImageId()));
        case "studioId":
            return Optional.ofNullable(clazz.cast(studioId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetStreamingImageRequest, T> g) {
        return obj -> g.apply((GetStreamingImageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NimbleRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetStreamingImageRequest> {
        /**
         * <p>
         * The streaming image ID.
         * </p>
         * 
         * @param streamingImageId
         *        The streaming image ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamingImageId(String streamingImageId);

        /**
         * <p>
         * The studio ID.
         * </p>
         * 
         * @param studioId
         *        The studio ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder studioId(String studioId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NimbleRequest.BuilderImpl implements Builder {
        private String streamingImageId;

        private String studioId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetStreamingImageRequest model) {
            super(model);
            streamingImageId(model.streamingImageId);
            studioId(model.studioId);
        }

        public final String getStreamingImageId() {
            return streamingImageId;
        }

        public final void setStreamingImageId(String streamingImageId) {
            this.streamingImageId = streamingImageId;
        }

        @Override
        @Transient
        public final Builder streamingImageId(String streamingImageId) {
            this.streamingImageId = streamingImageId;
            return this;
        }

        public final String getStudioId() {
            return studioId;
        }

        public final void setStudioId(String studioId) {
            this.studioId = studioId;
        }

        @Override
        @Transient
        public final Builder studioId(String studioId) {
            this.studioId = studioId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetStreamingImageRequest build() {
            return new GetStreamingImageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
