/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.nimble.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Initialization scripts for studio components.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StudioComponentInitializationScript implements SdkPojo, Serializable,
        ToCopyableBuilder<StudioComponentInitializationScript.Builder, StudioComponentInitializationScript> {
    private static final SdkField<String> LAUNCH_PROFILE_PROTOCOL_VERSION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("launchProfileProtocolVersion")
            .getter(getter(StudioComponentInitializationScript::launchProfileProtocolVersion))
            .setter(setter(Builder::launchProfileProtocolVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchProfileProtocolVersion")
                    .build()).build();

    private static final SdkField<String> PLATFORM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("platform").getter(getter(StudioComponentInitializationScript::platformAsString))
            .setter(setter(Builder::platform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()).build();

    private static final SdkField<String> RUN_CONTEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("runContext").getter(getter(StudioComponentInitializationScript::runContextAsString))
            .setter(setter(Builder::runContext))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runContext").build()).build();

    private static final SdkField<String> SCRIPT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("script")
            .getter(getter(StudioComponentInitializationScript::script)).setter(setter(Builder::script))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("script").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LAUNCH_PROFILE_PROTOCOL_VERSION_FIELD, PLATFORM_FIELD, RUN_CONTEXT_FIELD, SCRIPT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String launchProfileProtocolVersion;

    private final String platform;

    private final String runContext;

    private final String script;

    private StudioComponentInitializationScript(BuilderImpl builder) {
        this.launchProfileProtocolVersion = builder.launchProfileProtocolVersion;
        this.platform = builder.platform;
        this.runContext = builder.runContext;
        this.script = builder.script;
    }

    /**
     * <p>
     * The version number of the protocol that is used by the launch profile. The only valid version is "2021-03-31".
     * </p>
     * 
     * @return The version number of the protocol that is used by the launch profile. The only valid version is
     *         "2021-03-31".
     */
    public final String launchProfileProtocolVersion() {
        return launchProfileProtocolVersion;
    }

    /**
     * <p>
     * The platform of the initialization script, either WINDOWS or LINUX.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link LaunchProfilePlatform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #platformAsString}.
     * </p>
     * 
     * @return The platform of the initialization script, either WINDOWS or LINUX.
     * @see LaunchProfilePlatform
     */
    public final LaunchProfilePlatform platform() {
        return LaunchProfilePlatform.fromValue(platform);
    }

    /**
     * <p>
     * The platform of the initialization script, either WINDOWS or LINUX.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link LaunchProfilePlatform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #platformAsString}.
     * </p>
     * 
     * @return The platform of the initialization script, either WINDOWS or LINUX.
     * @see LaunchProfilePlatform
     */
    public final String platformAsString() {
        return platform;
    }

    /**
     * <p>
     * The method to use when running the initialization script.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #runContext} will
     * return {@link StudioComponentInitializationScriptRunContext#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #runContextAsString}.
     * </p>
     * 
     * @return The method to use when running the initialization script.
     * @see StudioComponentInitializationScriptRunContext
     */
    public final StudioComponentInitializationScriptRunContext runContext() {
        return StudioComponentInitializationScriptRunContext.fromValue(runContext);
    }

    /**
     * <p>
     * The method to use when running the initialization script.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #runContext} will
     * return {@link StudioComponentInitializationScriptRunContext#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #runContextAsString}.
     * </p>
     * 
     * @return The method to use when running the initialization script.
     * @see StudioComponentInitializationScriptRunContext
     */
    public final String runContextAsString() {
        return runContext;
    }

    /**
     * <p>
     * The initialization script.
     * </p>
     * 
     * @return The initialization script.
     */
    public final String script() {
        return script;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(launchProfileProtocolVersion());
        hashCode = 31 * hashCode + Objects.hashCode(platformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(runContextAsString());
        hashCode = 31 * hashCode + Objects.hashCode(script());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StudioComponentInitializationScript)) {
            return false;
        }
        StudioComponentInitializationScript other = (StudioComponentInitializationScript) obj;
        return Objects.equals(launchProfileProtocolVersion(), other.launchProfileProtocolVersion())
                && Objects.equals(platformAsString(), other.platformAsString())
                && Objects.equals(runContextAsString(), other.runContextAsString()) && Objects.equals(script(), other.script());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StudioComponentInitializationScript")
                .add("LaunchProfileProtocolVersion", launchProfileProtocolVersion()).add("Platform", platformAsString())
                .add("RunContext", runContextAsString()).add("Script", script()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "launchProfileProtocolVersion":
            return Optional.ofNullable(clazz.cast(launchProfileProtocolVersion()));
        case "platform":
            return Optional.ofNullable(clazz.cast(platformAsString()));
        case "runContext":
            return Optional.ofNullable(clazz.cast(runContextAsString()));
        case "script":
            return Optional.ofNullable(clazz.cast(script()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StudioComponentInitializationScript, T> g) {
        return obj -> g.apply((StudioComponentInitializationScript) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StudioComponentInitializationScript> {
        /**
         * <p>
         * The version number of the protocol that is used by the launch profile. The only valid version is
         * "2021-03-31".
         * </p>
         * 
         * @param launchProfileProtocolVersion
         *        The version number of the protocol that is used by the launch profile. The only valid version is
         *        "2021-03-31".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchProfileProtocolVersion(String launchProfileProtocolVersion);

        /**
         * <p>
         * The platform of the initialization script, either WINDOWS or LINUX.
         * </p>
         * 
         * @param platform
         *        The platform of the initialization script, either WINDOWS or LINUX.
         * @see LaunchProfilePlatform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LaunchProfilePlatform
         */
        Builder platform(String platform);

        /**
         * <p>
         * The platform of the initialization script, either WINDOWS or LINUX.
         * </p>
         * 
         * @param platform
         *        The platform of the initialization script, either WINDOWS or LINUX.
         * @see LaunchProfilePlatform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LaunchProfilePlatform
         */
        Builder platform(LaunchProfilePlatform platform);

        /**
         * <p>
         * The method to use when running the initialization script.
         * </p>
         * 
         * @param runContext
         *        The method to use when running the initialization script.
         * @see StudioComponentInitializationScriptRunContext
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StudioComponentInitializationScriptRunContext
         */
        Builder runContext(String runContext);

        /**
         * <p>
         * The method to use when running the initialization script.
         * </p>
         * 
         * @param runContext
         *        The method to use when running the initialization script.
         * @see StudioComponentInitializationScriptRunContext
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StudioComponentInitializationScriptRunContext
         */
        Builder runContext(StudioComponentInitializationScriptRunContext runContext);

        /**
         * <p>
         * The initialization script.
         * </p>
         * 
         * @param script
         *        The initialization script.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder script(String script);
    }

    static final class BuilderImpl implements Builder {
        private String launchProfileProtocolVersion;

        private String platform;

        private String runContext;

        private String script;

        private BuilderImpl() {
        }

        private BuilderImpl(StudioComponentInitializationScript model) {
            launchProfileProtocolVersion(model.launchProfileProtocolVersion);
            platform(model.platform);
            runContext(model.runContext);
            script(model.script);
        }

        public final String getLaunchProfileProtocolVersion() {
            return launchProfileProtocolVersion;
        }

        public final void setLaunchProfileProtocolVersion(String launchProfileProtocolVersion) {
            this.launchProfileProtocolVersion = launchProfileProtocolVersion;
        }

        @Override
        @Transient
        public final Builder launchProfileProtocolVersion(String launchProfileProtocolVersion) {
            this.launchProfileProtocolVersion = launchProfileProtocolVersion;
            return this;
        }

        public final String getPlatform() {
            return platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        @Transient
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        @Transient
        public final Builder platform(LaunchProfilePlatform platform) {
            this.platform(platform == null ? null : platform.toString());
            return this;
        }

        public final String getRunContext() {
            return runContext;
        }

        public final void setRunContext(String runContext) {
            this.runContext = runContext;
        }

        @Override
        @Transient
        public final Builder runContext(String runContext) {
            this.runContext = runContext;
            return this;
        }

        @Override
        @Transient
        public final Builder runContext(StudioComponentInitializationScriptRunContext runContext) {
            this.runContext(runContext == null ? null : runContext.toString());
            return this;
        }

        public final String getScript() {
            return script;
        }

        public final void setScript(String script) {
            this.script = script;
        }

        @Override
        @Transient
        public final Builder script(String script) {
            this.script = script;
            return this;
        }

        @Override
        public StudioComponentInitializationScript build() {
            return new StudioComponentInitializationScript(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
