/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.nimble.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * <p>
 * The current status of the studio component resource.
 * </p>
 * <p>
 * When the resource is in the 'READY' state, the status code signals what the last mutation made to the resource was.
 * </p>
 * <p>
 * When the resource is in a CREATE_FAILED/UPDATE_FAILED/DELETE_FAILED state, the status code signals what went wrong
 * and why the mutation failed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public enum StudioComponentStatusCode {
    ACTIVE_DIRECTORY_ALREADY_EXISTS("ACTIVE_DIRECTORY_ALREADY_EXISTS"),

    STUDIO_COMPONENT_CREATED("STUDIO_COMPONENT_CREATED"),

    STUDIO_COMPONENT_UPDATED("STUDIO_COMPONENT_UPDATED"),

    STUDIO_COMPONENT_DELETED("STUDIO_COMPONENT_DELETED"),

    ENCRYPTION_KEY_ACCESS_DENIED("ENCRYPTION_KEY_ACCESS_DENIED"),

    ENCRYPTION_KEY_NOT_FOUND("ENCRYPTION_KEY_NOT_FOUND"),

    STUDIO_COMPONENT_CREATE_IN_PROGRESS("STUDIO_COMPONENT_CREATE_IN_PROGRESS"),

    STUDIO_COMPONENT_UPDATE_IN_PROGRESS("STUDIO_COMPONENT_UPDATE_IN_PROGRESS"),

    STUDIO_COMPONENT_DELETE_IN_PROGRESS("STUDIO_COMPONENT_DELETE_IN_PROGRESS"),

    INTERNAL_ERROR("INTERNAL_ERROR"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StudioComponentStatusCode> VALUE_MAP = EnumUtils.uniqueIndex(
            StudioComponentStatusCode.class, StudioComponentStatusCode::toString);

    private final String value;

    private StudioComponentStatusCode(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return StudioComponentStatusCode corresponding to the value
     */
    public static StudioComponentStatusCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link StudioComponentStatusCode}s
     */
    public static Set<StudioComponentStatusCode> knownValues() {
        Set<StudioComponentStatusCode> knownValues = EnumSet.allOf(StudioComponentStatusCode.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
