/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.nimble.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A network that is used by a studio’s users and workflows, including render farm, Active Directory, licensing, and
 * file system.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StudioComponent implements SdkPojo, Serializable, ToCopyableBuilder<StudioComponent.Builder, StudioComponent> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(StudioComponent::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<StudioComponentConfiguration> CONFIGURATION_FIELD = SdkField
            .<StudioComponentConfiguration> builder(MarshallingType.SDK_POJO).memberName("configuration")
            .getter(getter(StudioComponent::configuration)).setter(setter(Builder::configuration))
            .constructor(StudioComponentConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(StudioComponent::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(StudioComponent::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(StudioComponent::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<String>> EC2_SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ec2SecurityGroupIds")
            .getter(getter(StudioComponent::ec2SecurityGroupIds))
            .setter(setter(Builder::ec2SecurityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2SecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StudioComponentInitializationScript>> INITIALIZATION_SCRIPTS_FIELD = SdkField
            .<List<StudioComponentInitializationScript>> builder(MarshallingType.LIST)
            .memberName("initializationScripts")
            .getter(getter(StudioComponent::initializationScripts))
            .setter(setter(Builder::initializationScripts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initializationScripts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StudioComponentInitializationScript> builder(MarshallingType.SDK_POJO)
                                            .constructor(StudioComponentInitializationScript::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(StudioComponent::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<ScriptParameterKeyValue>> SCRIPT_PARAMETERS_FIELD = SdkField
            .<List<ScriptParameterKeyValue>> builder(MarshallingType.LIST)
            .memberName("scriptParameters")
            .getter(getter(StudioComponent::scriptParameters))
            .setter(setter(Builder::scriptParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scriptParameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ScriptParameterKeyValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(ScriptParameterKeyValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("state")
            .getter(getter(StudioComponent::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusCode").getter(getter(StudioComponent::statusCodeAsString)).setter(setter(Builder::statusCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusCode").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusMessage").getter(getter(StudioComponent::statusMessage)).setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()).build();

    private static final SdkField<String> STUDIO_COMPONENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("studioComponentId").getter(getter(StudioComponent::studioComponentId))
            .setter(setter(Builder::studioComponentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("studioComponentId").build()).build();

    private static final SdkField<String> SUBTYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("subtype")
            .getter(getter(StudioComponent::subtypeAsString)).setter(setter(Builder::subtype))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subtype").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(StudioComponent::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(StudioComponent::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(StudioComponent::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> UPDATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("updatedBy").getter(getter(StudioComponent::updatedBy)).setter(setter(Builder::updatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            CONFIGURATION_FIELD, CREATED_AT_FIELD, CREATED_BY_FIELD, DESCRIPTION_FIELD, EC2_SECURITY_GROUP_IDS_FIELD,
            INITIALIZATION_SCRIPTS_FIELD, NAME_FIELD, SCRIPT_PARAMETERS_FIELD, STATE_FIELD, STATUS_CODE_FIELD,
            STATUS_MESSAGE_FIELD, STUDIO_COMPONENT_ID_FIELD, SUBTYPE_FIELD, TAGS_FIELD, TYPE_FIELD, UPDATED_AT_FIELD,
            UPDATED_BY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final StudioComponentConfiguration configuration;

    private final Instant createdAt;

    private final String createdBy;

    private final String description;

    private final List<String> ec2SecurityGroupIds;

    private final List<StudioComponentInitializationScript> initializationScripts;

    private final String name;

    private final List<ScriptParameterKeyValue> scriptParameters;

    private final String state;

    private final String statusCodeValue;

    private final String statusMessage;

    private final String studioComponentId;

    private final String subtype;

    private final Map<String, String> tags;

    private final String type;

    private final Instant updatedAt;

    private final String updatedBy;

    private StudioComponent(BuilderImpl builder) {
        this.arn = builder.arn;
        this.configuration = builder.configuration;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.description = builder.description;
        this.ec2SecurityGroupIds = builder.ec2SecurityGroupIds;
        this.initializationScripts = builder.initializationScripts;
        this.name = builder.name;
        this.scriptParameters = builder.scriptParameters;
        this.state = builder.state;
        this.statusCodeValue = builder.statusCodeValue;
        this.statusMessage = builder.statusMessage;
        this.studioComponentId = builder.studioComponentId;
        this.subtype = builder.subtype;
        this.tags = builder.tags;
        this.type = builder.type;
        this.updatedAt = builder.updatedAt;
        this.updatedBy = builder.updatedBy;
    }

    /**
     * <p>
     * The ARN of the resource.
     * </p>
     * 
     * @return The ARN of the resource.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The configuration of the studio component, based on component type.
     * </p>
     * 
     * @return The configuration of the studio component, based on component type.
     */
    public final StudioComponentConfiguration configuration() {
        return configuration;
    }

    /**
     * <p>
     * The Unix epoch timestamp in seconds for when the resource was created.
     * </p>
     * 
     * @return The Unix epoch timestamp in seconds for when the resource was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The user ID of the user that created the studio component.
     * </p>
     * 
     * @return The user ID of the user that created the studio component.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * A human-readable description for the studio component resource.
     * </p>
     * 
     * @return A human-readable description for the studio component resource.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Ec2SecurityGroupIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEc2SecurityGroupIds() {
        return ec2SecurityGroupIds != null && !(ec2SecurityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The EC2 security groups that control access to the studio component.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEc2SecurityGroupIds} method.
     * </p>
     * 
     * @return The EC2 security groups that control access to the studio component.
     */
    public final List<String> ec2SecurityGroupIds() {
        return ec2SecurityGroupIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the InitializationScripts property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasInitializationScripts() {
        return initializationScripts != null && !(initializationScripts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Initialization scripts for studio components.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInitializationScripts} method.
     * </p>
     * 
     * @return Initialization scripts for studio components.
     */
    public final List<StudioComponentInitializationScript> initializationScripts() {
        return initializationScripts;
    }

    /**
     * <p>
     * A friendly name for the studio component resource.
     * </p>
     * 
     * @return A friendly name for the studio component resource.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the ScriptParameters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasScriptParameters() {
        return scriptParameters != null && !(scriptParameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Parameters for the studio component scripts.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScriptParameters} method.
     * </p>
     * 
     * @return Parameters for the studio component scripts.
     */
    public final List<ScriptParameterKeyValue> scriptParameters() {
        return scriptParameters;
    }

    /**
     * <p>
     * The current state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link StudioComponentState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state.
     * @see StudioComponentState
     */
    public final StudioComponentState state() {
        return StudioComponentState.fromValue(state);
    }

    /**
     * <p>
     * The current state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link StudioComponentState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state.
     * @see StudioComponentState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The status code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusCode} will
     * return {@link StudioComponentStatusCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusCodeAsString}.
     * </p>
     * 
     * @return The status code.
     * @see StudioComponentStatusCode
     */
    public final StudioComponentStatusCode statusCode() {
        return StudioComponentStatusCode.fromValue(statusCodeValue);
    }

    /**
     * <p>
     * The status code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusCode} will
     * return {@link StudioComponentStatusCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusCodeAsString}.
     * </p>
     * 
     * @return The status code.
     * @see StudioComponentStatusCode
     */
    public final String statusCodeAsString() {
        return statusCodeValue;
    }

    /**
     * <p>
     * The status message for the studio component.
     * </p>
     * 
     * @return The status message for the studio component.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The unique identifier for a studio component resource.
     * </p>
     * 
     * @return The unique identifier for a studio component resource.
     */
    public final String studioComponentId() {
        return studioComponentId;
    }

    /**
     * <p>
     * The specific subtype of a studio component.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #subtype} will
     * return {@link StudioComponentSubtype#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #subtypeAsString}.
     * </p>
     * 
     * @return The specific subtype of a studio component.
     * @see StudioComponentSubtype
     */
    public final StudioComponentSubtype subtype() {
        return StudioComponentSubtype.fromValue(subtype);
    }

    /**
     * <p>
     * The specific subtype of a studio component.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #subtype} will
     * return {@link StudioComponentSubtype#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #subtypeAsString}.
     * </p>
     * 
     * @return The specific subtype of a studio component.
     * @see StudioComponentSubtype
     */
    public final String subtypeAsString() {
        return subtype;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A collection of labels, in the form of key:value pairs, that apply to this resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A collection of labels, in the form of key:value pairs, that apply to this resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The type of the studio component.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link StudioComponentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the studio component.
     * @see StudioComponentType
     */
    public final StudioComponentType type() {
        return StudioComponentType.fromValue(type);
    }

    /**
     * <p>
     * The type of the studio component.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link StudioComponentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the studio component.
     * @see StudioComponentType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The Unix epoch timestamp in seconds for when the resource was updated.
     * </p>
     * 
     * @return The Unix epoch timestamp in seconds for when the resource was updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The user ID of the user that most recently updated the resource.
     * </p>
     * 
     * @return The user ID of the user that most recently updated the resource.
     */
    public final String updatedBy() {
        return updatedBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasEc2SecurityGroupIds() ? ec2SecurityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasInitializationScripts() ? initializationScripts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasScriptParameters() ? scriptParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(studioComponentId());
        hashCode = 31 * hashCode + Objects.hashCode(subtypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedBy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StudioComponent)) {
            return false;
        }
        StudioComponent other = (StudioComponent) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(configuration(), other.configuration())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(description(), other.description())
                && hasEc2SecurityGroupIds() == other.hasEc2SecurityGroupIds()
                && Objects.equals(ec2SecurityGroupIds(), other.ec2SecurityGroupIds())
                && hasInitializationScripts() == other.hasInitializationScripts()
                && Objects.equals(initializationScripts(), other.initializationScripts()) && Objects.equals(name(), other.name())
                && hasScriptParameters() == other.hasScriptParameters()
                && Objects.equals(scriptParameters(), other.scriptParameters())
                && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(statusCodeAsString(), other.statusCodeAsString())
                && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(studioComponentId(), other.studioComponentId())
                && Objects.equals(subtypeAsString(), other.subtypeAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(updatedAt(), other.updatedAt()) && Objects.equals(updatedBy(), other.updatedBy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StudioComponent").add("Arn", arn()).add("Configuration", configuration())
                .add("CreatedAt", createdAt()).add("CreatedBy", createdBy()).add("Description", description())
                .add("Ec2SecurityGroupIds", hasEc2SecurityGroupIds() ? ec2SecurityGroupIds() : null)
                .add("InitializationScripts", hasInitializationScripts() ? initializationScripts() : null).add("Name", name())
                .add("ScriptParameters", hasScriptParameters() ? scriptParameters() : null).add("State", stateAsString())
                .add("StatusCode", statusCodeAsString()).add("StatusMessage", statusMessage())
                .add("StudioComponentId", studioComponentId()).add("Subtype", subtypeAsString())
                .add("Tags", hasTags() ? tags() : null).add("Type", typeAsString()).add("UpdatedAt", updatedAt())
                .add("UpdatedBy", updatedBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ec2SecurityGroupIds":
            return Optional.ofNullable(clazz.cast(ec2SecurityGroupIds()));
        case "initializationScripts":
            return Optional.ofNullable(clazz.cast(initializationScripts()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "scriptParameters":
            return Optional.ofNullable(clazz.cast(scriptParameters()));
        case "state":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "statusCode":
            return Optional.ofNullable(clazz.cast(statusCodeAsString()));
        case "statusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "studioComponentId":
            return Optional.ofNullable(clazz.cast(studioComponentId()));
        case "subtype":
            return Optional.ofNullable(clazz.cast(subtypeAsString()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "updatedBy":
            return Optional.ofNullable(clazz.cast(updatedBy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StudioComponent, T> g) {
        return obj -> g.apply((StudioComponent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StudioComponent> {
        /**
         * <p>
         * The ARN of the resource.
         * </p>
         * 
         * @param arn
         *        The ARN of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The configuration of the studio component, based on component type.
         * </p>
         * 
         * @param configuration
         *        The configuration of the studio component, based on component type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(StudioComponentConfiguration configuration);

        /**
         * <p>
         * The configuration of the studio component, based on component type.
         * </p>
         * This is a convenience that creates an instance of the {@link StudioComponentConfiguration.Builder} avoiding
         * the need to create one manually via {@link StudioComponentConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link StudioComponentConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #configuration(StudioComponentConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link StudioComponentConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(StudioComponentConfiguration)
         */
        default Builder configuration(Consumer<StudioComponentConfiguration.Builder> configuration) {
            return configuration(StudioComponentConfiguration.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * The Unix epoch timestamp in seconds for when the resource was created.
         * </p>
         * 
         * @param createdAt
         *        The Unix epoch timestamp in seconds for when the resource was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The user ID of the user that created the studio component.
         * </p>
         * 
         * @param createdBy
         *        The user ID of the user that created the studio component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * A human-readable description for the studio component resource.
         * </p>
         * 
         * @param description
         *        A human-readable description for the studio component resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The EC2 security groups that control access to the studio component.
         * </p>
         * 
         * @param ec2SecurityGroupIds
         *        The EC2 security groups that control access to the studio component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2SecurityGroupIds(Collection<String> ec2SecurityGroupIds);

        /**
         * <p>
         * The EC2 security groups that control access to the studio component.
         * </p>
         * 
         * @param ec2SecurityGroupIds
         *        The EC2 security groups that control access to the studio component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2SecurityGroupIds(String... ec2SecurityGroupIds);

        /**
         * <p>
         * Initialization scripts for studio components.
         * </p>
         * 
         * @param initializationScripts
         *        Initialization scripts for studio components.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initializationScripts(Collection<StudioComponentInitializationScript> initializationScripts);

        /**
         * <p>
         * Initialization scripts for studio components.
         * </p>
         * 
         * @param initializationScripts
         *        Initialization scripts for studio components.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initializationScripts(StudioComponentInitializationScript... initializationScripts);

        /**
         * <p>
         * Initialization scripts for studio components.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <StudioComponentInitializationScript>.Builder} avoiding the need to create one manually via {@link List
         * <StudioComponentInitializationScript>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StudioComponentInitializationScript>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #initializationScripts(List<StudioComponentInitializationScript>)}.
         * 
         * @param initializationScripts
         *        a consumer that will call methods on {@link List<StudioComponentInitializationScript>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #initializationScripts(List<StudioComponentInitializationScript>)
         */
        Builder initializationScripts(Consumer<StudioComponentInitializationScript.Builder>... initializationScripts);

        /**
         * <p>
         * A friendly name for the studio component resource.
         * </p>
         * 
         * @param name
         *        A friendly name for the studio component resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Parameters for the studio component scripts.
         * </p>
         * 
         * @param scriptParameters
         *        Parameters for the studio component scripts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scriptParameters(Collection<ScriptParameterKeyValue> scriptParameters);

        /**
         * <p>
         * Parameters for the studio component scripts.
         * </p>
         * 
         * @param scriptParameters
         *        Parameters for the studio component scripts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scriptParameters(ScriptParameterKeyValue... scriptParameters);

        /**
         * <p>
         * Parameters for the studio component scripts.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ScriptParameterKeyValue>.Builder} avoiding
         * the need to create one manually via {@link List<ScriptParameterKeyValue>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ScriptParameterKeyValue>.Builder#build()} is called
         * immediately and its result is passed to {@link #scriptParameters(List<ScriptParameterKeyValue>)}.
         * 
         * @param scriptParameters
         *        a consumer that will call methods on {@link List<ScriptParameterKeyValue>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scriptParameters(List<ScriptParameterKeyValue>)
         */
        Builder scriptParameters(Consumer<ScriptParameterKeyValue.Builder>... scriptParameters);

        /**
         * <p>
         * The current state.
         * </p>
         * 
         * @param state
         *        The current state.
         * @see StudioComponentState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StudioComponentState
         */
        Builder state(String state);

        /**
         * <p>
         * The current state.
         * </p>
         * 
         * @param state
         *        The current state.
         * @see StudioComponentState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StudioComponentState
         */
        Builder state(StudioComponentState state);

        /**
         * <p>
         * The status code.
         * </p>
         * 
         * @param statusCodeValue
         *        The status code.
         * @see StudioComponentStatusCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StudioComponentStatusCode
         */
        Builder statusCode(String statusCodeValue);

        /**
         * <p>
         * The status code.
         * </p>
         * 
         * @param statusCodeValue
         *        The status code.
         * @see StudioComponentStatusCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StudioComponentStatusCode
         */
        Builder statusCode(StudioComponentStatusCode statusCodeValue);

        /**
         * <p>
         * The status message for the studio component.
         * </p>
         * 
         * @param statusMessage
         *        The status message for the studio component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The unique identifier for a studio component resource.
         * </p>
         * 
         * @param studioComponentId
         *        The unique identifier for a studio component resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder studioComponentId(String studioComponentId);

        /**
         * <p>
         * The specific subtype of a studio component.
         * </p>
         * 
         * @param subtype
         *        The specific subtype of a studio component.
         * @see StudioComponentSubtype
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StudioComponentSubtype
         */
        Builder subtype(String subtype);

        /**
         * <p>
         * The specific subtype of a studio component.
         * </p>
         * 
         * @param subtype
         *        The specific subtype of a studio component.
         * @see StudioComponentSubtype
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StudioComponentSubtype
         */
        Builder subtype(StudioComponentSubtype subtype);

        /**
         * <p>
         * A collection of labels, in the form of key:value pairs, that apply to this resource.
         * </p>
         * 
         * @param tags
         *        A collection of labels, in the form of key:value pairs, that apply to this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The type of the studio component.
         * </p>
         * 
         * @param type
         *        The type of the studio component.
         * @see StudioComponentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StudioComponentType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the studio component.
         * </p>
         * 
         * @param type
         *        The type of the studio component.
         * @see StudioComponentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StudioComponentType
         */
        Builder type(StudioComponentType type);

        /**
         * <p>
         * The Unix epoch timestamp in seconds for when the resource was updated.
         * </p>
         * 
         * @param updatedAt
         *        The Unix epoch timestamp in seconds for when the resource was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The user ID of the user that most recently updated the resource.
         * </p>
         * 
         * @param updatedBy
         *        The user ID of the user that most recently updated the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedBy(String updatedBy);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private StudioComponentConfiguration configuration;

        private Instant createdAt;

        private String createdBy;

        private String description;

        private List<String> ec2SecurityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private List<StudioComponentInitializationScript> initializationScripts = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private List<ScriptParameterKeyValue> scriptParameters = DefaultSdkAutoConstructList.getInstance();

        private String state;

        private String statusCodeValue;

        private String statusMessage;

        private String studioComponentId;

        private String subtype;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String type;

        private Instant updatedAt;

        private String updatedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(StudioComponent model) {
            arn(model.arn);
            configuration(model.configuration);
            createdAt(model.createdAt);
            createdBy(model.createdBy);
            description(model.description);
            ec2SecurityGroupIds(model.ec2SecurityGroupIds);
            initializationScripts(model.initializationScripts);
            name(model.name);
            scriptParameters(model.scriptParameters);
            state(model.state);
            statusCode(model.statusCodeValue);
            statusMessage(model.statusMessage);
            studioComponentId(model.studioComponentId);
            subtype(model.subtype);
            tags(model.tags);
            type(model.type);
            updatedAt(model.updatedAt);
            updatedBy(model.updatedBy);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final StudioComponentConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(StudioComponentConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        @Transient
        public final Builder configuration(StudioComponentConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        @Transient
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        @Transient
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getEc2SecurityGroupIds() {
            if (ec2SecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return ec2SecurityGroupIds;
        }

        public final void setEc2SecurityGroupIds(Collection<String> ec2SecurityGroupIds) {
            this.ec2SecurityGroupIds = StudioComponentSecurityGroupIdListCopier.copy(ec2SecurityGroupIds);
        }

        @Override
        @Transient
        public final Builder ec2SecurityGroupIds(Collection<String> ec2SecurityGroupIds) {
            this.ec2SecurityGroupIds = StudioComponentSecurityGroupIdListCopier.copy(ec2SecurityGroupIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder ec2SecurityGroupIds(String... ec2SecurityGroupIds) {
            ec2SecurityGroupIds(Arrays.asList(ec2SecurityGroupIds));
            return this;
        }

        public final List<StudioComponentInitializationScript.Builder> getInitializationScripts() {
            List<StudioComponentInitializationScript.Builder> result = StudioComponentInitializationScriptListCopier
                    .copyToBuilder(this.initializationScripts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInitializationScripts(
                Collection<StudioComponentInitializationScript.BuilderImpl> initializationScripts) {
            this.initializationScripts = StudioComponentInitializationScriptListCopier.copyFromBuilder(initializationScripts);
        }

        @Override
        @Transient
        public final Builder initializationScripts(Collection<StudioComponentInitializationScript> initializationScripts) {
            this.initializationScripts = StudioComponentInitializationScriptListCopier.copy(initializationScripts);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder initializationScripts(StudioComponentInitializationScript... initializationScripts) {
            initializationScripts(Arrays.asList(initializationScripts));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder initializationScripts(Consumer<StudioComponentInitializationScript.Builder>... initializationScripts) {
            initializationScripts(Stream.of(initializationScripts)
                    .map(c -> StudioComponentInitializationScript.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<ScriptParameterKeyValue.Builder> getScriptParameters() {
            List<ScriptParameterKeyValue.Builder> result = StudioComponentScriptParameterKeyValueListCopier
                    .copyToBuilder(this.scriptParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScriptParameters(Collection<ScriptParameterKeyValue.BuilderImpl> scriptParameters) {
            this.scriptParameters = StudioComponentScriptParameterKeyValueListCopier.copyFromBuilder(scriptParameters);
        }

        @Override
        @Transient
        public final Builder scriptParameters(Collection<ScriptParameterKeyValue> scriptParameters) {
            this.scriptParameters = StudioComponentScriptParameterKeyValueListCopier.copy(scriptParameters);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder scriptParameters(ScriptParameterKeyValue... scriptParameters) {
            scriptParameters(Arrays.asList(scriptParameters));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder scriptParameters(Consumer<ScriptParameterKeyValue.Builder>... scriptParameters) {
            scriptParameters(Stream.of(scriptParameters).map(c -> ScriptParameterKeyValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        @Transient
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        @Transient
        public final Builder state(StudioComponentState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStatusCode() {
            return statusCodeValue;
        }

        public final void setStatusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
        }

        @Override
        @Transient
        public final Builder statusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
            return this;
        }

        @Override
        @Transient
        public final Builder statusCode(StudioComponentStatusCode statusCodeValue) {
            this.statusCode(statusCodeValue == null ? null : statusCodeValue.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        @Transient
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getStudioComponentId() {
            return studioComponentId;
        }

        public final void setStudioComponentId(String studioComponentId) {
            this.studioComponentId = studioComponentId;
        }

        @Override
        @Transient
        public final Builder studioComponentId(String studioComponentId) {
            this.studioComponentId = studioComponentId;
            return this;
        }

        public final String getSubtype() {
            return subtype;
        }

        public final void setSubtype(String subtype) {
            this.subtype = subtype;
        }

        @Override
        @Transient
        public final Builder subtype(String subtype) {
            this.subtype = subtype;
            return this;
        }

        @Override
        @Transient
        public final Builder subtype(StudioComponentSubtype subtype) {
            this.subtype(subtype == null ? null : subtype.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(StudioComponentType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        @Transient
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getUpdatedBy() {
            return updatedBy;
        }

        public final void setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
        }

        @Override
        @Transient
        public final Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        @Override
        public StudioComponent build() {
            return new StudioComponent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
