/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.nimble.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * <p>
 * The current state of the studio component resource.
 * </p>
 * <p>
 * While a studio component is being created, modified, or deleted, its state will equal "CREATE_IN_PROGRESS",
 * "UPDATE_IN_PROGRESS", or "DELETE_IN_PROGRESS"
 * </p>
 * <p>
 * These are called 'transition states'.
 * </p>
 * <p>
 * No modifications may be made to the studio component while it is in a transition state.
 * </p>
 * <p>
 * If creation of the resource fails, the state will change to `CREATE_FAILED`. The resource StatusCode and
 * StatusMessage will provide more information of why creation failed. The resource in this state will automatically be
 * deleted from your account after a period of time.
 * </p>
 * <p>
 * If updating the resource fails, the state will change to `UPDATE_FAILED`. The resource StatusCode and StatusMessage
 * will provide more information of why the update failed. The resource will be returned to the state it was in when the
 * update request was invoked.
 * </p>
 * <p>
 * If deleting the resource fails, the state will change to `DELETE_FAILED`. The resource StatusCode and StatusMessage
 * will provide more information of why the update failed. The resource will be returned to the state it was in when the
 * update request was invoked. After the resource is deleted successfully, it will change to the "DELETED" state. The
 * resource will no longer count against service quotas and cannot be used or acted upon any futher. It will be removed
 * from your account after a period of time.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public enum StudioComponentState {
    CREATE_IN_PROGRESS("CREATE_IN_PROGRESS"),

    READY("READY"),

    UPDATE_IN_PROGRESS("UPDATE_IN_PROGRESS"),

    DELETE_IN_PROGRESS("DELETE_IN_PROGRESS"),

    DELETED("DELETED"),

    DELETE_FAILED("DELETE_FAILED"),

    CREATE_FAILED("CREATE_FAILED"),

    UPDATE_FAILED("UPDATE_FAILED"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StudioComponentState> VALUE_MAP = EnumUtils.uniqueIndex(StudioComponentState.class,
            StudioComponentState::toString);

    private final String value;

    private StudioComponentState(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return StudioComponentState corresponding to the value
     */
    public static StudioComponentState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link StudioComponentState}s
     */
    public static Set<StudioComponentState> knownValues() {
        Set<StudioComponentState> knownValues = EnumSet.allOf(StudioComponentState.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
