/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.nimble.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StudioMembership implements SdkPojo, Serializable,
        ToCopyableBuilder<StudioMembership.Builder, StudioMembership> {
    private static final SdkField<String> IDENTITY_STORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identityStoreId").getter(getter(StudioMembership::identityStoreId))
            .setter(setter(Builder::identityStoreId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identityStoreId").build()).build();

    private static final SdkField<String> PERSONA_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("persona")
            .getter(getter(StudioMembership::personaAsString)).setter(setter(Builder::persona))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("persona").build()).build();

    private static final SdkField<String> PRINCIPAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("principalId").getter(getter(StudioMembership::principalId)).setter(setter(Builder::principalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principalId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_STORE_ID_FIELD,
            PERSONA_FIELD, PRINCIPAL_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String identityStoreId;

    private final String persona;

    private final String principalId;

    private StudioMembership(BuilderImpl builder) {
        this.identityStoreId = builder.identityStoreId;
        this.persona = builder.persona;
        this.principalId = builder.principalId;
    }

    /**
     * <p>
     * The ID of the identity store.
     * </p>
     * 
     * @return The ID of the identity store.
     */
    public final String identityStoreId() {
        return identityStoreId;
    }

    /**
     * <p>
     * The persona.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #persona} will
     * return {@link StudioPersona#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #personaAsString}.
     * </p>
     * 
     * @return The persona.
     * @see StudioPersona
     */
    public final StudioPersona persona() {
        return StudioPersona.fromValue(persona);
    }

    /**
     * <p>
     * The persona.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #persona} will
     * return {@link StudioPersona#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #personaAsString}.
     * </p>
     * 
     * @return The persona.
     * @see StudioPersona
     */
    public final String personaAsString() {
        return persona;
    }

    /**
     * <p>
     * The principal ID.
     * </p>
     * 
     * @return The principal ID.
     */
    public final String principalId() {
        return principalId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(identityStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(personaAsString());
        hashCode = 31 * hashCode + Objects.hashCode(principalId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StudioMembership)) {
            return false;
        }
        StudioMembership other = (StudioMembership) obj;
        return Objects.equals(identityStoreId(), other.identityStoreId())
                && Objects.equals(personaAsString(), other.personaAsString())
                && Objects.equals(principalId(), other.principalId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StudioMembership").add("IdentityStoreId", identityStoreId()).add("Persona", personaAsString())
                .add("PrincipalId", principalId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "identityStoreId":
            return Optional.ofNullable(clazz.cast(identityStoreId()));
        case "persona":
            return Optional.ofNullable(clazz.cast(personaAsString()));
        case "principalId":
            return Optional.ofNullable(clazz.cast(principalId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StudioMembership, T> g) {
        return obj -> g.apply((StudioMembership) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StudioMembership> {
        /**
         * <p>
         * The ID of the identity store.
         * </p>
         * 
         * @param identityStoreId
         *        The ID of the identity store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityStoreId(String identityStoreId);

        /**
         * <p>
         * The persona.
         * </p>
         * 
         * @param persona
         *        The persona.
         * @see StudioPersona
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StudioPersona
         */
        Builder persona(String persona);

        /**
         * <p>
         * The persona.
         * </p>
         * 
         * @param persona
         *        The persona.
         * @see StudioPersona
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StudioPersona
         */
        Builder persona(StudioPersona persona);

        /**
         * <p>
         * The principal ID.
         * </p>
         * 
         * @param principalId
         *        The principal ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalId(String principalId);
    }

    static final class BuilderImpl implements Builder {
        private String identityStoreId;

        private String persona;

        private String principalId;

        private BuilderImpl() {
        }

        private BuilderImpl(StudioMembership model) {
            identityStoreId(model.identityStoreId);
            persona(model.persona);
            principalId(model.principalId);
        }

        public final String getIdentityStoreId() {
            return identityStoreId;
        }

        public final void setIdentityStoreId(String identityStoreId) {
            this.identityStoreId = identityStoreId;
        }

        @Override
        @Transient
        public final Builder identityStoreId(String identityStoreId) {
            this.identityStoreId = identityStoreId;
            return this;
        }

        public final String getPersona() {
            return persona;
        }

        public final void setPersona(String persona) {
            this.persona = persona;
        }

        @Override
        @Transient
        public final Builder persona(String persona) {
            this.persona = persona;
            return this;
        }

        @Override
        @Transient
        public final Builder persona(StudioPersona persona) {
            this.persona(persona == null ? null : persona.toString());
            return this;
        }

        public final String getPrincipalId() {
            return principalId;
        }

        public final void setPrincipalId(String principalId) {
            this.principalId = principalId;
        }

        @Override
        @Transient
        public final Builder principalId(String principalId) {
            this.principalId = principalId;
            return this;
        }

        @Override
        public StudioMembership build() {
            return new StudioMembership(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
