/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.nimble.model.NimbleResponse;
import software.amazon.awssdk.services.nimble.model.StudioComponent;
import software.amazon.awssdk.services.nimble.model.StudioComponentListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListStudioComponentsResponse
extends NimbleResponse
implements ToCopyableBuilder<Builder, ListStudioComponentsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListStudioComponentsResponse.getter(ListStudioComponentsResponse::nextToken)).setter(ListStudioComponentsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<StudioComponent>> STUDIO_COMPONENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("studioComponents").getter(ListStudioComponentsResponse.getter(ListStudioComponentsResponse::studioComponents)).setter(ListStudioComponentsResponse.setter(Builder::studioComponents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("studioComponents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StudioComponent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, STUDIO_COMPONENTS_FIELD));
    private final String nextToken;
    private final List<StudioComponent> studioComponents;

    private ListStudioComponentsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.studioComponents = builder.studioComponents;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasStudioComponents() {
        return this.studioComponents != null && !(this.studioComponents instanceof SdkAutoConstructList);
    }

    public final List<StudioComponent> studioComponents() {
        return this.studioComponents;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStudioComponents() ? this.studioComponents() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStudioComponentsResponse)) {
            return false;
        }
        ListStudioComponentsResponse other = (ListStudioComponentsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasStudioComponents() == other.hasStudioComponents() && Objects.equals(this.studioComponents(), other.studioComponents());
    }

    public final String toString() {
        return ToString.builder((String)"ListStudioComponentsResponse").add("NextToken", (Object)this.nextToken()).add("StudioComponents", this.hasStudioComponents() ? this.studioComponents() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "studioComponents": {
                return Optional.ofNullable(clazz.cast(this.studioComponents()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListStudioComponentsResponse, T> g) {
        return obj -> g.apply((ListStudioComponentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NimbleResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<StudioComponent> studioComponents = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListStudioComponentsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.studioComponents(model.studioComponents);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<StudioComponent.Builder> getStudioComponents() {
            List<StudioComponent.Builder> result = StudioComponentListCopier.copyToBuilder(this.studioComponents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStudioComponents(Collection<StudioComponent.BuilderImpl> studioComponents) {
            this.studioComponents = StudioComponentListCopier.copyFromBuilder(studioComponents);
        }

        @Override
        @Transient
        public final Builder studioComponents(Collection<StudioComponent> studioComponents) {
            this.studioComponents = StudioComponentListCopier.copy(studioComponents);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder studioComponents(StudioComponent ... studioComponents) {
            this.studioComponents(Arrays.asList(studioComponents));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder studioComponents(Consumer<StudioComponent.Builder> ... studioComponents) {
            this.studioComponents(Stream.of(studioComponents).map(c -> (StudioComponent)((StudioComponent.Builder)StudioComponent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListStudioComponentsResponse build() {
            return new ListStudioComponentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NimbleResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListStudioComponentsResponse> {
        public Builder nextToken(String var1);

        public Builder studioComponents(Collection<StudioComponent> var1);

        public Builder studioComponents(StudioComponent ... var1);

        public Builder studioComponents(Consumer<StudioComponent.Builder> ... var1);
    }
}

