/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.nimble.model.LaunchProfileProtocolVersionListCopier;
import software.amazon.awssdk.services.nimble.model.LaunchProfileStudioComponentIdListCopier;
import software.amazon.awssdk.services.nimble.model.NimbleRequest;
import software.amazon.awssdk.services.nimble.model.StreamConfigurationCreate;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateLaunchProfileRequest
extends NimbleRequest
implements ToCopyableBuilder<Builder, UpdateLaunchProfileRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateLaunchProfileRequest.getter(UpdateLaunchProfileRequest::clientToken)).setter(UpdateLaunchProfileRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Client-Token").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateLaunchProfileRequest.getter(UpdateLaunchProfileRequest::description)).setter(UpdateLaunchProfileRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> LAUNCH_PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("launchProfileId").getter(UpdateLaunchProfileRequest.getter(UpdateLaunchProfileRequest::launchProfileId)).setter(UpdateLaunchProfileRequest.setter(Builder::launchProfileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("launchProfileId").build()}).build();
    private static final SdkField<List<String>> LAUNCH_PROFILE_PROTOCOL_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("launchProfileProtocolVersions").getter(UpdateLaunchProfileRequest.getter(UpdateLaunchProfileRequest::launchProfileProtocolVersions)).setter(UpdateLaunchProfileRequest.setter(Builder::launchProfileProtocolVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchProfileProtocolVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateLaunchProfileRequest.getter(UpdateLaunchProfileRequest::name)).setter(UpdateLaunchProfileRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<StreamConfigurationCreate> STREAM_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("streamConfiguration").getter(UpdateLaunchProfileRequest.getter(UpdateLaunchProfileRequest::streamConfiguration)).setter(UpdateLaunchProfileRequest.setter(Builder::streamConfiguration)).constructor(StreamConfigurationCreate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamConfiguration").build()}).build();
    private static final SdkField<List<String>> STUDIO_COMPONENT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("studioComponentIds").getter(UpdateLaunchProfileRequest.getter(UpdateLaunchProfileRequest::studioComponentIds)).setter(UpdateLaunchProfileRequest.setter(Builder::studioComponentIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("studioComponentIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STUDIO_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("studioId").getter(UpdateLaunchProfileRequest.getter(UpdateLaunchProfileRequest::studioId)).setter(UpdateLaunchProfileRequest.setter(Builder::studioId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("studioId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, DESCRIPTION_FIELD, LAUNCH_PROFILE_ID_FIELD, LAUNCH_PROFILE_PROTOCOL_VERSIONS_FIELD, NAME_FIELD, STREAM_CONFIGURATION_FIELD, STUDIO_COMPONENT_IDS_FIELD, STUDIO_ID_FIELD));
    private final String clientToken;
    private final String description;
    private final String launchProfileId;
    private final List<String> launchProfileProtocolVersions;
    private final String name;
    private final StreamConfigurationCreate streamConfiguration;
    private final List<String> studioComponentIds;
    private final String studioId;

    private UpdateLaunchProfileRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.launchProfileId = builder.launchProfileId;
        this.launchProfileProtocolVersions = builder.launchProfileProtocolVersions;
        this.name = builder.name;
        this.streamConfiguration = builder.streamConfiguration;
        this.studioComponentIds = builder.studioComponentIds;
        this.studioId = builder.studioId;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String description() {
        return this.description;
    }

    public final String launchProfileId() {
        return this.launchProfileId;
    }

    public final boolean hasLaunchProfileProtocolVersions() {
        return this.launchProfileProtocolVersions != null && !(this.launchProfileProtocolVersions instanceof SdkAutoConstructList);
    }

    public final List<String> launchProfileProtocolVersions() {
        return this.launchProfileProtocolVersions;
    }

    public final String name() {
        return this.name;
    }

    public final StreamConfigurationCreate streamConfiguration() {
        return this.streamConfiguration;
    }

    public final boolean hasStudioComponentIds() {
        return this.studioComponentIds != null && !(this.studioComponentIds instanceof SdkAutoConstructList);
    }

    public final List<String> studioComponentIds() {
        return this.studioComponentIds;
    }

    public final String studioId() {
        return this.studioId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLaunchProfileProtocolVersions() ? this.launchProfileProtocolVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStudioComponentIds() ? this.studioComponentIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.studioId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLaunchProfileRequest)) {
            return false;
        }
        UpdateLaunchProfileRequest other = (UpdateLaunchProfileRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.launchProfileId(), other.launchProfileId()) && this.hasLaunchProfileProtocolVersions() == other.hasLaunchProfileProtocolVersions() && Objects.equals(this.launchProfileProtocolVersions(), other.launchProfileProtocolVersions()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.streamConfiguration(), other.streamConfiguration()) && this.hasStudioComponentIds() == other.hasStudioComponentIds() && Objects.equals(this.studioComponentIds(), other.studioComponentIds()) && Objects.equals(this.studioId(), other.studioId());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateLaunchProfileRequest").add("ClientToken", (Object)this.clientToken()).add("Description", (Object)this.description()).add("LaunchProfileId", (Object)this.launchProfileId()).add("LaunchProfileProtocolVersions", this.hasLaunchProfileProtocolVersions() ? this.launchProfileProtocolVersions() : null).add("Name", (Object)this.name()).add("StreamConfiguration", (Object)this.streamConfiguration()).add("StudioComponentIds", this.hasStudioComponentIds() ? this.studioComponentIds() : null).add("StudioId", (Object)this.studioId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "launchProfileId": {
                return Optional.ofNullable(clazz.cast(this.launchProfileId()));
            }
            case "launchProfileProtocolVersions": {
                return Optional.ofNullable(clazz.cast(this.launchProfileProtocolVersions()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "streamConfiguration": {
                return Optional.ofNullable(clazz.cast(this.streamConfiguration()));
            }
            case "studioComponentIds": {
                return Optional.ofNullable(clazz.cast(this.studioComponentIds()));
            }
            case "studioId": {
                return Optional.ofNullable(clazz.cast(this.studioId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateLaunchProfileRequest, T> g) {
        return obj -> g.apply((UpdateLaunchProfileRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NimbleRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String description;
        private String launchProfileId;
        private List<String> launchProfileProtocolVersions = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private StreamConfigurationCreate streamConfiguration;
        private List<String> studioComponentIds = DefaultSdkAutoConstructList.getInstance();
        private String studioId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLaunchProfileRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.description(model.description);
            this.launchProfileId(model.launchProfileId);
            this.launchProfileProtocolVersions(model.launchProfileProtocolVersions);
            this.name(model.name);
            this.streamConfiguration(model.streamConfiguration);
            this.studioComponentIds(model.studioComponentIds);
            this.studioId(model.studioId);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getLaunchProfileId() {
            return this.launchProfileId;
        }

        public final void setLaunchProfileId(String launchProfileId) {
            this.launchProfileId = launchProfileId;
        }

        @Override
        @Transient
        public final Builder launchProfileId(String launchProfileId) {
            this.launchProfileId = launchProfileId;
            return this;
        }

        public final Collection<String> getLaunchProfileProtocolVersions() {
            if (this.launchProfileProtocolVersions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.launchProfileProtocolVersions;
        }

        public final void setLaunchProfileProtocolVersions(Collection<String> launchProfileProtocolVersions) {
            this.launchProfileProtocolVersions = LaunchProfileProtocolVersionListCopier.copy(launchProfileProtocolVersions);
        }

        @Override
        @Transient
        public final Builder launchProfileProtocolVersions(Collection<String> launchProfileProtocolVersions) {
            this.launchProfileProtocolVersions = LaunchProfileProtocolVersionListCopier.copy(launchProfileProtocolVersions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder launchProfileProtocolVersions(String ... launchProfileProtocolVersions) {
            this.launchProfileProtocolVersions(Arrays.asList(launchProfileProtocolVersions));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final StreamConfigurationCreate.Builder getStreamConfiguration() {
            return this.streamConfiguration != null ? this.streamConfiguration.toBuilder() : null;
        }

        public final void setStreamConfiguration(StreamConfigurationCreate.BuilderImpl streamConfiguration) {
            this.streamConfiguration = streamConfiguration != null ? streamConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder streamConfiguration(StreamConfigurationCreate streamConfiguration) {
            this.streamConfiguration = streamConfiguration;
            return this;
        }

        public final Collection<String> getStudioComponentIds() {
            if (this.studioComponentIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.studioComponentIds;
        }

        public final void setStudioComponentIds(Collection<String> studioComponentIds) {
            this.studioComponentIds = LaunchProfileStudioComponentIdListCopier.copy(studioComponentIds);
        }

        @Override
        @Transient
        public final Builder studioComponentIds(Collection<String> studioComponentIds) {
            this.studioComponentIds = LaunchProfileStudioComponentIdListCopier.copy(studioComponentIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder studioComponentIds(String ... studioComponentIds) {
            this.studioComponentIds(Arrays.asList(studioComponentIds));
            return this;
        }

        public final String getStudioId() {
            return this.studioId;
        }

        public final void setStudioId(String studioId) {
            this.studioId = studioId;
        }

        @Override
        @Transient
        public final Builder studioId(String studioId) {
            this.studioId = studioId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateLaunchProfileRequest build() {
            return new UpdateLaunchProfileRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NimbleRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateLaunchProfileRequest> {
        public Builder clientToken(String var1);

        public Builder description(String var1);

        public Builder launchProfileId(String var1);

        public Builder launchProfileProtocolVersions(Collection<String> var1);

        public Builder launchProfileProtocolVersions(String ... var1);

        public Builder name(String var1);

        public Builder streamConfiguration(StreamConfigurationCreate var1);

        default public Builder streamConfiguration(Consumer<StreamConfigurationCreate.Builder> streamConfiguration) {
            return this.streamConfiguration((StreamConfigurationCreate)((StreamConfigurationCreate.Builder)StreamConfigurationCreate.builder().applyMutation(streamConfiguration)).build());
        }

        public Builder studioComponentIds(Collection<String> var1);

        public Builder studioComponentIds(String ... var1);

        public Builder studioId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

