/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.nimble.NimbleClient;
import software.amazon.awssdk.services.nimble.model.LaunchProfileMembership;
import software.amazon.awssdk.services.nimble.model.ListLaunchProfileMembersRequest;
import software.amazon.awssdk.services.nimble.model.ListLaunchProfileMembersResponse;

public class ListLaunchProfileMembersIterable
implements SdkIterable<ListLaunchProfileMembersResponse> {
    private final NimbleClient client;
    private final ListLaunchProfileMembersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListLaunchProfileMembersIterable(NimbleClient client, ListLaunchProfileMembersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListLaunchProfileMembersResponseFetcher();
    }

    public Iterator<ListLaunchProfileMembersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<LaunchProfileMembership> members() {
        Function<ListLaunchProfileMembersResponse, Iterator> getIterator = response -> {
            if (response != null && response.members() != null) {
                return response.members().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListLaunchProfileMembersResponseFetcher
    implements SyncPageFetcher<ListLaunchProfileMembersResponse> {
        private ListLaunchProfileMembersResponseFetcher() {
        }

        public boolean hasNextPage(ListLaunchProfileMembersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListLaunchProfileMembersResponse nextPage(ListLaunchProfileMembersResponse previousPage) {
            if (previousPage == null) {
                return ListLaunchProfileMembersIterable.this.client.listLaunchProfileMembers(ListLaunchProfileMembersIterable.this.firstRequest);
            }
            return ListLaunchProfileMembersIterable.this.client.listLaunchProfileMembers((ListLaunchProfileMembersRequest)((Object)ListLaunchProfileMembersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

