/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.nimble.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <zonbook></zonbook><xhtml></xhtml>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLaunchProfileRequest extends NimbleRequest implements
        ToCopyableBuilder<CreateLaunchProfileRequest.Builder, CreateLaunchProfileRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateLaunchProfileRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Client-Token").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateLaunchProfileRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<String>> EC2_SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ec2SubnetIds")
            .getter(getter(CreateLaunchProfileRequest::ec2SubnetIds))
            .setter(setter(Builder::ec2SubnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2SubnetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> LAUNCH_PROFILE_PROTOCOL_VERSIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("launchProfileProtocolVersions")
            .getter(getter(CreateLaunchProfileRequest::launchProfileProtocolVersions))
            .setter(setter(Builder::launchProfileProtocolVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchProfileProtocolVersions")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateLaunchProfileRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<StreamConfigurationCreate> STREAM_CONFIGURATION_FIELD = SdkField
            .<StreamConfigurationCreate> builder(MarshallingType.SDK_POJO).memberName("streamConfiguration")
            .getter(getter(CreateLaunchProfileRequest::streamConfiguration)).setter(setter(Builder::streamConfiguration))
            .constructor(StreamConfigurationCreate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamConfiguration").build())
            .build();

    private static final SdkField<List<String>> STUDIO_COMPONENT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("studioComponentIds")
            .getter(getter(CreateLaunchProfileRequest::studioComponentIds))
            .setter(setter(Builder::studioComponentIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("studioComponentIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STUDIO_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("studioId").getter(getter(CreateLaunchProfileRequest::studioId)).setter(setter(Builder::studioId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("studioId").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateLaunchProfileRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            DESCRIPTION_FIELD, EC2_SUBNET_IDS_FIELD, LAUNCH_PROFILE_PROTOCOL_VERSIONS_FIELD, NAME_FIELD,
            STREAM_CONFIGURATION_FIELD, STUDIO_COMPONENT_IDS_FIELD, STUDIO_ID_FIELD, TAGS_FIELD));

    private final String clientToken;

    private final String description;

    private final List<String> ec2SubnetIds;

    private final List<String> launchProfileProtocolVersions;

    private final String name;

    private final StreamConfigurationCreate streamConfiguration;

    private final List<String> studioComponentIds;

    private final String studioId;

    private final Map<String, String> tags;

    private CreateLaunchProfileRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.ec2SubnetIds = builder.ec2SubnetIds;
        this.launchProfileProtocolVersions = builder.launchProfileProtocolVersions;
        this.name = builder.name;
        this.streamConfiguration = builder.streamConfiguration;
        this.studioComponentIds = builder.studioComponentIds;
        this.studioId = builder.studioId;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify
     * a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure
     * idempotency.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t
     *         specify a client token, the AWS SDK automatically generates a client token and uses it for the request to
     *         ensure idempotency.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The description.
     * </p>
     * 
     * @return The description.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Ec2SubnetIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEc2SubnetIds() {
        return ec2SubnetIds != null && !(ec2SubnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the IDs of the EC2 subnets where streaming sessions will be accessible from. These subnets must support
     * the specified instance types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEc2SubnetIds} method.
     * </p>
     * 
     * @return Specifies the IDs of the EC2 subnets where streaming sessions will be accessible from. These subnets must
     *         support the specified instance types.
     */
    public final List<String> ec2SubnetIds() {
        return ec2SubnetIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the LaunchProfileProtocolVersions property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasLaunchProfileProtocolVersions() {
        return launchProfileProtocolVersions != null && !(launchProfileProtocolVersions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The version number of the protocol that is used by the launch profile. The only valid version is "2021-03-31".
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLaunchProfileProtocolVersions} method.
     * </p>
     * 
     * @return The version number of the protocol that is used by the launch profile. The only valid version is
     *         "2021-03-31".
     */
    public final List<String> launchProfileProtocolVersions() {
        return launchProfileProtocolVersions;
    }

    /**
     * <p>
     * The name for the launch profile.
     * </p>
     * 
     * @return The name for the launch profile.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A configuration for a streaming session.
     * </p>
     * 
     * @return A configuration for a streaming session.
     */
    public final StreamConfigurationCreate streamConfiguration() {
        return streamConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the StudioComponentIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStudioComponentIds() {
        return studioComponentIds != null && !(studioComponentIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Unique identifiers for a collection of studio components that can be used with this launch profile.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStudioComponentIds} method.
     * </p>
     * 
     * @return Unique identifiers for a collection of studio components that can be used with this launch profile.
     */
    public final List<String> studioComponentIds() {
        return studioComponentIds;
    }

    /**
     * <p>
     * The studio ID.
     * </p>
     * 
     * @return The studio ID.
     */
    public final String studioId() {
        return studioId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A collection of labels, in the form of key:value pairs, that apply to this resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A collection of labels, in the form of key:value pairs, that apply to this resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasEc2SubnetIds() ? ec2SubnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLaunchProfileProtocolVersions() ? launchProfileProtocolVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(streamConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasStudioComponentIds() ? studioComponentIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(studioId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLaunchProfileRequest)) {
            return false;
        }
        CreateLaunchProfileRequest other = (CreateLaunchProfileRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(description(), other.description())
                && hasEc2SubnetIds() == other.hasEc2SubnetIds() && Objects.equals(ec2SubnetIds(), other.ec2SubnetIds())
                && hasLaunchProfileProtocolVersions() == other.hasLaunchProfileProtocolVersions()
                && Objects.equals(launchProfileProtocolVersions(), other.launchProfileProtocolVersions())
                && Objects.equals(name(), other.name()) && Objects.equals(streamConfiguration(), other.streamConfiguration())
                && hasStudioComponentIds() == other.hasStudioComponentIds()
                && Objects.equals(studioComponentIds(), other.studioComponentIds())
                && Objects.equals(studioId(), other.studioId()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("CreateLaunchProfileRequest")
                .add("ClientToken", clientToken())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Ec2SubnetIds", hasEc2SubnetIds() ? ec2SubnetIds() : null)
                .add("LaunchProfileProtocolVersions", hasLaunchProfileProtocolVersions() ? launchProfileProtocolVersions() : null)
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("StreamConfiguration", streamConfiguration())
                .add("StudioComponentIds", hasStudioComponentIds() ? studioComponentIds() : null).add("StudioId", studioId())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ec2SubnetIds":
            return Optional.ofNullable(clazz.cast(ec2SubnetIds()));
        case "launchProfileProtocolVersions":
            return Optional.ofNullable(clazz.cast(launchProfileProtocolVersions()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "streamConfiguration":
            return Optional.ofNullable(clazz.cast(streamConfiguration()));
        case "studioComponentIds":
            return Optional.ofNullable(clazz.cast(studioComponentIds()));
        case "studioId":
            return Optional.ofNullable(clazz.cast(studioId()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLaunchProfileRequest, T> g) {
        return obj -> g.apply((CreateLaunchProfileRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NimbleRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateLaunchProfileRequest> {
        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t
         * specify a client token, the AWS SDK automatically generates a client token and uses it for the request to
         * ensure idempotency.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you
         *        don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the
         *        request to ensure idempotency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The description.
         * </p>
         * 
         * @param description
         *        The description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Specifies the IDs of the EC2 subnets where streaming sessions will be accessible from. These subnets must
         * support the specified instance types.
         * </p>
         * 
         * @param ec2SubnetIds
         *        Specifies the IDs of the EC2 subnets where streaming sessions will be accessible from. These subnets
         *        must support the specified instance types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2SubnetIds(Collection<String> ec2SubnetIds);

        /**
         * <p>
         * Specifies the IDs of the EC2 subnets where streaming sessions will be accessible from. These subnets must
         * support the specified instance types.
         * </p>
         * 
         * @param ec2SubnetIds
         *        Specifies the IDs of the EC2 subnets where streaming sessions will be accessible from. These subnets
         *        must support the specified instance types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2SubnetIds(String... ec2SubnetIds);

        /**
         * <p>
         * The version number of the protocol that is used by the launch profile. The only valid version is
         * "2021-03-31".
         * </p>
         * 
         * @param launchProfileProtocolVersions
         *        The version number of the protocol that is used by the launch profile. The only valid version is
         *        "2021-03-31".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchProfileProtocolVersions(Collection<String> launchProfileProtocolVersions);

        /**
         * <p>
         * The version number of the protocol that is used by the launch profile. The only valid version is
         * "2021-03-31".
         * </p>
         * 
         * @param launchProfileProtocolVersions
         *        The version number of the protocol that is used by the launch profile. The only valid version is
         *        "2021-03-31".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchProfileProtocolVersions(String... launchProfileProtocolVersions);

        /**
         * <p>
         * The name for the launch profile.
         * </p>
         * 
         * @param name
         *        The name for the launch profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A configuration for a streaming session.
         * </p>
         * 
         * @param streamConfiguration
         *        A configuration for a streaming session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamConfiguration(StreamConfigurationCreate streamConfiguration);

        /**
         * <p>
         * A configuration for a streaming session.
         * </p>
         * This is a convenience that creates an instance of the {@link StreamConfigurationCreate.Builder} avoiding the
         * need to create one manually via {@link StreamConfigurationCreate#builder()}.
         *
         * When the {@link Consumer} completes, {@link StreamConfigurationCreate.Builder#build()} is called immediately
         * and its result is passed to {@link #streamConfiguration(StreamConfigurationCreate)}.
         * 
         * @param streamConfiguration
         *        a consumer that will call methods on {@link StreamConfigurationCreate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streamConfiguration(StreamConfigurationCreate)
         */
        default Builder streamConfiguration(Consumer<StreamConfigurationCreate.Builder> streamConfiguration) {
            return streamConfiguration(StreamConfigurationCreate.builder().applyMutation(streamConfiguration).build());
        }

        /**
         * <p>
         * Unique identifiers for a collection of studio components that can be used with this launch profile.
         * </p>
         * 
         * @param studioComponentIds
         *        Unique identifiers for a collection of studio components that can be used with this launch profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder studioComponentIds(Collection<String> studioComponentIds);

        /**
         * <p>
         * Unique identifiers for a collection of studio components that can be used with this launch profile.
         * </p>
         * 
         * @param studioComponentIds
         *        Unique identifiers for a collection of studio components that can be used with this launch profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder studioComponentIds(String... studioComponentIds);

        /**
         * <p>
         * The studio ID.
         * </p>
         * 
         * @param studioId
         *        The studio ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder studioId(String studioId);

        /**
         * <p>
         * A collection of labels, in the form of key:value pairs, that apply to this resource.
         * </p>
         * 
         * @param tags
         *        A collection of labels, in the form of key:value pairs, that apply to this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NimbleRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String description;

        private List<String> ec2SubnetIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> launchProfileProtocolVersions = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private StreamConfigurationCreate streamConfiguration;

        private List<String> studioComponentIds = DefaultSdkAutoConstructList.getInstance();

        private String studioId;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLaunchProfileRequest model) {
            super(model);
            clientToken(model.clientToken);
            description(model.description);
            ec2SubnetIds(model.ec2SubnetIds);
            launchProfileProtocolVersions(model.launchProfileProtocolVersions);
            name(model.name);
            streamConfiguration(model.streamConfiguration);
            studioComponentIds(model.studioComponentIds);
            studioId(model.studioId);
            tags(model.tags);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getEc2SubnetIds() {
            if (ec2SubnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return ec2SubnetIds;
        }

        public final void setEc2SubnetIds(Collection<String> ec2SubnetIds) {
            this.ec2SubnetIds = EC2SubnetIdListCopier.copy(ec2SubnetIds);
        }

        @Override
        @Transient
        public final Builder ec2SubnetIds(Collection<String> ec2SubnetIds) {
            this.ec2SubnetIds = EC2SubnetIdListCopier.copy(ec2SubnetIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder ec2SubnetIds(String... ec2SubnetIds) {
            ec2SubnetIds(Arrays.asList(ec2SubnetIds));
            return this;
        }

        public final Collection<String> getLaunchProfileProtocolVersions() {
            if (launchProfileProtocolVersions instanceof SdkAutoConstructList) {
                return null;
            }
            return launchProfileProtocolVersions;
        }

        public final void setLaunchProfileProtocolVersions(Collection<String> launchProfileProtocolVersions) {
            this.launchProfileProtocolVersions = LaunchProfileProtocolVersionListCopier.copy(launchProfileProtocolVersions);
        }

        @Override
        @Transient
        public final Builder launchProfileProtocolVersions(Collection<String> launchProfileProtocolVersions) {
            this.launchProfileProtocolVersions = LaunchProfileProtocolVersionListCopier.copy(launchProfileProtocolVersions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder launchProfileProtocolVersions(String... launchProfileProtocolVersions) {
            launchProfileProtocolVersions(Arrays.asList(launchProfileProtocolVersions));
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final StreamConfigurationCreate.Builder getStreamConfiguration() {
            return streamConfiguration != null ? streamConfiguration.toBuilder() : null;
        }

        public final void setStreamConfiguration(StreamConfigurationCreate.BuilderImpl streamConfiguration) {
            this.streamConfiguration = streamConfiguration != null ? streamConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder streamConfiguration(StreamConfigurationCreate streamConfiguration) {
            this.streamConfiguration = streamConfiguration;
            return this;
        }

        public final Collection<String> getStudioComponentIds() {
            if (studioComponentIds instanceof SdkAutoConstructList) {
                return null;
            }
            return studioComponentIds;
        }

        public final void setStudioComponentIds(Collection<String> studioComponentIds) {
            this.studioComponentIds = LaunchProfileStudioComponentIdListCopier.copy(studioComponentIds);
        }

        @Override
        @Transient
        public final Builder studioComponentIds(Collection<String> studioComponentIds) {
            this.studioComponentIds = LaunchProfileStudioComponentIdListCopier.copy(studioComponentIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder studioComponentIds(String... studioComponentIds) {
            studioComponentIds(Arrays.asList(studioComponentIds));
            return this;
        }

        public final String getStudioId() {
            return studioId;
        }

        public final void setStudioId(String studioId) {
            this.studioId = studioId;
        }

        @Override
        @Transient
        public final Builder studioId(String studioId) {
            this.studioId = studioId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLaunchProfileRequest build() {
            return new CreateLaunchProfileRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
