/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.nimble.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <zonbook></zonbook><xhtml></xhtml>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateStreamingSessionRequest extends NimbleRequest implements
        ToCopyableBuilder<CreateStreamingSessionRequest.Builder, CreateStreamingSessionRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateStreamingSessionRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Client-Token").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> EC2_INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ec2InstanceType").getter(getter(CreateStreamingSessionRequest::ec2InstanceTypeAsString))
            .setter(setter(Builder::ec2InstanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2InstanceType").build()).build();

    private static final SdkField<String> LAUNCH_PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("launchProfileId").getter(getter(CreateStreamingSessionRequest::launchProfileId))
            .setter(setter(Builder::launchProfileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchProfileId").build()).build();

    private static final SdkField<String> OWNED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ownedBy").getter(getter(CreateStreamingSessionRequest::ownedBy)).setter(setter(Builder::ownedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownedBy").build()).build();

    private static final SdkField<String> STREAMING_IMAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("streamingImageId").getter(getter(CreateStreamingSessionRequest::streamingImageId))
            .setter(setter(Builder::streamingImageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamingImageId").build()).build();

    private static final SdkField<String> STUDIO_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("studioId").getter(getter(CreateStreamingSessionRequest::studioId)).setter(setter(Builder::studioId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("studioId").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateStreamingSessionRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            EC2_INSTANCE_TYPE_FIELD, LAUNCH_PROFILE_ID_FIELD, OWNED_BY_FIELD, STREAMING_IMAGE_ID_FIELD, STUDIO_ID_FIELD,
            TAGS_FIELD));

    private final String clientToken;

    private final String ec2InstanceType;

    private final String launchProfileId;

    private final String ownedBy;

    private final String streamingImageId;

    private final String studioId;

    private final Map<String, String> tags;

    private CreateStreamingSessionRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.ec2InstanceType = builder.ec2InstanceType;
        this.launchProfileId = builder.launchProfileId;
        this.ownedBy = builder.ownedBy;
        this.streamingImageId = builder.streamingImageId;
        this.studioId = builder.studioId;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t specify
     * a client token, the AWS SDK automatically generates a client token and uses it for the request to ensure
     * idempotency.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t
     *         specify a client token, the AWS SDK automatically generates a client token and uses it for the request to
     *         ensure idempotency.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The EC2 Instance type used for the streaming session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ec2InstanceType}
     * will return {@link StreamingInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #ec2InstanceTypeAsString}.
     * </p>
     * 
     * @return The EC2 Instance type used for the streaming session.
     * @see StreamingInstanceType
     */
    public final StreamingInstanceType ec2InstanceType() {
        return StreamingInstanceType.fromValue(ec2InstanceType);
    }

    /**
     * <p>
     * The EC2 Instance type used for the streaming session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ec2InstanceType}
     * will return {@link StreamingInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #ec2InstanceTypeAsString}.
     * </p>
     * 
     * @return The EC2 Instance type used for the streaming session.
     * @see StreamingInstanceType
     */
    public final String ec2InstanceTypeAsString() {
        return ec2InstanceType;
    }

    /**
     * <p>
     * The launch profile ID.
     * </p>
     * 
     * @return The launch profile ID.
     */
    public final String launchProfileId() {
        return launchProfileId;
    }

    /**
     * <p>
     * The user ID of the user that owns the streaming session.
     * </p>
     * 
     * @return The user ID of the user that owns the streaming session.
     */
    public final String ownedBy() {
        return ownedBy;
    }

    /**
     * <p>
     * The ID of the streaming image.
     * </p>
     * 
     * @return The ID of the streaming image.
     */
    public final String streamingImageId() {
        return streamingImageId;
    }

    /**
     * <p>
     * The studio ID.
     * </p>
     * 
     * @return The studio ID.
     */
    public final String studioId() {
        return studioId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A collection of labels, in the form of key:value pairs, that apply to this resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A collection of labels, in the form of key:value pairs, that apply to this resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(ec2InstanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(launchProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(ownedBy());
        hashCode = 31 * hashCode + Objects.hashCode(streamingImageId());
        hashCode = 31 * hashCode + Objects.hashCode(studioId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStreamingSessionRequest)) {
            return false;
        }
        CreateStreamingSessionRequest other = (CreateStreamingSessionRequest) obj;
        return Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(ec2InstanceTypeAsString(), other.ec2InstanceTypeAsString())
                && Objects.equals(launchProfileId(), other.launchProfileId()) && Objects.equals(ownedBy(), other.ownedBy())
                && Objects.equals(streamingImageId(), other.streamingImageId()) && Objects.equals(studioId(), other.studioId())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateStreamingSessionRequest").add("ClientToken", clientToken())
                .add("Ec2InstanceType", ec2InstanceTypeAsString()).add("LaunchProfileId", launchProfileId())
                .add("OwnedBy", ownedBy()).add("StreamingImageId", streamingImageId()).add("StudioId", studioId())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "ec2InstanceType":
            return Optional.ofNullable(clazz.cast(ec2InstanceTypeAsString()));
        case "launchProfileId":
            return Optional.ofNullable(clazz.cast(launchProfileId()));
        case "ownedBy":
            return Optional.ofNullable(clazz.cast(ownedBy()));
        case "streamingImageId":
            return Optional.ofNullable(clazz.cast(streamingImageId()));
        case "studioId":
            return Optional.ofNullable(clazz.cast(studioId()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateStreamingSessionRequest, T> g) {
        return obj -> g.apply((CreateStreamingSessionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NimbleRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateStreamingSessionRequest> {
        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don’t
         * specify a client token, the AWS SDK automatically generates a client token and uses it for the request to
         * ensure idempotency.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you
         *        don’t specify a client token, the AWS SDK automatically generates a client token and uses it for the
         *        request to ensure idempotency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The EC2 Instance type used for the streaming session.
         * </p>
         * 
         * @param ec2InstanceType
         *        The EC2 Instance type used for the streaming session.
         * @see StreamingInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamingInstanceType
         */
        Builder ec2InstanceType(String ec2InstanceType);

        /**
         * <p>
         * The EC2 Instance type used for the streaming session.
         * </p>
         * 
         * @param ec2InstanceType
         *        The EC2 Instance type used for the streaming session.
         * @see StreamingInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamingInstanceType
         */
        Builder ec2InstanceType(StreamingInstanceType ec2InstanceType);

        /**
         * <p>
         * The launch profile ID.
         * </p>
         * 
         * @param launchProfileId
         *        The launch profile ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchProfileId(String launchProfileId);

        /**
         * <p>
         * The user ID of the user that owns the streaming session.
         * </p>
         * 
         * @param ownedBy
         *        The user ID of the user that owns the streaming session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownedBy(String ownedBy);

        /**
         * <p>
         * The ID of the streaming image.
         * </p>
         * 
         * @param streamingImageId
         *        The ID of the streaming image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamingImageId(String streamingImageId);

        /**
         * <p>
         * The studio ID.
         * </p>
         * 
         * @param studioId
         *        The studio ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder studioId(String studioId);

        /**
         * <p>
         * A collection of labels, in the form of key:value pairs, that apply to this resource.
         * </p>
         * 
         * @param tags
         *        A collection of labels, in the form of key:value pairs, that apply to this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NimbleRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String ec2InstanceType;

        private String launchProfileId;

        private String ownedBy;

        private String streamingImageId;

        private String studioId;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStreamingSessionRequest model) {
            super(model);
            clientToken(model.clientToken);
            ec2InstanceType(model.ec2InstanceType);
            launchProfileId(model.launchProfileId);
            ownedBy(model.ownedBy);
            streamingImageId(model.streamingImageId);
            studioId(model.studioId);
            tags(model.tags);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getEc2InstanceType() {
            return ec2InstanceType;
        }

        public final void setEc2InstanceType(String ec2InstanceType) {
            this.ec2InstanceType = ec2InstanceType;
        }

        @Override
        @Transient
        public final Builder ec2InstanceType(String ec2InstanceType) {
            this.ec2InstanceType = ec2InstanceType;
            return this;
        }

        @Override
        @Transient
        public final Builder ec2InstanceType(StreamingInstanceType ec2InstanceType) {
            this.ec2InstanceType(ec2InstanceType == null ? null : ec2InstanceType.toString());
            return this;
        }

        public final String getLaunchProfileId() {
            return launchProfileId;
        }

        public final void setLaunchProfileId(String launchProfileId) {
            this.launchProfileId = launchProfileId;
        }

        @Override
        @Transient
        public final Builder launchProfileId(String launchProfileId) {
            this.launchProfileId = launchProfileId;
            return this;
        }

        public final String getOwnedBy() {
            return ownedBy;
        }

        public final void setOwnedBy(String ownedBy) {
            this.ownedBy = ownedBy;
        }

        @Override
        @Transient
        public final Builder ownedBy(String ownedBy) {
            this.ownedBy = ownedBy;
            return this;
        }

        public final String getStreamingImageId() {
            return streamingImageId;
        }

        public final void setStreamingImageId(String streamingImageId) {
            this.streamingImageId = streamingImageId;
        }

        @Override
        @Transient
        public final Builder streamingImageId(String streamingImageId) {
            this.streamingImageId = streamingImageId;
            return this;
        }

        public final String getStudioId() {
            return studioId;
        }

        public final void setStudioId(String studioId) {
            this.studioId = studioId;
        }

        @Override
        @Transient
        public final Builder studioId(String studioId) {
            this.studioId = studioId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateStreamingSessionRequest build() {
            return new CreateStreamingSessionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
