/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.nimble.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <zonbook></zonbook><xhtml></xhtml>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetLaunchProfileMemberResponse extends NimbleResponse implements
        ToCopyableBuilder<GetLaunchProfileMemberResponse.Builder, GetLaunchProfileMemberResponse> {
    private static final SdkField<LaunchProfileMembership> MEMBER_FIELD = SdkField
            .<LaunchProfileMembership> builder(MarshallingType.SDK_POJO).memberName("member")
            .getter(getter(GetLaunchProfileMemberResponse::member)).setter(setter(Builder::member))
            .constructor(LaunchProfileMembership::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBER_FIELD));

    private final LaunchProfileMembership member;

    private GetLaunchProfileMemberResponse(BuilderImpl builder) {
        super(builder);
        this.member = builder.member;
    }

    /**
     * <p>
     * The member.
     * </p>
     * 
     * @return The member.
     */
    public final LaunchProfileMembership member() {
        return member;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(member());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLaunchProfileMemberResponse)) {
            return false;
        }
        GetLaunchProfileMemberResponse other = (GetLaunchProfileMemberResponse) obj;
        return Objects.equals(member(), other.member());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetLaunchProfileMemberResponse").add("Member", member()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "member":
            return Optional.ofNullable(clazz.cast(member()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetLaunchProfileMemberResponse, T> g) {
        return obj -> g.apply((GetLaunchProfileMemberResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NimbleResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetLaunchProfileMemberResponse> {
        /**
         * <p>
         * The member.
         * </p>
         * 
         * @param member
         *        The member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder member(LaunchProfileMembership member);

        /**
         * <p>
         * The member.
         * </p>
         * This is a convenience that creates an instance of the {@link LaunchProfileMembership.Builder} avoiding the
         * need to create one manually via {@link LaunchProfileMembership#builder()}.
         *
         * When the {@link Consumer} completes, {@link LaunchProfileMembership.Builder#build()} is called immediately
         * and its result is passed to {@link #member(LaunchProfileMembership)}.
         * 
         * @param member
         *        a consumer that will call methods on {@link LaunchProfileMembership.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #member(LaunchProfileMembership)
         */
        default Builder member(Consumer<LaunchProfileMembership.Builder> member) {
            return member(LaunchProfileMembership.builder().applyMutation(member).build());
        }
    }

    static final class BuilderImpl extends NimbleResponse.BuilderImpl implements Builder {
        private LaunchProfileMembership member;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLaunchProfileMemberResponse model) {
            super(model);
            member(model.member);
        }

        public final LaunchProfileMembership.Builder getMember() {
            return member != null ? member.toBuilder() : null;
        }

        public final void setMember(LaunchProfileMembership.BuilderImpl member) {
            this.member = member != null ? member.build() : null;
        }

        @Override
        @Transient
        public final Builder member(LaunchProfileMembership member) {
            this.member = member;
            return this;
        }

        @Override
        public GetLaunchProfileMemberResponse build() {
            return new GetLaunchProfileMemberResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
