/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.nimble.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <zonbook></zonbook><xhtml></xhtml>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetStudioMemberResponse extends NimbleResponse implements
        ToCopyableBuilder<GetStudioMemberResponse.Builder, GetStudioMemberResponse> {
    private static final SdkField<StudioMembership> MEMBER_FIELD = SdkField.<StudioMembership> builder(MarshallingType.SDK_POJO)
            .memberName("member").getter(getter(GetStudioMemberResponse::member)).setter(setter(Builder::member))
            .constructor(StudioMembership::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBER_FIELD));

    private final StudioMembership member;

    private GetStudioMemberResponse(BuilderImpl builder) {
        super(builder);
        this.member = builder.member;
    }

    /**
     * <p>
     * The member.
     * </p>
     * 
     * @return The member.
     */
    public final StudioMembership member() {
        return member;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(member());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetStudioMemberResponse)) {
            return false;
        }
        GetStudioMemberResponse other = (GetStudioMemberResponse) obj;
        return Objects.equals(member(), other.member());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetStudioMemberResponse").add("Member", member()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "member":
            return Optional.ofNullable(clazz.cast(member()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetStudioMemberResponse, T> g) {
        return obj -> g.apply((GetStudioMemberResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NimbleResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetStudioMemberResponse> {
        /**
         * <p>
         * The member.
         * </p>
         * 
         * @param member
         *        The member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder member(StudioMembership member);

        /**
         * <p>
         * The member.
         * </p>
         * This is a convenience that creates an instance of the {@link StudioMembership.Builder} avoiding the need to
         * create one manually via {@link StudioMembership#builder()}.
         *
         * When the {@link Consumer} completes, {@link StudioMembership.Builder#build()} is called immediately and its
         * result is passed to {@link #member(StudioMembership)}.
         * 
         * @param member
         *        a consumer that will call methods on {@link StudioMembership.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #member(StudioMembership)
         */
        default Builder member(Consumer<StudioMembership.Builder> member) {
            return member(StudioMembership.builder().applyMutation(member).build());
        }
    }

    static final class BuilderImpl extends NimbleResponse.BuilderImpl implements Builder {
        private StudioMembership member;

        private BuilderImpl() {
        }

        private BuilderImpl(GetStudioMemberResponse model) {
            super(model);
            member(model.member);
        }

        public final StudioMembership.Builder getMember() {
            return member != null ? member.toBuilder() : null;
        }

        public final void setMember(StudioMembership.BuilderImpl member) {
            this.member = member != null ? member.build() : null;
        }

        @Override
        @Transient
        public final Builder member(StudioMembership member) {
            this.member = member;
            return this;
        }

        @Override
        public GetStudioMemberResponse build() {
            return new GetStudioMemberResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
