/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ComputeFarmConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ComputeFarmConfiguration> {
    private static final SdkField<String> ACTIVE_DIRECTORY_USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("activeDirectoryUser").getter(ComputeFarmConfiguration.getter(ComputeFarmConfiguration::activeDirectoryUser)).setter(ComputeFarmConfiguration.setter(Builder::activeDirectoryUser)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeDirectoryUser").build()}).build();
    private static final SdkField<String> ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("endpoint").getter(ComputeFarmConfiguration.getter(ComputeFarmConfiguration::endpoint)).setter(ComputeFarmConfiguration.setter(Builder::endpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoint").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVE_DIRECTORY_USER_FIELD, ENDPOINT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String activeDirectoryUser;
    private final String endpoint;

    private ComputeFarmConfiguration(BuilderImpl builder) {
        this.activeDirectoryUser = builder.activeDirectoryUser;
        this.endpoint = builder.endpoint;
    }

    public final String activeDirectoryUser() {
        return this.activeDirectoryUser;
    }

    public final String endpoint() {
        return this.endpoint;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.activeDirectoryUser());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComputeFarmConfiguration)) {
            return false;
        }
        ComputeFarmConfiguration other = (ComputeFarmConfiguration)obj;
        return Objects.equals(this.activeDirectoryUser(), other.activeDirectoryUser()) && Objects.equals(this.endpoint(), other.endpoint());
    }

    public final String toString() {
        return ToString.builder((String)"ComputeFarmConfiguration").add("ActiveDirectoryUser", (Object)this.activeDirectoryUser()).add("Endpoint", (Object)(this.endpoint() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "activeDirectoryUser": {
                return Optional.ofNullable(clazz.cast(this.activeDirectoryUser()));
            }
            case "endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ComputeFarmConfiguration, T> g) {
        return obj -> g.apply((ComputeFarmConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String activeDirectoryUser;
        private String endpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(ComputeFarmConfiguration model) {
            this.activeDirectoryUser(model.activeDirectoryUser);
            this.endpoint(model.endpoint);
        }

        public final String getActiveDirectoryUser() {
            return this.activeDirectoryUser;
        }

        public final void setActiveDirectoryUser(String activeDirectoryUser) {
            this.activeDirectoryUser = activeDirectoryUser;
        }

        @Override
        @Transient
        public final Builder activeDirectoryUser(String activeDirectoryUser) {
            this.activeDirectoryUser = activeDirectoryUser;
            return this;
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        @Transient
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public ComputeFarmConfiguration build() {
            return new ComputeFarmConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ComputeFarmConfiguration> {
        public Builder activeDirectoryUser(String var1);

        public Builder endpoint(String var1);
    }
}

