/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.nimble.model.NimbleRequest;
import software.amazon.awssdk.services.nimble.model.StudioEncryptionConfiguration;
import software.amazon.awssdk.services.nimble.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateStudioRequest
extends NimbleRequest
implements ToCopyableBuilder<Builder, CreateStudioRequest> {
    private static final SdkField<String> ADMIN_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("adminRoleArn").getter(CreateStudioRequest.getter(CreateStudioRequest::adminRoleArn)).setter(CreateStudioRequest.setter(Builder::adminRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adminRoleArn").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateStudioRequest.getter(CreateStudioRequest::clientToken)).setter(CreateStudioRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Client-Token").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(CreateStudioRequest.getter(CreateStudioRequest::displayName)).setter(CreateStudioRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<StudioEncryptionConfiguration> STUDIO_ENCRYPTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("studioEncryptionConfiguration").getter(CreateStudioRequest.getter(CreateStudioRequest::studioEncryptionConfiguration)).setter(CreateStudioRequest.setter(Builder::studioEncryptionConfiguration)).constructor(StudioEncryptionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("studioEncryptionConfiguration").build()}).build();
    private static final SdkField<String> STUDIO_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("studioName").getter(CreateStudioRequest.getter(CreateStudioRequest::studioName)).setter(CreateStudioRequest.setter(Builder::studioName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("studioName").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateStudioRequest.getter(CreateStudioRequest::tags)).setter(CreateStudioRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> USER_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userRoleArn").getter(CreateStudioRequest.getter(CreateStudioRequest::userRoleArn)).setter(CreateStudioRequest.setter(Builder::userRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userRoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADMIN_ROLE_ARN_FIELD, CLIENT_TOKEN_FIELD, DISPLAY_NAME_FIELD, STUDIO_ENCRYPTION_CONFIGURATION_FIELD, STUDIO_NAME_FIELD, TAGS_FIELD, USER_ROLE_ARN_FIELD));
    private final String adminRoleArn;
    private final String clientToken;
    private final String displayName;
    private final StudioEncryptionConfiguration studioEncryptionConfiguration;
    private final String studioName;
    private final Map<String, String> tags;
    private final String userRoleArn;

    private CreateStudioRequest(BuilderImpl builder) {
        super(builder);
        this.adminRoleArn = builder.adminRoleArn;
        this.clientToken = builder.clientToken;
        this.displayName = builder.displayName;
        this.studioEncryptionConfiguration = builder.studioEncryptionConfiguration;
        this.studioName = builder.studioName;
        this.tags = builder.tags;
        this.userRoleArn = builder.userRoleArn;
    }

    public final String adminRoleArn() {
        return this.adminRoleArn;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final StudioEncryptionConfiguration studioEncryptionConfiguration() {
        return this.studioEncryptionConfiguration;
    }

    public final String studioName() {
        return this.studioName;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String userRoleArn() {
        return this.userRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.adminRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.studioEncryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.studioName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.userRoleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStudioRequest)) {
            return false;
        }
        CreateStudioRequest other = (CreateStudioRequest)((Object)obj);
        return Objects.equals(this.adminRoleArn(), other.adminRoleArn()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.studioEncryptionConfiguration(), other.studioEncryptionConfiguration()) && Objects.equals(this.studioName(), other.studioName()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.userRoleArn(), other.userRoleArn());
    }

    public final String toString() {
        return ToString.builder((String)"CreateStudioRequest").add("AdminRoleArn", (Object)this.adminRoleArn()).add("ClientToken", (Object)this.clientToken()).add("DisplayName", (Object)(this.displayName() == null ? null : "*** Sensitive Data Redacted ***")).add("StudioEncryptionConfiguration", (Object)this.studioEncryptionConfiguration()).add("StudioName", (Object)this.studioName()).add("Tags", this.hasTags() ? this.tags() : null).add("UserRoleArn", (Object)this.userRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "adminRoleArn": {
                return Optional.ofNullable(clazz.cast(this.adminRoleArn()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "studioEncryptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.studioEncryptionConfiguration()));
            }
            case "studioName": {
                return Optional.ofNullable(clazz.cast(this.studioName()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "userRoleArn": {
                return Optional.ofNullable(clazz.cast(this.userRoleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateStudioRequest, T> g) {
        return obj -> g.apply((CreateStudioRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NimbleRequest.BuilderImpl
    implements Builder {
        private String adminRoleArn;
        private String clientToken;
        private String displayName;
        private StudioEncryptionConfiguration studioEncryptionConfiguration;
        private String studioName;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String userRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStudioRequest model) {
            super(model);
            this.adminRoleArn(model.adminRoleArn);
            this.clientToken(model.clientToken);
            this.displayName(model.displayName);
            this.studioEncryptionConfiguration(model.studioEncryptionConfiguration);
            this.studioName(model.studioName);
            this.tags(model.tags);
            this.userRoleArn(model.userRoleArn);
        }

        public final String getAdminRoleArn() {
            return this.adminRoleArn;
        }

        public final void setAdminRoleArn(String adminRoleArn) {
            this.adminRoleArn = adminRoleArn;
        }

        @Override
        @Transient
        public final Builder adminRoleArn(String adminRoleArn) {
            this.adminRoleArn = adminRoleArn;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        @Transient
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final StudioEncryptionConfiguration.Builder getStudioEncryptionConfiguration() {
            return this.studioEncryptionConfiguration != null ? this.studioEncryptionConfiguration.toBuilder() : null;
        }

        public final void setStudioEncryptionConfiguration(StudioEncryptionConfiguration.BuilderImpl studioEncryptionConfiguration) {
            this.studioEncryptionConfiguration = studioEncryptionConfiguration != null ? studioEncryptionConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder studioEncryptionConfiguration(StudioEncryptionConfiguration studioEncryptionConfiguration) {
            this.studioEncryptionConfiguration = studioEncryptionConfiguration;
            return this;
        }

        public final String getStudioName() {
            return this.studioName;
        }

        public final void setStudioName(String studioName) {
            this.studioName = studioName;
        }

        @Override
        @Transient
        public final Builder studioName(String studioName) {
            this.studioName = studioName;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final String getUserRoleArn() {
            return this.userRoleArn;
        }

        public final void setUserRoleArn(String userRoleArn) {
            this.userRoleArn = userRoleArn;
        }

        @Override
        @Transient
        public final Builder userRoleArn(String userRoleArn) {
            this.userRoleArn = userRoleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateStudioRequest build() {
            return new CreateStudioRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NimbleRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateStudioRequest> {
        public Builder adminRoleArn(String var1);

        public Builder clientToken(String var1);

        public Builder displayName(String var1);

        public Builder studioEncryptionConfiguration(StudioEncryptionConfiguration var1);

        default public Builder studioEncryptionConfiguration(Consumer<StudioEncryptionConfiguration.Builder> studioEncryptionConfiguration) {
            return this.studioEncryptionConfiguration((StudioEncryptionConfiguration)((StudioEncryptionConfiguration.Builder)StudioEncryptionConfiguration.builder().applyMutation(studioEncryptionConfiguration)).build());
        }

        public Builder studioName(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder userRoleArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

