/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.nimble.model.NimbleRequest;
import software.amazon.awssdk.services.nimble.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetLaunchProfileInitializationRequest
extends NimbleRequest
implements ToCopyableBuilder<Builder, GetLaunchProfileInitializationRequest> {
    private static final SdkField<String> LAUNCH_PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("launchProfileId").getter(GetLaunchProfileInitializationRequest.getter(GetLaunchProfileInitializationRequest::launchProfileId)).setter(GetLaunchProfileInitializationRequest.setter(Builder::launchProfileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("launchProfileId").build()}).build();
    private static final SdkField<List<String>> LAUNCH_PROFILE_PROTOCOL_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("launchProfileProtocolVersions").getter(GetLaunchProfileInitializationRequest.getter(GetLaunchProfileInitializationRequest::launchProfileProtocolVersions)).setter(GetLaunchProfileInitializationRequest.setter(Builder::launchProfileProtocolVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("launchProfileProtocolVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LAUNCH_PURPOSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("launchPurpose").getter(GetLaunchProfileInitializationRequest.getter(GetLaunchProfileInitializationRequest::launchPurpose)).setter(GetLaunchProfileInitializationRequest.setter(Builder::launchPurpose)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("launchPurpose").build()}).build();
    private static final SdkField<String> PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("platform").getter(GetLaunchProfileInitializationRequest.getter(GetLaunchProfileInitializationRequest::platform)).setter(GetLaunchProfileInitializationRequest.setter(Builder::platform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("platform").build()}).build();
    private static final SdkField<String> STUDIO_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("studioId").getter(GetLaunchProfileInitializationRequest.getter(GetLaunchProfileInitializationRequest::studioId)).setter(GetLaunchProfileInitializationRequest.setter(Builder::studioId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("studioId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAUNCH_PROFILE_ID_FIELD, LAUNCH_PROFILE_PROTOCOL_VERSIONS_FIELD, LAUNCH_PURPOSE_FIELD, PLATFORM_FIELD, STUDIO_ID_FIELD));
    private final String launchProfileId;
    private final List<String> launchProfileProtocolVersions;
    private final String launchPurpose;
    private final String platform;
    private final String studioId;

    private GetLaunchProfileInitializationRequest(BuilderImpl builder) {
        super(builder);
        this.launchProfileId = builder.launchProfileId;
        this.launchProfileProtocolVersions = builder.launchProfileProtocolVersions;
        this.launchPurpose = builder.launchPurpose;
        this.platform = builder.platform;
        this.studioId = builder.studioId;
    }

    public final String launchProfileId() {
        return this.launchProfileId;
    }

    public final boolean hasLaunchProfileProtocolVersions() {
        return this.launchProfileProtocolVersions != null && !(this.launchProfileProtocolVersions instanceof SdkAutoConstructList);
    }

    public final List<String> launchProfileProtocolVersions() {
        return this.launchProfileProtocolVersions;
    }

    public final String launchPurpose() {
        return this.launchPurpose;
    }

    public final String platform() {
        return this.platform;
    }

    public final String studioId() {
        return this.studioId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.launchProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLaunchProfileProtocolVersions() ? this.launchProfileProtocolVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.launchPurpose());
        hashCode = 31 * hashCode + Objects.hashCode(this.platform());
        hashCode = 31 * hashCode + Objects.hashCode(this.studioId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLaunchProfileInitializationRequest)) {
            return false;
        }
        GetLaunchProfileInitializationRequest other = (GetLaunchProfileInitializationRequest)((Object)obj);
        return Objects.equals(this.launchProfileId(), other.launchProfileId()) && this.hasLaunchProfileProtocolVersions() == other.hasLaunchProfileProtocolVersions() && Objects.equals(this.launchProfileProtocolVersions(), other.launchProfileProtocolVersions()) && Objects.equals(this.launchPurpose(), other.launchPurpose()) && Objects.equals(this.platform(), other.platform()) && Objects.equals(this.studioId(), other.studioId());
    }

    public final String toString() {
        return ToString.builder((String)"GetLaunchProfileInitializationRequest").add("LaunchProfileId", (Object)this.launchProfileId()).add("LaunchProfileProtocolVersions", this.hasLaunchProfileProtocolVersions() ? this.launchProfileProtocolVersions() : null).add("LaunchPurpose", (Object)this.launchPurpose()).add("Platform", (Object)this.platform()).add("StudioId", (Object)this.studioId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "launchProfileId": {
                return Optional.ofNullable(clazz.cast(this.launchProfileId()));
            }
            case "launchProfileProtocolVersions": {
                return Optional.ofNullable(clazz.cast(this.launchProfileProtocolVersions()));
            }
            case "launchPurpose": {
                return Optional.ofNullable(clazz.cast(this.launchPurpose()));
            }
            case "platform": {
                return Optional.ofNullable(clazz.cast(this.platform()));
            }
            case "studioId": {
                return Optional.ofNullable(clazz.cast(this.studioId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetLaunchProfileInitializationRequest, T> g) {
        return obj -> g.apply((GetLaunchProfileInitializationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NimbleRequest.BuilderImpl
    implements Builder {
        private String launchProfileId;
        private List<String> launchProfileProtocolVersions = DefaultSdkAutoConstructList.getInstance();
        private String launchPurpose;
        private String platform;
        private String studioId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLaunchProfileInitializationRequest model) {
            super(model);
            this.launchProfileId(model.launchProfileId);
            this.launchProfileProtocolVersions(model.launchProfileProtocolVersions);
            this.launchPurpose(model.launchPurpose);
            this.platform(model.platform);
            this.studioId(model.studioId);
        }

        public final String getLaunchProfileId() {
            return this.launchProfileId;
        }

        public final void setLaunchProfileId(String launchProfileId) {
            this.launchProfileId = launchProfileId;
        }

        @Override
        @Transient
        public final Builder launchProfileId(String launchProfileId) {
            this.launchProfileId = launchProfileId;
            return this;
        }

        public final Collection<String> getLaunchProfileProtocolVersions() {
            if (this.launchProfileProtocolVersions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.launchProfileProtocolVersions;
        }

        public final void setLaunchProfileProtocolVersions(Collection<String> launchProfileProtocolVersions) {
            this.launchProfileProtocolVersions = StringListCopier.copy(launchProfileProtocolVersions);
        }

        @Override
        @Transient
        public final Builder launchProfileProtocolVersions(Collection<String> launchProfileProtocolVersions) {
            this.launchProfileProtocolVersions = StringListCopier.copy(launchProfileProtocolVersions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder launchProfileProtocolVersions(String ... launchProfileProtocolVersions) {
            this.launchProfileProtocolVersions(Arrays.asList(launchProfileProtocolVersions));
            return this;
        }

        public final String getLaunchPurpose() {
            return this.launchPurpose;
        }

        public final void setLaunchPurpose(String launchPurpose) {
            this.launchPurpose = launchPurpose;
        }

        @Override
        @Transient
        public final Builder launchPurpose(String launchPurpose) {
            this.launchPurpose = launchPurpose;
            return this;
        }

        public final String getPlatform() {
            return this.platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        @Transient
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final String getStudioId() {
            return this.studioId;
        }

        public final void setStudioId(String studioId) {
            this.studioId = studioId;
        }

        @Override
        @Transient
        public final Builder studioId(String studioId) {
            this.studioId = studioId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetLaunchProfileInitializationRequest build() {
            return new GetLaunchProfileInitializationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NimbleRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetLaunchProfileInitializationRequest> {
        public Builder launchProfileId(String var1);

        public Builder launchProfileProtocolVersions(Collection<String> var1);

        public Builder launchProfileProtocolVersions(String ... var1);

        public Builder launchPurpose(String var1);

        public Builder platform(String var1);

        public Builder studioId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

