/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.nimble.model.StreamingClipboardMode;
import software.amazon.awssdk.services.nimble.model.StreamingImageIdListCopier;
import software.amazon.awssdk.services.nimble.model.StreamingInstanceType;
import software.amazon.awssdk.services.nimble.model.StreamingInstanceTypeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StreamConfigurationCreate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StreamConfigurationCreate> {
    private static final SdkField<String> CLIPBOARD_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clipboardMode").getter(StreamConfigurationCreate.getter(StreamConfigurationCreate::clipboardModeAsString)).setter(StreamConfigurationCreate.setter(Builder::clipboardMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clipboardMode").build()}).build();
    private static final SdkField<List<String>> EC2_INSTANCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ec2InstanceTypes").getter(StreamConfigurationCreate.getter(StreamConfigurationCreate::ec2InstanceTypesAsStrings)).setter(StreamConfigurationCreate.setter(Builder::ec2InstanceTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2InstanceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_SESSION_LENGTH_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxSessionLengthInMinutes").getter(StreamConfigurationCreate.getter(StreamConfigurationCreate::maxSessionLengthInMinutes)).setter(StreamConfigurationCreate.setter(Builder::maxSessionLengthInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxSessionLengthInMinutes").build()}).build();
    private static final SdkField<Integer> MAX_STOPPED_SESSION_LENGTH_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxStoppedSessionLengthInMinutes").getter(StreamConfigurationCreate.getter(StreamConfigurationCreate::maxStoppedSessionLengthInMinutes)).setter(StreamConfigurationCreate.setter(Builder::maxStoppedSessionLengthInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxStoppedSessionLengthInMinutes").build()}).build();
    private static final SdkField<List<String>> STREAMING_IMAGE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("streamingImageIds").getter(StreamConfigurationCreate.getter(StreamConfigurationCreate::streamingImageIds)).setter(StreamConfigurationCreate.setter(Builder::streamingImageIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamingImageIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIPBOARD_MODE_FIELD, EC2_INSTANCE_TYPES_FIELD, MAX_SESSION_LENGTH_IN_MINUTES_FIELD, MAX_STOPPED_SESSION_LENGTH_IN_MINUTES_FIELD, STREAMING_IMAGE_IDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String clipboardMode;
    private final List<String> ec2InstanceTypes;
    private final Integer maxSessionLengthInMinutes;
    private final Integer maxStoppedSessionLengthInMinutes;
    private final List<String> streamingImageIds;

    private StreamConfigurationCreate(BuilderImpl builder) {
        this.clipboardMode = builder.clipboardMode;
        this.ec2InstanceTypes = builder.ec2InstanceTypes;
        this.maxSessionLengthInMinutes = builder.maxSessionLengthInMinutes;
        this.maxStoppedSessionLengthInMinutes = builder.maxStoppedSessionLengthInMinutes;
        this.streamingImageIds = builder.streamingImageIds;
    }

    public final StreamingClipboardMode clipboardMode() {
        return StreamingClipboardMode.fromValue(this.clipboardMode);
    }

    public final String clipboardModeAsString() {
        return this.clipboardMode;
    }

    public final List<StreamingInstanceType> ec2InstanceTypes() {
        return StreamingInstanceTypeListCopier.copyStringToEnum(this.ec2InstanceTypes);
    }

    public final boolean hasEc2InstanceTypes() {
        return this.ec2InstanceTypes != null && !(this.ec2InstanceTypes instanceof SdkAutoConstructList);
    }

    public final List<String> ec2InstanceTypesAsStrings() {
        return this.ec2InstanceTypes;
    }

    public final Integer maxSessionLengthInMinutes() {
        return this.maxSessionLengthInMinutes;
    }

    public final Integer maxStoppedSessionLengthInMinutes() {
        return this.maxStoppedSessionLengthInMinutes;
    }

    public final boolean hasStreamingImageIds() {
        return this.streamingImageIds != null && !(this.streamingImageIds instanceof SdkAutoConstructList);
    }

    public final List<String> streamingImageIds() {
        return this.streamingImageIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clipboardModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEc2InstanceTypes() ? this.ec2InstanceTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxSessionLengthInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxStoppedSessionLengthInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStreamingImageIds() ? this.streamingImageIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamConfigurationCreate)) {
            return false;
        }
        StreamConfigurationCreate other = (StreamConfigurationCreate)obj;
        return Objects.equals(this.clipboardModeAsString(), other.clipboardModeAsString()) && this.hasEc2InstanceTypes() == other.hasEc2InstanceTypes() && Objects.equals(this.ec2InstanceTypesAsStrings(), other.ec2InstanceTypesAsStrings()) && Objects.equals(this.maxSessionLengthInMinutes(), other.maxSessionLengthInMinutes()) && Objects.equals(this.maxStoppedSessionLengthInMinutes(), other.maxStoppedSessionLengthInMinutes()) && this.hasStreamingImageIds() == other.hasStreamingImageIds() && Objects.equals(this.streamingImageIds(), other.streamingImageIds());
    }

    public final String toString() {
        return ToString.builder((String)"StreamConfigurationCreate").add("ClipboardMode", (Object)this.clipboardModeAsString()).add("Ec2InstanceTypes", this.hasEc2InstanceTypes() ? this.ec2InstanceTypesAsStrings() : null).add("MaxSessionLengthInMinutes", (Object)this.maxSessionLengthInMinutes()).add("MaxStoppedSessionLengthInMinutes", (Object)this.maxStoppedSessionLengthInMinutes()).add("StreamingImageIds", this.hasStreamingImageIds() ? this.streamingImageIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clipboardMode": {
                return Optional.ofNullable(clazz.cast(this.clipboardModeAsString()));
            }
            case "ec2InstanceTypes": {
                return Optional.ofNullable(clazz.cast(this.ec2InstanceTypesAsStrings()));
            }
            case "maxSessionLengthInMinutes": {
                return Optional.ofNullable(clazz.cast(this.maxSessionLengthInMinutes()));
            }
            case "maxStoppedSessionLengthInMinutes": {
                return Optional.ofNullable(clazz.cast(this.maxStoppedSessionLengthInMinutes()));
            }
            case "streamingImageIds": {
                return Optional.ofNullable(clazz.cast(this.streamingImageIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StreamConfigurationCreate, T> g) {
        return obj -> g.apply((StreamConfigurationCreate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clipboardMode;
        private List<String> ec2InstanceTypes = DefaultSdkAutoConstructList.getInstance();
        private Integer maxSessionLengthInMinutes;
        private Integer maxStoppedSessionLengthInMinutes;
        private List<String> streamingImageIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StreamConfigurationCreate model) {
            this.clipboardMode(model.clipboardMode);
            this.ec2InstanceTypesWithStrings(model.ec2InstanceTypes);
            this.maxSessionLengthInMinutes(model.maxSessionLengthInMinutes);
            this.maxStoppedSessionLengthInMinutes(model.maxStoppedSessionLengthInMinutes);
            this.streamingImageIds(model.streamingImageIds);
        }

        public final String getClipboardMode() {
            return this.clipboardMode;
        }

        public final void setClipboardMode(String clipboardMode) {
            this.clipboardMode = clipboardMode;
        }

        @Override
        @Transient
        public final Builder clipboardMode(String clipboardMode) {
            this.clipboardMode = clipboardMode;
            return this;
        }

        @Override
        @Transient
        public final Builder clipboardMode(StreamingClipboardMode clipboardMode) {
            this.clipboardMode(clipboardMode == null ? null : clipboardMode.toString());
            return this;
        }

        public final Collection<String> getEc2InstanceTypes() {
            if (this.ec2InstanceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ec2InstanceTypes;
        }

        public final void setEc2InstanceTypes(Collection<String> ec2InstanceTypes) {
            this.ec2InstanceTypes = StreamingInstanceTypeListCopier.copy(ec2InstanceTypes);
        }

        @Override
        @Transient
        public final Builder ec2InstanceTypesWithStrings(Collection<String> ec2InstanceTypes) {
            this.ec2InstanceTypes = StreamingInstanceTypeListCopier.copy(ec2InstanceTypes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder ec2InstanceTypesWithStrings(String ... ec2InstanceTypes) {
            this.ec2InstanceTypesWithStrings(Arrays.asList(ec2InstanceTypes));
            return this;
        }

        @Override
        @Transient
        public final Builder ec2InstanceTypes(Collection<StreamingInstanceType> ec2InstanceTypes) {
            this.ec2InstanceTypes = StreamingInstanceTypeListCopier.copyEnumToString(ec2InstanceTypes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder ec2InstanceTypes(StreamingInstanceType ... ec2InstanceTypes) {
            this.ec2InstanceTypes(Arrays.asList(ec2InstanceTypes));
            return this;
        }

        public final Integer getMaxSessionLengthInMinutes() {
            return this.maxSessionLengthInMinutes;
        }

        public final void setMaxSessionLengthInMinutes(Integer maxSessionLengthInMinutes) {
            this.maxSessionLengthInMinutes = maxSessionLengthInMinutes;
        }

        @Override
        @Transient
        public final Builder maxSessionLengthInMinutes(Integer maxSessionLengthInMinutes) {
            this.maxSessionLengthInMinutes = maxSessionLengthInMinutes;
            return this;
        }

        public final Integer getMaxStoppedSessionLengthInMinutes() {
            return this.maxStoppedSessionLengthInMinutes;
        }

        public final void setMaxStoppedSessionLengthInMinutes(Integer maxStoppedSessionLengthInMinutes) {
            this.maxStoppedSessionLengthInMinutes = maxStoppedSessionLengthInMinutes;
        }

        @Override
        @Transient
        public final Builder maxStoppedSessionLengthInMinutes(Integer maxStoppedSessionLengthInMinutes) {
            this.maxStoppedSessionLengthInMinutes = maxStoppedSessionLengthInMinutes;
            return this;
        }

        public final Collection<String> getStreamingImageIds() {
            if (this.streamingImageIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.streamingImageIds;
        }

        public final void setStreamingImageIds(Collection<String> streamingImageIds) {
            this.streamingImageIds = StreamingImageIdListCopier.copy(streamingImageIds);
        }

        @Override
        @Transient
        public final Builder streamingImageIds(Collection<String> streamingImageIds) {
            this.streamingImageIds = StreamingImageIdListCopier.copy(streamingImageIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder streamingImageIds(String ... streamingImageIds) {
            this.streamingImageIds(Arrays.asList(streamingImageIds));
            return this;
        }

        public StreamConfigurationCreate build() {
            return new StreamConfigurationCreate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StreamConfigurationCreate> {
        public Builder clipboardMode(String var1);

        public Builder clipboardMode(StreamingClipboardMode var1);

        public Builder ec2InstanceTypesWithStrings(Collection<String> var1);

        public Builder ec2InstanceTypesWithStrings(String ... var1);

        public Builder ec2InstanceTypes(Collection<StreamingInstanceType> var1);

        public Builder ec2InstanceTypes(StreamingInstanceType ... var1);

        public Builder maxSessionLengthInMinutes(Integer var1);

        public Builder maxStoppedSessionLengthInMinutes(Integer var1);

        public Builder streamingImageIds(Collection<String> var1);

        public Builder streamingImageIds(String ... var1);
    }
}

