/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.nimble.model.LaunchProfilePersona;
import software.amazon.awssdk.services.nimble.model.NimbleRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateLaunchProfileMemberRequest
extends NimbleRequest
implements ToCopyableBuilder<Builder, UpdateLaunchProfileMemberRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateLaunchProfileMemberRequest.getter(UpdateLaunchProfileMemberRequest::clientToken)).setter(UpdateLaunchProfileMemberRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Client-Token").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> LAUNCH_PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("launchProfileId").getter(UpdateLaunchProfileMemberRequest.getter(UpdateLaunchProfileMemberRequest::launchProfileId)).setter(UpdateLaunchProfileMemberRequest.setter(Builder::launchProfileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("launchProfileId").build()}).build();
    private static final SdkField<String> PERSONA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("persona").getter(UpdateLaunchProfileMemberRequest.getter(UpdateLaunchProfileMemberRequest::personaAsString)).setter(UpdateLaunchProfileMemberRequest.setter(Builder::persona)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("persona").build()}).build();
    private static final SdkField<String> PRINCIPAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("principalId").getter(UpdateLaunchProfileMemberRequest.getter(UpdateLaunchProfileMemberRequest::principalId)).setter(UpdateLaunchProfileMemberRequest.setter(Builder::principalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("principalId").build()}).build();
    private static final SdkField<String> STUDIO_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("studioId").getter(UpdateLaunchProfileMemberRequest.getter(UpdateLaunchProfileMemberRequest::studioId)).setter(UpdateLaunchProfileMemberRequest.setter(Builder::studioId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("studioId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, LAUNCH_PROFILE_ID_FIELD, PERSONA_FIELD, PRINCIPAL_ID_FIELD, STUDIO_ID_FIELD));
    private final String clientToken;
    private final String launchProfileId;
    private final String persona;
    private final String principalId;
    private final String studioId;

    private UpdateLaunchProfileMemberRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.launchProfileId = builder.launchProfileId;
        this.persona = builder.persona;
        this.principalId = builder.principalId;
        this.studioId = builder.studioId;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String launchProfileId() {
        return this.launchProfileId;
    }

    public final LaunchProfilePersona persona() {
        return LaunchProfilePersona.fromValue(this.persona);
    }

    public final String personaAsString() {
        return this.persona;
    }

    public final String principalId() {
        return this.principalId;
    }

    public final String studioId() {
        return this.studioId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.personaAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.principalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.studioId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLaunchProfileMemberRequest)) {
            return false;
        }
        UpdateLaunchProfileMemberRequest other = (UpdateLaunchProfileMemberRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.launchProfileId(), other.launchProfileId()) && Objects.equals(this.personaAsString(), other.personaAsString()) && Objects.equals(this.principalId(), other.principalId()) && Objects.equals(this.studioId(), other.studioId());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateLaunchProfileMemberRequest").add("ClientToken", (Object)this.clientToken()).add("LaunchProfileId", (Object)this.launchProfileId()).add("Persona", (Object)this.personaAsString()).add("PrincipalId", (Object)this.principalId()).add("StudioId", (Object)this.studioId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "launchProfileId": {
                return Optional.ofNullable(clazz.cast(this.launchProfileId()));
            }
            case "persona": {
                return Optional.ofNullable(clazz.cast(this.personaAsString()));
            }
            case "principalId": {
                return Optional.ofNullable(clazz.cast(this.principalId()));
            }
            case "studioId": {
                return Optional.ofNullable(clazz.cast(this.studioId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateLaunchProfileMemberRequest, T> g) {
        return obj -> g.apply((UpdateLaunchProfileMemberRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NimbleRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String launchProfileId;
        private String persona;
        private String principalId;
        private String studioId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLaunchProfileMemberRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.launchProfileId(model.launchProfileId);
            this.persona(model.persona);
            this.principalId(model.principalId);
            this.studioId(model.studioId);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getLaunchProfileId() {
            return this.launchProfileId;
        }

        public final void setLaunchProfileId(String launchProfileId) {
            this.launchProfileId = launchProfileId;
        }

        @Override
        @Transient
        public final Builder launchProfileId(String launchProfileId) {
            this.launchProfileId = launchProfileId;
            return this;
        }

        public final String getPersona() {
            return this.persona;
        }

        public final void setPersona(String persona) {
            this.persona = persona;
        }

        @Override
        @Transient
        public final Builder persona(String persona) {
            this.persona = persona;
            return this;
        }

        @Override
        @Transient
        public final Builder persona(LaunchProfilePersona persona) {
            this.persona(persona == null ? null : persona.toString());
            return this;
        }

        public final String getPrincipalId() {
            return this.principalId;
        }

        public final void setPrincipalId(String principalId) {
            this.principalId = principalId;
        }

        @Override
        @Transient
        public final Builder principalId(String principalId) {
            this.principalId = principalId;
            return this;
        }

        public final String getStudioId() {
            return this.studioId;
        }

        public final void setStudioId(String studioId) {
            this.studioId = studioId;
        }

        @Override
        @Transient
        public final Builder studioId(String studioId) {
            this.studioId = studioId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateLaunchProfileMemberRequest build() {
            return new UpdateLaunchProfileMemberRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NimbleRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateLaunchProfileMemberRequest> {
        public Builder clientToken(String var1);

        public Builder launchProfileId(String var1);

        public Builder persona(String var1);

        public Builder persona(LaunchProfilePersona var1);

        public Builder principalId(String var1);

        public Builder studioId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

