/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.nimble.NimbleClient;
import software.amazon.awssdk.services.nimble.model.ListStudioComponentsRequest;
import software.amazon.awssdk.services.nimble.model.ListStudioComponentsResponse;
import software.amazon.awssdk.services.nimble.model.StudioComponent;

public class ListStudioComponentsIterable
implements SdkIterable<ListStudioComponentsResponse> {
    private final NimbleClient client;
    private final ListStudioComponentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListStudioComponentsIterable(NimbleClient client, ListStudioComponentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListStudioComponentsResponseFetcher();
    }

    public Iterator<ListStudioComponentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<StudioComponent> studioComponents() {
        Function<ListStudioComponentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.studioComponents() != null) {
                return response.studioComponents().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListStudioComponentsResponseFetcher
    implements SyncPageFetcher<ListStudioComponentsResponse> {
        private ListStudioComponentsResponseFetcher() {
        }

        public boolean hasNextPage(ListStudioComponentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListStudioComponentsResponse nextPage(ListStudioComponentsResponse previousPage) {
            if (previousPage == null) {
                return ListStudioComponentsIterable.this.client.listStudioComponents(ListStudioComponentsIterable.this.firstRequest);
            }
            return ListStudioComponentsIterable.this.client.listStudioComponents((ListStudioComponentsRequest)((Object)ListStudioComponentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

