/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.nimble.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListStudiosResponse extends NimbleResponse implements
        ToCopyableBuilder<ListStudiosResponse.Builder, ListStudiosResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListStudiosResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<Studio>> STUDIOS_FIELD = SdkField
            .<List<Studio>> builder(MarshallingType.LIST)
            .memberName("studios")
            .getter(getter(ListStudiosResponse::studios))
            .setter(setter(Builder::studios))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("studios").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Studio> builder(MarshallingType.SDK_POJO)
                                            .constructor(Studio::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            STUDIOS_FIELD));

    private final String nextToken;

    private final List<Studio> studios;

    private ListStudiosResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.studios = builder.studios;
    }

    /**
     * <p>
     * The token for the next set of results, or null if there are no more results.
     * </p>
     * 
     * @return The token for the next set of results, or null if there are no more results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Studios property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStudios() {
        return studios != null && !(studios instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A collection of studios.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStudios} method.
     * </p>
     * 
     * @return A collection of studios.
     */
    public final List<Studio> studios() {
        return studios;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasStudios() ? studios() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStudiosResponse)) {
            return false;
        }
        ListStudiosResponse other = (ListStudiosResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasStudios() == other.hasStudios()
                && Objects.equals(studios(), other.studios());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListStudiosResponse").add("NextToken", nextToken())
                .add("Studios", hasStudios() ? studios() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "studios":
            return Optional.ofNullable(clazz.cast(studios()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListStudiosResponse, T> g) {
        return obj -> g.apply((ListStudiosResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NimbleResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListStudiosResponse> {
        /**
         * <p>
         * The token for the next set of results, or null if there are no more results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results, or null if there are no more results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A collection of studios.
         * </p>
         * 
         * @param studios
         *        A collection of studios.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder studios(Collection<Studio> studios);

        /**
         * <p>
         * A collection of studios.
         * </p>
         * 
         * @param studios
         *        A collection of studios.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder studios(Studio... studios);

        /**
         * <p>
         * A collection of studios.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.nimble.model.Studio.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.nimble.model.Studio#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.nimble.model.Studio.Builder#build()} is called immediately and its
         * result is passed to {@link #studios(List<Studio>)}.
         * 
         * @param studios
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.nimble.model.Studio.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #studios(java.util.Collection<Studio>)
         */
        Builder studios(Consumer<Studio.Builder>... studios);
    }

    static final class BuilderImpl extends NimbleResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<Studio> studios = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListStudiosResponse model) {
            super(model);
            nextToken(model.nextToken);
            studios(model.studios);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<Studio.Builder> getStudios() {
            List<Studio.Builder> result = StudioListCopier.copyToBuilder(this.studios);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStudios(Collection<Studio.BuilderImpl> studios) {
            this.studios = StudioListCopier.copyFromBuilder(studios);
        }

        @Override
        public final Builder studios(Collection<Studio> studios) {
            this.studios = StudioListCopier.copy(studios);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder studios(Studio... studios) {
            studios(Arrays.asList(studios));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder studios(Consumer<Studio.Builder>... studios) {
            studios(Stream.of(studios).map(c -> Studio.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListStudiosResponse build() {
            return new ListStudiosResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
