/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.nimble.model.NimbleResponse;
import software.amazon.awssdk.services.nimble.model.StreamingImage;
import software.amazon.awssdk.services.nimble.model.StreamingImageListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListStreamingImagesResponse
extends NimbleResponse
implements ToCopyableBuilder<Builder, ListStreamingImagesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListStreamingImagesResponse.getter(ListStreamingImagesResponse::nextToken)).setter(ListStreamingImagesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<StreamingImage>> STREAMING_IMAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("streamingImages").getter(ListStreamingImagesResponse.getter(ListStreamingImagesResponse::streamingImages)).setter(ListStreamingImagesResponse.setter(Builder::streamingImages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamingImages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StreamingImage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, STREAMING_IMAGES_FIELD));
    private final String nextToken;
    private final List<StreamingImage> streamingImages;

    private ListStreamingImagesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.streamingImages = builder.streamingImages;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasStreamingImages() {
        return this.streamingImages != null && !(this.streamingImages instanceof SdkAutoConstructList);
    }

    public final List<StreamingImage> streamingImages() {
        return this.streamingImages;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStreamingImages() ? this.streamingImages() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStreamingImagesResponse)) {
            return false;
        }
        ListStreamingImagesResponse other = (ListStreamingImagesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasStreamingImages() == other.hasStreamingImages() && Objects.equals(this.streamingImages(), other.streamingImages());
    }

    public final String toString() {
        return ToString.builder((String)"ListStreamingImagesResponse").add("NextToken", (Object)this.nextToken()).add("StreamingImages", this.hasStreamingImages() ? this.streamingImages() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "streamingImages": {
                return Optional.ofNullable(clazz.cast(this.streamingImages()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListStreamingImagesResponse, T> g) {
        return obj -> g.apply((ListStreamingImagesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NimbleResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<StreamingImage> streamingImages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListStreamingImagesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.streamingImages(model.streamingImages);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<StreamingImage.Builder> getStreamingImages() {
            List<StreamingImage.Builder> result = StreamingImageListCopier.copyToBuilder(this.streamingImages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStreamingImages(Collection<StreamingImage.BuilderImpl> streamingImages) {
            this.streamingImages = StreamingImageListCopier.copyFromBuilder(streamingImages);
        }

        @Override
        public final Builder streamingImages(Collection<StreamingImage> streamingImages) {
            this.streamingImages = StreamingImageListCopier.copy(streamingImages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder streamingImages(StreamingImage ... streamingImages) {
            this.streamingImages(Arrays.asList(streamingImages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder streamingImages(Consumer<StreamingImage.Builder> ... streamingImages) {
            this.streamingImages(Stream.of(streamingImages).map(c -> (StreamingImage)((StreamingImage.Builder)StreamingImage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListStreamingImagesResponse build() {
            return new ListStreamingImagesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NimbleResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListStreamingImagesResponse> {
        public Builder nextToken(String var1);

        public Builder streamingImages(Collection<StreamingImage> var1);

        public Builder streamingImages(StreamingImage ... var1);

        public Builder streamingImages(Consumer<StreamingImage.Builder> ... var1);
    }
}

