/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.nimble.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configures how streaming sessions are backed up when launched from this launch profile.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StreamConfigurationSessionBackup implements SdkPojo, Serializable,
        ToCopyableBuilder<StreamConfigurationSessionBackup.Builder, StreamConfigurationSessionBackup> {
    private static final SdkField<Integer> MAX_BACKUPS_TO_RETAIN_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxBackupsToRetain").getter(getter(StreamConfigurationSessionBackup::maxBackupsToRetain))
            .setter(setter(Builder::maxBackupsToRetain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxBackupsToRetain").build())
            .build();

    private static final SdkField<String> MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("mode")
            .getter(getter(StreamConfigurationSessionBackup::modeAsString)).setter(setter(Builder::mode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_BACKUPS_TO_RETAIN_FIELD,
            MODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer maxBackupsToRetain;

    private final String mode;

    private StreamConfigurationSessionBackup(BuilderImpl builder) {
        this.maxBackupsToRetain = builder.maxBackupsToRetain;
        this.mode = builder.mode;
    }

    /**
     * <p>
     * The maximum number of backups that each streaming session created from this launch profile can have.
     * </p>
     * 
     * @return The maximum number of backups that each streaming session created from this launch profile can have.
     */
    public final Integer maxBackupsToRetain() {
        return maxBackupsToRetain;
    }

    /**
     * <p>
     * Specifies how artists sessions are backed up.
     * </p>
     * <p>
     * Configures backups for streaming sessions launched with this launch profile. The default value is
     * <code>DEACTIVATED</code>, which means that backups are deactivated. To allow backups, set this value to
     * <code>AUTOMATIC</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link SessionBackupMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return Specifies how artists sessions are backed up.</p>
     *         <p>
     *         Configures backups for streaming sessions launched with this launch profile. The default value is
     *         <code>DEACTIVATED</code>, which means that backups are deactivated. To allow backups, set this value to
     *         <code>AUTOMATIC</code>.
     * @see SessionBackupMode
     */
    public final SessionBackupMode mode() {
        return SessionBackupMode.fromValue(mode);
    }

    /**
     * <p>
     * Specifies how artists sessions are backed up.
     * </p>
     * <p>
     * Configures backups for streaming sessions launched with this launch profile. The default value is
     * <code>DEACTIVATED</code>, which means that backups are deactivated. To allow backups, set this value to
     * <code>AUTOMATIC</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link SessionBackupMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return Specifies how artists sessions are backed up.</p>
     *         <p>
     *         Configures backups for streaming sessions launched with this launch profile. The default value is
     *         <code>DEACTIVATED</code>, which means that backups are deactivated. To allow backups, set this value to
     *         <code>AUTOMATIC</code>.
     * @see SessionBackupMode
     */
    public final String modeAsString() {
        return mode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maxBackupsToRetain());
        hashCode = 31 * hashCode + Objects.hashCode(modeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamConfigurationSessionBackup)) {
            return false;
        }
        StreamConfigurationSessionBackup other = (StreamConfigurationSessionBackup) obj;
        return Objects.equals(maxBackupsToRetain(), other.maxBackupsToRetain())
                && Objects.equals(modeAsString(), other.modeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StreamConfigurationSessionBackup").add("MaxBackupsToRetain", maxBackupsToRetain())
                .add("Mode", modeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "maxBackupsToRetain":
            return Optional.ofNullable(clazz.cast(maxBackupsToRetain()));
        case "mode":
            return Optional.ofNullable(clazz.cast(modeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StreamConfigurationSessionBackup, T> g) {
        return obj -> g.apply((StreamConfigurationSessionBackup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StreamConfigurationSessionBackup> {
        /**
         * <p>
         * The maximum number of backups that each streaming session created from this launch profile can have.
         * </p>
         * 
         * @param maxBackupsToRetain
         *        The maximum number of backups that each streaming session created from this launch profile can have.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxBackupsToRetain(Integer maxBackupsToRetain);

        /**
         * <p>
         * Specifies how artists sessions are backed up.
         * </p>
         * <p>
         * Configures backups for streaming sessions launched with this launch profile. The default value is
         * <code>DEACTIVATED</code>, which means that backups are deactivated. To allow backups, set this value to
         * <code>AUTOMATIC</code>.
         * </p>
         * 
         * @param mode
         *        Specifies how artists sessions are backed up.</p>
         *        <p>
         *        Configures backups for streaming sessions launched with this launch profile. The default value is
         *        <code>DEACTIVATED</code>, which means that backups are deactivated. To allow backups, set this value
         *        to <code>AUTOMATIC</code>.
         * @see SessionBackupMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SessionBackupMode
         */
        Builder mode(String mode);

        /**
         * <p>
         * Specifies how artists sessions are backed up.
         * </p>
         * <p>
         * Configures backups for streaming sessions launched with this launch profile. The default value is
         * <code>DEACTIVATED</code>, which means that backups are deactivated. To allow backups, set this value to
         * <code>AUTOMATIC</code>.
         * </p>
         * 
         * @param mode
         *        Specifies how artists sessions are backed up.</p>
         *        <p>
         *        Configures backups for streaming sessions launched with this launch profile. The default value is
         *        <code>DEACTIVATED</code>, which means that backups are deactivated. To allow backups, set this value
         *        to <code>AUTOMATIC</code>.
         * @see SessionBackupMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SessionBackupMode
         */
        Builder mode(SessionBackupMode mode);
    }

    static final class BuilderImpl implements Builder {
        private Integer maxBackupsToRetain;

        private String mode;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamConfigurationSessionBackup model) {
            maxBackupsToRetain(model.maxBackupsToRetain);
            mode(model.mode);
        }

        public final Integer getMaxBackupsToRetain() {
            return maxBackupsToRetain;
        }

        public final void setMaxBackupsToRetain(Integer maxBackupsToRetain) {
            this.maxBackupsToRetain = maxBackupsToRetain;
        }

        @Override
        public final Builder maxBackupsToRetain(Integer maxBackupsToRetain) {
            this.maxBackupsToRetain = maxBackupsToRetain;
            return this;
        }

        public final String getMode() {
            return mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(SessionBackupMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        @Override
        public StreamConfigurationSessionBackup build() {
            return new StreamConfigurationSessionBackup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
