/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.nimble.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetStreamingSessionBackupResponse extends NimbleResponse implements
        ToCopyableBuilder<GetStreamingSessionBackupResponse.Builder, GetStreamingSessionBackupResponse> {
    private static final SdkField<StreamingSessionBackup> STREAMING_SESSION_BACKUP_FIELD = SdkField
            .<StreamingSessionBackup> builder(MarshallingType.SDK_POJO).memberName("streamingSessionBackup")
            .getter(getter(GetStreamingSessionBackupResponse::streamingSessionBackup))
            .setter(setter(Builder::streamingSessionBackup)).constructor(StreamingSessionBackup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamingSessionBackup").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(STREAMING_SESSION_BACKUP_FIELD));

    private final StreamingSessionBackup streamingSessionBackup;

    private GetStreamingSessionBackupResponse(BuilderImpl builder) {
        super(builder);
        this.streamingSessionBackup = builder.streamingSessionBackup;
    }

    /**
     * <p>
     * Information about the streaming session backup.
     * </p>
     * 
     * @return Information about the streaming session backup.
     */
    public final StreamingSessionBackup streamingSessionBackup() {
        return streamingSessionBackup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(streamingSessionBackup());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetStreamingSessionBackupResponse)) {
            return false;
        }
        GetStreamingSessionBackupResponse other = (GetStreamingSessionBackupResponse) obj;
        return Objects.equals(streamingSessionBackup(), other.streamingSessionBackup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetStreamingSessionBackupResponse").add("StreamingSessionBackup", streamingSessionBackup())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "streamingSessionBackup":
            return Optional.ofNullable(clazz.cast(streamingSessionBackup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetStreamingSessionBackupResponse, T> g) {
        return obj -> g.apply((GetStreamingSessionBackupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NimbleResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetStreamingSessionBackupResponse> {
        /**
         * <p>
         * Information about the streaming session backup.
         * </p>
         * 
         * @param streamingSessionBackup
         *        Information about the streaming session backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamingSessionBackup(StreamingSessionBackup streamingSessionBackup);

        /**
         * <p>
         * Information about the streaming session backup.
         * </p>
         * This is a convenience method that creates an instance of the {@link StreamingSessionBackup.Builder} avoiding
         * the need to create one manually via {@link StreamingSessionBackup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StreamingSessionBackup.Builder#build()} is called immediately and
         * its result is passed to {@link #streamingSessionBackup(StreamingSessionBackup)}.
         * 
         * @param streamingSessionBackup
         *        a consumer that will call methods on {@link StreamingSessionBackup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streamingSessionBackup(StreamingSessionBackup)
         */
        default Builder streamingSessionBackup(Consumer<StreamingSessionBackup.Builder> streamingSessionBackup) {
            return streamingSessionBackup(StreamingSessionBackup.builder().applyMutation(streamingSessionBackup).build());
        }
    }

    static final class BuilderImpl extends NimbleResponse.BuilderImpl implements Builder {
        private StreamingSessionBackup streamingSessionBackup;

        private BuilderImpl() {
        }

        private BuilderImpl(GetStreamingSessionBackupResponse model) {
            super(model);
            streamingSessionBackup(model.streamingSessionBackup);
        }

        public final StreamingSessionBackup.Builder getStreamingSessionBackup() {
            return streamingSessionBackup != null ? streamingSessionBackup.toBuilder() : null;
        }

        public final void setStreamingSessionBackup(StreamingSessionBackup.BuilderImpl streamingSessionBackup) {
            this.streamingSessionBackup = streamingSessionBackup != null ? streamingSessionBackup.build() : null;
        }

        @Override
        public final Builder streamingSessionBackup(StreamingSessionBackup streamingSessionBackup) {
            this.streamingSessionBackup = streamingSessionBackup;
            return this;
        }

        @Override
        public GetStreamingSessionBackupResponse build() {
            return new GetStreamingSessionBackupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
