/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.nimble.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateLaunchProfileResponse extends NimbleResponse implements
        ToCopyableBuilder<UpdateLaunchProfileResponse.Builder, UpdateLaunchProfileResponse> {
    private static final SdkField<LaunchProfile> LAUNCH_PROFILE_FIELD = SdkField
            .<LaunchProfile> builder(MarshallingType.SDK_POJO).memberName("launchProfile")
            .getter(getter(UpdateLaunchProfileResponse::launchProfile)).setter(setter(Builder::launchProfile))
            .constructor(LaunchProfile::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchProfile").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAUNCH_PROFILE_FIELD));

    private final LaunchProfile launchProfile;

    private UpdateLaunchProfileResponse(BuilderImpl builder) {
        super(builder);
        this.launchProfile = builder.launchProfile;
    }

    /**
     * <p>
     * The launch profile.
     * </p>
     * 
     * @return The launch profile.
     */
    public final LaunchProfile launchProfile() {
        return launchProfile;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(launchProfile());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLaunchProfileResponse)) {
            return false;
        }
        UpdateLaunchProfileResponse other = (UpdateLaunchProfileResponse) obj;
        return Objects.equals(launchProfile(), other.launchProfile());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateLaunchProfileResponse").add("LaunchProfile", launchProfile()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "launchProfile":
            return Optional.ofNullable(clazz.cast(launchProfile()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateLaunchProfileResponse, T> g) {
        return obj -> g.apply((UpdateLaunchProfileResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NimbleResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateLaunchProfileResponse> {
        /**
         * <p>
         * The launch profile.
         * </p>
         * 
         * @param launchProfile
         *        The launch profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchProfile(LaunchProfile launchProfile);

        /**
         * <p>
         * The launch profile.
         * </p>
         * This is a convenience method that creates an instance of the {@link LaunchProfile.Builder} avoiding the need
         * to create one manually via {@link LaunchProfile#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LaunchProfile.Builder#build()} is called immediately and its
         * result is passed to {@link #launchProfile(LaunchProfile)}.
         * 
         * @param launchProfile
         *        a consumer that will call methods on {@link LaunchProfile.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchProfile(LaunchProfile)
         */
        default Builder launchProfile(Consumer<LaunchProfile.Builder> launchProfile) {
            return launchProfile(LaunchProfile.builder().applyMutation(launchProfile).build());
        }
    }

    static final class BuilderImpl extends NimbleResponse.BuilderImpl implements Builder {
        private LaunchProfile launchProfile;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLaunchProfileResponse model) {
            super(model);
            launchProfile(model.launchProfile);
        }

        public final LaunchProfile.Builder getLaunchProfile() {
            return launchProfile != null ? launchProfile.toBuilder() : null;
        }

        public final void setLaunchProfile(LaunchProfile.BuilderImpl launchProfile) {
            this.launchProfile = launchProfile != null ? launchProfile.build() : null;
        }

        @Override
        public final Builder launchProfile(LaunchProfile launchProfile) {
            this.launchProfile = launchProfile;
            return this;
        }

        @Override
        public UpdateLaunchProfileResponse build() {
            return new UpdateLaunchProfileResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
