/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.nimble.NimbleClient;
import software.amazon.awssdk.services.nimble.internal.UserAgentUtils;
import software.amazon.awssdk.services.nimble.model.Eula;
import software.amazon.awssdk.services.nimble.model.ListEulasRequest;
import software.amazon.awssdk.services.nimble.model.ListEulasResponse;

public class ListEulasIterable
implements SdkIterable<ListEulasResponse> {
    private final NimbleClient client;
    private final ListEulasRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEulasIterable(NimbleClient client, ListEulasRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListEulasResponseFetcher();
    }

    public Iterator<ListEulasResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Eula> eulas() {
        Function<ListEulasResponse, Iterator> getIterator = response -> {
            if (response != null && response.eulas() != null) {
                return response.eulas().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListEulasResponseFetcher
    implements SyncPageFetcher<ListEulasResponse> {
        private ListEulasResponseFetcher() {
        }

        public boolean hasNextPage(ListEulasResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEulasResponse nextPage(ListEulasResponse previousPage) {
            if (previousPage == null) {
                return ListEulasIterable.this.client.listEulas(ListEulasIterable.this.firstRequest);
            }
            return ListEulasIterable.this.client.listEulas((ListEulasRequest)((Object)ListEulasIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

