/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.notifications;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.notifications.model.AccessDeniedException;
import software.amazon.awssdk.services.notifications.model.AssociateChannelRequest;
import software.amazon.awssdk.services.notifications.model.AssociateChannelResponse;
import software.amazon.awssdk.services.notifications.model.AssociateManagedNotificationAccountContactRequest;
import software.amazon.awssdk.services.notifications.model.AssociateManagedNotificationAccountContactResponse;
import software.amazon.awssdk.services.notifications.model.AssociateManagedNotificationAdditionalChannelRequest;
import software.amazon.awssdk.services.notifications.model.AssociateManagedNotificationAdditionalChannelResponse;
import software.amazon.awssdk.services.notifications.model.ConflictException;
import software.amazon.awssdk.services.notifications.model.CreateEventRuleRequest;
import software.amazon.awssdk.services.notifications.model.CreateEventRuleResponse;
import software.amazon.awssdk.services.notifications.model.CreateNotificationConfigurationRequest;
import software.amazon.awssdk.services.notifications.model.CreateNotificationConfigurationResponse;
import software.amazon.awssdk.services.notifications.model.DeleteEventRuleRequest;
import software.amazon.awssdk.services.notifications.model.DeleteEventRuleResponse;
import software.amazon.awssdk.services.notifications.model.DeleteNotificationConfigurationRequest;
import software.amazon.awssdk.services.notifications.model.DeleteNotificationConfigurationResponse;
import software.amazon.awssdk.services.notifications.model.DeregisterNotificationHubRequest;
import software.amazon.awssdk.services.notifications.model.DeregisterNotificationHubResponse;
import software.amazon.awssdk.services.notifications.model.DisableNotificationsAccessForOrganizationRequest;
import software.amazon.awssdk.services.notifications.model.DisableNotificationsAccessForOrganizationResponse;
import software.amazon.awssdk.services.notifications.model.DisassociateChannelRequest;
import software.amazon.awssdk.services.notifications.model.DisassociateChannelResponse;
import software.amazon.awssdk.services.notifications.model.DisassociateManagedNotificationAccountContactRequest;
import software.amazon.awssdk.services.notifications.model.DisassociateManagedNotificationAccountContactResponse;
import software.amazon.awssdk.services.notifications.model.DisassociateManagedNotificationAdditionalChannelRequest;
import software.amazon.awssdk.services.notifications.model.DisassociateManagedNotificationAdditionalChannelResponse;
import software.amazon.awssdk.services.notifications.model.EnableNotificationsAccessForOrganizationRequest;
import software.amazon.awssdk.services.notifications.model.EnableNotificationsAccessForOrganizationResponse;
import software.amazon.awssdk.services.notifications.model.GetEventRuleRequest;
import software.amazon.awssdk.services.notifications.model.GetEventRuleResponse;
import software.amazon.awssdk.services.notifications.model.GetManagedNotificationChildEventRequest;
import software.amazon.awssdk.services.notifications.model.GetManagedNotificationChildEventResponse;
import software.amazon.awssdk.services.notifications.model.GetManagedNotificationConfigurationRequest;
import software.amazon.awssdk.services.notifications.model.GetManagedNotificationConfigurationResponse;
import software.amazon.awssdk.services.notifications.model.GetManagedNotificationEventRequest;
import software.amazon.awssdk.services.notifications.model.GetManagedNotificationEventResponse;
import software.amazon.awssdk.services.notifications.model.GetNotificationConfigurationRequest;
import software.amazon.awssdk.services.notifications.model.GetNotificationConfigurationResponse;
import software.amazon.awssdk.services.notifications.model.GetNotificationEventRequest;
import software.amazon.awssdk.services.notifications.model.GetNotificationEventResponse;
import software.amazon.awssdk.services.notifications.model.GetNotificationsAccessForOrganizationRequest;
import software.amazon.awssdk.services.notifications.model.GetNotificationsAccessForOrganizationResponse;
import software.amazon.awssdk.services.notifications.model.InternalServerException;
import software.amazon.awssdk.services.notifications.model.ListChannelsRequest;
import software.amazon.awssdk.services.notifications.model.ListChannelsResponse;
import software.amazon.awssdk.services.notifications.model.ListEventRulesRequest;
import software.amazon.awssdk.services.notifications.model.ListEventRulesResponse;
import software.amazon.awssdk.services.notifications.model.ListManagedNotificationChannelAssociationsRequest;
import software.amazon.awssdk.services.notifications.model.ListManagedNotificationChannelAssociationsResponse;
import software.amazon.awssdk.services.notifications.model.ListManagedNotificationChildEventsRequest;
import software.amazon.awssdk.services.notifications.model.ListManagedNotificationChildEventsResponse;
import software.amazon.awssdk.services.notifications.model.ListManagedNotificationConfigurationsRequest;
import software.amazon.awssdk.services.notifications.model.ListManagedNotificationConfigurationsResponse;
import software.amazon.awssdk.services.notifications.model.ListManagedNotificationEventsRequest;
import software.amazon.awssdk.services.notifications.model.ListManagedNotificationEventsResponse;
import software.amazon.awssdk.services.notifications.model.ListNotificationConfigurationsRequest;
import software.amazon.awssdk.services.notifications.model.ListNotificationConfigurationsResponse;
import software.amazon.awssdk.services.notifications.model.ListNotificationEventsRequest;
import software.amazon.awssdk.services.notifications.model.ListNotificationEventsResponse;
import software.amazon.awssdk.services.notifications.model.ListNotificationHubsRequest;
import software.amazon.awssdk.services.notifications.model.ListNotificationHubsResponse;
import software.amazon.awssdk.services.notifications.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.notifications.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.notifications.model.NotificationsException;
import software.amazon.awssdk.services.notifications.model.RegisterNotificationHubRequest;
import software.amazon.awssdk.services.notifications.model.RegisterNotificationHubResponse;
import software.amazon.awssdk.services.notifications.model.ResourceNotFoundException;
import software.amazon.awssdk.services.notifications.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.notifications.model.TagResourceRequest;
import software.amazon.awssdk.services.notifications.model.TagResourceResponse;
import software.amazon.awssdk.services.notifications.model.ThrottlingException;
import software.amazon.awssdk.services.notifications.model.UntagResourceRequest;
import software.amazon.awssdk.services.notifications.model.UntagResourceResponse;
import software.amazon.awssdk.services.notifications.model.UpdateEventRuleRequest;
import software.amazon.awssdk.services.notifications.model.UpdateEventRuleResponse;
import software.amazon.awssdk.services.notifications.model.UpdateNotificationConfigurationRequest;
import software.amazon.awssdk.services.notifications.model.UpdateNotificationConfigurationResponse;
import software.amazon.awssdk.services.notifications.model.ValidationException;
import software.amazon.awssdk.services.notifications.paginators.ListChannelsIterable;
import software.amazon.awssdk.services.notifications.paginators.ListEventRulesIterable;
import software.amazon.awssdk.services.notifications.paginators.ListManagedNotificationChannelAssociationsIterable;
import software.amazon.awssdk.services.notifications.paginators.ListManagedNotificationChildEventsIterable;
import software.amazon.awssdk.services.notifications.paginators.ListManagedNotificationConfigurationsIterable;
import software.amazon.awssdk.services.notifications.paginators.ListManagedNotificationEventsIterable;
import software.amazon.awssdk.services.notifications.paginators.ListNotificationConfigurationsIterable;
import software.amazon.awssdk.services.notifications.paginators.ListNotificationEventsIterable;
import software.amazon.awssdk.services.notifications.paginators.ListNotificationHubsIterable;

/**
 * Service client for accessing AWS User Notifications. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * The <i>Amazon Web Services User Notifications API Reference</i> provides descriptions, API request parameters, and
 * the JSON response for each of the User Notification API actions.
 * </p>
 * <p>
 * User Notification control plane APIs are currently available in US East (Virginia) - <code>us-east-1</code>.
 * </p>
 * <p>
 * <a href="https://docs.aws.amazon.com/notifications/latest/APIReference/API_GetNotificationEvent.html">
 * GetNotificationEvent</a> and <a
 * href="https://docs.aws.amazon.com/notifications/latest/APIReference/API_ListNotificationEvents.html"
 * >ListNotificationEvents</a> APIs are currently available in <a
 * href="https://docs.aws.amazon.com/notifications/latest/userguide/supported-regions.html">commercial partition
 * Regions</a> and only return notifications stored in the same Region in which they're called.
 * </p>
 * <p>
 * The User Notifications console can only be used in US East (Virginia). Your data however, is stored in each Region
 * chosen as a <a href="https://docs.aws.amazon.com/notifications/latest/userguide/notification-hubs.html">notification
 * hub</a> in addition to US East (Virginia).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface NotificationsClient extends AwsClient {
    String SERVICE_NAME = "notifications";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "notifications";

    /**
     * <p>
     * Associates a delivery <a
     * href="https://docs.aws.amazon.com/notifications/latest/userguide/managing-delivery-channels.html">Channel</a>
     * with a particular <code>NotificationConfiguration</code>. Supported Channels include Chatbot, the Console Mobile
     * Application, and emails (notifications-contacts).
     * </p>
     *
     * @param associateChannelRequest
     * @return Result of the AssociateChannel operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.AssociateChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/AssociateChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateChannelResponse associateChannel(AssociateChannelRequest associateChannelRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException, InternalServerException,
            ThrottlingException, ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            NotificationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a delivery <a
     * href="https://docs.aws.amazon.com/notifications/latest/userguide/managing-delivery-channels.html">Channel</a>
     * with a particular <code>NotificationConfiguration</code>. Supported Channels include Chatbot, the Console Mobile
     * Application, and emails (notifications-contacts).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateChannelRequest.Builder} avoiding the need
     * to create one manually via {@link AssociateChannelRequest#builder()}
     * </p>
     *
     * @param associateChannelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.AssociateChannelRequest.Builder} to create a
     *        request.
     * @return Result of the AssociateChannel operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.AssociateChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/AssociateChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateChannelResponse associateChannel(Consumer<AssociateChannelRequest.Builder> associateChannelRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException, InternalServerException,
            ThrottlingException, ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            NotificationsException {
        return associateChannel(AssociateChannelRequest.builder().applyMutation(associateChannelRequest).build());
    }

    /**
     * <p>
     * Associates an Account Contact with a particular <code>ManagedNotificationConfiguration</code>.
     * </p>
     *
     * @param associateManagedNotificationAccountContactRequest
     * @return Result of the AssociateManagedNotificationAccountContact operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.AssociateManagedNotificationAccountContact
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/AssociateManagedNotificationAccountContact"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateManagedNotificationAccountContactResponse associateManagedNotificationAccountContact(
            AssociateManagedNotificationAccountContactRequest associateManagedNotificationAccountContactRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException, InternalServerException,
            ThrottlingException, ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            NotificationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates an Account Contact with a particular <code>ManagedNotificationConfiguration</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link AssociateManagedNotificationAccountContactRequest.Builder} avoiding the need to create one manually via
     * {@link AssociateManagedNotificationAccountContactRequest#builder()}
     * </p>
     *
     * @param associateManagedNotificationAccountContactRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.AssociateManagedNotificationAccountContactRequest.Builder}
     *        to create a request.
     * @return Result of the AssociateManagedNotificationAccountContact operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.AssociateManagedNotificationAccountContact
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/AssociateManagedNotificationAccountContact"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateManagedNotificationAccountContactResponse associateManagedNotificationAccountContact(
            Consumer<AssociateManagedNotificationAccountContactRequest.Builder> associateManagedNotificationAccountContactRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException, InternalServerException,
            ThrottlingException, ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            NotificationsException {
        return associateManagedNotificationAccountContact(AssociateManagedNotificationAccountContactRequest.builder()
                .applyMutation(associateManagedNotificationAccountContactRequest).build());
    }

    /**
     * <p>
     * Associates an additional Channel with a particular <code>ManagedNotificationConfiguration</code>.
     * </p>
     * <p>
     * Supported Channels include Chatbot, the Console Mobile Application, and emails (notifications-contacts).
     * </p>
     *
     * @param associateManagedNotificationAdditionalChannelRequest
     * @return Result of the AssociateManagedNotificationAdditionalChannel operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.AssociateManagedNotificationAdditionalChannel
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/AssociateManagedNotificationAdditionalChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateManagedNotificationAdditionalChannelResponse associateManagedNotificationAdditionalChannel(
            AssociateManagedNotificationAdditionalChannelRequest associateManagedNotificationAdditionalChannelRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException, InternalServerException,
            ThrottlingException, ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            NotificationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates an additional Channel with a particular <code>ManagedNotificationConfiguration</code>.
     * </p>
     * <p>
     * Supported Channels include Chatbot, the Console Mobile Application, and emails (notifications-contacts).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link AssociateManagedNotificationAdditionalChannelRequest.Builder} avoiding the need to create one manually via
     * {@link AssociateManagedNotificationAdditionalChannelRequest#builder()}
     * </p>
     *
     * @param associateManagedNotificationAdditionalChannelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.AssociateManagedNotificationAdditionalChannelRequest.Builder}
     *        to create a request.
     * @return Result of the AssociateManagedNotificationAdditionalChannel operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.AssociateManagedNotificationAdditionalChannel
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/AssociateManagedNotificationAdditionalChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateManagedNotificationAdditionalChannelResponse associateManagedNotificationAdditionalChannel(
            Consumer<AssociateManagedNotificationAdditionalChannelRequest.Builder> associateManagedNotificationAdditionalChannelRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException, InternalServerException,
            ThrottlingException, ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            NotificationsException {
        return associateManagedNotificationAdditionalChannel(AssociateManagedNotificationAdditionalChannelRequest.builder()
                .applyMutation(associateManagedNotificationAdditionalChannelRequest).build());
    }

    /**
     * <p>
     * Creates an <a href="https://docs.aws.amazon.com/notifications/latest/userguide/glossary.html">
     * <code>EventRule</code> </a> that is associated with a specified <code>NotificationConfiguration</code>.
     * </p>
     *
     * @param createEventRuleRequest
     * @return Result of the CreateEventRule operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.CreateEventRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/CreateEventRule" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateEventRuleResponse createEventRule(CreateEventRuleRequest createEventRuleRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException, InternalServerException,
            ThrottlingException, ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            NotificationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an <a href="https://docs.aws.amazon.com/notifications/latest/userguide/glossary.html">
     * <code>EventRule</code> </a> that is associated with a specified <code>NotificationConfiguration</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEventRuleRequest.Builder} avoiding the need
     * to create one manually via {@link CreateEventRuleRequest#builder()}
     * </p>
     *
     * @param createEventRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.CreateEventRuleRequest.Builder} to create a
     *        request.
     * @return Result of the CreateEventRule operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.CreateEventRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/CreateEventRule" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateEventRuleResponse createEventRule(Consumer<CreateEventRuleRequest.Builder> createEventRuleRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException, InternalServerException,
            ThrottlingException, ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            NotificationsException {
        return createEventRule(CreateEventRuleRequest.builder().applyMutation(createEventRuleRequest).build());
    }

    /**
     * <p>
     * Creates a new <code>NotificationConfiguration</code>.
     * </p>
     *
     * @param createNotificationConfigurationRequest
     * @return Result of the CreateNotificationConfiguration operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.CreateNotificationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/CreateNotificationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateNotificationConfigurationResponse createNotificationConfiguration(
            CreateNotificationConfigurationRequest createNotificationConfigurationRequest) throws ServiceQuotaExceededException,
            AccessDeniedException, ValidationException, InternalServerException, ThrottlingException, ConflictException,
            AwsServiceException, SdkClientException, NotificationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new <code>NotificationConfiguration</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateNotificationConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link CreateNotificationConfigurationRequest#builder()}
     * </p>
     *
     * @param createNotificationConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.CreateNotificationConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the CreateNotificationConfiguration operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.CreateNotificationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/CreateNotificationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateNotificationConfigurationResponse createNotificationConfiguration(
            Consumer<CreateNotificationConfigurationRequest.Builder> createNotificationConfigurationRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException, InternalServerException,
            ThrottlingException, ConflictException, AwsServiceException, SdkClientException, NotificationsException {
        return createNotificationConfiguration(CreateNotificationConfigurationRequest.builder()
                .applyMutation(createNotificationConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes an <code>EventRule</code>.
     * </p>
     *
     * @param deleteEventRuleRequest
     * @return Result of the DeleteEventRule operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.DeleteEventRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/DeleteEventRule" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteEventRuleResponse deleteEventRule(DeleteEventRuleRequest deleteEventRuleRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ThrottlingException, ConflictException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, NotificationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an <code>EventRule</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEventRuleRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteEventRuleRequest#builder()}
     * </p>
     *
     * @param deleteEventRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.DeleteEventRuleRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteEventRule operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.DeleteEventRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/DeleteEventRule" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteEventRuleResponse deleteEventRule(Consumer<DeleteEventRuleRequest.Builder> deleteEventRuleRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ThrottlingException, ConflictException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, NotificationsException {
        return deleteEventRule(DeleteEventRuleRequest.builder().applyMutation(deleteEventRuleRequest).build());
    }

    /**
     * <p>
     * Deletes a <code>NotificationConfiguration</code>.
     * </p>
     *
     * @param deleteNotificationConfigurationRequest
     * @return Result of the DeleteNotificationConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.DeleteNotificationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/DeleteNotificationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteNotificationConfigurationResponse deleteNotificationConfiguration(
            DeleteNotificationConfigurationRequest deleteNotificationConfigurationRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ThrottlingException, ConflictException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, NotificationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a <code>NotificationConfiguration</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteNotificationConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteNotificationConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteNotificationConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.DeleteNotificationConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteNotificationConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.DeleteNotificationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/DeleteNotificationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteNotificationConfigurationResponse deleteNotificationConfiguration(
            Consumer<DeleteNotificationConfigurationRequest.Builder> deleteNotificationConfigurationRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ThrottlingException, ConflictException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, NotificationsException {
        return deleteNotificationConfiguration(DeleteNotificationConfigurationRequest.builder()
                .applyMutation(deleteNotificationConfigurationRequest).build());
    }

    /**
     * <p>
     * Deregisters a <code>NotificationConfiguration</code> in the specified Region.
     * </p>
     * <note>
     * <p>
     * You can't deregister the last <code>NotificationHub</code> in the account. <code>NotificationEvents</code> stored
     * in the deregistered <code>NotificationConfiguration</code> are no longer be visible. Recreating a new
     * <code>NotificationConfiguration</code> in the same Region restores access to those
     * <code>NotificationEvents</code>.
     * </p>
     * </note>
     *
     * @param deregisterNotificationHubRequest
     * @return Result of the DeregisterNotificationHub operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.DeregisterNotificationHub
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/DeregisterNotificationHub"
     *      target="_top">AWS API Documentation</a>
     */
    default DeregisterNotificationHubResponse deregisterNotificationHub(
            DeregisterNotificationHubRequest deregisterNotificationHubRequest) throws AccessDeniedException, ValidationException,
            InternalServerException, ThrottlingException, ConflictException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, NotificationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deregisters a <code>NotificationConfiguration</code> in the specified Region.
     * </p>
     * <note>
     * <p>
     * You can't deregister the last <code>NotificationHub</code> in the account. <code>NotificationEvents</code> stored
     * in the deregistered <code>NotificationConfiguration</code> are no longer be visible. Recreating a new
     * <code>NotificationConfiguration</code> in the same Region restores access to those
     * <code>NotificationEvents</code>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeregisterNotificationHubRequest.Builder} avoiding
     * the need to create one manually via {@link DeregisterNotificationHubRequest#builder()}
     * </p>
     *
     * @param deregisterNotificationHubRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.DeregisterNotificationHubRequest.Builder} to
     *        create a request.
     * @return Result of the DeregisterNotificationHub operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.DeregisterNotificationHub
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/DeregisterNotificationHub"
     *      target="_top">AWS API Documentation</a>
     */
    default DeregisterNotificationHubResponse deregisterNotificationHub(
            Consumer<DeregisterNotificationHubRequest.Builder> deregisterNotificationHubRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ThrottlingException, ConflictException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, NotificationsException {
        return deregisterNotificationHub(DeregisterNotificationHubRequest.builder()
                .applyMutation(deregisterNotificationHubRequest).build());
    }

    /**
     * <p>
     * Disables service trust between User Notifications and Amazon Web Services Organizations.
     * </p>
     *
     * @param disableNotificationsAccessForOrganizationRequest
     * @return Result of the DisableNotificationsAccessForOrganization operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.DisableNotificationsAccessForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/DisableNotificationsAccessForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default DisableNotificationsAccessForOrganizationResponse disableNotificationsAccessForOrganization(
            DisableNotificationsAccessForOrganizationRequest disableNotificationsAccessForOrganizationRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException, InternalServerException,
            ThrottlingException, ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            NotificationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables service trust between User Notifications and Amazon Web Services Organizations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DisableNotificationsAccessForOrganizationRequest.Builder} avoiding the need to create one manually via
     * {@link DisableNotificationsAccessForOrganizationRequest#builder()}
     * </p>
     *
     * @param disableNotificationsAccessForOrganizationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.DisableNotificationsAccessForOrganizationRequest.Builder}
     *        to create a request.
     * @return Result of the DisableNotificationsAccessForOrganization operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.DisableNotificationsAccessForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/DisableNotificationsAccessForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default DisableNotificationsAccessForOrganizationResponse disableNotificationsAccessForOrganization(
            Consumer<DisableNotificationsAccessForOrganizationRequest.Builder> disableNotificationsAccessForOrganizationRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException, InternalServerException,
            ThrottlingException, ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            NotificationsException {
        return disableNotificationsAccessForOrganization(DisableNotificationsAccessForOrganizationRequest.builder()
                .applyMutation(disableNotificationsAccessForOrganizationRequest).build());
    }

    /**
     * <p>
     * Disassociates a Channel from a specified <code>NotificationConfiguration</code>. Supported Channels include
     * Chatbot, the Console Mobile Application, and emails (notifications-contacts).
     * </p>
     *
     * @param disassociateChannelRequest
     * @return Result of the DisassociateChannel operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.DisassociateChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/DisassociateChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateChannelResponse disassociateChannel(DisassociateChannelRequest disassociateChannelRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, NotificationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a Channel from a specified <code>NotificationConfiguration</code>. Supported Channels include
     * Chatbot, the Console Mobile Application, and emails (notifications-contacts).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateChannelRequest.Builder} avoiding the
     * need to create one manually via {@link DisassociateChannelRequest#builder()}
     * </p>
     *
     * @param disassociateChannelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.DisassociateChannelRequest.Builder} to create a
     *        request.
     * @return Result of the DisassociateChannel operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.DisassociateChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/DisassociateChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateChannelResponse disassociateChannel(
            Consumer<DisassociateChannelRequest.Builder> disassociateChannelRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ThrottlingException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, NotificationsException {
        return disassociateChannel(DisassociateChannelRequest.builder().applyMutation(disassociateChannelRequest).build());
    }

    /**
     * <p>
     * Disassociates an Account Contact with a particular <code>ManagedNotificationConfiguration</code>.
     * </p>
     *
     * @param disassociateManagedNotificationAccountContactRequest
     * @return Result of the DisassociateManagedNotificationAccountContact operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.DisassociateManagedNotificationAccountContact
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/DisassociateManagedNotificationAccountContact"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateManagedNotificationAccountContactResponse disassociateManagedNotificationAccountContact(
            DisassociateManagedNotificationAccountContactRequest disassociateManagedNotificationAccountContactRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ThrottlingException, ConflictException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, NotificationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates an Account Contact with a particular <code>ManagedNotificationConfiguration</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DisassociateManagedNotificationAccountContactRequest.Builder} avoiding the need to create one manually via
     * {@link DisassociateManagedNotificationAccountContactRequest#builder()}
     * </p>
     *
     * @param disassociateManagedNotificationAccountContactRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.DisassociateManagedNotificationAccountContactRequest.Builder}
     *        to create a request.
     * @return Result of the DisassociateManagedNotificationAccountContact operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.DisassociateManagedNotificationAccountContact
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/DisassociateManagedNotificationAccountContact"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateManagedNotificationAccountContactResponse disassociateManagedNotificationAccountContact(
            Consumer<DisassociateManagedNotificationAccountContactRequest.Builder> disassociateManagedNotificationAccountContactRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ThrottlingException, ConflictException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, NotificationsException {
        return disassociateManagedNotificationAccountContact(DisassociateManagedNotificationAccountContactRequest.builder()
                .applyMutation(disassociateManagedNotificationAccountContactRequest).build());
    }

    /**
     * <p>
     * Disassociates an additional Channel from a particular <code>ManagedNotificationConfiguration</code>.
     * </p>
     * <p>
     * Supported Channels include Chatbot, the Console Mobile Application, and emails (notifications-contacts).
     * </p>
     *
     * @param disassociateManagedNotificationAdditionalChannelRequest
     * @return Result of the DisassociateManagedNotificationAdditionalChannel operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.DisassociateManagedNotificationAdditionalChannel
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/DisassociateManagedNotificationAdditionalChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateManagedNotificationAdditionalChannelResponse disassociateManagedNotificationAdditionalChannel(
            DisassociateManagedNotificationAdditionalChannelRequest disassociateManagedNotificationAdditionalChannelRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, NotificationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates an additional Channel from a particular <code>ManagedNotificationConfiguration</code>.
     * </p>
     * <p>
     * Supported Channels include Chatbot, the Console Mobile Application, and emails (notifications-contacts).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DisassociateManagedNotificationAdditionalChannelRequest.Builder} avoiding the need to create one manually
     * via {@link DisassociateManagedNotificationAdditionalChannelRequest#builder()}
     * </p>
     *
     * @param disassociateManagedNotificationAdditionalChannelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.DisassociateManagedNotificationAdditionalChannelRequest.Builder}
     *        to create a request.
     * @return Result of the DisassociateManagedNotificationAdditionalChannel operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.DisassociateManagedNotificationAdditionalChannel
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/DisassociateManagedNotificationAdditionalChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateManagedNotificationAdditionalChannelResponse disassociateManagedNotificationAdditionalChannel(
            Consumer<DisassociateManagedNotificationAdditionalChannelRequest.Builder> disassociateManagedNotificationAdditionalChannelRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, NotificationsException {
        return disassociateManagedNotificationAdditionalChannel(DisassociateManagedNotificationAdditionalChannelRequest.builder()
                .applyMutation(disassociateManagedNotificationAdditionalChannelRequest).build());
    }

    /**
     * <p>
     * Enables service trust between User Notifications and Amazon Web Services Organizations.
     * </p>
     *
     * @param enableNotificationsAccessForOrganizationRequest
     * @return Result of the EnableNotificationsAccessForOrganization operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.EnableNotificationsAccessForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/EnableNotificationsAccessForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default EnableNotificationsAccessForOrganizationResponse enableNotificationsAccessForOrganization(
            EnableNotificationsAccessForOrganizationRequest enableNotificationsAccessForOrganizationRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException, InternalServerException,
            ThrottlingException, ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            NotificationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables service trust between User Notifications and Amazon Web Services Organizations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link EnableNotificationsAccessForOrganizationRequest.Builder} avoiding the need to create one manually via
     * {@link EnableNotificationsAccessForOrganizationRequest#builder()}
     * </p>
     *
     * @param enableNotificationsAccessForOrganizationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.EnableNotificationsAccessForOrganizationRequest.Builder}
     *        to create a request.
     * @return Result of the EnableNotificationsAccessForOrganization operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.EnableNotificationsAccessForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/EnableNotificationsAccessForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default EnableNotificationsAccessForOrganizationResponse enableNotificationsAccessForOrganization(
            Consumer<EnableNotificationsAccessForOrganizationRequest.Builder> enableNotificationsAccessForOrganizationRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException, InternalServerException,
            ThrottlingException, ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            NotificationsException {
        return enableNotificationsAccessForOrganization(EnableNotificationsAccessForOrganizationRequest.builder()
                .applyMutation(enableNotificationsAccessForOrganizationRequest).build());
    }

    /**
     * <p>
     * Returns a specified <code>EventRule</code>.
     * </p>
     *
     * @param getEventRuleRequest
     * @return Result of the GetEventRule operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.GetEventRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/GetEventRule" target="_top">AWS
     *      API Documentation</a>
     */
    default GetEventRuleResponse getEventRule(GetEventRuleRequest getEventRuleRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ThrottlingException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, NotificationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a specified <code>EventRule</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEventRuleRequest.Builder} avoiding the need to
     * create one manually via {@link GetEventRuleRequest#builder()}
     * </p>
     *
     * @param getEventRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.GetEventRuleRequest.Builder} to create a
     *        request.
     * @return Result of the GetEventRule operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.GetEventRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/GetEventRule" target="_top">AWS
     *      API Documentation</a>
     */
    default GetEventRuleResponse getEventRule(Consumer<GetEventRuleRequest.Builder> getEventRuleRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, NotificationsException {
        return getEventRule(GetEventRuleRequest.builder().applyMutation(getEventRuleRequest).build());
    }

    /**
     * <p>
     * Returns the child event of a specific given <code>ManagedNotificationEvent</code>.
     * </p>
     *
     * @param getManagedNotificationChildEventRequest
     * @return Result of the GetManagedNotificationChildEvent operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.GetManagedNotificationChildEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/GetManagedNotificationChildEvent"
     *      target="_top">AWS API Documentation</a>
     */
    default GetManagedNotificationChildEventResponse getManagedNotificationChildEvent(
            GetManagedNotificationChildEventRequest getManagedNotificationChildEventRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ThrottlingException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, NotificationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the child event of a specific given <code>ManagedNotificationEvent</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetManagedNotificationChildEventRequest.Builder}
     * avoiding the need to create one manually via {@link GetManagedNotificationChildEventRequest#builder()}
     * </p>
     *
     * @param getManagedNotificationChildEventRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.GetManagedNotificationChildEventRequest.Builder}
     *        to create a request.
     * @return Result of the GetManagedNotificationChildEvent operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.GetManagedNotificationChildEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/GetManagedNotificationChildEvent"
     *      target="_top">AWS API Documentation</a>
     */
    default GetManagedNotificationChildEventResponse getManagedNotificationChildEvent(
            Consumer<GetManagedNotificationChildEventRequest.Builder> getManagedNotificationChildEventRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, NotificationsException {
        return getManagedNotificationChildEvent(GetManagedNotificationChildEventRequest.builder()
                .applyMutation(getManagedNotificationChildEventRequest).build());
    }

    /**
     * <p>
     * Returns a specified <code>ManagedNotificationConfiguration</code>.
     * </p>
     *
     * @param getManagedNotificationConfigurationRequest
     * @return Result of the GetManagedNotificationConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.GetManagedNotificationConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/GetManagedNotificationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetManagedNotificationConfigurationResponse getManagedNotificationConfiguration(
            GetManagedNotificationConfigurationRequest getManagedNotificationConfigurationRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ThrottlingException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, NotificationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a specified <code>ManagedNotificationConfiguration</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetManagedNotificationConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link GetManagedNotificationConfigurationRequest#builder()}
     * </p>
     *
     * @param getManagedNotificationConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.GetManagedNotificationConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the GetManagedNotificationConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.GetManagedNotificationConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/GetManagedNotificationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetManagedNotificationConfigurationResponse getManagedNotificationConfiguration(
            Consumer<GetManagedNotificationConfigurationRequest.Builder> getManagedNotificationConfigurationRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, NotificationsException {
        return getManagedNotificationConfiguration(GetManagedNotificationConfigurationRequest.builder()
                .applyMutation(getManagedNotificationConfigurationRequest).build());
    }

    /**
     * <p>
     * Returns a specified <code>ManagedNotificationEvent</code>.
     * </p>
     *
     * @param getManagedNotificationEventRequest
     * @return Result of the GetManagedNotificationEvent operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.GetManagedNotificationEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/GetManagedNotificationEvent"
     *      target="_top">AWS API Documentation</a>
     */
    default GetManagedNotificationEventResponse getManagedNotificationEvent(
            GetManagedNotificationEventRequest getManagedNotificationEventRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ThrottlingException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, NotificationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a specified <code>ManagedNotificationEvent</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetManagedNotificationEventRequest.Builder}
     * avoiding the need to create one manually via {@link GetManagedNotificationEventRequest#builder()}
     * </p>
     *
     * @param getManagedNotificationEventRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.GetManagedNotificationEventRequest.Builder} to
     *        create a request.
     * @return Result of the GetManagedNotificationEvent operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.GetManagedNotificationEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/GetManagedNotificationEvent"
     *      target="_top">AWS API Documentation</a>
     */
    default GetManagedNotificationEventResponse getManagedNotificationEvent(
            Consumer<GetManagedNotificationEventRequest.Builder> getManagedNotificationEventRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, NotificationsException {
        return getManagedNotificationEvent(GetManagedNotificationEventRequest.builder()
                .applyMutation(getManagedNotificationEventRequest).build());
    }

    /**
     * <p>
     * Returns a specified <code>NotificationConfiguration</code>.
     * </p>
     *
     * @param getNotificationConfigurationRequest
     * @return Result of the GetNotificationConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.GetNotificationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/GetNotificationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetNotificationConfigurationResponse getNotificationConfiguration(
            GetNotificationConfigurationRequest getNotificationConfigurationRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ThrottlingException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, NotificationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a specified <code>NotificationConfiguration</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetNotificationConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link GetNotificationConfigurationRequest#builder()}
     * </p>
     *
     * @param getNotificationConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.GetNotificationConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the GetNotificationConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.GetNotificationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/GetNotificationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetNotificationConfigurationResponse getNotificationConfiguration(
            Consumer<GetNotificationConfigurationRequest.Builder> getNotificationConfigurationRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, NotificationsException {
        return getNotificationConfiguration(GetNotificationConfigurationRequest.builder()
                .applyMutation(getNotificationConfigurationRequest).build());
    }

    /**
     * <p>
     * Returns a specified <code>NotificationEvent</code>.
     * </p>
     * <important>
     * <p>
     * User Notifications stores notifications in the individual Regions you register as notification hubs and the
     * Region of the source event rule. <code>GetNotificationEvent</code> only returns notifications stored in the same
     * Region in which the action is called. User Notifications doesn't backfill notifications to new Regions selected
     * as notification hubs. For this reason, we recommend that you make calls in your oldest registered notification
     * hub. For more information, see <a
     * href="https://docs.aws.amazon.com/notifications/latest/userguide/notification-hubs.html">Notification hubs</a> in
     * the <i>Amazon Web Services User Notifications User Guide</i>.
     * </p>
     * </important>
     *
     * @param getNotificationEventRequest
     * @return Result of the GetNotificationEvent operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.GetNotificationEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/GetNotificationEvent"
     *      target="_top">AWS API Documentation</a>
     */
    default GetNotificationEventResponse getNotificationEvent(GetNotificationEventRequest getNotificationEventRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, NotificationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a specified <code>NotificationEvent</code>.
     * </p>
     * <important>
     * <p>
     * User Notifications stores notifications in the individual Regions you register as notification hubs and the
     * Region of the source event rule. <code>GetNotificationEvent</code> only returns notifications stored in the same
     * Region in which the action is called. User Notifications doesn't backfill notifications to new Regions selected
     * as notification hubs. For this reason, we recommend that you make calls in your oldest registered notification
     * hub. For more information, see <a
     * href="https://docs.aws.amazon.com/notifications/latest/userguide/notification-hubs.html">Notification hubs</a> in
     * the <i>Amazon Web Services User Notifications User Guide</i>.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetNotificationEventRequest.Builder} avoiding the
     * need to create one manually via {@link GetNotificationEventRequest#builder()}
     * </p>
     *
     * @param getNotificationEventRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.GetNotificationEventRequest.Builder} to create
     *        a request.
     * @return Result of the GetNotificationEvent operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.GetNotificationEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/GetNotificationEvent"
     *      target="_top">AWS API Documentation</a>
     */
    default GetNotificationEventResponse getNotificationEvent(
            Consumer<GetNotificationEventRequest.Builder> getNotificationEventRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ThrottlingException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, NotificationsException {
        return getNotificationEvent(GetNotificationEventRequest.builder().applyMutation(getNotificationEventRequest).build());
    }

    /**
     * <p>
     * Returns the AccessStatus of Service Trust Enablement for User Notifications and Amazon Web Services
     * Organizations.
     * </p>
     *
     * @param getNotificationsAccessForOrganizationRequest
     * @return Result of the GetNotificationsAccessForOrganization operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.GetNotificationsAccessForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/GetNotificationsAccessForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default GetNotificationsAccessForOrganizationResponse getNotificationsAccessForOrganization(
            GetNotificationsAccessForOrganizationRequest getNotificationsAccessForOrganizationRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, NotificationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the AccessStatus of Service Trust Enablement for User Notifications and Amazon Web Services
     * Organizations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetNotificationsAccessForOrganizationRequest.Builder} avoiding the need to create one manually via
     * {@link GetNotificationsAccessForOrganizationRequest#builder()}
     * </p>
     *
     * @param getNotificationsAccessForOrganizationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.GetNotificationsAccessForOrganizationRequest.Builder}
     *        to create a request.
     * @return Result of the GetNotificationsAccessForOrganization operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.GetNotificationsAccessForOrganization
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/GetNotificationsAccessForOrganization"
     *      target="_top">AWS API Documentation</a>
     */
    default GetNotificationsAccessForOrganizationResponse getNotificationsAccessForOrganization(
            Consumer<GetNotificationsAccessForOrganizationRequest.Builder> getNotificationsAccessForOrganizationRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, NotificationsException {
        return getNotificationsAccessForOrganization(GetNotificationsAccessForOrganizationRequest.builder()
                .applyMutation(getNotificationsAccessForOrganizationRequest).build());
    }

    /**
     * <p>
     * Returns a list of Channels for a <code>NotificationConfiguration</code>.
     * </p>
     *
     * @param listChannelsRequest
     * @return Result of the ListChannels operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.ListChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListChannels" target="_top">AWS
     *      API Documentation</a>
     */
    default ListChannelsResponse listChannels(ListChannelsRequest listChannelsRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ThrottlingException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, NotificationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of Channels for a <code>NotificationConfiguration</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListChannelsRequest.Builder} avoiding the need to
     * create one manually via {@link ListChannelsRequest#builder()}
     * </p>
     *
     * @param listChannelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.ListChannelsRequest.Builder} to create a
     *        request.
     * @return Result of the ListChannels operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.ListChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListChannels" target="_top">AWS
     *      API Documentation</a>
     */
    default ListChannelsResponse listChannels(Consumer<ListChannelsRequest.Builder> listChannelsRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, NotificationsException {
        return listChannels(ListChannelsRequest.builder().applyMutation(listChannelsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listChannels(software.amazon.awssdk.services.notifications.model.ListChannelsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListChannelsIterable responses = client.listChannelsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.notifications.paginators.ListChannelsIterable responses = client
     *             .listChannelsPaginator(request);
     *     for (software.amazon.awssdk.services.notifications.model.ListChannelsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListChannelsIterable responses = client.listChannelsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listChannels(software.amazon.awssdk.services.notifications.model.ListChannelsRequest)} operation.</b>
     * </p>
     *
     * @param listChannelsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.ListChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListChannels" target="_top">AWS
     *      API Documentation</a>
     */
    default ListChannelsIterable listChannelsPaginator(ListChannelsRequest listChannelsRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ThrottlingException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, NotificationsException {
        return new ListChannelsIterable(this, listChannelsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listChannels(software.amazon.awssdk.services.notifications.model.ListChannelsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListChannelsIterable responses = client.listChannelsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.notifications.paginators.ListChannelsIterable responses = client
     *             .listChannelsPaginator(request);
     *     for (software.amazon.awssdk.services.notifications.model.ListChannelsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListChannelsIterable responses = client.listChannelsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listChannels(software.amazon.awssdk.services.notifications.model.ListChannelsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListChannelsRequest.Builder} avoiding the need to
     * create one manually via {@link ListChannelsRequest#builder()}
     * </p>
     *
     * @param listChannelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.ListChannelsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.ListChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListChannels" target="_top">AWS
     *      API Documentation</a>
     */
    default ListChannelsIterable listChannelsPaginator(Consumer<ListChannelsRequest.Builder> listChannelsRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, NotificationsException {
        return listChannelsPaginator(ListChannelsRequest.builder().applyMutation(listChannelsRequest).build());
    }

    /**
     * <p>
     * Returns a list of <code>EventRules</code> according to specified filters, in reverse chronological order (newest
     * first).
     * </p>
     *
     * @param listEventRulesRequest
     * @return Result of the ListEventRules operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.ListEventRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListEventRules" target="_top">AWS
     *      API Documentation</a>
     */
    default ListEventRulesResponse listEventRules(ListEventRulesRequest listEventRulesRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ThrottlingException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, NotificationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of <code>EventRules</code> according to specified filters, in reverse chronological order (newest
     * first).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventRulesRequest.Builder} avoiding the need to
     * create one manually via {@link ListEventRulesRequest#builder()}
     * </p>
     *
     * @param listEventRulesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.ListEventRulesRequest.Builder} to create a
     *        request.
     * @return Result of the ListEventRules operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.ListEventRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListEventRules" target="_top">AWS
     *      API Documentation</a>
     */
    default ListEventRulesResponse listEventRules(Consumer<ListEventRulesRequest.Builder> listEventRulesRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, NotificationsException {
        return listEventRules(ListEventRulesRequest.builder().applyMutation(listEventRulesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEventRules(software.amazon.awssdk.services.notifications.model.ListEventRulesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListEventRulesIterable responses = client.listEventRulesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.notifications.paginators.ListEventRulesIterable responses = client
     *             .listEventRulesPaginator(request);
     *     for (software.amazon.awssdk.services.notifications.model.ListEventRulesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListEventRulesIterable responses = client.listEventRulesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventRules(software.amazon.awssdk.services.notifications.model.ListEventRulesRequest)} operation.</b>
     * </p>
     *
     * @param listEventRulesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.ListEventRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListEventRules" target="_top">AWS
     *      API Documentation</a>
     */
    default ListEventRulesIterable listEventRulesPaginator(ListEventRulesRequest listEventRulesRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, NotificationsException {
        return new ListEventRulesIterable(this, listEventRulesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEventRules(software.amazon.awssdk.services.notifications.model.ListEventRulesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListEventRulesIterable responses = client.listEventRulesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.notifications.paginators.ListEventRulesIterable responses = client
     *             .listEventRulesPaginator(request);
     *     for (software.amazon.awssdk.services.notifications.model.ListEventRulesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListEventRulesIterable responses = client.listEventRulesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventRules(software.amazon.awssdk.services.notifications.model.ListEventRulesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventRulesRequest.Builder} avoiding the need to
     * create one manually via {@link ListEventRulesRequest#builder()}
     * </p>
     *
     * @param listEventRulesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.ListEventRulesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.ListEventRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListEventRules" target="_top">AWS
     *      API Documentation</a>
     */
    default ListEventRulesIterable listEventRulesPaginator(Consumer<ListEventRulesRequest.Builder> listEventRulesRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, NotificationsException {
        return listEventRulesPaginator(ListEventRulesRequest.builder().applyMutation(listEventRulesRequest).build());
    }

    /**
     * <p>
     * Returns a list of Account contacts and Channels associated with a <code>ManagedNotificationConfiguration</code>,
     * in paginated format.
     * </p>
     *
     * @param listManagedNotificationChannelAssociationsRequest
     * @return Result of the ListManagedNotificationChannelAssociations operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.ListManagedNotificationChannelAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListManagedNotificationChannelAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListManagedNotificationChannelAssociationsResponse listManagedNotificationChannelAssociations(
            ListManagedNotificationChannelAssociationsRequest listManagedNotificationChannelAssociationsRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, NotificationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of Account contacts and Channels associated with a <code>ManagedNotificationConfiguration</code>,
     * in paginated format.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListManagedNotificationChannelAssociationsRequest.Builder} avoiding the need to create one manually via
     * {@link ListManagedNotificationChannelAssociationsRequest#builder()}
     * </p>
     *
     * @param listManagedNotificationChannelAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.ListManagedNotificationChannelAssociationsRequest.Builder}
     *        to create a request.
     * @return Result of the ListManagedNotificationChannelAssociations operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.ListManagedNotificationChannelAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListManagedNotificationChannelAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListManagedNotificationChannelAssociationsResponse listManagedNotificationChannelAssociations(
            Consumer<ListManagedNotificationChannelAssociationsRequest.Builder> listManagedNotificationChannelAssociationsRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, NotificationsException {
        return listManagedNotificationChannelAssociations(ListManagedNotificationChannelAssociationsRequest.builder()
                .applyMutation(listManagedNotificationChannelAssociationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listManagedNotificationChannelAssociations(software.amazon.awssdk.services.notifications.model.ListManagedNotificationChannelAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListManagedNotificationChannelAssociationsIterable responses = client.listManagedNotificationChannelAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.notifications.paginators.ListManagedNotificationChannelAssociationsIterable responses = client
     *             .listManagedNotificationChannelAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.notifications.model.ListManagedNotificationChannelAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListManagedNotificationChannelAssociationsIterable responses = client.listManagedNotificationChannelAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listManagedNotificationChannelAssociations(software.amazon.awssdk.services.notifications.model.ListManagedNotificationChannelAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listManagedNotificationChannelAssociationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.ListManagedNotificationChannelAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListManagedNotificationChannelAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListManagedNotificationChannelAssociationsIterable listManagedNotificationChannelAssociationsPaginator(
            ListManagedNotificationChannelAssociationsRequest listManagedNotificationChannelAssociationsRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, NotificationsException {
        return new ListManagedNotificationChannelAssociationsIterable(this, listManagedNotificationChannelAssociationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listManagedNotificationChannelAssociations(software.amazon.awssdk.services.notifications.model.ListManagedNotificationChannelAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListManagedNotificationChannelAssociationsIterable responses = client.listManagedNotificationChannelAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.notifications.paginators.ListManagedNotificationChannelAssociationsIterable responses = client
     *             .listManagedNotificationChannelAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.notifications.model.ListManagedNotificationChannelAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListManagedNotificationChannelAssociationsIterable responses = client.listManagedNotificationChannelAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listManagedNotificationChannelAssociations(software.amazon.awssdk.services.notifications.model.ListManagedNotificationChannelAssociationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListManagedNotificationChannelAssociationsRequest.Builder} avoiding the need to create one manually via
     * {@link ListManagedNotificationChannelAssociationsRequest#builder()}
     * </p>
     *
     * @param listManagedNotificationChannelAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.ListManagedNotificationChannelAssociationsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.ListManagedNotificationChannelAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListManagedNotificationChannelAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListManagedNotificationChannelAssociationsIterable listManagedNotificationChannelAssociationsPaginator(
            Consumer<ListManagedNotificationChannelAssociationsRequest.Builder> listManagedNotificationChannelAssociationsRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, NotificationsException {
        return listManagedNotificationChannelAssociationsPaginator(ListManagedNotificationChannelAssociationsRequest.builder()
                .applyMutation(listManagedNotificationChannelAssociationsRequest).build());
    }

    /**
     * <p>
     * Returns a list of <code>ManagedNotificationChildEvents</code> for a specified aggregate
     * <code>ManagedNotificationEvent</code>, ordered by creation time in reverse chronological order (newest first).
     * </p>
     *
     * @param listManagedNotificationChildEventsRequest
     * @return Result of the ListManagedNotificationChildEvents operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.ListManagedNotificationChildEvents
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListManagedNotificationChildEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListManagedNotificationChildEventsResponse listManagedNotificationChildEvents(
            ListManagedNotificationChildEventsRequest listManagedNotificationChildEventsRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            NotificationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of <code>ManagedNotificationChildEvents</code> for a specified aggregate
     * <code>ManagedNotificationEvent</code>, ordered by creation time in reverse chronological order (newest first).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListManagedNotificationChildEventsRequest.Builder}
     * avoiding the need to create one manually via {@link ListManagedNotificationChildEventsRequest#builder()}
     * </p>
     *
     * @param listManagedNotificationChildEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.ListManagedNotificationChildEventsRequest.Builder}
     *        to create a request.
     * @return Result of the ListManagedNotificationChildEvents operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.ListManagedNotificationChildEvents
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListManagedNotificationChildEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListManagedNotificationChildEventsResponse listManagedNotificationChildEvents(
            Consumer<ListManagedNotificationChildEventsRequest.Builder> listManagedNotificationChildEventsRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, NotificationsException {
        return listManagedNotificationChildEvents(ListManagedNotificationChildEventsRequest.builder()
                .applyMutation(listManagedNotificationChildEventsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listManagedNotificationChildEvents(software.amazon.awssdk.services.notifications.model.ListManagedNotificationChildEventsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListManagedNotificationChildEventsIterable responses = client.listManagedNotificationChildEventsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.notifications.paginators.ListManagedNotificationChildEventsIterable responses = client
     *             .listManagedNotificationChildEventsPaginator(request);
     *     for (software.amazon.awssdk.services.notifications.model.ListManagedNotificationChildEventsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListManagedNotificationChildEventsIterable responses = client.listManagedNotificationChildEventsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listManagedNotificationChildEvents(software.amazon.awssdk.services.notifications.model.ListManagedNotificationChildEventsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listManagedNotificationChildEventsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.ListManagedNotificationChildEvents
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListManagedNotificationChildEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListManagedNotificationChildEventsIterable listManagedNotificationChildEventsPaginator(
            ListManagedNotificationChildEventsRequest listManagedNotificationChildEventsRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            NotificationsException {
        return new ListManagedNotificationChildEventsIterable(this, listManagedNotificationChildEventsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listManagedNotificationChildEvents(software.amazon.awssdk.services.notifications.model.ListManagedNotificationChildEventsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListManagedNotificationChildEventsIterable responses = client.listManagedNotificationChildEventsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.notifications.paginators.ListManagedNotificationChildEventsIterable responses = client
     *             .listManagedNotificationChildEventsPaginator(request);
     *     for (software.amazon.awssdk.services.notifications.model.ListManagedNotificationChildEventsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListManagedNotificationChildEventsIterable responses = client.listManagedNotificationChildEventsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listManagedNotificationChildEvents(software.amazon.awssdk.services.notifications.model.ListManagedNotificationChildEventsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListManagedNotificationChildEventsRequest.Builder}
     * avoiding the need to create one manually via {@link ListManagedNotificationChildEventsRequest#builder()}
     * </p>
     *
     * @param listManagedNotificationChildEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.ListManagedNotificationChildEventsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.ListManagedNotificationChildEvents
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListManagedNotificationChildEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListManagedNotificationChildEventsIterable listManagedNotificationChildEventsPaginator(
            Consumer<ListManagedNotificationChildEventsRequest.Builder> listManagedNotificationChildEventsRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, NotificationsException {
        return listManagedNotificationChildEventsPaginator(ListManagedNotificationChildEventsRequest.builder()
                .applyMutation(listManagedNotificationChildEventsRequest).build());
    }

    /**
     * <p>
     * Returns a list of Managed Notification Configurations according to specified filters, ordered by creation time in
     * reverse chronological order (newest first).
     * </p>
     *
     * @param listManagedNotificationConfigurationsRequest
     * @return Result of the ListManagedNotificationConfigurations operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.ListManagedNotificationConfigurations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListManagedNotificationConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListManagedNotificationConfigurationsResponse listManagedNotificationConfigurations(
            ListManagedNotificationConfigurationsRequest listManagedNotificationConfigurationsRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, NotificationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of Managed Notification Configurations according to specified filters, ordered by creation time in
     * reverse chronological order (newest first).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListManagedNotificationConfigurationsRequest.Builder} avoiding the need to create one manually via
     * {@link ListManagedNotificationConfigurationsRequest#builder()}
     * </p>
     *
     * @param listManagedNotificationConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.ListManagedNotificationConfigurationsRequest.Builder}
     *        to create a request.
     * @return Result of the ListManagedNotificationConfigurations operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.ListManagedNotificationConfigurations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListManagedNotificationConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListManagedNotificationConfigurationsResponse listManagedNotificationConfigurations(
            Consumer<ListManagedNotificationConfigurationsRequest.Builder> listManagedNotificationConfigurationsRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, NotificationsException {
        return listManagedNotificationConfigurations(ListManagedNotificationConfigurationsRequest.builder()
                .applyMutation(listManagedNotificationConfigurationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listManagedNotificationConfigurations(software.amazon.awssdk.services.notifications.model.ListManagedNotificationConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListManagedNotificationConfigurationsIterable responses = client.listManagedNotificationConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.notifications.paginators.ListManagedNotificationConfigurationsIterable responses = client
     *             .listManagedNotificationConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.notifications.model.ListManagedNotificationConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListManagedNotificationConfigurationsIterable responses = client.listManagedNotificationConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listManagedNotificationConfigurations(software.amazon.awssdk.services.notifications.model.ListManagedNotificationConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listManagedNotificationConfigurationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.ListManagedNotificationConfigurations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListManagedNotificationConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListManagedNotificationConfigurationsIterable listManagedNotificationConfigurationsPaginator(
            ListManagedNotificationConfigurationsRequest listManagedNotificationConfigurationsRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, NotificationsException {
        return new ListManagedNotificationConfigurationsIterable(this, listManagedNotificationConfigurationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listManagedNotificationConfigurations(software.amazon.awssdk.services.notifications.model.ListManagedNotificationConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListManagedNotificationConfigurationsIterable responses = client.listManagedNotificationConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.notifications.paginators.ListManagedNotificationConfigurationsIterable responses = client
     *             .listManagedNotificationConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.notifications.model.ListManagedNotificationConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListManagedNotificationConfigurationsIterable responses = client.listManagedNotificationConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listManagedNotificationConfigurations(software.amazon.awssdk.services.notifications.model.ListManagedNotificationConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListManagedNotificationConfigurationsRequest.Builder} avoiding the need to create one manually via
     * {@link ListManagedNotificationConfigurationsRequest#builder()}
     * </p>
     *
     * @param listManagedNotificationConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.ListManagedNotificationConfigurationsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.ListManagedNotificationConfigurations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListManagedNotificationConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListManagedNotificationConfigurationsIterable listManagedNotificationConfigurationsPaginator(
            Consumer<ListManagedNotificationConfigurationsRequest.Builder> listManagedNotificationConfigurationsRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, NotificationsException {
        return listManagedNotificationConfigurationsPaginator(ListManagedNotificationConfigurationsRequest.builder()
                .applyMutation(listManagedNotificationConfigurationsRequest).build());
    }

    /**
     * <p>
     * Returns a list of Managed Notification Events according to specified filters, ordered by creation time in reverse
     * chronological order (newest first).
     * </p>
     *
     * @param listManagedNotificationEventsRequest
     * @return Result of the ListManagedNotificationEvents operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.ListManagedNotificationEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListManagedNotificationEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListManagedNotificationEventsResponse listManagedNotificationEvents(
            ListManagedNotificationEventsRequest listManagedNotificationEventsRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            NotificationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of Managed Notification Events according to specified filters, ordered by creation time in reverse
     * chronological order (newest first).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListManagedNotificationEventsRequest.Builder}
     * avoiding the need to create one manually via {@link ListManagedNotificationEventsRequest#builder()}
     * </p>
     *
     * @param listManagedNotificationEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.ListManagedNotificationEventsRequest.Builder}
     *        to create a request.
     * @return Result of the ListManagedNotificationEvents operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.ListManagedNotificationEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListManagedNotificationEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListManagedNotificationEventsResponse listManagedNotificationEvents(
            Consumer<ListManagedNotificationEventsRequest.Builder> listManagedNotificationEventsRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, NotificationsException {
        return listManagedNotificationEvents(ListManagedNotificationEventsRequest.builder()
                .applyMutation(listManagedNotificationEventsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listManagedNotificationEvents(software.amazon.awssdk.services.notifications.model.ListManagedNotificationEventsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListManagedNotificationEventsIterable responses = client.listManagedNotificationEventsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.notifications.paginators.ListManagedNotificationEventsIterable responses = client
     *             .listManagedNotificationEventsPaginator(request);
     *     for (software.amazon.awssdk.services.notifications.model.ListManagedNotificationEventsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListManagedNotificationEventsIterable responses = client.listManagedNotificationEventsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listManagedNotificationEvents(software.amazon.awssdk.services.notifications.model.ListManagedNotificationEventsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listManagedNotificationEventsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.ListManagedNotificationEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListManagedNotificationEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListManagedNotificationEventsIterable listManagedNotificationEventsPaginator(
            ListManagedNotificationEventsRequest listManagedNotificationEventsRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            NotificationsException {
        return new ListManagedNotificationEventsIterable(this, listManagedNotificationEventsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listManagedNotificationEvents(software.amazon.awssdk.services.notifications.model.ListManagedNotificationEventsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListManagedNotificationEventsIterable responses = client.listManagedNotificationEventsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.notifications.paginators.ListManagedNotificationEventsIterable responses = client
     *             .listManagedNotificationEventsPaginator(request);
     *     for (software.amazon.awssdk.services.notifications.model.ListManagedNotificationEventsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListManagedNotificationEventsIterable responses = client.listManagedNotificationEventsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listManagedNotificationEvents(software.amazon.awssdk.services.notifications.model.ListManagedNotificationEventsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListManagedNotificationEventsRequest.Builder}
     * avoiding the need to create one manually via {@link ListManagedNotificationEventsRequest#builder()}
     * </p>
     *
     * @param listManagedNotificationEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.ListManagedNotificationEventsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.ListManagedNotificationEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListManagedNotificationEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListManagedNotificationEventsIterable listManagedNotificationEventsPaginator(
            Consumer<ListManagedNotificationEventsRequest.Builder> listManagedNotificationEventsRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, NotificationsException {
        return listManagedNotificationEventsPaginator(ListManagedNotificationEventsRequest.builder()
                .applyMutation(listManagedNotificationEventsRequest).build());
    }

    /**
     * <p>
     * Returns a list of abbreviated <code>NotificationConfigurations</code> according to specified filters, in reverse
     * chronological order (newest first).
     * </p>
     *
     * @param listNotificationConfigurationsRequest
     * @return Result of the ListNotificationConfigurations operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.ListNotificationConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListNotificationConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNotificationConfigurationsResponse listNotificationConfigurations(
            ListNotificationConfigurationsRequest listNotificationConfigurationsRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            NotificationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of abbreviated <code>NotificationConfigurations</code> according to specified filters, in reverse
     * chronological order (newest first).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNotificationConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListNotificationConfigurationsRequest#builder()}
     * </p>
     *
     * @param listNotificationConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.ListNotificationConfigurationsRequest.Builder}
     *        to create a request.
     * @return Result of the ListNotificationConfigurations operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.ListNotificationConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListNotificationConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNotificationConfigurationsResponse listNotificationConfigurations(
            Consumer<ListNotificationConfigurationsRequest.Builder> listNotificationConfigurationsRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, NotificationsException {
        return listNotificationConfigurations(ListNotificationConfigurationsRequest.builder()
                .applyMutation(listNotificationConfigurationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listNotificationConfigurations(software.amazon.awssdk.services.notifications.model.ListNotificationConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListNotificationConfigurationsIterable responses = client.listNotificationConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.notifications.paginators.ListNotificationConfigurationsIterable responses = client
     *             .listNotificationConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.notifications.model.ListNotificationConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListNotificationConfigurationsIterable responses = client.listNotificationConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNotificationConfigurations(software.amazon.awssdk.services.notifications.model.ListNotificationConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listNotificationConfigurationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.ListNotificationConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListNotificationConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNotificationConfigurationsIterable listNotificationConfigurationsPaginator(
            ListNotificationConfigurationsRequest listNotificationConfigurationsRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            NotificationsException {
        return new ListNotificationConfigurationsIterable(this, listNotificationConfigurationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listNotificationConfigurations(software.amazon.awssdk.services.notifications.model.ListNotificationConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListNotificationConfigurationsIterable responses = client.listNotificationConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.notifications.paginators.ListNotificationConfigurationsIterable responses = client
     *             .listNotificationConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.notifications.model.ListNotificationConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListNotificationConfigurationsIterable responses = client.listNotificationConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNotificationConfigurations(software.amazon.awssdk.services.notifications.model.ListNotificationConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNotificationConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListNotificationConfigurationsRequest#builder()}
     * </p>
     *
     * @param listNotificationConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.ListNotificationConfigurationsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.ListNotificationConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListNotificationConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNotificationConfigurationsIterable listNotificationConfigurationsPaginator(
            Consumer<ListNotificationConfigurationsRequest.Builder> listNotificationConfigurationsRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, NotificationsException {
        return listNotificationConfigurationsPaginator(ListNotificationConfigurationsRequest.builder()
                .applyMutation(listNotificationConfigurationsRequest).build());
    }

    /**
     * <p>
     * Returns a list of <code>NotificationEvents</code> according to specified filters, in reverse chronological order
     * (newest first).
     * </p>
     * <important>
     * <p>
     * User Notifications stores notifications in the individual Regions you register as notification hubs and the
     * Region of the source event rule. ListNotificationEvents only returns notifications stored in the same Region in
     * which the action is called. User Notifications doesn't backfill notifications to new Regions selected as
     * notification hubs. For this reason, we recommend that you make calls in your oldest registered notification hub.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/notifications/latest/userguide/notification-hubs.html">Notification hubs</a> in
     * the <i>Amazon Web Services User Notifications User Guide</i>.
     * </p>
     * </important>
     *
     * @param listNotificationEventsRequest
     * @return Result of the ListNotificationEvents operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.ListNotificationEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListNotificationEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNotificationEventsResponse listNotificationEvents(ListNotificationEventsRequest listNotificationEventsRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, NotificationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of <code>NotificationEvents</code> according to specified filters, in reverse chronological order
     * (newest first).
     * </p>
     * <important>
     * <p>
     * User Notifications stores notifications in the individual Regions you register as notification hubs and the
     * Region of the source event rule. ListNotificationEvents only returns notifications stored in the same Region in
     * which the action is called. User Notifications doesn't backfill notifications to new Regions selected as
     * notification hubs. For this reason, we recommend that you make calls in your oldest registered notification hub.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/notifications/latest/userguide/notification-hubs.html">Notification hubs</a> in
     * the <i>Amazon Web Services User Notifications User Guide</i>.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNotificationEventsRequest.Builder} avoiding the
     * need to create one manually via {@link ListNotificationEventsRequest#builder()}
     * </p>
     *
     * @param listNotificationEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.ListNotificationEventsRequest.Builder} to
     *        create a request.
     * @return Result of the ListNotificationEvents operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.ListNotificationEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListNotificationEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNotificationEventsResponse listNotificationEvents(
            Consumer<ListNotificationEventsRequest.Builder> listNotificationEventsRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            NotificationsException {
        return listNotificationEvents(ListNotificationEventsRequest.builder().applyMutation(listNotificationEventsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listNotificationEvents(software.amazon.awssdk.services.notifications.model.ListNotificationEventsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListNotificationEventsIterable responses = client.listNotificationEventsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.notifications.paginators.ListNotificationEventsIterable responses = client
     *             .listNotificationEventsPaginator(request);
     *     for (software.amazon.awssdk.services.notifications.model.ListNotificationEventsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListNotificationEventsIterable responses = client.listNotificationEventsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNotificationEvents(software.amazon.awssdk.services.notifications.model.ListNotificationEventsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listNotificationEventsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.ListNotificationEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListNotificationEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNotificationEventsIterable listNotificationEventsPaginator(
            ListNotificationEventsRequest listNotificationEventsRequest) throws AccessDeniedException, ValidationException,
            InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, NotificationsException {
        return new ListNotificationEventsIterable(this, listNotificationEventsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listNotificationEvents(software.amazon.awssdk.services.notifications.model.ListNotificationEventsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListNotificationEventsIterable responses = client.listNotificationEventsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.notifications.paginators.ListNotificationEventsIterable responses = client
     *             .listNotificationEventsPaginator(request);
     *     for (software.amazon.awssdk.services.notifications.model.ListNotificationEventsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListNotificationEventsIterable responses = client.listNotificationEventsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNotificationEvents(software.amazon.awssdk.services.notifications.model.ListNotificationEventsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNotificationEventsRequest.Builder} avoiding the
     * need to create one manually via {@link ListNotificationEventsRequest#builder()}
     * </p>
     *
     * @param listNotificationEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.ListNotificationEventsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.ListNotificationEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListNotificationEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNotificationEventsIterable listNotificationEventsPaginator(
            Consumer<ListNotificationEventsRequest.Builder> listNotificationEventsRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            NotificationsException {
        return listNotificationEventsPaginator(ListNotificationEventsRequest.builder()
                .applyMutation(listNotificationEventsRequest).build());
    }

    /**
     * <p>
     * Returns a list of <code>NotificationHubs</code>.
     * </p>
     *
     * @param listNotificationHubsRequest
     * @return Result of the ListNotificationHubs operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.ListNotificationHubs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListNotificationHubs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNotificationHubsResponse listNotificationHubs(ListNotificationHubsRequest listNotificationHubsRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, NotificationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of <code>NotificationHubs</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNotificationHubsRequest.Builder} avoiding the
     * need to create one manually via {@link ListNotificationHubsRequest#builder()}
     * </p>
     *
     * @param listNotificationHubsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.ListNotificationHubsRequest.Builder} to create
     *        a request.
     * @return Result of the ListNotificationHubs operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.ListNotificationHubs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListNotificationHubs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNotificationHubsResponse listNotificationHubs(
            Consumer<ListNotificationHubsRequest.Builder> listNotificationHubsRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            NotificationsException {
        return listNotificationHubs(ListNotificationHubsRequest.builder().applyMutation(listNotificationHubsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listNotificationHubs(software.amazon.awssdk.services.notifications.model.ListNotificationHubsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListNotificationHubsIterable responses = client.listNotificationHubsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.notifications.paginators.ListNotificationHubsIterable responses = client
     *             .listNotificationHubsPaginator(request);
     *     for (software.amazon.awssdk.services.notifications.model.ListNotificationHubsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListNotificationHubsIterable responses = client.listNotificationHubsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNotificationHubs(software.amazon.awssdk.services.notifications.model.ListNotificationHubsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listNotificationHubsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.ListNotificationHubs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListNotificationHubs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNotificationHubsIterable listNotificationHubsPaginator(ListNotificationHubsRequest listNotificationHubsRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, NotificationsException {
        return new ListNotificationHubsIterable(this, listNotificationHubsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listNotificationHubs(software.amazon.awssdk.services.notifications.model.ListNotificationHubsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListNotificationHubsIterable responses = client.listNotificationHubsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.notifications.paginators.ListNotificationHubsIterable responses = client
     *             .listNotificationHubsPaginator(request);
     *     for (software.amazon.awssdk.services.notifications.model.ListNotificationHubsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.notifications.paginators.ListNotificationHubsIterable responses = client.listNotificationHubsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNotificationHubs(software.amazon.awssdk.services.notifications.model.ListNotificationHubsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNotificationHubsRequest.Builder} avoiding the
     * need to create one manually via {@link ListNotificationHubsRequest#builder()}
     * </p>
     *
     * @param listNotificationHubsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.ListNotificationHubsRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.ListNotificationHubs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListNotificationHubs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNotificationHubsIterable listNotificationHubsPaginator(
            Consumer<ListNotificationHubsRequest.Builder> listNotificationHubsRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            NotificationsException {
        return listNotificationHubsPaginator(ListNotificationHubsRequest.builder().applyMutation(listNotificationHubsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of tags for a specified Amazon Resource Name (ARN).
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html">Tagging
     * your Amazon Web Services resources</a> in the <i>Tagging Amazon Web Services Resources User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This is only supported for <code>NotificationConfigurations</code>.
     * </p>
     * </note>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, NotificationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of tags for a specified Amazon Resource Name (ARN).
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html">Tagging
     * your Amazon Web Services resources</a> in the <i>Tagging Amazon Web Services Resources User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This is only supported for <code>NotificationConfigurations</code>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ThrottlingException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, NotificationsException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Registers a <code>NotificationConfiguration</code> in the specified Region.
     * </p>
     * <p>
     * There is a maximum of one <code>NotificationConfiguration</code> per Region. You can have a maximum of 3
     * <code>NotificationHub</code> resources at a time.
     * </p>
     *
     * @param registerNotificationHubRequest
     * @return Result of the RegisterNotificationHub operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.RegisterNotificationHub
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/RegisterNotificationHub"
     *      target="_top">AWS API Documentation</a>
     */
    default RegisterNotificationHubResponse registerNotificationHub(RegisterNotificationHubRequest registerNotificationHubRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException, InternalServerException,
            ThrottlingException, ConflictException, AwsServiceException, SdkClientException, NotificationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers a <code>NotificationConfiguration</code> in the specified Region.
     * </p>
     * <p>
     * There is a maximum of one <code>NotificationConfiguration</code> per Region. You can have a maximum of 3
     * <code>NotificationHub</code> resources at a time.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterNotificationHubRequest.Builder} avoiding
     * the need to create one manually via {@link RegisterNotificationHubRequest#builder()}
     * </p>
     *
     * @param registerNotificationHubRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.RegisterNotificationHubRequest.Builder} to
     *        create a request.
     * @return Result of the RegisterNotificationHub operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.RegisterNotificationHub
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/RegisterNotificationHub"
     *      target="_top">AWS API Documentation</a>
     */
    default RegisterNotificationHubResponse registerNotificationHub(
            Consumer<RegisterNotificationHubRequest.Builder> registerNotificationHubRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException, InternalServerException,
            ThrottlingException, ConflictException, AwsServiceException, SdkClientException, NotificationsException {
        return registerNotificationHub(RegisterNotificationHubRequest.builder().applyMutation(registerNotificationHubRequest)
                .build());
    }

    /**
     * <p>
     * Tags the resource with a tag key and value.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html">Tagging
     * your Amazon Web Services resources</a> in the <i>Tagging Amazon Web Services Resources User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This is only supported for <code>NotificationConfigurations</code>.
     * </p>
     * </note>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ThrottlingException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, NotificationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Tags the resource with a tag key and value.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html">Tagging
     * your Amazon Web Services resources</a> in the <i>Tagging Amazon Web Services Resources User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This is only supported for <code>NotificationConfigurations</code>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the TagResource operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, NotificationsException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Untags a resource with a specified Amazon Resource Name (ARN).
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html">Tagging
     * your Amazon Web Services resources</a> in the <i>Tagging Amazon Web Services Resources User Guide</i>.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ThrottlingException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, NotificationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Untags a resource with a specified Amazon Resource Name (ARN).
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html">Tagging
     * your Amazon Web Services resources</a> in the <i>Tagging Amazon Web Services Resources User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, NotificationsException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an existing <code>EventRule</code>.
     * </p>
     *
     * @param updateEventRuleRequest
     * @return Result of the UpdateEventRule operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.UpdateEventRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/UpdateEventRule" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateEventRuleResponse updateEventRule(UpdateEventRuleRequest updateEventRuleRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ThrottlingException, ConflictException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, NotificationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing <code>EventRule</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEventRuleRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateEventRuleRequest#builder()}
     * </p>
     *
     * @param updateEventRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.UpdateEventRuleRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateEventRule operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.UpdateEventRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/UpdateEventRule" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateEventRuleResponse updateEventRule(Consumer<UpdateEventRuleRequest.Builder> updateEventRuleRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ThrottlingException, ConflictException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, NotificationsException {
        return updateEventRule(UpdateEventRuleRequest.builder().applyMutation(updateEventRuleRequest).build());
    }

    /**
     * <p>
     * Updates a <code>NotificationConfiguration</code>.
     * </p>
     *
     * @param updateNotificationConfigurationRequest
     * @return Result of the UpdateNotificationConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.UpdateNotificationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/UpdateNotificationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateNotificationConfigurationResponse updateNotificationConfiguration(
            UpdateNotificationConfigurationRequest updateNotificationConfigurationRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, ThrottlingException, ConflictException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, NotificationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a <code>NotificationConfiguration</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateNotificationConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateNotificationConfigurationRequest#builder()}
     * </p>
     *
     * @param updateNotificationConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.notifications.model.UpdateNotificationConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the UpdateNotificationConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         User does not have sufficient access to perform this action.
     * @throws ValidationException
     *         This exception is thrown when the notification event fails validation.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NotificationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NotificationsClient.UpdateNotificationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/notifications-2018-05-10/UpdateNotificationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateNotificationConfigurationResponse updateNotificationConfiguration(
            Consumer<UpdateNotificationConfigurationRequest.Builder> updateNotificationConfigurationRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, ThrottlingException, ConflictException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, NotificationsException {
        return updateNotificationConfiguration(UpdateNotificationConfigurationRequest.builder()
                .applyMutation(updateNotificationConfigurationRequest).build());
    }

    /**
     * Create a {@link NotificationsClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static NotificationsClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link NotificationsClient}.
     */
    static NotificationsClientBuilder builder() {
        return new DefaultNotificationsClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default NotificationsServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
