/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.notifications.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides additional information about the aggregation key.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AggregationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<AggregationSummary.Builder, AggregationSummary> {
    private static final SdkField<Integer> EVENT_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("eventCount").getter(getter(AggregationSummary::eventCount)).setter(setter(Builder::eventCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventCount").build()).build();

    private static final SdkField<List<AggregationKey>> AGGREGATED_BY_FIELD = SdkField
            .<List<AggregationKey>> builder(MarshallingType.LIST)
            .memberName("aggregatedBy")
            .getter(getter(AggregationSummary::aggregatedBy))
            .setter(setter(Builder::aggregatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregatedBy").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AggregationKey> builder(MarshallingType.SDK_POJO)
                                            .constructor(AggregationKey::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<SummarizationDimensionOverview> AGGREGATED_ACCOUNTS_FIELD = SdkField
            .<SummarizationDimensionOverview> builder(MarshallingType.SDK_POJO).memberName("aggregatedAccounts")
            .getter(getter(AggregationSummary::aggregatedAccounts)).setter(setter(Builder::aggregatedAccounts))
            .constructor(SummarizationDimensionOverview::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregatedAccounts").build())
            .build();

    private static final SdkField<SummarizationDimensionOverview> AGGREGATED_REGIONS_FIELD = SdkField
            .<SummarizationDimensionOverview> builder(MarshallingType.SDK_POJO).memberName("aggregatedRegions")
            .getter(getter(AggregationSummary::aggregatedRegions)).setter(setter(Builder::aggregatedRegions))
            .constructor(SummarizationDimensionOverview::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregatedRegions").build()).build();

    private static final SdkField<SummarizationDimensionOverview> AGGREGATED_ORGANIZATIONAL_UNITS_FIELD = SdkField
            .<SummarizationDimensionOverview> builder(MarshallingType.SDK_POJO)
            .memberName("aggregatedOrganizationalUnits")
            .getter(getter(AggregationSummary::aggregatedOrganizationalUnits))
            .setter(setter(Builder::aggregatedOrganizationalUnits))
            .constructor(SummarizationDimensionOverview::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregatedOrganizationalUnits")
                    .build()).build();

    private static final SdkField<List<SummarizationDimensionOverview>> ADDITIONAL_SUMMARIZATION_DIMENSIONS_FIELD = SdkField
            .<List<SummarizationDimensionOverview>> builder(MarshallingType.LIST)
            .memberName("additionalSummarizationDimensions")
            .getter(getter(AggregationSummary::additionalSummarizationDimensions))
            .setter(setter(Builder::additionalSummarizationDimensions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalSummarizationDimensions")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SummarizationDimensionOverview> builder(MarshallingType.SDK_POJO)
                                            .constructor(SummarizationDimensionOverview::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_COUNT_FIELD,
            AGGREGATED_BY_FIELD, AGGREGATED_ACCOUNTS_FIELD, AGGREGATED_REGIONS_FIELD, AGGREGATED_ORGANIZATIONAL_UNITS_FIELD,
            ADDITIONAL_SUMMARIZATION_DIMENSIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer eventCount;

    private final List<AggregationKey> aggregatedBy;

    private final SummarizationDimensionOverview aggregatedAccounts;

    private final SummarizationDimensionOverview aggregatedRegions;

    private final SummarizationDimensionOverview aggregatedOrganizationalUnits;

    private final List<SummarizationDimensionOverview> additionalSummarizationDimensions;

    private AggregationSummary(BuilderImpl builder) {
        this.eventCount = builder.eventCount;
        this.aggregatedBy = builder.aggregatedBy;
        this.aggregatedAccounts = builder.aggregatedAccounts;
        this.aggregatedRegions = builder.aggregatedRegions;
        this.aggregatedOrganizationalUnits = builder.aggregatedOrganizationalUnits;
        this.additionalSummarizationDimensions = builder.additionalSummarizationDimensions;
    }

    /**
     * <p>
     * Indicates the number of events associated with the aggregation key.
     * </p>
     * 
     * @return Indicates the number of events associated with the aggregation key.
     */
    public final Integer eventCount() {
        return eventCount;
    }

    /**
     * For responses, this returns true if the service returned a value for the AggregatedBy property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAggregatedBy() {
        return aggregatedBy != null && !(aggregatedBy instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Indicates the criteria or rules by which notifications have been grouped together.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAggregatedBy} method.
     * </p>
     * 
     * @return Indicates the criteria or rules by which notifications have been grouped together.
     */
    public final List<AggregationKey> aggregatedBy() {
        return aggregatedBy;
    }

    /**
     * <p>
     * Indicates the Amazon Web Services accounts in the aggregation key.
     * </p>
     * 
     * @return Indicates the Amazon Web Services accounts in the aggregation key.
     */
    public final SummarizationDimensionOverview aggregatedAccounts() {
        return aggregatedAccounts;
    }

    /**
     * <p>
     * Indicates the Amazon Web Services Regions in the aggregation key.
     * </p>
     * 
     * @return Indicates the Amazon Web Services Regions in the aggregation key.
     */
    public final SummarizationDimensionOverview aggregatedRegions() {
        return aggregatedRegions;
    }

    /**
     * <p>
     * Indicates the collection of organizational units that are involved in the aggregation key.
     * </p>
     * 
     * @return Indicates the collection of organizational units that are involved in the aggregation key.
     */
    public final SummarizationDimensionOverview aggregatedOrganizationalUnits() {
        return aggregatedOrganizationalUnits;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalSummarizationDimensions
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasAdditionalSummarizationDimensions() {
        return additionalSummarizationDimensions != null && !(additionalSummarizationDimensions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of additional dimensions used to group and summarize data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalSummarizationDimensions}
     * method.
     * </p>
     * 
     * @return List of additional dimensions used to group and summarize data.
     */
    public final List<SummarizationDimensionOverview> additionalSummarizationDimensions() {
        return additionalSummarizationDimensions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eventCount());
        hashCode = 31 * hashCode + Objects.hashCode(hasAggregatedBy() ? aggregatedBy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(aggregatedAccounts());
        hashCode = 31 * hashCode + Objects.hashCode(aggregatedRegions());
        hashCode = 31 * hashCode + Objects.hashCode(aggregatedOrganizationalUnits());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasAdditionalSummarizationDimensions() ? additionalSummarizationDimensions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregationSummary)) {
            return false;
        }
        AggregationSummary other = (AggregationSummary) obj;
        return Objects.equals(eventCount(), other.eventCount()) && hasAggregatedBy() == other.hasAggregatedBy()
                && Objects.equals(aggregatedBy(), other.aggregatedBy())
                && Objects.equals(aggregatedAccounts(), other.aggregatedAccounts())
                && Objects.equals(aggregatedRegions(), other.aggregatedRegions())
                && Objects.equals(aggregatedOrganizationalUnits(), other.aggregatedOrganizationalUnits())
                && hasAdditionalSummarizationDimensions() == other.hasAdditionalSummarizationDimensions()
                && Objects.equals(additionalSummarizationDimensions(), other.additionalSummarizationDimensions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("AggregationSummary")
                .add("EventCount", eventCount())
                .add("AggregatedBy", hasAggregatedBy() ? aggregatedBy() : null)
                .add("AggregatedAccounts", aggregatedAccounts())
                .add("AggregatedRegions", aggregatedRegions())
                .add("AggregatedOrganizationalUnits", aggregatedOrganizationalUnits())
                .add("AdditionalSummarizationDimensions",
                        hasAdditionalSummarizationDimensions() ? additionalSummarizationDimensions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eventCount":
            return Optional.ofNullable(clazz.cast(eventCount()));
        case "aggregatedBy":
            return Optional.ofNullable(clazz.cast(aggregatedBy()));
        case "aggregatedAccounts":
            return Optional.ofNullable(clazz.cast(aggregatedAccounts()));
        case "aggregatedRegions":
            return Optional.ofNullable(clazz.cast(aggregatedRegions()));
        case "aggregatedOrganizationalUnits":
            return Optional.ofNullable(clazz.cast(aggregatedOrganizationalUnits()));
        case "additionalSummarizationDimensions":
            return Optional.ofNullable(clazz.cast(additionalSummarizationDimensions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("eventCount", EVENT_COUNT_FIELD);
        map.put("aggregatedBy", AGGREGATED_BY_FIELD);
        map.put("aggregatedAccounts", AGGREGATED_ACCOUNTS_FIELD);
        map.put("aggregatedRegions", AGGREGATED_REGIONS_FIELD);
        map.put("aggregatedOrganizationalUnits", AGGREGATED_ORGANIZATIONAL_UNITS_FIELD);
        map.put("additionalSummarizationDimensions", ADDITIONAL_SUMMARIZATION_DIMENSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AggregationSummary, T> g) {
        return obj -> g.apply((AggregationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AggregationSummary> {
        /**
         * <p>
         * Indicates the number of events associated with the aggregation key.
         * </p>
         * 
         * @param eventCount
         *        Indicates the number of events associated with the aggregation key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventCount(Integer eventCount);

        /**
         * <p>
         * Indicates the criteria or rules by which notifications have been grouped together.
         * </p>
         * 
         * @param aggregatedBy
         *        Indicates the criteria or rules by which notifications have been grouped together.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregatedBy(Collection<AggregationKey> aggregatedBy);

        /**
         * <p>
         * Indicates the criteria or rules by which notifications have been grouped together.
         * </p>
         * 
         * @param aggregatedBy
         *        Indicates the criteria or rules by which notifications have been grouped together.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregatedBy(AggregationKey... aggregatedBy);

        /**
         * <p>
         * Indicates the criteria or rules by which notifications have been grouped together.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.notifications.model.AggregationKey.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.notifications.model.AggregationKey#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.notifications.model.AggregationKey.Builder#build()} is called
         * immediately and its result is passed to {@link #aggregatedBy(List<AggregationKey>)}.
         * 
         * @param aggregatedBy
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.notifications.model.AggregationKey.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aggregatedBy(java.util.Collection<AggregationKey>)
         */
        Builder aggregatedBy(Consumer<AggregationKey.Builder>... aggregatedBy);

        /**
         * <p>
         * Indicates the Amazon Web Services accounts in the aggregation key.
         * </p>
         * 
         * @param aggregatedAccounts
         *        Indicates the Amazon Web Services accounts in the aggregation key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregatedAccounts(SummarizationDimensionOverview aggregatedAccounts);

        /**
         * <p>
         * Indicates the Amazon Web Services accounts in the aggregation key.
         * </p>
         * This is a convenience method that creates an instance of the {@link SummarizationDimensionOverview.Builder}
         * avoiding the need to create one manually via {@link SummarizationDimensionOverview#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SummarizationDimensionOverview.Builder#build()} is called
         * immediately and its result is passed to {@link #aggregatedAccounts(SummarizationDimensionOverview)}.
         * 
         * @param aggregatedAccounts
         *        a consumer that will call methods on {@link SummarizationDimensionOverview.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aggregatedAccounts(SummarizationDimensionOverview)
         */
        default Builder aggregatedAccounts(Consumer<SummarizationDimensionOverview.Builder> aggregatedAccounts) {
            return aggregatedAccounts(SummarizationDimensionOverview.builder().applyMutation(aggregatedAccounts).build());
        }

        /**
         * <p>
         * Indicates the Amazon Web Services Regions in the aggregation key.
         * </p>
         * 
         * @param aggregatedRegions
         *        Indicates the Amazon Web Services Regions in the aggregation key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregatedRegions(SummarizationDimensionOverview aggregatedRegions);

        /**
         * <p>
         * Indicates the Amazon Web Services Regions in the aggregation key.
         * </p>
         * This is a convenience method that creates an instance of the {@link SummarizationDimensionOverview.Builder}
         * avoiding the need to create one manually via {@link SummarizationDimensionOverview#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SummarizationDimensionOverview.Builder#build()} is called
         * immediately and its result is passed to {@link #aggregatedRegions(SummarizationDimensionOverview)}.
         * 
         * @param aggregatedRegions
         *        a consumer that will call methods on {@link SummarizationDimensionOverview.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aggregatedRegions(SummarizationDimensionOverview)
         */
        default Builder aggregatedRegions(Consumer<SummarizationDimensionOverview.Builder> aggregatedRegions) {
            return aggregatedRegions(SummarizationDimensionOverview.builder().applyMutation(aggregatedRegions).build());
        }

        /**
         * <p>
         * Indicates the collection of organizational units that are involved in the aggregation key.
         * </p>
         * 
         * @param aggregatedOrganizationalUnits
         *        Indicates the collection of organizational units that are involved in the aggregation key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregatedOrganizationalUnits(SummarizationDimensionOverview aggregatedOrganizationalUnits);

        /**
         * <p>
         * Indicates the collection of organizational units that are involved in the aggregation key.
         * </p>
         * This is a convenience method that creates an instance of the {@link SummarizationDimensionOverview.Builder}
         * avoiding the need to create one manually via {@link SummarizationDimensionOverview#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SummarizationDimensionOverview.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #aggregatedOrganizationalUnits(SummarizationDimensionOverview)}.
         * 
         * @param aggregatedOrganizationalUnits
         *        a consumer that will call methods on {@link SummarizationDimensionOverview.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aggregatedOrganizationalUnits(SummarizationDimensionOverview)
         */
        default Builder aggregatedOrganizationalUnits(
                Consumer<SummarizationDimensionOverview.Builder> aggregatedOrganizationalUnits) {
            return aggregatedOrganizationalUnits(SummarizationDimensionOverview.builder()
                    .applyMutation(aggregatedOrganizationalUnits).build());
        }

        /**
         * <p>
         * List of additional dimensions used to group and summarize data.
         * </p>
         * 
         * @param additionalSummarizationDimensions
         *        List of additional dimensions used to group and summarize data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalSummarizationDimensions(Collection<SummarizationDimensionOverview> additionalSummarizationDimensions);

        /**
         * <p>
         * List of additional dimensions used to group and summarize data.
         * </p>
         * 
         * @param additionalSummarizationDimensions
         *        List of additional dimensions used to group and summarize data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalSummarizationDimensions(SummarizationDimensionOverview... additionalSummarizationDimensions);

        /**
         * <p>
         * List of additional dimensions used to group and summarize data.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.notifications.model.SummarizationDimensionOverview.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.notifications.model.SummarizationDimensionOverview#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.notifications.model.SummarizationDimensionOverview.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #additionalSummarizationDimensions(List<SummarizationDimensionOverview>)}.
         * 
         * @param additionalSummarizationDimensions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.notifications.model.SummarizationDimensionOverview.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #additionalSummarizationDimensions(java.util.Collection<SummarizationDimensionOverview>)
         */
        Builder additionalSummarizationDimensions(
                Consumer<SummarizationDimensionOverview.Builder>... additionalSummarizationDimensions);
    }

    static final class BuilderImpl implements Builder {
        private Integer eventCount;

        private List<AggregationKey> aggregatedBy = DefaultSdkAutoConstructList.getInstance();

        private SummarizationDimensionOverview aggregatedAccounts;

        private SummarizationDimensionOverview aggregatedRegions;

        private SummarizationDimensionOverview aggregatedOrganizationalUnits;

        private List<SummarizationDimensionOverview> additionalSummarizationDimensions = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AggregationSummary model) {
            eventCount(model.eventCount);
            aggregatedBy(model.aggregatedBy);
            aggregatedAccounts(model.aggregatedAccounts);
            aggregatedRegions(model.aggregatedRegions);
            aggregatedOrganizationalUnits(model.aggregatedOrganizationalUnits);
            additionalSummarizationDimensions(model.additionalSummarizationDimensions);
        }

        public final Integer getEventCount() {
            return eventCount;
        }

        public final void setEventCount(Integer eventCount) {
            this.eventCount = eventCount;
        }

        @Override
        public final Builder eventCount(Integer eventCount) {
            this.eventCount = eventCount;
            return this;
        }

        public final List<AggregationKey.Builder> getAggregatedBy() {
            List<AggregationKey.Builder> result = AggregationKeysCopier.copyToBuilder(this.aggregatedBy);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAggregatedBy(Collection<AggregationKey.BuilderImpl> aggregatedBy) {
            this.aggregatedBy = AggregationKeysCopier.copyFromBuilder(aggregatedBy);
        }

        @Override
        public final Builder aggregatedBy(Collection<AggregationKey> aggregatedBy) {
            this.aggregatedBy = AggregationKeysCopier.copy(aggregatedBy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregatedBy(AggregationKey... aggregatedBy) {
            aggregatedBy(Arrays.asList(aggregatedBy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregatedBy(Consumer<AggregationKey.Builder>... aggregatedBy) {
            aggregatedBy(Stream.of(aggregatedBy).map(c -> AggregationKey.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final SummarizationDimensionOverview.Builder getAggregatedAccounts() {
            return aggregatedAccounts != null ? aggregatedAccounts.toBuilder() : null;
        }

        public final void setAggregatedAccounts(SummarizationDimensionOverview.BuilderImpl aggregatedAccounts) {
            this.aggregatedAccounts = aggregatedAccounts != null ? aggregatedAccounts.build() : null;
        }

        @Override
        public final Builder aggregatedAccounts(SummarizationDimensionOverview aggregatedAccounts) {
            this.aggregatedAccounts = aggregatedAccounts;
            return this;
        }

        public final SummarizationDimensionOverview.Builder getAggregatedRegions() {
            return aggregatedRegions != null ? aggregatedRegions.toBuilder() : null;
        }

        public final void setAggregatedRegions(SummarizationDimensionOverview.BuilderImpl aggregatedRegions) {
            this.aggregatedRegions = aggregatedRegions != null ? aggregatedRegions.build() : null;
        }

        @Override
        public final Builder aggregatedRegions(SummarizationDimensionOverview aggregatedRegions) {
            this.aggregatedRegions = aggregatedRegions;
            return this;
        }

        public final SummarizationDimensionOverview.Builder getAggregatedOrganizationalUnits() {
            return aggregatedOrganizationalUnits != null ? aggregatedOrganizationalUnits.toBuilder() : null;
        }

        public final void setAggregatedOrganizationalUnits(
                SummarizationDimensionOverview.BuilderImpl aggregatedOrganizationalUnits) {
            this.aggregatedOrganizationalUnits = aggregatedOrganizationalUnits != null ? aggregatedOrganizationalUnits.build()
                    : null;
        }

        @Override
        public final Builder aggregatedOrganizationalUnits(SummarizationDimensionOverview aggregatedOrganizationalUnits) {
            this.aggregatedOrganizationalUnits = aggregatedOrganizationalUnits;
            return this;
        }

        public final List<SummarizationDimensionOverview.Builder> getAdditionalSummarizationDimensions() {
            List<SummarizationDimensionOverview.Builder> result = SummarizationDimensionOverviewsCopier
                    .copyToBuilder(this.additionalSummarizationDimensions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdditionalSummarizationDimensions(
                Collection<SummarizationDimensionOverview.BuilderImpl> additionalSummarizationDimensions) {
            this.additionalSummarizationDimensions = SummarizationDimensionOverviewsCopier
                    .copyFromBuilder(additionalSummarizationDimensions);
        }

        @Override
        public final Builder additionalSummarizationDimensions(
                Collection<SummarizationDimensionOverview> additionalSummarizationDimensions) {
            this.additionalSummarizationDimensions = SummarizationDimensionOverviewsCopier
                    .copy(additionalSummarizationDimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalSummarizationDimensions(
                SummarizationDimensionOverview... additionalSummarizationDimensions) {
            additionalSummarizationDimensions(Arrays.asList(additionalSummarizationDimensions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalSummarizationDimensions(
                Consumer<SummarizationDimensionOverview.Builder>... additionalSummarizationDimensions) {
            additionalSummarizationDimensions(Stream.of(additionalSummarizationDimensions)
                    .map(c -> SummarizationDimensionOverview.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public AggregationSummary build() {
            return new AggregationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
