/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.notifications.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetEventRuleResponse extends NotificationsResponse implements
        ToCopyableBuilder<GetEventRuleResponse.Builder, GetEventRuleResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(GetEventRuleResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> NOTIFICATION_CONFIGURATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("notificationConfigurationArn")
            .getter(getter(GetEventRuleResponse::notificationConfigurationArn))
            .setter(setter(Builder::notificationConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notificationConfigurationArn")
                    .build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime")
            .getter(getter(GetEventRuleResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("source")
            .getter(getter(GetEventRuleResponse::source)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventType").getter(getter(GetEventRuleResponse::eventType)).setter(setter(Builder::eventType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventType").build()).build();

    private static final SdkField<String> EVENT_PATTERN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventPattern").getter(getter(GetEventRuleResponse::eventPattern)).setter(setter(Builder::eventPattern))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventPattern").build()).build();

    private static final SdkField<List<String>> REGIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("regions")
            .getter(getter(GetEventRuleResponse::regions))
            .setter(setter(Builder::regions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> MANAGED_RULES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("managedRules")
            .getter(getter(GetEventRuleResponse::managedRules))
            .setter(setter(Builder::managedRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, EventRuleStatusSummary>> STATUS_SUMMARY_BY_REGION_FIELD = SdkField
            .<Map<String, EventRuleStatusSummary>> builder(MarshallingType.MAP)
            .memberName("statusSummaryByRegion")
            .getter(getter(GetEventRuleResponse::statusSummaryByRegion))
            .setter(setter(Builder::statusSummaryByRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusSummaryByRegion").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<EventRuleStatusSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(EventRuleStatusSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            NOTIFICATION_CONFIGURATION_ARN_FIELD, CREATION_TIME_FIELD, SOURCE_FIELD, EVENT_TYPE_FIELD, EVENT_PATTERN_FIELD,
            REGIONS_FIELD, MANAGED_RULES_FIELD, STATUS_SUMMARY_BY_REGION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final String notificationConfigurationArn;

    private final Instant creationTime;

    private final String source;

    private final String eventType;

    private final String eventPattern;

    private final List<String> regions;

    private final List<String> managedRules;

    private final Map<String, EventRuleStatusSummary> statusSummaryByRegion;

    private GetEventRuleResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.notificationConfigurationArn = builder.notificationConfigurationArn;
        this.creationTime = builder.creationTime;
        this.source = builder.source;
        this.eventType = builder.eventType;
        this.eventPattern = builder.eventPattern;
        this.regions = builder.regions;
        this.managedRules = builder.managedRules;
        this.statusSummaryByRegion = builder.statusSummaryByRegion;
    }

    /**
     * <p>
     * The ARN of the resource.
     * </p>
     * 
     * @return The ARN of the resource.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The ARN of a <code>NotificationConfiguration</code>.
     * </p>
     * 
     * @return The ARN of a <code>NotificationConfiguration</code>.
     */
    public final String notificationConfigurationArn() {
        return notificationConfigurationArn;
    }

    /**
     * <p>
     * The date when the <code>EventRule</code> was created.
     * </p>
     * 
     * @return The date when the <code>EventRule</code> was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The matched event source.
     * </p>
     * <p>
     * Must match one of the valid EventBridge sources. Only Amazon Web Services service sourced events are supported.
     * For example, <code>aws.ec2</code> and <code>aws.cloudwatch</code>. For more information, see <a href=
     * "https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-service-event.html#eb-service-event-delivery-level"
     * >Event delivery from Amazon Web Services services</a> in the <i>Amazon EventBridge User Guide</i>.
     * </p>
     * 
     * @return The matched event source.</p>
     *         <p>
     *         Must match one of the valid EventBridge sources. Only Amazon Web Services service sourced events are
     *         supported. For example, <code>aws.ec2</code> and <code>aws.cloudwatch</code>. For more information, see
     *         <a href=
     *         "https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-service-event.html#eb-service-event-delivery-level"
     *         >Event delivery from Amazon Web Services services</a> in the <i>Amazon EventBridge User Guide</i>.
     */
    public final String source() {
        return source;
    }

    /**
     * <p>
     * The event type to match.
     * </p>
     * <p>
     * Must match one of the valid Amazon EventBridge event types. For example, EC2 Instance State-change Notification
     * and Amazon CloudWatch Alarm State Change. For more information, see <a href=
     * "https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-service-event.html#eb-service-event-delivery-level"
     * >Event delivery from Amazon Web Services services</a> in the <i>Amazon EventBridge User Guide</i>.
     * </p>
     * 
     * @return The event type to match.</p>
     *         <p>
     *         Must match one of the valid Amazon EventBridge event types. For example, EC2 Instance State-change
     *         Notification and Amazon CloudWatch Alarm State Change. For more information, see <a href=
     *         "https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-service-event.html#eb-service-event-delivery-level"
     *         >Event delivery from Amazon Web Services services</a> in the <i>Amazon EventBridge User Guide</i>.
     */
    public final String eventType() {
        return eventType;
    }

    /**
     * <p>
     * An additional event pattern used to further filter the events this <code>EventRule</code> receives.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-event-patterns.html">Amazon EventBridge event
     * patterns</a> in the <i>Amazon EventBridge User Guide.</i>
     * </p>
     * 
     * @return An additional event pattern used to further filter the events this <code>EventRule</code> receives.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-event-patterns.html">Amazon EventBridge
     *         event patterns</a> in the <i>Amazon EventBridge User Guide.</i>
     */
    public final String eventPattern() {
        return eventPattern;
    }

    /**
     * For responses, this returns true if the service returned a value for the Regions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRegions() {
        return regions != null && !(regions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Amazon Web Services Regions that send events to this <code>EventRule</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRegions} method.
     * </p>
     * 
     * @return A list of Amazon Web Services Regions that send events to this <code>EventRule</code>.
     */
    public final List<String> regions() {
        return regions;
    }

    /**
     * For responses, this returns true if the service returned a value for the ManagedRules property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasManagedRules() {
        return managedRules != null && !(managedRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of managed rules from EventBridge that are associated with this <code>EventRule</code>.
     * </p>
     * <note>
     * <p>
     * These are created by User Notifications within your account so this <code>EventRule</code> functions.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasManagedRules} method.
     * </p>
     * 
     * @return A list of managed rules from EventBridge that are associated with this <code>EventRule</code>.</p> <note>
     *         <p>
     *         These are created by User Notifications within your account so this <code>EventRule</code> functions.
     *         </p>
     */
    public final List<String> managedRules() {
        return managedRules;
    }

    /**
     * For responses, this returns true if the service returned a value for the StatusSummaryByRegion property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasStatusSummaryByRegion() {
        return statusSummaryByRegion != null && !(statusSummaryByRegion instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of an <code>EventRule</code>'s status by Region. Regions are mapped to <code>EventRuleStatusSummary</code>
     * .
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatusSummaryByRegion} method.
     * </p>
     * 
     * @return A list of an <code>EventRule</code>'s status by Region. Regions are mapped to
     *         <code>EventRuleStatusSummary</code>.
     */
    public final Map<String, EventRuleStatusSummary> statusSummaryByRegion() {
        return statusSummaryByRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(notificationConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(eventType());
        hashCode = 31 * hashCode + Objects.hashCode(eventPattern());
        hashCode = 31 * hashCode + Objects.hashCode(hasRegions() ? regions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasManagedRules() ? managedRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasStatusSummaryByRegion() ? statusSummaryByRegion() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEventRuleResponse)) {
            return false;
        }
        GetEventRuleResponse other = (GetEventRuleResponse) obj;
        return Objects.equals(arn(), other.arn())
                && Objects.equals(notificationConfigurationArn(), other.notificationConfigurationArn())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(source(), other.source())
                && Objects.equals(eventType(), other.eventType()) && Objects.equals(eventPattern(), other.eventPattern())
                && hasRegions() == other.hasRegions() && Objects.equals(regions(), other.regions())
                && hasManagedRules() == other.hasManagedRules() && Objects.equals(managedRules(), other.managedRules())
                && hasStatusSummaryByRegion() == other.hasStatusSummaryByRegion()
                && Objects.equals(statusSummaryByRegion(), other.statusSummaryByRegion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetEventRuleResponse").add("Arn", arn())
                .add("NotificationConfigurationArn", notificationConfigurationArn()).add("CreationTime", creationTime())
                .add("Source", source()).add("EventType", eventType()).add("EventPattern", eventPattern())
                .add("Regions", hasRegions() ? regions() : null).add("ManagedRules", hasManagedRules() ? managedRules() : null)
                .add("StatusSummaryByRegion", hasStatusSummaryByRegion() ? statusSummaryByRegion() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "notificationConfigurationArn":
            return Optional.ofNullable(clazz.cast(notificationConfigurationArn()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "source":
            return Optional.ofNullable(clazz.cast(source()));
        case "eventType":
            return Optional.ofNullable(clazz.cast(eventType()));
        case "eventPattern":
            return Optional.ofNullable(clazz.cast(eventPattern()));
        case "regions":
            return Optional.ofNullable(clazz.cast(regions()));
        case "managedRules":
            return Optional.ofNullable(clazz.cast(managedRules()));
        case "statusSummaryByRegion":
            return Optional.ofNullable(clazz.cast(statusSummaryByRegion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("notificationConfigurationArn", NOTIFICATION_CONFIGURATION_ARN_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("source", SOURCE_FIELD);
        map.put("eventType", EVENT_TYPE_FIELD);
        map.put("eventPattern", EVENT_PATTERN_FIELD);
        map.put("regions", REGIONS_FIELD);
        map.put("managedRules", MANAGED_RULES_FIELD);
        map.put("statusSummaryByRegion", STATUS_SUMMARY_BY_REGION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetEventRuleResponse, T> g) {
        return obj -> g.apply((GetEventRuleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NotificationsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetEventRuleResponse> {
        /**
         * <p>
         * The ARN of the resource.
         * </p>
         * 
         * @param arn
         *        The ARN of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The ARN of a <code>NotificationConfiguration</code>.
         * </p>
         * 
         * @param notificationConfigurationArn
         *        The ARN of a <code>NotificationConfiguration</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationConfigurationArn(String notificationConfigurationArn);

        /**
         * <p>
         * The date when the <code>EventRule</code> was created.
         * </p>
         * 
         * @param creationTime
         *        The date when the <code>EventRule</code> was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The matched event source.
         * </p>
         * <p>
         * Must match one of the valid EventBridge sources. Only Amazon Web Services service sourced events are
         * supported. For example, <code>aws.ec2</code> and <code>aws.cloudwatch</code>. For more information, see <a
         * href=
         * "https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-service-event.html#eb-service-event-delivery-level"
         * >Event delivery from Amazon Web Services services</a> in the <i>Amazon EventBridge User Guide</i>.
         * </p>
         * 
         * @param source
         *        The matched event source.</p>
         *        <p>
         *        Must match one of the valid EventBridge sources. Only Amazon Web Services service sourced events are
         *        supported. For example, <code>aws.ec2</code> and <code>aws.cloudwatch</code>. For more information,
         *        see <a href=
         *        "https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-service-event.html#eb-service-event-delivery-level"
         *        >Event delivery from Amazon Web Services services</a> in the <i>Amazon EventBridge User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(String source);

        /**
         * <p>
         * The event type to match.
         * </p>
         * <p>
         * Must match one of the valid Amazon EventBridge event types. For example, EC2 Instance State-change
         * Notification and Amazon CloudWatch Alarm State Change. For more information, see <a href=
         * "https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-service-event.html#eb-service-event-delivery-level"
         * >Event delivery from Amazon Web Services services</a> in the <i>Amazon EventBridge User Guide</i>.
         * </p>
         * 
         * @param eventType
         *        The event type to match.</p>
         *        <p>
         *        Must match one of the valid Amazon EventBridge event types. For example, EC2 Instance State-change
         *        Notification and Amazon CloudWatch Alarm State Change. For more information, see <a href=
         *        "https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-service-event.html#eb-service-event-delivery-level"
         *        >Event delivery from Amazon Web Services services</a> in the <i>Amazon EventBridge User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventType(String eventType);

        /**
         * <p>
         * An additional event pattern used to further filter the events this <code>EventRule</code> receives.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-event-patterns.html">Amazon EventBridge
         * event patterns</a> in the <i>Amazon EventBridge User Guide.</i>
         * </p>
         * 
         * @param eventPattern
         *        An additional event pattern used to further filter the events this <code>EventRule</code>
         *        receives.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-event-patterns.html">Amazon
         *        EventBridge event patterns</a> in the <i>Amazon EventBridge User Guide.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventPattern(String eventPattern);

        /**
         * <p>
         * A list of Amazon Web Services Regions that send events to this <code>EventRule</code>.
         * </p>
         * 
         * @param regions
         *        A list of Amazon Web Services Regions that send events to this <code>EventRule</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regions(Collection<String> regions);

        /**
         * <p>
         * A list of Amazon Web Services Regions that send events to this <code>EventRule</code>.
         * </p>
         * 
         * @param regions
         *        A list of Amazon Web Services Regions that send events to this <code>EventRule</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regions(String... regions);

        /**
         * <p>
         * A list of managed rules from EventBridge that are associated with this <code>EventRule</code>.
         * </p>
         * <note>
         * <p>
         * These are created by User Notifications within your account so this <code>EventRule</code> functions.
         * </p>
         * </note>
         * 
         * @param managedRules
         *        A list of managed rules from EventBridge that are associated with this <code>EventRule</code>.</p>
         *        <note>
         *        <p>
         *        These are created by User Notifications within your account so this <code>EventRule</code> functions.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedRules(Collection<String> managedRules);

        /**
         * <p>
         * A list of managed rules from EventBridge that are associated with this <code>EventRule</code>.
         * </p>
         * <note>
         * <p>
         * These are created by User Notifications within your account so this <code>EventRule</code> functions.
         * </p>
         * </note>
         * 
         * @param managedRules
         *        A list of managed rules from EventBridge that are associated with this <code>EventRule</code>.</p>
         *        <note>
         *        <p>
         *        These are created by User Notifications within your account so this <code>EventRule</code> functions.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedRules(String... managedRules);

        /**
         * <p>
         * A list of an <code>EventRule</code>'s status by Region. Regions are mapped to
         * <code>EventRuleStatusSummary</code>.
         * </p>
         * 
         * @param statusSummaryByRegion
         *        A list of an <code>EventRule</code>'s status by Region. Regions are mapped to
         *        <code>EventRuleStatusSummary</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusSummaryByRegion(Map<String, EventRuleStatusSummary> statusSummaryByRegion);
    }

    static final class BuilderImpl extends NotificationsResponse.BuilderImpl implements Builder {
        private String arn;

        private String notificationConfigurationArn;

        private Instant creationTime;

        private String source;

        private String eventType;

        private String eventPattern;

        private List<String> regions = DefaultSdkAutoConstructList.getInstance();

        private List<String> managedRules = DefaultSdkAutoConstructList.getInstance();

        private Map<String, EventRuleStatusSummary> statusSummaryByRegion = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetEventRuleResponse model) {
            super(model);
            arn(model.arn);
            notificationConfigurationArn(model.notificationConfigurationArn);
            creationTime(model.creationTime);
            source(model.source);
            eventType(model.eventType);
            eventPattern(model.eventPattern);
            regions(model.regions);
            managedRules(model.managedRules);
            statusSummaryByRegion(model.statusSummaryByRegion);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getNotificationConfigurationArn() {
            return notificationConfigurationArn;
        }

        public final void setNotificationConfigurationArn(String notificationConfigurationArn) {
            this.notificationConfigurationArn = notificationConfigurationArn;
        }

        @Override
        public final Builder notificationConfigurationArn(String notificationConfigurationArn) {
            this.notificationConfigurationArn = notificationConfigurationArn;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getEventType() {
            return eventType;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        public final String getEventPattern() {
            return eventPattern;
        }

        public final void setEventPattern(String eventPattern) {
            this.eventPattern = eventPattern;
        }

        @Override
        public final Builder eventPattern(String eventPattern) {
            this.eventPattern = eventPattern;
            return this;
        }

        public final Collection<String> getRegions() {
            if (regions instanceof SdkAutoConstructList) {
                return null;
            }
            return regions;
        }

        public final void setRegions(Collection<String> regions) {
            this.regions = RegionsCopier.copy(regions);
        }

        @Override
        public final Builder regions(Collection<String> regions) {
            this.regions = RegionsCopier.copy(regions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(String... regions) {
            regions(Arrays.asList(regions));
            return this;
        }

        public final Collection<String> getManagedRules() {
            if (managedRules instanceof SdkAutoConstructList) {
                return null;
            }
            return managedRules;
        }

        public final void setManagedRules(Collection<String> managedRules) {
            this.managedRules = ManagedRuleArnsCopier.copy(managedRules);
        }

        @Override
        public final Builder managedRules(Collection<String> managedRules) {
            this.managedRules = ManagedRuleArnsCopier.copy(managedRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedRules(String... managedRules) {
            managedRules(Arrays.asList(managedRules));
            return this;
        }

        public final Map<String, EventRuleStatusSummary.Builder> getStatusSummaryByRegion() {
            Map<String, EventRuleStatusSummary.Builder> result = StatusSummaryByRegionCopier
                    .copyToBuilder(this.statusSummaryByRegion);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setStatusSummaryByRegion(Map<String, EventRuleStatusSummary.BuilderImpl> statusSummaryByRegion) {
            this.statusSummaryByRegion = StatusSummaryByRegionCopier.copyFromBuilder(statusSummaryByRegion);
        }

        @Override
        public final Builder statusSummaryByRegion(Map<String, EventRuleStatusSummary> statusSummaryByRegion) {
            this.statusSummaryByRegion = StatusSummaryByRegionCopier.copy(statusSummaryByRegion);
            return this;
        }

        @Override
        public GetEventRuleResponse build() {
            return new GetEventRuleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
