/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.notifications.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetManagedNotificationChildEventResponse extends NotificationsResponse implements
        ToCopyableBuilder<GetManagedNotificationChildEventResponse.Builder, GetManagedNotificationChildEventResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(GetManagedNotificationChildEventResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> MANAGED_NOTIFICATION_CONFIGURATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("managedNotificationConfigurationArn")
            .getter(getter(GetManagedNotificationChildEventResponse::managedNotificationConfigurationArn))
            .setter(setter(Builder::managedNotificationConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("managedNotificationConfigurationArn").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime")
            .getter(getter(GetManagedNotificationChildEventResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<ManagedNotificationChildEvent> CONTENT_FIELD = SdkField
            .<ManagedNotificationChildEvent> builder(MarshallingType.SDK_POJO).memberName("content")
            .getter(getter(GetManagedNotificationChildEventResponse::content)).setter(setter(Builder::content))
            .constructor(ManagedNotificationChildEvent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            MANAGED_NOTIFICATION_CONFIGURATION_ARN_FIELD, CREATION_TIME_FIELD, CONTENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final String managedNotificationConfigurationArn;

    private final Instant creationTime;

    private final ManagedNotificationChildEvent content;

    private GetManagedNotificationChildEventResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.managedNotificationConfigurationArn = builder.managedNotificationConfigurationArn;
        this.creationTime = builder.creationTime;
        this.content = builder.content;
    }

    /**
     * <p>
     * The ARN of the resource.
     * </p>
     * 
     * @return The ARN of the resource.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the <code>ManagedNotificationConfiguration</code> associated with the
     * <code>ManagedNotificationChildEvent</code>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the <code>ManagedNotificationConfiguration</code> associated with the
     *         <code>ManagedNotificationChildEvent</code>.
     */
    public final String managedNotificationConfigurationArn() {
        return managedNotificationConfigurationArn;
    }

    /**
     * <p>
     * The creation time of the <code>ManagedNotificationChildEvent</code>.
     * </p>
     * 
     * @return The creation time of the <code>ManagedNotificationChildEvent</code>.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The content of the <code>ManagedNotificationChildEvent</code>.
     * </p>
     * 
     * @return The content of the <code>ManagedNotificationChildEvent</code>.
     */
    public final ManagedNotificationChildEvent content() {
        return content;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(managedNotificationConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetManagedNotificationChildEventResponse)) {
            return false;
        }
        GetManagedNotificationChildEventResponse other = (GetManagedNotificationChildEventResponse) obj;
        return Objects.equals(arn(), other.arn())
                && Objects.equals(managedNotificationConfigurationArn(), other.managedNotificationConfigurationArn())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(content(), other.content());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetManagedNotificationChildEventResponse").add("Arn", arn())
                .add("ManagedNotificationConfigurationArn", managedNotificationConfigurationArn())
                .add("CreationTime", creationTime()).add("Content", content()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "managedNotificationConfigurationArn":
            return Optional.ofNullable(clazz.cast(managedNotificationConfigurationArn()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "content":
            return Optional.ofNullable(clazz.cast(content()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("managedNotificationConfigurationArn", MANAGED_NOTIFICATION_CONFIGURATION_ARN_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("content", CONTENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetManagedNotificationChildEventResponse, T> g) {
        return obj -> g.apply((GetManagedNotificationChildEventResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NotificationsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetManagedNotificationChildEventResponse> {
        /**
         * <p>
         * The ARN of the resource.
         * </p>
         * 
         * @param arn
         *        The ARN of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the <code>ManagedNotificationConfiguration</code> associated with the
         * <code>ManagedNotificationChildEvent</code>.
         * </p>
         * 
         * @param managedNotificationConfigurationArn
         *        The Amazon Resource Name (ARN) of the <code>ManagedNotificationConfiguration</code> associated with
         *        the <code>ManagedNotificationChildEvent</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedNotificationConfigurationArn(String managedNotificationConfigurationArn);

        /**
         * <p>
         * The creation time of the <code>ManagedNotificationChildEvent</code>.
         * </p>
         * 
         * @param creationTime
         *        The creation time of the <code>ManagedNotificationChildEvent</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The content of the <code>ManagedNotificationChildEvent</code>.
         * </p>
         * 
         * @param content
         *        The content of the <code>ManagedNotificationChildEvent</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(ManagedNotificationChildEvent content);

        /**
         * <p>
         * The content of the <code>ManagedNotificationChildEvent</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ManagedNotificationChildEvent.Builder}
         * avoiding the need to create one manually via {@link ManagedNotificationChildEvent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ManagedNotificationChildEvent.Builder#build()} is called
         * immediately and its result is passed to {@link #content(ManagedNotificationChildEvent)}.
         * 
         * @param content
         *        a consumer that will call methods on {@link ManagedNotificationChildEvent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #content(ManagedNotificationChildEvent)
         */
        default Builder content(Consumer<ManagedNotificationChildEvent.Builder> content) {
            return content(ManagedNotificationChildEvent.builder().applyMutation(content).build());
        }
    }

    static final class BuilderImpl extends NotificationsResponse.BuilderImpl implements Builder {
        private String arn;

        private String managedNotificationConfigurationArn;

        private Instant creationTime;

        private ManagedNotificationChildEvent content;

        private BuilderImpl() {
        }

        private BuilderImpl(GetManagedNotificationChildEventResponse model) {
            super(model);
            arn(model.arn);
            managedNotificationConfigurationArn(model.managedNotificationConfigurationArn);
            creationTime(model.creationTime);
            content(model.content);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getManagedNotificationConfigurationArn() {
            return managedNotificationConfigurationArn;
        }

        public final void setManagedNotificationConfigurationArn(String managedNotificationConfigurationArn) {
            this.managedNotificationConfigurationArn = managedNotificationConfigurationArn;
        }

        @Override
        public final Builder managedNotificationConfigurationArn(String managedNotificationConfigurationArn) {
            this.managedNotificationConfigurationArn = managedNotificationConfigurationArn;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final ManagedNotificationChildEvent.Builder getContent() {
            return content != null ? content.toBuilder() : null;
        }

        public final void setContent(ManagedNotificationChildEvent.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(ManagedNotificationChildEvent content) {
            this.content = content;
            return this;
        }

        @Override
        public GetManagedNotificationChildEventResponse build() {
            return new GetManagedNotificationChildEventResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
