/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.notifications.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetManagedNotificationConfigurationResponse extends NotificationsResponse implements
        ToCopyableBuilder<GetManagedNotificationConfigurationResponse.Builder, GetManagedNotificationConfigurationResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(GetManagedNotificationConfigurationResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetManagedNotificationConfigurationResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetManagedNotificationConfigurationResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("category").getter(getter(GetManagedNotificationConfigurationResponse::category))
            .setter(setter(Builder::category))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("category").build()).build();

    private static final SdkField<String> SUB_CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("subCategory").getter(getter(GetManagedNotificationConfigurationResponse::subCategory))
            .setter(setter(Builder::subCategory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subCategory").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, CATEGORY_FIELD, SUB_CATEGORY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final String name;

    private final String description;

    private final String category;

    private final String subCategory;

    private GetManagedNotificationConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.category = builder.category;
        this.subCategory = builder.subCategory;
    }

    /**
     * <p>
     * The ARN of the <code>ManagedNotificationConfiguration</code> resource.
     * </p>
     * 
     * @return The ARN of the <code>ManagedNotificationConfiguration</code> resource.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the <code>ManagedNotificationConfiguration</code>.
     * </p>
     * 
     * @return The name of the <code>ManagedNotificationConfiguration</code>.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the <code>ManagedNotificationConfiguration</code>.
     * </p>
     * 
     * @return The description of the <code>ManagedNotificationConfiguration</code>.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The category of the <code>ManagedNotificationConfiguration</code>.
     * </p>
     * 
     * @return The category of the <code>ManagedNotificationConfiguration</code>.
     */
    public final String category() {
        return category;
    }

    /**
     * <p>
     * The subCategory of the <code>ManagedNotificationConfiguration</code>.
     * </p>
     * 
     * @return The subCategory of the <code>ManagedNotificationConfiguration</code>.
     */
    public final String subCategory() {
        return subCategory;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(category());
        hashCode = 31 * hashCode + Objects.hashCode(subCategory());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetManagedNotificationConfigurationResponse)) {
            return false;
        }
        GetManagedNotificationConfigurationResponse other = (GetManagedNotificationConfigurationResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(category(), other.category())
                && Objects.equals(subCategory(), other.subCategory());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetManagedNotificationConfigurationResponse").add("Arn", arn()).add("Name", name())
                .add("Description", description()).add("Category", category()).add("SubCategory", subCategory()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "category":
            return Optional.ofNullable(clazz.cast(category()));
        case "subCategory":
            return Optional.ofNullable(clazz.cast(subCategory()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("category", CATEGORY_FIELD);
        map.put("subCategory", SUB_CATEGORY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetManagedNotificationConfigurationResponse, T> g) {
        return obj -> g.apply((GetManagedNotificationConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NotificationsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetManagedNotificationConfigurationResponse> {
        /**
         * <p>
         * The ARN of the <code>ManagedNotificationConfiguration</code> resource.
         * </p>
         * 
         * @param arn
         *        The ARN of the <code>ManagedNotificationConfiguration</code> resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the <code>ManagedNotificationConfiguration</code>.
         * </p>
         * 
         * @param name
         *        The name of the <code>ManagedNotificationConfiguration</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the <code>ManagedNotificationConfiguration</code>.
         * </p>
         * 
         * @param description
         *        The description of the <code>ManagedNotificationConfiguration</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The category of the <code>ManagedNotificationConfiguration</code>.
         * </p>
         * 
         * @param category
         *        The category of the <code>ManagedNotificationConfiguration</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder category(String category);

        /**
         * <p>
         * The subCategory of the <code>ManagedNotificationConfiguration</code>.
         * </p>
         * 
         * @param subCategory
         *        The subCategory of the <code>ManagedNotificationConfiguration</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subCategory(String subCategory);
    }

    static final class BuilderImpl extends NotificationsResponse.BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String description;

        private String category;

        private String subCategory;

        private BuilderImpl() {
        }

        private BuilderImpl(GetManagedNotificationConfigurationResponse model) {
            super(model);
            arn(model.arn);
            name(model.name);
            description(model.description);
            category(model.category);
            subCategory(model.subCategory);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getCategory() {
            return category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        public final String getSubCategory() {
            return subCategory;
        }

        public final void setSubCategory(String subCategory) {
            this.subCategory = subCategory;
        }

        @Override
        public final Builder subCategory(String subCategory) {
            this.subCategory = subCategory;
            return this;
        }

        @Override
        public GetManagedNotificationConfigurationResponse build() {
            return new GetManagedNotificationConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
