/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.notifications.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetNotificationEventResponse extends NotificationsResponse implements
        ToCopyableBuilder<GetNotificationEventResponse.Builder, GetNotificationEventResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(GetNotificationEventResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> NOTIFICATION_CONFIGURATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("notificationConfigurationArn")
            .getter(getter(GetNotificationEventResponse::notificationConfigurationArn))
            .setter(setter(Builder::notificationConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notificationConfigurationArn")
                    .build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime")
            .getter(getter(GetNotificationEventResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<NotificationEvent> CONTENT_FIELD = SdkField
            .<NotificationEvent> builder(MarshallingType.SDK_POJO).memberName("content")
            .getter(getter(GetNotificationEventResponse::content)).setter(setter(Builder::content))
            .constructor(NotificationEvent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            NOTIFICATION_CONFIGURATION_ARN_FIELD, CREATION_TIME_FIELD, CONTENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final String notificationConfigurationArn;

    private final Instant creationTime;

    private final NotificationEvent content;

    private GetNotificationEventResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.notificationConfigurationArn = builder.notificationConfigurationArn;
        this.creationTime = builder.creationTime;
        this.content = builder.content;
    }

    /**
     * <p>
     * The ARN of the resource.
     * </p>
     * 
     * @return The ARN of the resource.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The ARN of the <code>NotificationConfiguration</code>.
     * </p>
     * 
     * @return The ARN of the <code>NotificationConfiguration</code>.
     */
    public final String notificationConfigurationArn() {
        return notificationConfigurationArn;
    }

    /**
     * <p>
     * The creation time of the <code>NotificationEvent</code>.
     * </p>
     * 
     * @return The creation time of the <code>NotificationEvent</code>.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The content of the <code>NotificationEvent</code>.
     * </p>
     * 
     * @return The content of the <code>NotificationEvent</code>.
     */
    public final NotificationEvent content() {
        return content;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(notificationConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetNotificationEventResponse)) {
            return false;
        }
        GetNotificationEventResponse other = (GetNotificationEventResponse) obj;
        return Objects.equals(arn(), other.arn())
                && Objects.equals(notificationConfigurationArn(), other.notificationConfigurationArn())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(content(), other.content());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetNotificationEventResponse").add("Arn", arn())
                .add("NotificationConfigurationArn", notificationConfigurationArn()).add("CreationTime", creationTime())
                .add("Content", content()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "notificationConfigurationArn":
            return Optional.ofNullable(clazz.cast(notificationConfigurationArn()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "content":
            return Optional.ofNullable(clazz.cast(content()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("notificationConfigurationArn", NOTIFICATION_CONFIGURATION_ARN_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("content", CONTENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetNotificationEventResponse, T> g) {
        return obj -> g.apply((GetNotificationEventResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NotificationsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetNotificationEventResponse> {
        /**
         * <p>
         * The ARN of the resource.
         * </p>
         * 
         * @param arn
         *        The ARN of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The ARN of the <code>NotificationConfiguration</code>.
         * </p>
         * 
         * @param notificationConfigurationArn
         *        The ARN of the <code>NotificationConfiguration</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationConfigurationArn(String notificationConfigurationArn);

        /**
         * <p>
         * The creation time of the <code>NotificationEvent</code>.
         * </p>
         * 
         * @param creationTime
         *        The creation time of the <code>NotificationEvent</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The content of the <code>NotificationEvent</code>.
         * </p>
         * 
         * @param content
         *        The content of the <code>NotificationEvent</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(NotificationEvent content);

        /**
         * <p>
         * The content of the <code>NotificationEvent</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link NotificationEvent.Builder} avoiding the
         * need to create one manually via {@link NotificationEvent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NotificationEvent.Builder#build()} is called immediately and its
         * result is passed to {@link #content(NotificationEvent)}.
         * 
         * @param content
         *        a consumer that will call methods on {@link NotificationEvent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #content(NotificationEvent)
         */
        default Builder content(Consumer<NotificationEvent.Builder> content) {
            return content(NotificationEvent.builder().applyMutation(content).build());
        }
    }

    static final class BuilderImpl extends NotificationsResponse.BuilderImpl implements Builder {
        private String arn;

        private String notificationConfigurationArn;

        private Instant creationTime;

        private NotificationEvent content;

        private BuilderImpl() {
        }

        private BuilderImpl(GetNotificationEventResponse model) {
            super(model);
            arn(model.arn);
            notificationConfigurationArn(model.notificationConfigurationArn);
            creationTime(model.creationTime);
            content(model.content);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getNotificationConfigurationArn() {
            return notificationConfigurationArn;
        }

        public final void setNotificationConfigurationArn(String notificationConfigurationArn) {
            this.notificationConfigurationArn = notificationConfigurationArn;
        }

        @Override
        public final Builder notificationConfigurationArn(String notificationConfigurationArn) {
            this.notificationConfigurationArn = notificationConfigurationArn;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final NotificationEvent.Builder getContent() {
            return content != null ? content.toBuilder() : null;
        }

        public final void setContent(NotificationEvent.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(NotificationEvent content) {
            this.content = content;
            return this;
        }

        @Override
        public GetNotificationEventResponse build() {
            return new GetNotificationEventResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
