/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.notifications.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEventRulesResponse extends NotificationsResponse implements
        ToCopyableBuilder<ListEventRulesResponse.Builder, ListEventRulesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListEventRulesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<EventRuleStructure>> EVENT_RULES_FIELD = SdkField
            .<List<EventRuleStructure>> builder(MarshallingType.LIST)
            .memberName("eventRules")
            .getter(getter(ListEventRulesResponse::eventRules))
            .setter(setter(Builder::eventRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EventRuleStructure> builder(MarshallingType.SDK_POJO)
                                            .constructor(EventRuleStructure::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            EVENT_RULES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<EventRuleStructure> eventRules;

    private ListEventRulesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.eventRules = builder.eventRules;
    }

    /**
     * <p>
     * A pagination token. If a non-null pagination token is returned in a result, pass its value in another request to
     * retrieve more entries.
     * </p>
     * 
     * @return A pagination token. If a non-null pagination token is returned in a result, pass its value in another
     *         request to retrieve more entries.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the EventRules property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEventRules() {
        return eventRules != null && !(eventRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>EventRules</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventRules} method.
     * </p>
     * 
     * @return A list of <code>EventRules</code>.
     */
    public final List<EventRuleStructure> eventRules() {
        return eventRules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasEventRules() ? eventRules() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEventRulesResponse)) {
            return false;
        }
        ListEventRulesResponse other = (ListEventRulesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasEventRules() == other.hasEventRules()
                && Objects.equals(eventRules(), other.eventRules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListEventRulesResponse").add("NextToken", nextToken())
                .add("EventRules", hasEventRules() ? eventRules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "eventRules":
            return Optional.ofNullable(clazz.cast(eventRules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("eventRules", EVENT_RULES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEventRulesResponse, T> g) {
        return obj -> g.apply((ListEventRulesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NotificationsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListEventRulesResponse> {
        /**
         * <p>
         * A pagination token. If a non-null pagination token is returned in a result, pass its value in another request
         * to retrieve more entries.
         * </p>
         * 
         * @param nextToken
         *        A pagination token. If a non-null pagination token is returned in a result, pass its value in another
         *        request to retrieve more entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of <code>EventRules</code>.
         * </p>
         * 
         * @param eventRules
         *        A list of <code>EventRules</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventRules(Collection<EventRuleStructure> eventRules);

        /**
         * <p>
         * A list of <code>EventRules</code>.
         * </p>
         * 
         * @param eventRules
         *        A list of <code>EventRules</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventRules(EventRuleStructure... eventRules);

        /**
         * <p>
         * A list of <code>EventRules</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.notifications.model.EventRuleStructure.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.notifications.model.EventRuleStructure#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.notifications.model.EventRuleStructure.Builder#build()} is called
         * immediately and its result is passed to {@link #eventRules(List<EventRuleStructure>)}.
         * 
         * @param eventRules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.notifications.model.EventRuleStructure.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventRules(java.util.Collection<EventRuleStructure>)
         */
        Builder eventRules(Consumer<EventRuleStructure.Builder>... eventRules);
    }

    static final class BuilderImpl extends NotificationsResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<EventRuleStructure> eventRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListEventRulesResponse model) {
            super(model);
            nextToken(model.nextToken);
            eventRules(model.eventRules);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<EventRuleStructure.Builder> getEventRules() {
            List<EventRuleStructure.Builder> result = EventRulesCopier.copyToBuilder(this.eventRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventRules(Collection<EventRuleStructure.BuilderImpl> eventRules) {
            this.eventRules = EventRulesCopier.copyFromBuilder(eventRules);
        }

        @Override
        public final Builder eventRules(Collection<EventRuleStructure> eventRules) {
            this.eventRules = EventRulesCopier.copy(eventRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventRules(EventRuleStructure... eventRules) {
            eventRules(Arrays.asList(eventRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventRules(Consumer<EventRuleStructure.Builder>... eventRules) {
            eventRules(Stream.of(eventRules).map(c -> EventRuleStructure.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListEventRulesResponse build() {
            return new ListEventRulesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
