/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.notifications.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListManagedNotificationChildEventsRequest extends NotificationsRequest implements
        ToCopyableBuilder<ListManagedNotificationChildEventsRequest.Builder, ListManagedNotificationChildEventsRequest> {
    private static final SdkField<String> AGGREGATE_MANAGED_NOTIFICATION_EVENT_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("aggregateManagedNotificationEventArn")
            .getter(getter(ListManagedNotificationChildEventsRequest::aggregateManagedNotificationEventArn))
            .setter(setter(Builder::aggregateManagedNotificationEventArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("aggregateManagedNotificationEventArn")
                    .build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime")
            .getter(getter(ListManagedNotificationChildEventsRequest::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("startTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime")
            .getter(getter(ListManagedNotificationChildEventsRequest::endTime))
            .setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("endTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> LOCALE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("locale")
            .getter(getter(ListManagedNotificationChildEventsRequest::localeAsString)).setter(setter(Builder::locale))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("locale").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListManagedNotificationChildEventsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> RELATED_ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("relatedAccount").getter(getter(ListManagedNotificationChildEventsRequest::relatedAccount))
            .setter(setter(Builder::relatedAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("relatedAccount").build())
            .build();

    private static final SdkField<String> ORGANIZATIONAL_UNIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("organizationalUnitId").getter(getter(ListManagedNotificationChildEventsRequest::organizationalUnitId))
            .setter(setter(Builder::organizationalUnitId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("organizationalUnitId").build())
            .build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListManagedNotificationChildEventsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AGGREGATE_MANAGED_NOTIFICATION_EVENT_ARN_FIELD, START_TIME_FIELD, END_TIME_FIELD, LOCALE_FIELD, MAX_RESULTS_FIELD,
            RELATED_ACCOUNT_FIELD, ORGANIZATIONAL_UNIT_ID_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String aggregateManagedNotificationEventArn;

    private final Instant startTime;

    private final Instant endTime;

    private final String locale;

    private final Integer maxResults;

    private final String relatedAccount;

    private final String organizationalUnitId;

    private final String nextToken;

    private ListManagedNotificationChildEventsRequest(BuilderImpl builder) {
        super(builder);
        this.aggregateManagedNotificationEventArn = builder.aggregateManagedNotificationEventArn;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.locale = builder.locale;
        this.maxResults = builder.maxResults;
        this.relatedAccount = builder.relatedAccount;
        this.organizationalUnitId = builder.organizationalUnitId;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the <code>ManagedNotificationEvent</code>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the <code>ManagedNotificationEvent</code>.
     */
    public final String aggregateManagedNotificationEventArn() {
        return aggregateManagedNotificationEventArn;
    }

    /**
     * <p>
     * The earliest time of events to return from this call.
     * </p>
     * 
     * @return The earliest time of events to return from this call.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * Latest time of events to return from this call.
     * </p>
     * 
     * @return Latest time of events to return from this call.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The locale code of the language used for the retrieved <code>NotificationEvent</code>. The default locale is
     * English.<code>en_US</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #locale} will
     * return {@link LocaleCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #localeAsString}.
     * </p>
     * 
     * @return The locale code of the language used for the retrieved <code>NotificationEvent</code>. The default locale
     *         is English.<code>en_US</code>.
     * @see LocaleCode
     */
    public final LocaleCode locale() {
        return LocaleCode.fromValue(locale);
    }

    /**
     * <p>
     * The locale code of the language used for the retrieved <code>NotificationEvent</code>. The default locale is
     * English.<code>en_US</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #locale} will
     * return {@link LocaleCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #localeAsString}.
     * </p>
     * 
     * @return The locale code of the language used for the retrieved <code>NotificationEvent</code>. The default locale
     *         is English.<code>en_US</code>.
     * @see LocaleCode
     */
    public final String localeAsString() {
        return locale;
    }

    /**
     * <p>
     * The maximum number of results to be returned in this call. Defaults to 20.
     * </p>
     * 
     * @return The maximum number of results to be returned in this call. Defaults to 20.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The Amazon Web Services account ID associated with the Managed Notification Child Events.
     * </p>
     * 
     * @return The Amazon Web Services account ID associated with the Managed Notification Child Events.
     */
    public final String relatedAccount() {
        return relatedAccount;
    }

    /**
     * <p>
     * The identifier of the Amazon Web Services Organizations organizational unit (OU) associated with the Managed
     * Notification Child Events.
     * </p>
     * 
     * @return The identifier of the Amazon Web Services Organizations organizational unit (OU) associated with the
     *         Managed Notification Child Events.
     */
    public final String organizationalUnitId() {
        return organizationalUnitId;
    }

    /**
     * <p>
     * The start token for paginated calls. Retrieved from the response of a previous
     * ListManagedNotificationChannelAssociations call. Next token uses Base64 encoding.
     * </p>
     * 
     * @return The start token for paginated calls. Retrieved from the response of a previous
     *         ListManagedNotificationChannelAssociations call. Next token uses Base64 encoding.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(aggregateManagedNotificationEventArn());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(localeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(relatedAccount());
        hashCode = 31 * hashCode + Objects.hashCode(organizationalUnitId());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListManagedNotificationChildEventsRequest)) {
            return false;
        }
        ListManagedNotificationChildEventsRequest other = (ListManagedNotificationChildEventsRequest) obj;
        return Objects.equals(aggregateManagedNotificationEventArn(), other.aggregateManagedNotificationEventArn())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(localeAsString(), other.localeAsString()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(relatedAccount(), other.relatedAccount())
                && Objects.equals(organizationalUnitId(), other.organizationalUnitId())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListManagedNotificationChildEventsRequest")
                .add("AggregateManagedNotificationEventArn", aggregateManagedNotificationEventArn())
                .add("StartTime", startTime()).add("EndTime", endTime()).add("Locale", localeAsString())
                .add("MaxResults", maxResults()).add("RelatedAccount", relatedAccount())
                .add("OrganizationalUnitId", organizationalUnitId()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "aggregateManagedNotificationEventArn":
            return Optional.ofNullable(clazz.cast(aggregateManagedNotificationEventArn()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "locale":
            return Optional.ofNullable(clazz.cast(localeAsString()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "relatedAccount":
            return Optional.ofNullable(clazz.cast(relatedAccount()));
        case "organizationalUnitId":
            return Optional.ofNullable(clazz.cast(organizationalUnitId()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("aggregateManagedNotificationEventArn", AGGREGATE_MANAGED_NOTIFICATION_EVENT_ARN_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("locale", LOCALE_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("relatedAccount", RELATED_ACCOUNT_FIELD);
        map.put("organizationalUnitId", ORGANIZATIONAL_UNIT_ID_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListManagedNotificationChildEventsRequest, T> g) {
        return obj -> g.apply((ListManagedNotificationChildEventsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NotificationsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListManagedNotificationChildEventsRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the <code>ManagedNotificationEvent</code>.
         * </p>
         * 
         * @param aggregateManagedNotificationEventArn
         *        The Amazon Resource Name (ARN) of the <code>ManagedNotificationEvent</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregateManagedNotificationEventArn(String aggregateManagedNotificationEventArn);

        /**
         * <p>
         * The earliest time of events to return from this call.
         * </p>
         * 
         * @param startTime
         *        The earliest time of events to return from this call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * Latest time of events to return from this call.
         * </p>
         * 
         * @param endTime
         *        Latest time of events to return from this call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The locale code of the language used for the retrieved <code>NotificationEvent</code>. The default locale is
         * English.<code>en_US</code>.
         * </p>
         * 
         * @param locale
         *        The locale code of the language used for the retrieved <code>NotificationEvent</code>. The default
         *        locale is English.<code>en_US</code>.
         * @see LocaleCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LocaleCode
         */
        Builder locale(String locale);

        /**
         * <p>
         * The locale code of the language used for the retrieved <code>NotificationEvent</code>. The default locale is
         * English.<code>en_US</code>.
         * </p>
         * 
         * @param locale
         *        The locale code of the language used for the retrieved <code>NotificationEvent</code>. The default
         *        locale is English.<code>en_US</code>.
         * @see LocaleCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LocaleCode
         */
        Builder locale(LocaleCode locale);

        /**
         * <p>
         * The maximum number of results to be returned in this call. Defaults to 20.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to be returned in this call. Defaults to 20.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The Amazon Web Services account ID associated with the Managed Notification Child Events.
         * </p>
         * 
         * @param relatedAccount
         *        The Amazon Web Services account ID associated with the Managed Notification Child Events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedAccount(String relatedAccount);

        /**
         * <p>
         * The identifier of the Amazon Web Services Organizations organizational unit (OU) associated with the Managed
         * Notification Child Events.
         * </p>
         * 
         * @param organizationalUnitId
         *        The identifier of the Amazon Web Services Organizations organizational unit (OU) associated with the
         *        Managed Notification Child Events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationalUnitId(String organizationalUnitId);

        /**
         * <p>
         * The start token for paginated calls. Retrieved from the response of a previous
         * ListManagedNotificationChannelAssociations call. Next token uses Base64 encoding.
         * </p>
         * 
         * @param nextToken
         *        The start token for paginated calls. Retrieved from the response of a previous
         *        ListManagedNotificationChannelAssociations call. Next token uses Base64 encoding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NotificationsRequest.BuilderImpl implements Builder {
        private String aggregateManagedNotificationEventArn;

        private Instant startTime;

        private Instant endTime;

        private String locale;

        private Integer maxResults;

        private String relatedAccount;

        private String organizationalUnitId;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListManagedNotificationChildEventsRequest model) {
            super(model);
            aggregateManagedNotificationEventArn(model.aggregateManagedNotificationEventArn);
            startTime(model.startTime);
            endTime(model.endTime);
            locale(model.locale);
            maxResults(model.maxResults);
            relatedAccount(model.relatedAccount);
            organizationalUnitId(model.organizationalUnitId);
            nextToken(model.nextToken);
        }

        public final String getAggregateManagedNotificationEventArn() {
            return aggregateManagedNotificationEventArn;
        }

        public final void setAggregateManagedNotificationEventArn(String aggregateManagedNotificationEventArn) {
            this.aggregateManagedNotificationEventArn = aggregateManagedNotificationEventArn;
        }

        @Override
        public final Builder aggregateManagedNotificationEventArn(String aggregateManagedNotificationEventArn) {
            this.aggregateManagedNotificationEventArn = aggregateManagedNotificationEventArn;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getLocale() {
            return locale;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        @Override
        public final Builder locale(LocaleCode locale) {
            this.locale(locale == null ? null : locale.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getRelatedAccount() {
            return relatedAccount;
        }

        public final void setRelatedAccount(String relatedAccount) {
            this.relatedAccount = relatedAccount;
        }

        @Override
        public final Builder relatedAccount(String relatedAccount) {
            this.relatedAccount = relatedAccount;
            return this;
        }

        public final String getOrganizationalUnitId() {
            return organizationalUnitId;
        }

        public final void setOrganizationalUnitId(String organizationalUnitId) {
            this.organizationalUnitId = organizationalUnitId;
        }

        @Override
        public final Builder organizationalUnitId(String organizationalUnitId) {
            this.organizationalUnitId = organizationalUnitId;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListManagedNotificationChildEventsRequest build() {
            return new ListManagedNotificationChildEventsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
