/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.notifications.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum LocaleCode {
    DE_DE("de_DE"),

    EN_CA("en_CA"),

    EN_US("en_US"),

    EN_UK("en_UK"),

    ES_ES("es_ES"),

    FR_CA("fr_CA"),

    FR_FR("fr_FR"),

    ID_ID("id_ID"),

    IT_IT("it_IT"),

    JA_JP("ja_JP"),

    KO_KR("ko_KR"),

    PT_BR("pt_BR"),

    TR_TR("tr_TR"),

    ZH_CN("zh_CN"),

    ZH_TW("zh_TW"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, LocaleCode> VALUE_MAP = EnumUtils.uniqueIndex(LocaleCode.class, LocaleCode::toString);

    private final String value;

    private LocaleCode(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return LocaleCode corresponding to the value
     */
    public static LocaleCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link LocaleCode}s
     */
    public static Set<LocaleCode> knownValues() {
        Set<LocaleCode> knownValues = EnumSet.allOf(LocaleCode.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
