/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.notifications.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an overview and metadata for a <code>ManagedNotificationChildEvent</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ManagedNotificationChildEventOverview implements SdkPojo, Serializable,
        ToCopyableBuilder<ManagedNotificationChildEventOverview.Builder, ManagedNotificationChildEventOverview> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(ManagedNotificationChildEventOverview::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> MANAGED_NOTIFICATION_CONFIGURATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("managedNotificationConfigurationArn")
            .getter(getter(ManagedNotificationChildEventOverview::managedNotificationConfigurationArn))
            .setter(setter(Builder::managedNotificationConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("managedNotificationConfigurationArn").build()).build();

    private static final SdkField<String> RELATED_ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("relatedAccount").getter(getter(ManagedNotificationChildEventOverview::relatedAccount))
            .setter(setter(Builder::relatedAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relatedAccount").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime")
            .getter(getter(ManagedNotificationChildEventOverview::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<ManagedNotificationChildEventSummary> CHILD_EVENT_FIELD = SdkField
            .<ManagedNotificationChildEventSummary> builder(MarshallingType.SDK_POJO).memberName("childEvent")
            .getter(getter(ManagedNotificationChildEventOverview::childEvent)).setter(setter(Builder::childEvent))
            .constructor(ManagedNotificationChildEventSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("childEvent").build()).build();

    private static final SdkField<String> AGGREGATE_MANAGED_NOTIFICATION_EVENT_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("aggregateManagedNotificationEventArn")
            .getter(getter(ManagedNotificationChildEventOverview::aggregateManagedNotificationEventArn))
            .setter(setter(Builder::aggregateManagedNotificationEventArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("aggregateManagedNotificationEventArn").build()).build();

    private static final SdkField<String> ORGANIZATIONAL_UNIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("organizationalUnitId").getter(getter(ManagedNotificationChildEventOverview::organizationalUnitId))
            .setter(setter(Builder::organizationalUnitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("organizationalUnitId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            MANAGED_NOTIFICATION_CONFIGURATION_ARN_FIELD, RELATED_ACCOUNT_FIELD, CREATION_TIME_FIELD, CHILD_EVENT_FIELD,
            AGGREGATE_MANAGED_NOTIFICATION_EVENT_ARN_FIELD, ORGANIZATIONAL_UNIT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String managedNotificationConfigurationArn;

    private final String relatedAccount;

    private final Instant creationTime;

    private final ManagedNotificationChildEventSummary childEvent;

    private final String aggregateManagedNotificationEventArn;

    private final String organizationalUnitId;

    private ManagedNotificationChildEventOverview(BuilderImpl builder) {
        this.arn = builder.arn;
        this.managedNotificationConfigurationArn = builder.managedNotificationConfigurationArn;
        this.relatedAccount = builder.relatedAccount;
        this.creationTime = builder.creationTime;
        this.childEvent = builder.childEvent;
        this.aggregateManagedNotificationEventArn = builder.aggregateManagedNotificationEventArn;
        this.organizationalUnitId = builder.organizationalUnitId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the <code>ManagedNotificationChildEvent</code>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the <code>ManagedNotificationChildEvent</code>.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the <code>ManagedNotificationConfiguration</code>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the <code>ManagedNotificationConfiguration</code>.
     */
    public final String managedNotificationConfigurationArn() {
        return managedNotificationConfigurationArn;
    }

    /**
     * <p>
     * The account that related to the <code>ManagedNotificationChildEvent</code>.
     * </p>
     * 
     * @return The account that related to the <code>ManagedNotificationChildEvent</code>.
     */
    public final String relatedAccount() {
        return relatedAccount;
    }

    /**
     * <p>
     * The creation time of the <code>ManagedNotificationChildEvent</code>.
     * </p>
     * 
     * @return The creation time of the <code>ManagedNotificationChildEvent</code>.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The content of the <code>ManagedNotificationChildEvent</code>.
     * </p>
     * 
     * @return The content of the <code>ManagedNotificationChildEvent</code>.
     */
    public final ManagedNotificationChildEventSummary childEvent() {
        return childEvent;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the ManagedNotificationEvent that is associated with this
     * <code>ManagedNotificationChildEvent</code>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the ManagedNotificationEvent that is associated with this
     *         <code>ManagedNotificationChildEvent</code>.
     */
    public final String aggregateManagedNotificationEventArn() {
        return aggregateManagedNotificationEventArn;
    }

    /**
     * <p>
     * The Organizational Unit Id that an AWS account belongs to.
     * </p>
     * 
     * @return The Organizational Unit Id that an AWS account belongs to.
     */
    public final String organizationalUnitId() {
        return organizationalUnitId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(managedNotificationConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(relatedAccount());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(childEvent());
        hashCode = 31 * hashCode + Objects.hashCode(aggregateManagedNotificationEventArn());
        hashCode = 31 * hashCode + Objects.hashCode(organizationalUnitId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedNotificationChildEventOverview)) {
            return false;
        }
        ManagedNotificationChildEventOverview other = (ManagedNotificationChildEventOverview) obj;
        return Objects.equals(arn(), other.arn())
                && Objects.equals(managedNotificationConfigurationArn(), other.managedNotificationConfigurationArn())
                && Objects.equals(relatedAccount(), other.relatedAccount())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(childEvent(), other.childEvent())
                && Objects.equals(aggregateManagedNotificationEventArn(), other.aggregateManagedNotificationEventArn())
                && Objects.equals(organizationalUnitId(), other.organizationalUnitId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ManagedNotificationChildEventOverview").add("Arn", arn())
                .add("ManagedNotificationConfigurationArn", managedNotificationConfigurationArn())
                .add("RelatedAccount", relatedAccount()).add("CreationTime", creationTime()).add("ChildEvent", childEvent())
                .add("AggregateManagedNotificationEventArn", aggregateManagedNotificationEventArn())
                .add("OrganizationalUnitId", organizationalUnitId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "managedNotificationConfigurationArn":
            return Optional.ofNullable(clazz.cast(managedNotificationConfigurationArn()));
        case "relatedAccount":
            return Optional.ofNullable(clazz.cast(relatedAccount()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "childEvent":
            return Optional.ofNullable(clazz.cast(childEvent()));
        case "aggregateManagedNotificationEventArn":
            return Optional.ofNullable(clazz.cast(aggregateManagedNotificationEventArn()));
        case "organizationalUnitId":
            return Optional.ofNullable(clazz.cast(organizationalUnitId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("managedNotificationConfigurationArn", MANAGED_NOTIFICATION_CONFIGURATION_ARN_FIELD);
        map.put("relatedAccount", RELATED_ACCOUNT_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("childEvent", CHILD_EVENT_FIELD);
        map.put("aggregateManagedNotificationEventArn", AGGREGATE_MANAGED_NOTIFICATION_EVENT_ARN_FIELD);
        map.put("organizationalUnitId", ORGANIZATIONAL_UNIT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ManagedNotificationChildEventOverview, T> g) {
        return obj -> g.apply((ManagedNotificationChildEventOverview) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ManagedNotificationChildEventOverview> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the <code>ManagedNotificationChildEvent</code>.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the <code>ManagedNotificationChildEvent</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the <code>ManagedNotificationConfiguration</code>.
         * </p>
         * 
         * @param managedNotificationConfigurationArn
         *        The Amazon Resource Name (ARN) of the <code>ManagedNotificationConfiguration</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedNotificationConfigurationArn(String managedNotificationConfigurationArn);

        /**
         * <p>
         * The account that related to the <code>ManagedNotificationChildEvent</code>.
         * </p>
         * 
         * @param relatedAccount
         *        The account that related to the <code>ManagedNotificationChildEvent</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedAccount(String relatedAccount);

        /**
         * <p>
         * The creation time of the <code>ManagedNotificationChildEvent</code>.
         * </p>
         * 
         * @param creationTime
         *        The creation time of the <code>ManagedNotificationChildEvent</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The content of the <code>ManagedNotificationChildEvent</code>.
         * </p>
         * 
         * @param childEvent
         *        The content of the <code>ManagedNotificationChildEvent</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder childEvent(ManagedNotificationChildEventSummary childEvent);

        /**
         * <p>
         * The content of the <code>ManagedNotificationChildEvent</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ManagedNotificationChildEventSummary.Builder} avoiding the need to create one manually via
         * {@link ManagedNotificationChildEventSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ManagedNotificationChildEventSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #childEvent(ManagedNotificationChildEventSummary)}.
         * 
         * @param childEvent
         *        a consumer that will call methods on {@link ManagedNotificationChildEventSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #childEvent(ManagedNotificationChildEventSummary)
         */
        default Builder childEvent(Consumer<ManagedNotificationChildEventSummary.Builder> childEvent) {
            return childEvent(ManagedNotificationChildEventSummary.builder().applyMutation(childEvent).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the ManagedNotificationEvent that is associated with this
         * <code>ManagedNotificationChildEvent</code>.
         * </p>
         * 
         * @param aggregateManagedNotificationEventArn
         *        The Amazon Resource Name (ARN) of the ManagedNotificationEvent that is associated with this
         *        <code>ManagedNotificationChildEvent</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregateManagedNotificationEventArn(String aggregateManagedNotificationEventArn);

        /**
         * <p>
         * The Organizational Unit Id that an AWS account belongs to.
         * </p>
         * 
         * @param organizationalUnitId
         *        The Organizational Unit Id that an AWS account belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationalUnitId(String organizationalUnitId);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String managedNotificationConfigurationArn;

        private String relatedAccount;

        private Instant creationTime;

        private ManagedNotificationChildEventSummary childEvent;

        private String aggregateManagedNotificationEventArn;

        private String organizationalUnitId;

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedNotificationChildEventOverview model) {
            arn(model.arn);
            managedNotificationConfigurationArn(model.managedNotificationConfigurationArn);
            relatedAccount(model.relatedAccount);
            creationTime(model.creationTime);
            childEvent(model.childEvent);
            aggregateManagedNotificationEventArn(model.aggregateManagedNotificationEventArn);
            organizationalUnitId(model.organizationalUnitId);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getManagedNotificationConfigurationArn() {
            return managedNotificationConfigurationArn;
        }

        public final void setManagedNotificationConfigurationArn(String managedNotificationConfigurationArn) {
            this.managedNotificationConfigurationArn = managedNotificationConfigurationArn;
        }

        @Override
        public final Builder managedNotificationConfigurationArn(String managedNotificationConfigurationArn) {
            this.managedNotificationConfigurationArn = managedNotificationConfigurationArn;
            return this;
        }

        public final String getRelatedAccount() {
            return relatedAccount;
        }

        public final void setRelatedAccount(String relatedAccount) {
            this.relatedAccount = relatedAccount;
        }

        @Override
        public final Builder relatedAccount(String relatedAccount) {
            this.relatedAccount = relatedAccount;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final ManagedNotificationChildEventSummary.Builder getChildEvent() {
            return childEvent != null ? childEvent.toBuilder() : null;
        }

        public final void setChildEvent(ManagedNotificationChildEventSummary.BuilderImpl childEvent) {
            this.childEvent = childEvent != null ? childEvent.build() : null;
        }

        @Override
        public final Builder childEvent(ManagedNotificationChildEventSummary childEvent) {
            this.childEvent = childEvent;
            return this;
        }

        public final String getAggregateManagedNotificationEventArn() {
            return aggregateManagedNotificationEventArn;
        }

        public final void setAggregateManagedNotificationEventArn(String aggregateManagedNotificationEventArn) {
            this.aggregateManagedNotificationEventArn = aggregateManagedNotificationEventArn;
        }

        @Override
        public final Builder aggregateManagedNotificationEventArn(String aggregateManagedNotificationEventArn) {
            this.aggregateManagedNotificationEventArn = aggregateManagedNotificationEventArn;
            return this;
        }

        public final String getOrganizationalUnitId() {
            return organizationalUnitId;
        }

        public final void setOrganizationalUnitId(String organizationalUnitId) {
            this.organizationalUnitId = organizationalUnitId;
        }

        @Override
        public final Builder organizationalUnitId(String organizationalUnitId) {
            this.organizationalUnitId = organizationalUnitId;
            return this;
        }

        @Override
        public ManagedNotificationChildEventOverview build() {
            return new ManagedNotificationChildEventOverview(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
